; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -force-streaming-compatible-sve < %s | FileCheck %s

target triple = "aarch64-unknown-linux-gnu"

define void @build_vector_7_inc1_v4i1(ptr %a) #0 {
; CHECK-LABEL: build_vector_7_inc1_v4i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #5
; CHECK-NEXT:    strb w8, [x0]
; CHECK-NEXT:    ret
  store <4 x i1> <i1 true, i1 false, i1 true, i1 false>, ptr %a, align 1
  ret void
}

define void @build_vector_7_inc1_v32i8(ptr %a) #0 {
; CHECK-LABEL: build_vector_7_inc1_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    index z0.b, #0, #1
; CHECK-NEXT:    mov z1.d, z0.d
; CHECK-NEXT:    add z0.b, z0.b, #7 // =0x7
; CHECK-NEXT:    add z1.b, z1.b, #23 // =0x17
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  store <32 x i8> <i8 7, i8 8, i8 9, i8 10, i8 11, i8 12, i8 13, i8 14, i8 15, i8 16, i8 17, i8 18, i8 19, i8 20, i8 21, i8 22, i8 23, i8 24, i8 25, i8 26, i8 27, i8 28, i8 29, i8 30, i8 31, i8 32, i8 33, i8 34, i8 35, i8 36, i8 37, i8 38>, ptr %a, align 1
  ret void
}

define void @build_vector_0_inc2_v16i16(ptr %a) #0 {
; CHECK-LABEL: build_vector_0_inc2_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    index z0.h, #0, #2
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    add z0.h, z0.h, #16 // =0x10
; CHECK-NEXT:    str q0, [x0, #16]
; CHECK-NEXT:    ret
  store <16 x i16> <i16 0, i16 2, i16 4, i16 6, i16 8, i16 10, i16 12, i16 14, i16 16, i16 18, i16 20, i16 22, i16 24, i16 26, i16 28, i16 30>, ptr %a, align 2
  ret void
}

; Negative const stride.
define void @build_vector_0_dec3_v8i32(ptr %a) #0 {
; CHECK-LABEL: build_vector_0_dec3_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    index z0.s, #0, #-3
; CHECK-NEXT:    mov z1.s, #-12 // =0xfffffffffffffff4
; CHECK-NEXT:    add z1.s, z0.s, z1.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  store <8 x i32> <i32 0, i32 -3, i32 -6, i32 -9, i32 -12, i32 -15, i32 -18, i32 -21>, ptr %a, align 4
  ret void
}

; Constant stride that's too big to be directly encoded into the index.
define void @build_vector_minus2_dec32_v4i64(ptr %a) #0 {
; CHECK-LABEL: build_vector_minus2_dec32_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #-32
; CHECK-NEXT:    mov z0.d, #-66 // =0xffffffffffffffbe
; CHECK-NEXT:    mov z2.d, #-2 // =0xfffffffffffffffe
; CHECK-NEXT:    index z1.d, #0, x8
; CHECK-NEXT:    add z0.d, z1.d, z0.d
; CHECK-NEXT:    add z1.d, z1.d, z2.d
; CHECK-NEXT:    stp q1, q0, [x0]
; CHECK-NEXT:    ret
  store <4 x i64> <i64 -2, i64 -34, i64 -66, i64 -98>, ptr %a, align 8
  ret void
}

; Constant but not a sequence.
define void @build_vector_no_stride_v4i64(ptr %a) #0 {
; CHECK-LABEL: build_vector_no_stride_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    index z0.d, #1, #7
; CHECK-NEXT:    index z1.d, #0, #4
; CHECK-NEXT:    stp q1, q0, [x0]
; CHECK-NEXT:    ret
  store <4 x i64> <i64 0, i64 4, i64 1, i64 8>, ptr %a, align 8
  ret void
}

define void @build_vector_0_inc2_v16f16(ptr %a) #0 {
; CHECK-LABEL: build_vector_0_inc2_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI6_0
; CHECK-NEXT:    adrp x9, .LCPI6_1
; CHECK-NEXT:    ldr q0, [x8, :lo12:.LCPI6_0]
; CHECK-NEXT:    ldr q1, [x9, :lo12:.LCPI6_1]
; CHECK-NEXT:    stp q1, q0, [x0]
; CHECK-NEXT:    ret
  store <16 x half> <half 0.0, half 2.0, half 4.0, half 6.0, half 8.0, half 10.0, half 12.0, half 14.0, half 16.0, half 18.0, half 20.0, half 22.0, half 24.0, half 26.0, half 28.0, half 30.0>, ptr %a, align 2
  ret void
}

; Negative const stride.
define void @build_vector_0_dec3_v8f32(ptr %a) #0 {
; CHECK-LABEL: build_vector_0_dec3_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI7_0
; CHECK-NEXT:    adrp x9, .LCPI7_1
; CHECK-NEXT:    ldr q0, [x8, :lo12:.LCPI7_0]
; CHECK-NEXT:    ldr q1, [x9, :lo12:.LCPI7_1]
; CHECK-NEXT:    stp q1, q0, [x0]
; CHECK-NEXT:    ret
  store <8 x float> <float 0.0, float -3.0, float -6.0, float -9.0, float -12.0, float -15.0, float -18.0, float -21.0>, ptr %a, align 4
  ret void
}

; Constant stride that's too big to be directly encoded into the index.
define void @build_vector_minus2_dec32_v4f64(ptr %a) #0 {
; CHECK-LABEL: build_vector_minus2_dec32_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI8_0
; CHECK-NEXT:    adrp x9, .LCPI8_1
; CHECK-NEXT:    ldr q0, [x8, :lo12:.LCPI8_0]
; CHECK-NEXT:    ldr q1, [x9, :lo12:.LCPI8_1]
; CHECK-NEXT:    stp q1, q0, [x0]
; CHECK-NEXT:    ret
  store <4 x double> <double -2.0, double -34.0, double -66.0, double -98.0>, ptr %a, align 8
  ret void
}

; Constant but not a sequence.
define void @build_vector_no_stride_v4f64(ptr %a) #0 {
; CHECK-LABEL: build_vector_no_stride_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI9_0
; CHECK-NEXT:    adrp x9, .LCPI9_1
; CHECK-NEXT:    ldr q0, [x8, :lo12:.LCPI9_0]
; CHECK-NEXT:    ldr q1, [x9, :lo12:.LCPI9_1]
; CHECK-NEXT:    stp q1, q0, [x0]
; CHECK-NEXT:    ret
  store <4 x double> <double 0.0, double 4.0, double 1.0, double 8.0>, ptr %a, align 8
  ret void
}


attributes #0 = { "target-features"="+sve" }
