; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -o - %s -mtriple=aarch64-- | FileCheck %s

define void @and1(i32 %a, ptr nocapture %p) {
; CHECK-LABEL: and1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    and w8, w0, #0xfffffffd
; CHECK-NEXT:    strb w8, [x1]
; CHECK-NEXT:    ret
entry:
  %and = and i32 %a, 253
  %conv = trunc i32 %and to i8
  store i8 %conv, ptr %p, align 1
  ret void
}

; (a & 0x3dfd) | 0xffffc000
define i32 @and2(i32 %a) {
; CHECK-LABEL: and2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    and w8, w0, #0xfdfdfdfd
; CHECK-NEXT:    orr w0, w8, #0xffffc000
; CHECK-NEXT:    ret
entry:
  %and = and i32 %a, 15869
  %or = or i32 %and, -16384
  ret i32 %or
}

; (a & 0x19) | 0xffffffc0
define i32 @and3(i32 %a) {
; CHECK-LABEL: and3:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    and w8, w0, #0x99999999
; CHECK-NEXT:    orr w0, w8, #0xffffffc0
; CHECK-NEXT:    ret
entry:
  %and = and i32 %a, 25
  %or = or i32 %and, -64
  ret i32 %or
}

; (a & 0xc5600) | 0xfff1f1ff
define i32 @and4(i32 %a) {
; CHECK-LABEL: and4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov w8, #61951
; CHECK-NEXT:    and w9, w0, #0xfffc07ff
; CHECK-NEXT:    movk w8, #65521, lsl #16
; CHECK-NEXT:    orr w0, w9, w8
; CHECK-NEXT:    ret
entry:
  %and = and i32 %a, 787968
  %or = or i32 %and, -921089
  ret i32 %or
}

; Make sure we don't shrink or optimize an XOR's immediate operand if the
; immediate is -1. Instruction selection turns (and ((xor $mask, -1), $v0)) into
; a BIC.
define i32 @xor1(i32 %a) {
; CHECK-LABEL: xor1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov w8, #56
; CHECK-NEXT:    bic w0, w8, w0, lsl #3
; CHECK-NEXT:    ret
entry:
  %shl = shl i32 %a, 3
  %xor = and i32 %shl, 56
  %and = xor i32 %xor, 56
  ret i32 %and
}

; Check that, when (and %t1, 129) is transformed to (and %t0, 0),
; (xor %arg, 129) doesn't get transformed to (xor %arg, 0).
define i64 @PR33100(i64 %arg) {
; CHECK-LABEL: PR33100:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    mov w8, #129
; CHECK-NEXT:    eor x0, x0, x8
; CHECK-NEXT:    mov w8, #8
; CHECK-NEXT:    str x8, [sp, #8]
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    ret
entry:
  %alloca0 = alloca i64
  store i64 8, ptr %alloca0, align 4
  %t0 = load i64, ptr %alloca0, align 4
  %t1 = shl i64 %arg, %t0
  %and0 = and i64 %t1, 129
  %xor0 = xor i64 %arg, 129
  %t2 = add i64 %and0, %xor0
  ret i64 %t2
}
