/*
 * Decompiled with CFR 0.152.
 */
package jarinstaller.oshandler;

import jarinstaller.oshandler.defaultOsHandler;
import jarinstaller.oshandler.linuxdesktop.GnomeDesktop;
import jarinstaller.oshandler.linuxdesktop.ILinuxDesktopHandler;
import jarinstaller.oshandler.linuxdesktop.KdeDesktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;

public class defaultUnixOsHandler
extends defaultOsHandler {
    private static final String os_shell = "/bin/bash";
    private static final String os_shell_param = "-c";
    private static final String os_shell_env_prefix = "$";
    private static final String os_init_dir = "/etc";
    private String os_user_profile_name = null;
    public static final String PROF_DEF = ".profile";
    public static final String PROF_BASH = ".bash_profile";
    private String os_application_dir = null;
    private String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
    private String defaultBrowser = "";
    private ILinuxDesktopHandler KDEHandler = new KdeDesktop();
    private ILinuxDesktopHandler GnomeHandler = new GnomeDesktop();

    public String getInitDir() {
        return os_init_dir;
    }

    public String getApplicationDir() {
        if (this.os_application_dir == null) {
            this.os_application_dir = this.createApplicationDir();
        }
        return this.os_application_dir;
    }

    public String getProgramFilesDir() {
        return this.getApplicationDir();
    }

    public String createApplicationDir() {
        return "/usr/share";
    }

    public String getEnvironmentVariable(String var) {
        Process p = null;
        String command = os_shell_env_prefix + var;
        BufferedReader br = null;
        try {
            p = Runtime.getRuntime().exec(new String[]{os_shell, os_shell_param, "echo " + command});
            br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String env = br.readLine();
            br.close();
            this.closeProcess(p);
            p = null;
            this.showDebugMessage(var + "=" + env);
            return env;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e1) {
                    // empty catch block
                }
                if (p != null) {
                    this.closeProcess(p);
                    p = null;
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
            return "";
        }
    }

    public boolean createEnvironmentVariable(String tmpdir, String userfile, String key, String value) {
        try {
            this.setUserProfileName();
            File profile = new File(this.getUserHomeDir() + File.separator + this.os_user_profile_name);
            if (!this.createExecFile(profile, false)) {
                return false;
            }
            if (!this.includeFile(profile, this.getUserHomeDir() + File.separator + "." + userfile)) {
                return false;
            }
            File file = new File(this.getUserHomeDir() + File.separator + "." + userfile);
            if (!this.createExecFile(file, false)) {
                return false;
            }
            this.execute("echo \"export " + key + "=" + "\"" + value + "\"" + "\" > " + file.getAbsolutePath());
            this.execute(". " + file.getAbsolutePath());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void setUserProfileName() {
        if (this.os_user_profile_name == null) {
            this.os_user_profile_name = this.createUserProfileName();
        }
    }

    private String createUserProfileName() {
        if (this.isFileExists(this.getUserHomeDir() + File.separator + PROF_BASH)) {
            return PROF_BASH;
        }
        return PROF_DEF;
    }

    private boolean isFileExists(String filename) {
        return new File(filename).exists();
    }

    private boolean createExecFile(File file, boolean re_create) {
        if (file.exists() && !re_create) {
            return true;
        }
        if (!this.writeFile(file, new Vector(), "UTF-8", false)) {
            return false;
        }
        try {
            this.setExecuteFlag(file.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean includeFile(File file, String name) {
        if (!this.searchStrInFile(file, name)) {
            try {
                this.execute("echo \". " + name + "\" >> " + file.getAbsolutePath());
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public void execute(String command) throws Exception {
        this.execute(command, null, null, true);
    }

    public void execute(String command, String[] env, File defaultpath) throws Exception {
        this.execute(command, env, defaultpath, false);
    }

    public void execute(String command, String[] env, File defaultpath, boolean needOutput) throws Exception {
        String[] shellCommand = new String[]{os_shell, os_shell_param, command};
        String debuginfo = this.getDebugInfo(shellCommand);
        Process p = null;
        try {
            String errmsg;
            this.showDebugMessage("Start:" + debuginfo);
            p = Runtime.getRuntime().exec(shellCommand, env, defaultpath);
            if (needOutput && (errmsg = this.getStdError(p)).trim().length() != 0) {
                this.showMessage(errmsg);
            }
            this.closeProcess(p);
            p = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                if (p != null) {
                    this.closeProcess(p);
                    p = null;
                }
            }
            catch (Exception d) {
                // empty catch block
            }
            throw e;
        }
    }

    public void setExecuteFlag(String filename) throws Exception {
        String command = "chmod 755 " + filename;
        this.execute(command);
    }

    public void createDesktopIcon(String tmpdir, String name, String description, String target, String arguments, String workingDirectory, String icon) {
        this.createItem(this.KDEHandler, this.KDEHandler.getDesktopPath(), tmpdir, name, description, target, arguments, workingDirectory, icon);
        this.createItem(this.GnomeHandler, this.GnomeHandler.getDesktopPath(), tmpdir, name, description, target, arguments, workingDirectory, icon);
    }

    public void createMenuItem(String tmpdir, String name, String description, String target, String arguments, String workingDirectory, String icon) {
        this.createItem(this.KDEHandler, this.KDEHandler.getMenuPath(name), tmpdir, name, description, target, arguments, workingDirectory, icon);
        this.createItem(this.GnomeHandler, this.GnomeHandler.getMenuPath(name), tmpdir, name, description, target, arguments, workingDirectory, icon);
    }

    public void createItem(ILinuxDesktopHandler desktopHandler, File location, String tmpdir, String name, String description, String target, String arguments, String workingDirectory, String icon) {
        if (location != null) {
            Vector item = desktopHandler.buildItem(name, description, target, arguments, workingDirectory, icon);
            File execfile = new File(tmpdir + File.separator + "createdesktopshortcut.lin");
            if (!this.writeFile(execfile, item, "UTF-8", false)) {
                this.showMessage("Ind\u00edt\u00f3 ikon l\u00e9trehoz\u00e1sa sikertelen");
                return;
            }
            try {
                this.execute("cat " + execfile.getAbsolutePath() + " > " + location.getAbsolutePath() + File.separator + name + ".desktop");
            }
            catch (Exception e) {
                this.showMessage("Hiba az asztali ikon l\u00e9trehoz\u00e1sa sor\u00e1n (" + e.getMessage() + ")");
            }
            execfile.delete();
        }
    }

    public String getSystemBrowserPath() {
        if (this.defaultBrowser != null) {
            return this.defaultBrowser;
        }
        int count = 0;
        while (count < this.browsers.length && this.defaultBrowser == null) {
            this.defaultBrowser = this.executeShowResult("which " + this.browsers[count++]);
        }
        return this.defaultBrowser;
    }

    public String getDirtyEnvironmentVariable(String var, String userfile) {
        String result = this.getEnvironmentVariable(var);
        if (result.length() > 0) {
            return result;
        }
        return this.getEnvFromFile(var, this.getUserHomeDir() + File.separator + "." + userfile);
    }
}

