#!/bin/bash -eu

repo=https://github.com/openSUSE/hwinfo.git
version=$1
tmp=$(mktemp -d)

(
    cd $tmp
    git clone ${repo} hwinfo
    cd hwinfo
    git reset --hard ${version}
    # the build system needs this
    make changelog # this creates VERSION as well
)

cp -f ${tmp}/hwinfo/changelog debian/CHANGELOG
rm -rf ${tmp}
git add debian/CHANGELOG
git commit -a -m "Updated upstream changelog"
