// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/api/endpoint.proto

package serviceconfig

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// `Endpoint` describes a network endpoint that serves a set of APIs.
// A service may expose any number of endpoints, and all endpoints share the
// same service configuration, such as quota configuration and monitoring
// configuration.
//
// Example service configuration:
//
//     name: library-example.googleapis.com
//     endpoints:
//       # Below entry makes 'google.example.library.v1.Library'
//       # API be served from endpoint address library-example.googleapis.com.
//       # It also allows HTTP OPTIONS calls to be passed to the backend, for
//       # it to decide whether the subsequent cross-origin request is
//       # allowed to proceed.
//     - name: library-example.googleapis.com
//       allow_cors: true
type Endpoint struct {
	// The canonical name of this endpoint.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// DEPRECATED: This field is no longer supported. Instead of using aliases,
	// please specify multiple [google.api.Endpoint][google.api.Endpoint] for each of the intented
	// alias.
	//
	// Additional names that this endpoint will be hosted on.
	Aliases []string `protobuf:"bytes,2,rep,name=aliases" json:"aliases,omitempty"`
	// The list of APIs served by this endpoint.
	Apis []string `protobuf:"bytes,3,rep,name=apis" json:"apis,omitempty"`
	// The list of features enabled on this endpoint.
	Features []string `protobuf:"bytes,4,rep,name=features" json:"features,omitempty"`
	// The specification of an Internet routable address of API frontend that will
	// handle requests to this [API Endpoint](https://cloud.google.com/apis/design/glossary).
	// It should be either a valid IPv4 address or a fully-qualified domain name.
	// For example, "8.8.8.8" or "myservice.appspot.com".
	Target string `protobuf:"bytes,101,opt,name=target" json:"target,omitempty"`
	// Allowing
	// [CORS](https://en.wikipedia.org/wiki/Cross-origin_resource_sharing), aka
	// cross-domain traffic, would allow the backends served from this endpoint to
	// receive and respond to HTTP OPTIONS requests. The response will be used by
	// the browser to determine whether the subsequent cross-origin request is
	// allowed to proceed.
	AllowCors bool `protobuf:"varint,5,opt,name=allow_cors,json=allowCors" json:"allow_cors,omitempty"`
}

func (m *Endpoint) Reset()                    { *m = Endpoint{} }
func (m *Endpoint) String() string            { return proto.CompactTextString(m) }
func (*Endpoint) ProtoMessage()               {}
func (*Endpoint) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{0} }

func (m *Endpoint) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Endpoint) GetAliases() []string {
	if m != nil {
		return m.Aliases
	}
	return nil
}

func (m *Endpoint) GetApis() []string {
	if m != nil {
		return m.Apis
	}
	return nil
}

func (m *Endpoint) GetFeatures() []string {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *Endpoint) GetTarget() string {
	if m != nil {
		return m.Target
	}
	return ""
}

func (m *Endpoint) GetAllowCors() bool {
	if m != nil {
		return m.AllowCors
	}
	return false
}

func init() {
	proto.RegisterType((*Endpoint)(nil), "google.api.Endpoint")
}

func init() { proto.RegisterFile("google/api/endpoint.proto", fileDescriptor7) }

var fileDescriptor7 = []byte{
	// 253 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x54, 0x90, 0x41, 0x4b, 0xc4, 0x30,
	0x10, 0x85, 0xe9, 0x6e, 0x5d, 0xdb, 0x01, 0x3d, 0xe4, 0x20, 0x71, 0x51, 0x28, 0x9e, 0x7a, 0x6a,
	0x0f, 0x1e, 0x3d, 0xb9, 0xb2, 0x88, 0xb7, 0xd2, 0xa3, 0x17, 0x19, 0xeb, 0x6c, 0x08, 0x64, 0x33,
	0x21, 0x89, 0xfa, 0x73, 0x04, 0x7f, 0xa9, 0x34, 0xed, 0xaa, 0x7b, 0x9b, 0xef, 0xbd, 0x37, 0x61,
	0x5e, 0xe0, 0x52, 0x31, 0x2b, 0x43, 0x2d, 0x3a, 0xdd, 0x92, 0x7d, 0x73, 0xac, 0x6d, 0x6c, 0x9c,
	0xe7, 0xc8, 0x02, 0x26, 0xab, 0x41, 0xa7, 0xd7, 0x57, 0xff, 0x62, 0x68, 0x2d, 0x47, 0x8c, 0x9a,
	0x6d, 0x98, 0x92, 0x37, 0x5f, 0x19, 0x14, 0xdb, 0x79, 0x59, 0x08, 0xc8, 0x2d, 0xee, 0x49, 0x66,
	0x55, 0x56, 0x97, 0x7d, 0x9a, 0x85, 0x84, 0x53, 0x34, 0x1a, 0x03, 0x05, 0xb9, 0xa8, 0x96, 0x75,
	0xd9, 0x1f, 0x70, 0x4c, 0xa3, 0xd3, 0x41, 0x2e, 0x93, 0x9c, 0x66, 0xb1, 0x86, 0x62, 0x47, 0x18,
	0xdf, 0x3d, 0x05, 0x99, 0x27, 0xfd, 0x97, 0xc5, 0x05, 0xac, 0x22, 0x7a, 0x45, 0x51, 0x52, 0x7a,
	0x7f, 0x26, 0x71, 0x0d, 0x80, 0xc6, 0xf0, 0xe7, 0xcb, 0xc0, 0x3e, 0xc8, 0x93, 0x2a, 0xab, 0x8b,
	0xbe, 0x4c, 0xca, 0x03, 0xfb, 0xb0, 0x61, 0x38, 0x1f, 0x78, 0xdf, 0xfc, 0x35, 0xda, 0x9c, 0x1d,
	0x0e, 0xee, 0xc6, 0x0a, 0x5d, 0xf6, 0xbc, 0x9d, 0x4d, 0xc5, 0x06, 0xad, 0x6a, 0xd8, 0xab, 0x56,
	0x91, 0x4d, 0x05, 0xdb, 0xc9, 0x1a, 0x8f, 0x4b, 0x3f, 0x10, 0xc8, 0x7f, 0xe8, 0x81, 0x06, 0xb6,
	0x3b, 0xad, 0xee, 0x8e, 0xe8, 0x7b, 0x91, 0x3f, 0xde, 0x77, 0x4f, 0xaf, 0xab, 0xb4, 0x78, 0xfb,
	0x13, 0x00, 0x00, 0xff, 0xff, 0x34, 0x0e, 0xdd, 0x70, 0x60, 0x01, 0x00, 0x00,
}
