/* TerrestrialChannel.c generated by valac 0.15.2.10-1402f-dirty, the Vala compiler
 * generated from TerrestrialChannel.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>


#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;
typedef struct _DVBChannelPrivate DVBChannelPrivate;

#define DVB_TYPE_TERRESTRIAL_CHANNEL (dvb_terrestrial_channel_get_type ())
#define DVB_TERRESTRIAL_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannel))
#define DVB_TERRESTRIAL_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannelClass))
#define DVB_IS_TERRESTRIAL_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL))
#define DVB_IS_TERRESTRIAL_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TERRESTRIAL_CHANNEL))
#define DVB_TERRESTRIAL_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannelClass))

typedef struct _DVBTerrestrialChannel DVBTerrestrialChannel;
typedef struct _DVBTerrestrialChannelClass DVBTerrestrialChannelClass;
typedef struct _DVBTerrestrialChannelPrivate DVBTerrestrialChannelPrivate;

#define DVB_TYPE_DVB_SRC_INVERSION (dvb_dvb_src_inversion_get_type ())

#define DVB_TYPE_DVB_SRC_BANDWIDTH (dvb_dvb_src_bandwidth_get_type ())

#define DVB_TYPE_DVB_SRC_CODE_RATE (dvb_dvb_src_code_rate_get_type ())

#define DVB_TYPE_DVB_SRC_MODULATION (dvb_dvb_src_modulation_get_type ())

#define DVB_TYPE_DVB_SRC_TRANSMISSION_MODE (dvb_dvb_src_transmission_mode_get_type ())

#define DVB_TYPE_DVB_SRC_GUARD (dvb_dvb_src_guard_get_type ())

#define DVB_TYPE_DVB_SRC_HIERARCHY (dvb_dvb_src_hierarchy_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

struct _DVBChannel {
	GObject parent_instance;
	DVBChannelPrivate * priv;
};

struct _DVBChannelClass {
	GObjectClass parent_class;
	gboolean (*is_valid) (DVBChannel* self);
	gboolean (*on_same_transport_stream) (DVBChannel* self, DVBChannel* channel);
	gboolean (*equals) (DVBChannel* self, DVBChannel* channel);
	void (*setup_dvb_source) (DVBChannel* self, GstElement* source);
	gchar* (*to_string) (DVBChannel* self);
};

struct _DVBTerrestrialChannel {
	DVBChannel parent_instance;
	DVBTerrestrialChannelPrivate * priv;
};

struct _DVBTerrestrialChannelClass {
	DVBChannelClass parent_class;
};

typedef enum  {
	DVB_DVB_SRC_INVERSION_INVERSION_OFF,
	DVB_DVB_SRC_INVERSION_INVERSION_ON,
	DVB_DVB_SRC_INVERSION_INVERSION_AUTO
} DVBDvbSrcInversion;

typedef enum  {
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_8_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_7_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_6_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_AUTO
} DVBDvbSrcBandwidth;

typedef enum  {
	DVB_DVB_SRC_CODE_RATE_FEC_NONE,
	DVB_DVB_SRC_CODE_RATE_FEC_1_2,
	DVB_DVB_SRC_CODE_RATE_FEC_2_3,
	DVB_DVB_SRC_CODE_RATE_FEC_3_4,
	DVB_DVB_SRC_CODE_RATE_FEC_4_5,
	DVB_DVB_SRC_CODE_RATE_FEC_5_6,
	DVB_DVB_SRC_CODE_RATE_FEC_6_7,
	DVB_DVB_SRC_CODE_RATE_FEC_7_8,
	DVB_DVB_SRC_CODE_RATE_FEC_8_9,
	DVB_DVB_SRC_CODE_RATE_FEC_AUTO
} DVBDvbSrcCodeRate;

typedef enum  {
	DVB_DVB_SRC_MODULATION_QPSK,
	DVB_DVB_SRC_MODULATION_QAM_16,
	DVB_DVB_SRC_MODULATION_QAM_32,
	DVB_DVB_SRC_MODULATION_QAM_64,
	DVB_DVB_SRC_MODULATION_QAM_128,
	DVB_DVB_SRC_MODULATION_QAM_256,
	DVB_DVB_SRC_MODULATION_QAM_AUTO
} DVBDvbSrcModulation;

typedef enum  {
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_2K,
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_8K,
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_AUTO
} DVBDvbSrcTransmissionMode;

typedef enum  {
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_32,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_16,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_8,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_4,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_AUTO
} DVBDvbSrcGuard;

typedef enum  {
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_NONE,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_1,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_2,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_4,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_AUTO
} DVBDvbSrcHierarchy;

struct _DVBTerrestrialChannelPrivate {
	DVBDvbSrcInversion _Inversion;
	DVBDvbSrcBandwidth _Bandwidth;
	DVBDvbSrcCodeRate _CodeRateHP;
	DVBDvbSrcCodeRate _CodeRateLP;
	DVBDvbSrcModulation _Constellation;
	DVBDvbSrcTransmissionMode _TransmissionMode;
	DVBDvbSrcGuard _GuardInterval;
	DVBDvbSrcHierarchy _Hierarchy;
};


static gpointer dvb_terrestrial_channel_parent_class = NULL;

GType dvb_channel_get_type (void) G_GNUC_CONST;
GType dvb_terrestrial_channel_get_type (void) G_GNUC_CONST;
GType dvb_dvb_src_inversion_get_type (void) G_GNUC_CONST;
GType dvb_dvb_src_bandwidth_get_type (void) G_GNUC_CONST;
GType dvb_dvb_src_code_rate_get_type (void) G_GNUC_CONST;
GType dvb_dvb_src_modulation_get_type (void) G_GNUC_CONST;
GType dvb_dvb_src_transmission_mode_get_type (void) G_GNUC_CONST;
GType dvb_dvb_src_guard_get_type (void) G_GNUC_CONST;
GType dvb_dvb_src_hierarchy_get_type (void) G_GNUC_CONST;
#define DVB_TERRESTRIAL_CHANNEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannelPrivate))
enum  {
	DVB_TERRESTRIAL_CHANNEL_DUMMY_PROPERTY,
	DVB_TERRESTRIAL_CHANNEL_INVERSION,
	DVB_TERRESTRIAL_CHANNEL_BANDWIDTH,
	DVB_TERRESTRIAL_CHANNEL_CODE_RATE_HP,
	DVB_TERRESTRIAL_CHANNEL_CODE_RATE_LP,
	DVB_TERRESTRIAL_CHANNEL_CONSTELLATION,
	DVB_TERRESTRIAL_CHANNEL_TRANSMISSION_MODE,
	DVB_TERRESTRIAL_CHANNEL_GUARD_INTERVAL,
	DVB_TERRESTRIAL_CHANNEL_HIERARCHY
};
DVBTerrestrialChannel* dvb_terrestrial_channel_new (guint group_id);
DVBTerrestrialChannel* dvb_terrestrial_channel_construct (GType object_type, guint group_id);
DVBChannel* dvb_channel_construct (GType object_type, guint group_id);
DVBTerrestrialChannel* dvb_terrestrial_channel_new_without_schedule (void);
DVBTerrestrialChannel* dvb_terrestrial_channel_construct_without_schedule (GType object_type);
DVBChannel* dvb_channel_construct_without_schedule (GType object_type);
static void dvb_terrestrial_channel_real_setup_dvb_source (DVBChannel* base, GstElement* source);
DVBDvbSrcModulation dvb_terrestrial_channel_get_Constellation (DVBTerrestrialChannel* self);
DVBDvbSrcTransmissionMode dvb_terrestrial_channel_get_TransmissionMode (DVBTerrestrialChannel* self);
DVBDvbSrcCodeRate dvb_terrestrial_channel_get_CodeRateHP (DVBTerrestrialChannel* self);
DVBDvbSrcCodeRate dvb_terrestrial_channel_get_CodeRateLP (DVBTerrestrialChannel* self);
DVBDvbSrcGuard dvb_terrestrial_channel_get_GuardInterval (DVBTerrestrialChannel* self);
DVBDvbSrcBandwidth dvb_terrestrial_channel_get_Bandwidth (DVBTerrestrialChannel* self);
guint dvb_channel_get_Frequency (DVBChannel* self);
DVBDvbSrcHierarchy dvb_terrestrial_channel_get_Hierarchy (DVBTerrestrialChannel* self);
DVBDvbSrcInversion dvb_terrestrial_channel_get_Inversion (DVBTerrestrialChannel* self);
static gchar* dvb_terrestrial_channel_real_to_string (DVBChannel* base);
const gchar* dvb_channel_get_Name (DVBChannel* self);
const gchar* dvb_utils_get_nick_from_enum (GType enumtype, gint val);
guint dvb_channel_get_VideoPID (DVBChannel* self);
gchar* dvb_channel_get_audio_pids_string (DVBChannel* self);
guint dvb_channel_get_Sid (DVBChannel* self);
void dvb_terrestrial_channel_set_Inversion (DVBTerrestrialChannel* self, DVBDvbSrcInversion value);
void dvb_terrestrial_channel_set_Bandwidth (DVBTerrestrialChannel* self, DVBDvbSrcBandwidth value);
void dvb_terrestrial_channel_set_CodeRateHP (DVBTerrestrialChannel* self, DVBDvbSrcCodeRate value);
void dvb_terrestrial_channel_set_CodeRateLP (DVBTerrestrialChannel* self, DVBDvbSrcCodeRate value);
void dvb_terrestrial_channel_set_Constellation (DVBTerrestrialChannel* self, DVBDvbSrcModulation value);
void dvb_terrestrial_channel_set_TransmissionMode (DVBTerrestrialChannel* self, DVBDvbSrcTransmissionMode value);
void dvb_terrestrial_channel_set_GuardInterval (DVBTerrestrialChannel* self, DVBDvbSrcGuard value);
void dvb_terrestrial_channel_set_Hierarchy (DVBTerrestrialChannel* self, DVBDvbSrcHierarchy value);
static void dvb_terrestrial_channel_finalize (GObject* obj);
static void _vala_dvb_terrestrial_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_terrestrial_channel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


DVBTerrestrialChannel* dvb_terrestrial_channel_construct (GType object_type, guint group_id) {
	DVBTerrestrialChannel * self = NULL;
	guint _tmp0_;
	_tmp0_ = group_id;
	self = (DVBTerrestrialChannel*) dvb_channel_construct (object_type, _tmp0_);
	return self;
}


DVBTerrestrialChannel* dvb_terrestrial_channel_new (guint group_id) {
	return dvb_terrestrial_channel_construct (DVB_TYPE_TERRESTRIAL_CHANNEL, group_id);
}


DVBTerrestrialChannel* dvb_terrestrial_channel_construct_without_schedule (GType object_type) {
	DVBTerrestrialChannel * self = NULL;
	self = (DVBTerrestrialChannel*) dvb_channel_construct_without_schedule (object_type);
	return self;
}


DVBTerrestrialChannel* dvb_terrestrial_channel_new_without_schedule (void) {
	return dvb_terrestrial_channel_construct_without_schedule (DVB_TYPE_TERRESTRIAL_CHANNEL);
}


static void dvb_terrestrial_channel_real_setup_dvb_source (DVBChannel* base, GstElement* source) {
	DVBTerrestrialChannel * self;
	GstElement* _tmp0_;
	DVBDvbSrcModulation _tmp1_;
	GstElement* _tmp2_;
	DVBDvbSrcTransmissionMode _tmp3_;
	GstElement* _tmp4_;
	DVBDvbSrcCodeRate _tmp5_;
	GstElement* _tmp6_;
	DVBDvbSrcCodeRate _tmp7_;
	GstElement* _tmp8_;
	DVBDvbSrcGuard _tmp9_;
	GstElement* _tmp10_;
	DVBDvbSrcBandwidth _tmp11_;
	GstElement* _tmp12_;
	guint _tmp13_;
	guint _tmp14_;
	GstElement* _tmp15_;
	DVBDvbSrcHierarchy _tmp16_;
	GstElement* _tmp17_;
	DVBDvbSrcInversion _tmp18_;
	self = (DVBTerrestrialChannel*) base;
	g_return_if_fail (source != NULL);
	_tmp0_ = source;
	_tmp1_ = self->priv->_Constellation;
	g_object_set ((GObject*) _tmp0_, "modulation", _tmp1_, NULL);
	_tmp2_ = source;
	_tmp3_ = self->priv->_TransmissionMode;
	g_object_set ((GObject*) _tmp2_, "trans-mode", _tmp3_, NULL);
	_tmp4_ = source;
	_tmp5_ = self->priv->_CodeRateHP;
	g_object_set ((GObject*) _tmp4_, "code-rate-hp", _tmp5_, NULL);
	_tmp6_ = source;
	_tmp7_ = self->priv->_CodeRateLP;
	g_object_set ((GObject*) _tmp6_, "code-rate-lp", _tmp7_, NULL);
	_tmp8_ = source;
	_tmp9_ = self->priv->_GuardInterval;
	g_object_set ((GObject*) _tmp8_, "guard", _tmp9_, NULL);
	_tmp10_ = source;
	_tmp11_ = self->priv->_Bandwidth;
	g_object_set ((GObject*) _tmp10_, "bandwidth", _tmp11_, NULL);
	_tmp12_ = source;
	_tmp13_ = dvb_channel_get_Frequency ((DVBChannel*) self);
	_tmp14_ = _tmp13_;
	g_object_set ((GObject*) _tmp12_, "frequency", _tmp14_, NULL);
	_tmp15_ = source;
	_tmp16_ = self->priv->_Hierarchy;
	g_object_set ((GObject*) _tmp15_, "hierarchy", _tmp16_, NULL);
	_tmp17_ = source;
	_tmp18_ = self->priv->_Inversion;
	g_object_set ((GObject*) _tmp17_, "inversion", _tmp18_, NULL);
}


static gchar* dvb_terrestrial_channel_real_to_string (DVBChannel* base) {
	DVBTerrestrialChannel * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	DVBDvbSrcInversion _tmp4_;
	const gchar* _tmp5_ = NULL;
	DVBDvbSrcBandwidth _tmp6_;
	const gchar* _tmp7_ = NULL;
	DVBDvbSrcCodeRate _tmp8_;
	const gchar* _tmp9_ = NULL;
	DVBDvbSrcCodeRate _tmp10_;
	const gchar* _tmp11_ = NULL;
	DVBDvbSrcModulation _tmp12_;
	const gchar* _tmp13_ = NULL;
	DVBDvbSrcTransmissionMode _tmp14_;
	const gchar* _tmp15_ = NULL;
	DVBDvbSrcGuard _tmp16_;
	const gchar* _tmp17_ = NULL;
	DVBDvbSrcHierarchy _tmp18_;
	const gchar* _tmp19_ = NULL;
	guint _tmp20_;
	guint _tmp21_;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	guint _tmp24_;
	guint _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	self = (DVBTerrestrialChannel*) base;
	_tmp0_ = dvb_channel_get_Name ((DVBChannel*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = dvb_channel_get_Frequency ((DVBChannel*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_Inversion;
	_tmp5_ = dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_INVERSION, (gint) _tmp4_);
	_tmp6_ = self->priv->_Bandwidth;
	_tmp7_ = dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_BANDWIDTH, (gint) _tmp6_);
	_tmp8_ = self->priv->_CodeRateHP;
	_tmp9_ = dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_CODE_RATE, (gint) _tmp8_);
	_tmp10_ = self->priv->_CodeRateLP;
	_tmp11_ = dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_CODE_RATE, (gint) _tmp10_);
	_tmp12_ = self->priv->_Constellation;
	_tmp13_ = dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_MODULATION, (gint) _tmp12_);
	_tmp14_ = self->priv->_TransmissionMode;
	_tmp15_ = dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_TRANSMISSION_MODE, (gint) _tmp14_);
	_tmp16_ = self->priv->_GuardInterval;
	_tmp17_ = dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_GUARD, (gint) _tmp16_);
	_tmp18_ = self->priv->_Hierarchy;
	_tmp19_ = dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_HIERARCHY, (gint) _tmp18_);
	_tmp20_ = dvb_channel_get_VideoPID ((DVBChannel*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = dvb_channel_get_audio_pids_string ((DVBChannel*) self);
	_tmp23_ = _tmp22_;
	_tmp24_ = dvb_channel_get_Sid ((DVBChannel*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_strdup_printf ("%s:%u:%s:%s:%s:%s:%s:%s:%s:%s:%u:%s:%u", _tmp1_, _tmp3_, _tmp5_, _tmp7_, _tmp9_, _tmp11_, _tmp13_, _tmp15_, _tmp17_, _tmp19_, _tmp21_, _tmp23_, _tmp25_);
	_tmp27_ = _tmp26_;
	_g_free0 (_tmp23_);
	result = _tmp27_;
	return result;
}


DVBDvbSrcInversion dvb_terrestrial_channel_get_Inversion (DVBTerrestrialChannel* self) {
	DVBDvbSrcInversion result;
	DVBDvbSrcInversion _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_Inversion;
	result = _tmp0_;
	return result;
}


void dvb_terrestrial_channel_set_Inversion (DVBTerrestrialChannel* self, DVBDvbSrcInversion value) {
	DVBDvbSrcInversion _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_Inversion = _tmp0_;
	g_object_notify ((GObject *) self, "Inversion");
}


DVBDvbSrcBandwidth dvb_terrestrial_channel_get_Bandwidth (DVBTerrestrialChannel* self) {
	DVBDvbSrcBandwidth result;
	DVBDvbSrcBandwidth _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_Bandwidth;
	result = _tmp0_;
	return result;
}


void dvb_terrestrial_channel_set_Bandwidth (DVBTerrestrialChannel* self, DVBDvbSrcBandwidth value) {
	DVBDvbSrcBandwidth _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_Bandwidth = _tmp0_;
	g_object_notify ((GObject *) self, "Bandwidth");
}


DVBDvbSrcCodeRate dvb_terrestrial_channel_get_CodeRateHP (DVBTerrestrialChannel* self) {
	DVBDvbSrcCodeRate result;
	DVBDvbSrcCodeRate _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_CodeRateHP;
	result = _tmp0_;
	return result;
}


void dvb_terrestrial_channel_set_CodeRateHP (DVBTerrestrialChannel* self, DVBDvbSrcCodeRate value) {
	DVBDvbSrcCodeRate _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_CodeRateHP = _tmp0_;
	g_object_notify ((GObject *) self, "CodeRateHP");
}


DVBDvbSrcCodeRate dvb_terrestrial_channel_get_CodeRateLP (DVBTerrestrialChannel* self) {
	DVBDvbSrcCodeRate result;
	DVBDvbSrcCodeRate _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_CodeRateLP;
	result = _tmp0_;
	return result;
}


void dvb_terrestrial_channel_set_CodeRateLP (DVBTerrestrialChannel* self, DVBDvbSrcCodeRate value) {
	DVBDvbSrcCodeRate _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_CodeRateLP = _tmp0_;
	g_object_notify ((GObject *) self, "CodeRateLP");
}


DVBDvbSrcModulation dvb_terrestrial_channel_get_Constellation (DVBTerrestrialChannel* self) {
	DVBDvbSrcModulation result;
	DVBDvbSrcModulation _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_Constellation;
	result = _tmp0_;
	return result;
}


void dvb_terrestrial_channel_set_Constellation (DVBTerrestrialChannel* self, DVBDvbSrcModulation value) {
	DVBDvbSrcModulation _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_Constellation = _tmp0_;
	g_object_notify ((GObject *) self, "Constellation");
}


DVBDvbSrcTransmissionMode dvb_terrestrial_channel_get_TransmissionMode (DVBTerrestrialChannel* self) {
	DVBDvbSrcTransmissionMode result;
	DVBDvbSrcTransmissionMode _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_TransmissionMode;
	result = _tmp0_;
	return result;
}


void dvb_terrestrial_channel_set_TransmissionMode (DVBTerrestrialChannel* self, DVBDvbSrcTransmissionMode value) {
	DVBDvbSrcTransmissionMode _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_TransmissionMode = _tmp0_;
	g_object_notify ((GObject *) self, "TransmissionMode");
}


DVBDvbSrcGuard dvb_terrestrial_channel_get_GuardInterval (DVBTerrestrialChannel* self) {
	DVBDvbSrcGuard result;
	DVBDvbSrcGuard _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_GuardInterval;
	result = _tmp0_;
	return result;
}


void dvb_terrestrial_channel_set_GuardInterval (DVBTerrestrialChannel* self, DVBDvbSrcGuard value) {
	DVBDvbSrcGuard _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_GuardInterval = _tmp0_;
	g_object_notify ((GObject *) self, "GuardInterval");
}


DVBDvbSrcHierarchy dvb_terrestrial_channel_get_Hierarchy (DVBTerrestrialChannel* self) {
	DVBDvbSrcHierarchy result;
	DVBDvbSrcHierarchy _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_Hierarchy;
	result = _tmp0_;
	return result;
}


void dvb_terrestrial_channel_set_Hierarchy (DVBTerrestrialChannel* self, DVBDvbSrcHierarchy value) {
	DVBDvbSrcHierarchy _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_Hierarchy = _tmp0_;
	g_object_notify ((GObject *) self, "Hierarchy");
}


static void dvb_terrestrial_channel_class_init (DVBTerrestrialChannelClass * klass) {
	dvb_terrestrial_channel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBTerrestrialChannelPrivate));
	DVB_CHANNEL_CLASS (klass)->setup_dvb_source = dvb_terrestrial_channel_real_setup_dvb_source;
	DVB_CHANNEL_CLASS (klass)->to_string = dvb_terrestrial_channel_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_terrestrial_channel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_terrestrial_channel_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_terrestrial_channel_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TERRESTRIAL_CHANNEL_INVERSION, g_param_spec_enum ("Inversion", "Inversion", "Inversion", DVB_TYPE_DVB_SRC_INVERSION, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TERRESTRIAL_CHANNEL_BANDWIDTH, g_param_spec_enum ("Bandwidth", "Bandwidth", "Bandwidth", DVB_TYPE_DVB_SRC_BANDWIDTH, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TERRESTRIAL_CHANNEL_CODE_RATE_HP, g_param_spec_enum ("CodeRateHP", "CodeRateHP", "CodeRateHP", DVB_TYPE_DVB_SRC_CODE_RATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TERRESTRIAL_CHANNEL_CODE_RATE_LP, g_param_spec_enum ("CodeRateLP", "CodeRateLP", "CodeRateLP", DVB_TYPE_DVB_SRC_CODE_RATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TERRESTRIAL_CHANNEL_CONSTELLATION, g_param_spec_enum ("Constellation", "Constellation", "Constellation", DVB_TYPE_DVB_SRC_MODULATION, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TERRESTRIAL_CHANNEL_TRANSMISSION_MODE, g_param_spec_enum ("TransmissionMode", "TransmissionMode", "TransmissionMode", DVB_TYPE_DVB_SRC_TRANSMISSION_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TERRESTRIAL_CHANNEL_GUARD_INTERVAL, g_param_spec_enum ("GuardInterval", "GuardInterval", "GuardInterval", DVB_TYPE_DVB_SRC_GUARD, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TERRESTRIAL_CHANNEL_HIERARCHY, g_param_spec_enum ("Hierarchy", "Hierarchy", "Hierarchy", DVB_TYPE_DVB_SRC_HIERARCHY, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void dvb_terrestrial_channel_instance_init (DVBTerrestrialChannel * self) {
	self->priv = DVB_TERRESTRIAL_CHANNEL_GET_PRIVATE (self);
}


static void dvb_terrestrial_channel_finalize (GObject* obj) {
	DVBTerrestrialChannel * self;
	self = DVB_TERRESTRIAL_CHANNEL (obj);
	G_OBJECT_CLASS (dvb_terrestrial_channel_parent_class)->finalize (obj);
}


GType dvb_terrestrial_channel_get_type (void) {
	static volatile gsize dvb_terrestrial_channel_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_terrestrial_channel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBTerrestrialChannelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_terrestrial_channel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBTerrestrialChannel), 0, (GInstanceInitFunc) dvb_terrestrial_channel_instance_init, NULL };
		GType dvb_terrestrial_channel_type_id;
		dvb_terrestrial_channel_type_id = g_type_register_static (DVB_TYPE_CHANNEL, "DVBTerrestrialChannel", &g_define_type_info, 0);
		g_once_init_leave (&dvb_terrestrial_channel_type_id__volatile, dvb_terrestrial_channel_type_id);
	}
	return dvb_terrestrial_channel_type_id__volatile;
}


static void _vala_dvb_terrestrial_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBTerrestrialChannel * self;
	self = DVB_TERRESTRIAL_CHANNEL (object);
	switch (property_id) {
		case DVB_TERRESTRIAL_CHANNEL_INVERSION:
		g_value_set_enum (value, dvb_terrestrial_channel_get_Inversion (self));
		break;
		case DVB_TERRESTRIAL_CHANNEL_BANDWIDTH:
		g_value_set_enum (value, dvb_terrestrial_channel_get_Bandwidth (self));
		break;
		case DVB_TERRESTRIAL_CHANNEL_CODE_RATE_HP:
		g_value_set_enum (value, dvb_terrestrial_channel_get_CodeRateHP (self));
		break;
		case DVB_TERRESTRIAL_CHANNEL_CODE_RATE_LP:
		g_value_set_enum (value, dvb_terrestrial_channel_get_CodeRateLP (self));
		break;
		case DVB_TERRESTRIAL_CHANNEL_CONSTELLATION:
		g_value_set_enum (value, dvb_terrestrial_channel_get_Constellation (self));
		break;
		case DVB_TERRESTRIAL_CHANNEL_TRANSMISSION_MODE:
		g_value_set_enum (value, dvb_terrestrial_channel_get_TransmissionMode (self));
		break;
		case DVB_TERRESTRIAL_CHANNEL_GUARD_INTERVAL:
		g_value_set_enum (value, dvb_terrestrial_channel_get_GuardInterval (self));
		break;
		case DVB_TERRESTRIAL_CHANNEL_HIERARCHY:
		g_value_set_enum (value, dvb_terrestrial_channel_get_Hierarchy (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_terrestrial_channel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBTerrestrialChannel * self;
	self = DVB_TERRESTRIAL_CHANNEL (object);
	switch (property_id) {
		case DVB_TERRESTRIAL_CHANNEL_INVERSION:
		dvb_terrestrial_channel_set_Inversion (self, g_value_get_enum (value));
		break;
		case DVB_TERRESTRIAL_CHANNEL_BANDWIDTH:
		dvb_terrestrial_channel_set_Bandwidth (self, g_value_get_enum (value));
		break;
		case DVB_TERRESTRIAL_CHANNEL_CODE_RATE_HP:
		dvb_terrestrial_channel_set_CodeRateHP (self, g_value_get_enum (value));
		break;
		case DVB_TERRESTRIAL_CHANNEL_CODE_RATE_LP:
		dvb_terrestrial_channel_set_CodeRateLP (self, g_value_get_enum (value));
		break;
		case DVB_TERRESTRIAL_CHANNEL_CONSTELLATION:
		dvb_terrestrial_channel_set_Constellation (self, g_value_get_enum (value));
		break;
		case DVB_TERRESTRIAL_CHANNEL_TRANSMISSION_MODE:
		dvb_terrestrial_channel_set_TransmissionMode (self, g_value_get_enum (value));
		break;
		case DVB_TERRESTRIAL_CHANNEL_GUARD_INTERVAL:
		dvb_terrestrial_channel_set_GuardInterval (self, g_value_get_enum (value));
		break;
		case DVB_TERRESTRIAL_CHANNEL_HIERARCHY:
		dvb_terrestrial_channel_set_Hierarchy (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



