/* MpegTsEnums.c generated by valac 0.15.2.10-1402f-dirty, the Vala compiler
 * generated from MpegTsEnums.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define DVB_TYPE_DVB_SRC_CODE_RATE (dvb_dvb_src_code_rate_get_type ())

#define DVB_TYPE_DVB_SRC_MODULATION (dvb_dvb_src_modulation_get_type ())

#define DVB_TYPE_DVB_SRC_TRANSMISSION_MODE (dvb_dvb_src_transmission_mode_get_type ())

#define DVB_TYPE_DVB_SRC_BANDWIDTH (dvb_dvb_src_bandwidth_get_type ())

#define DVB_TYPE_DVB_SRC_GUARD (dvb_dvb_src_guard_get_type ())

#define DVB_TYPE_DVB_SRC_HIERARCHY (dvb_dvb_src_hierarchy_get_type ())

#define DVB_TYPE_DVB_SRC_INVERSION (dvb_dvb_src_inversion_get_type ())

typedef enum  {
	DVB_DVB_SRC_CODE_RATE_FEC_NONE,
	DVB_DVB_SRC_CODE_RATE_FEC_1_2,
	DVB_DVB_SRC_CODE_RATE_FEC_2_3,
	DVB_DVB_SRC_CODE_RATE_FEC_3_4,
	DVB_DVB_SRC_CODE_RATE_FEC_4_5,
	DVB_DVB_SRC_CODE_RATE_FEC_5_6,
	DVB_DVB_SRC_CODE_RATE_FEC_6_7,
	DVB_DVB_SRC_CODE_RATE_FEC_7_8,
	DVB_DVB_SRC_CODE_RATE_FEC_8_9,
	DVB_DVB_SRC_CODE_RATE_FEC_AUTO
} DVBDvbSrcCodeRate;

typedef enum  {
	DVB_DVB_SRC_MODULATION_QPSK,
	DVB_DVB_SRC_MODULATION_QAM_16,
	DVB_DVB_SRC_MODULATION_QAM_32,
	DVB_DVB_SRC_MODULATION_QAM_64,
	DVB_DVB_SRC_MODULATION_QAM_128,
	DVB_DVB_SRC_MODULATION_QAM_256,
	DVB_DVB_SRC_MODULATION_QAM_AUTO
} DVBDvbSrcModulation;

typedef enum  {
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_2K,
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_8K,
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_AUTO
} DVBDvbSrcTransmissionMode;

typedef enum  {
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_8_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_7_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_6_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_AUTO
} DVBDvbSrcBandwidth;

typedef enum  {
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_32,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_16,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_8,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_4,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_AUTO
} DVBDvbSrcGuard;

typedef enum  {
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_NONE,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_1,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_2,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_4,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_AUTO
} DVBDvbSrcHierarchy;

typedef enum  {
	DVB_DVB_SRC_INVERSION_INVERSION_OFF,
	DVB_DVB_SRC_INVERSION_INVERSION_ON,
	DVB_DVB_SRC_INVERSION_INVERSION_AUTO
} DVBDvbSrcInversion;



GType dvb_dvb_src_code_rate_get_type (void) G_GNUC_CONST;
GType dvb_dvb_src_modulation_get_type (void) G_GNUC_CONST;
GType dvb_dvb_src_transmission_mode_get_type (void) G_GNUC_CONST;
GType dvb_dvb_src_bandwidth_get_type (void) G_GNUC_CONST;
GType dvb_dvb_src_guard_get_type (void) G_GNUC_CONST;
GType dvb_dvb_src_hierarchy_get_type (void) G_GNUC_CONST;
GType dvb_dvb_src_inversion_get_type (void) G_GNUC_CONST;
DVBDvbSrcBandwidth dvb_get_bandwidth_val (guint bandwidth);
DVBDvbSrcHierarchy dvb_get_hierarchy_val (guint hierarchy);
DVBDvbSrcModulation dvb_get_modulation_val (const gchar* constellation);
DVBDvbSrcCodeRate dvb_get_code_rate_val (const gchar* code_rate_string);
DVBDvbSrcGuard dvb_get_guard_interval_val (guint guard);
DVBDvbSrcTransmissionMode dvb_get_transmission_mode_val (const gchar* transmode);


GType dvb_dvb_src_code_rate_get_type (void) {
	static volatile gsize dvb_dvb_src_code_rate_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_dvb_src_code_rate_type_id__volatile)) {
		static const GEnumValue values[] = {{DVB_DVB_SRC_CODE_RATE_FEC_NONE, "DVB_DVB_SRC_CODE_RATE_FEC_NONE", "fec-none"}, {DVB_DVB_SRC_CODE_RATE_FEC_1_2, "DVB_DVB_SRC_CODE_RATE_FEC_1_2", "fec-1-2"}, {DVB_DVB_SRC_CODE_RATE_FEC_2_3, "DVB_DVB_SRC_CODE_RATE_FEC_2_3", "fec-2-3"}, {DVB_DVB_SRC_CODE_RATE_FEC_3_4, "DVB_DVB_SRC_CODE_RATE_FEC_3_4", "fec-3-4"}, {DVB_DVB_SRC_CODE_RATE_FEC_4_5, "DVB_DVB_SRC_CODE_RATE_FEC_4_5", "fec-4-5"}, {DVB_DVB_SRC_CODE_RATE_FEC_5_6, "DVB_DVB_SRC_CODE_RATE_FEC_5_6", "fec-5-6"}, {DVB_DVB_SRC_CODE_RATE_FEC_6_7, "DVB_DVB_SRC_CODE_RATE_FEC_6_7", "fec-6-7"}, {DVB_DVB_SRC_CODE_RATE_FEC_7_8, "DVB_DVB_SRC_CODE_RATE_FEC_7_8", "fec-7-8"}, {DVB_DVB_SRC_CODE_RATE_FEC_8_9, "DVB_DVB_SRC_CODE_RATE_FEC_8_9", "fec-8-9"}, {DVB_DVB_SRC_CODE_RATE_FEC_AUTO, "DVB_DVB_SRC_CODE_RATE_FEC_AUTO", "fec-auto"}, {0, NULL, NULL}};
		GType dvb_dvb_src_code_rate_type_id;
		dvb_dvb_src_code_rate_type_id = g_enum_register_static ("DVBDvbSrcCodeRate", values);
		g_once_init_leave (&dvb_dvb_src_code_rate_type_id__volatile, dvb_dvb_src_code_rate_type_id);
	}
	return dvb_dvb_src_code_rate_type_id__volatile;
}


GType dvb_dvb_src_modulation_get_type (void) {
	static volatile gsize dvb_dvb_src_modulation_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_dvb_src_modulation_type_id__volatile)) {
		static const GEnumValue values[] = {{DVB_DVB_SRC_MODULATION_QPSK, "DVB_DVB_SRC_MODULATION_QPSK", "qpsk"}, {DVB_DVB_SRC_MODULATION_QAM_16, "DVB_DVB_SRC_MODULATION_QAM_16", "qam-16"}, {DVB_DVB_SRC_MODULATION_QAM_32, "DVB_DVB_SRC_MODULATION_QAM_32", "qam-32"}, {DVB_DVB_SRC_MODULATION_QAM_64, "DVB_DVB_SRC_MODULATION_QAM_64", "qam-64"}, {DVB_DVB_SRC_MODULATION_QAM_128, "DVB_DVB_SRC_MODULATION_QAM_128", "qam-128"}, {DVB_DVB_SRC_MODULATION_QAM_256, "DVB_DVB_SRC_MODULATION_QAM_256", "qam-256"}, {DVB_DVB_SRC_MODULATION_QAM_AUTO, "DVB_DVB_SRC_MODULATION_QAM_AUTO", "qam-auto"}, {0, NULL, NULL}};
		GType dvb_dvb_src_modulation_type_id;
		dvb_dvb_src_modulation_type_id = g_enum_register_static ("DVBDvbSrcModulation", values);
		g_once_init_leave (&dvb_dvb_src_modulation_type_id__volatile, dvb_dvb_src_modulation_type_id);
	}
	return dvb_dvb_src_modulation_type_id__volatile;
}


GType dvb_dvb_src_transmission_mode_get_type (void) {
	static volatile gsize dvb_dvb_src_transmission_mode_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_dvb_src_transmission_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_2K, "DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_2K", "transmission-mode-2k"}, {DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_8K, "DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_8K", "transmission-mode-8k"}, {DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_AUTO, "DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_AUTO", "transmission-mode-auto"}, {0, NULL, NULL}};
		GType dvb_dvb_src_transmission_mode_type_id;
		dvb_dvb_src_transmission_mode_type_id = g_enum_register_static ("DVBDvbSrcTransmissionMode", values);
		g_once_init_leave (&dvb_dvb_src_transmission_mode_type_id__volatile, dvb_dvb_src_transmission_mode_type_id);
	}
	return dvb_dvb_src_transmission_mode_type_id__volatile;
}


GType dvb_dvb_src_bandwidth_get_type (void) {
	static volatile gsize dvb_dvb_src_bandwidth_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_dvb_src_bandwidth_type_id__volatile)) {
		static const GEnumValue values[] = {{DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_8_MHZ, "DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_8_MHZ", "bandwidth-8-mhz"}, {DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_7_MHZ, "DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_7_MHZ", "bandwidth-7-mhz"}, {DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_6_MHZ, "DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_6_MHZ", "bandwidth-6-mhz"}, {DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_AUTO, "DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_AUTO", "bandwidth-auto"}, {0, NULL, NULL}};
		GType dvb_dvb_src_bandwidth_type_id;
		dvb_dvb_src_bandwidth_type_id = g_enum_register_static ("DVBDvbSrcBandwidth", values);
		g_once_init_leave (&dvb_dvb_src_bandwidth_type_id__volatile, dvb_dvb_src_bandwidth_type_id);
	}
	return dvb_dvb_src_bandwidth_type_id__volatile;
}


GType dvb_dvb_src_guard_get_type (void) {
	static volatile gsize dvb_dvb_src_guard_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_dvb_src_guard_type_id__volatile)) {
		static const GEnumValue values[] = {{DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_32, "DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_32", "guard-interval-1-32"}, {DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_16, "DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_16", "guard-interval-1-16"}, {DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_8, "DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_8", "guard-interval-1-8"}, {DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_4, "DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_4", "guard-interval-1-4"}, {DVB_DVB_SRC_GUARD_GUARD_INTERVAL_AUTO, "DVB_DVB_SRC_GUARD_GUARD_INTERVAL_AUTO", "guard-interval-auto"}, {0, NULL, NULL}};
		GType dvb_dvb_src_guard_type_id;
		dvb_dvb_src_guard_type_id = g_enum_register_static ("DVBDvbSrcGuard", values);
		g_once_init_leave (&dvb_dvb_src_guard_type_id__volatile, dvb_dvb_src_guard_type_id);
	}
	return dvb_dvb_src_guard_type_id__volatile;
}


GType dvb_dvb_src_hierarchy_get_type (void) {
	static volatile gsize dvb_dvb_src_hierarchy_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_dvb_src_hierarchy_type_id__volatile)) {
		static const GEnumValue values[] = {{DVB_DVB_SRC_HIERARCHY_HIERARCHY_NONE, "DVB_DVB_SRC_HIERARCHY_HIERARCHY_NONE", "hierarchy-none"}, {DVB_DVB_SRC_HIERARCHY_HIERARCHY_1, "DVB_DVB_SRC_HIERARCHY_HIERARCHY_1", "hierarchy-1"}, {DVB_DVB_SRC_HIERARCHY_HIERARCHY_2, "DVB_DVB_SRC_HIERARCHY_HIERARCHY_2", "hierarchy-2"}, {DVB_DVB_SRC_HIERARCHY_HIERARCHY_4, "DVB_DVB_SRC_HIERARCHY_HIERARCHY_4", "hierarchy-4"}, {DVB_DVB_SRC_HIERARCHY_HIERARCHY_AUTO, "DVB_DVB_SRC_HIERARCHY_HIERARCHY_AUTO", "hierarchy-auto"}, {0, NULL, NULL}};
		GType dvb_dvb_src_hierarchy_type_id;
		dvb_dvb_src_hierarchy_type_id = g_enum_register_static ("DVBDvbSrcHierarchy", values);
		g_once_init_leave (&dvb_dvb_src_hierarchy_type_id__volatile, dvb_dvb_src_hierarchy_type_id);
	}
	return dvb_dvb_src_hierarchy_type_id__volatile;
}


GType dvb_dvb_src_inversion_get_type (void) {
	static volatile gsize dvb_dvb_src_inversion_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_dvb_src_inversion_type_id__volatile)) {
		static const GEnumValue values[] = {{DVB_DVB_SRC_INVERSION_INVERSION_OFF, "DVB_DVB_SRC_INVERSION_INVERSION_OFF", "inversion-off"}, {DVB_DVB_SRC_INVERSION_INVERSION_ON, "DVB_DVB_SRC_INVERSION_INVERSION_ON", "inversion-on"}, {DVB_DVB_SRC_INVERSION_INVERSION_AUTO, "DVB_DVB_SRC_INVERSION_INVERSION_AUTO", "inversion-auto"}, {0, NULL, NULL}};
		GType dvb_dvb_src_inversion_type_id;
		dvb_dvb_src_inversion_type_id = g_enum_register_static ("DVBDvbSrcInversion", values);
		g_once_init_leave (&dvb_dvb_src_inversion_type_id__volatile, dvb_dvb_src_inversion_type_id);
	}
	return dvb_dvb_src_inversion_type_id__volatile;
}


/**
     * @bandwith: 0, 6, 7 or 8
     */
DVBDvbSrcBandwidth dvb_get_bandwidth_val (guint bandwidth) {
	DVBDvbSrcBandwidth result = 0;
	DVBDvbSrcBandwidth val = 0;
	guint _tmp0_;
	_tmp0_ = bandwidth;
	switch (_tmp0_) {
		case 6:
		{
			val = DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_6_MHZ;
			break;
		}
		case 7:
		{
			val = DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_7_MHZ;
			break;
		}
		case 8:
		{
			val = DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_8_MHZ;
			break;
		}
		default:
		{
			val = DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_AUTO;
			break;
		}
	}
	result = val;
	return result;
}


/**
     * @hierarchy: 0, 1, 2 or 4.
     * If value doesn't match one of above HIERARCHY_AUTO is returned.
     */
DVBDvbSrcHierarchy dvb_get_hierarchy_val (guint hierarchy) {
	DVBDvbSrcHierarchy result = 0;
	DVBDvbSrcHierarchy val = 0;
	guint _tmp0_;
	_tmp0_ = hierarchy;
	switch (_tmp0_) {
		case 0:
		{
			val = DVB_DVB_SRC_HIERARCHY_HIERARCHY_NONE;
			break;
		}
		case 1:
		{
			val = DVB_DVB_SRC_HIERARCHY_HIERARCHY_1;
			break;
		}
		case 2:
		{
			val = DVB_DVB_SRC_HIERARCHY_HIERARCHY_2;
			break;
		}
		case 4:
		{
			val = DVB_DVB_SRC_HIERARCHY_HIERARCHY_4;
			break;
		}
		default:
		{
			val = DVB_DVB_SRC_HIERARCHY_HIERARCHY_AUTO;
			break;
		}
	}
	result = val;
	return result;
}


/**
     * @modulation: QPSK, QAM16, QAM32, QAM64, QAM128 or QAM256.
     * If value doesn't match one of above QAM_AUTO is returned.
     */
DVBDvbSrcModulation dvb_get_modulation_val (const gchar* constellation) {
	DVBDvbSrcModulation result = 0;
	DVBDvbSrcModulation val = 0;
	const gchar* _tmp0_;
	g_return_val_if_fail (constellation != NULL, 0);
	_tmp0_ = constellation;
	if (g_strcmp0 (_tmp0_, "QPSK") == 0) {
		val = DVB_DVB_SRC_MODULATION_QPSK;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = constellation;
		if (g_strcmp0 (_tmp1_, "QAM16") == 0) {
			val = DVB_DVB_SRC_MODULATION_QAM_16;
		} else {
			const gchar* _tmp2_;
			_tmp2_ = constellation;
			if (g_strcmp0 (_tmp2_, "QAM32") == 0) {
				val = DVB_DVB_SRC_MODULATION_QAM_32;
			} else {
				const gchar* _tmp3_;
				_tmp3_ = constellation;
				if (g_strcmp0 (_tmp3_, "QAM64") == 0) {
					val = DVB_DVB_SRC_MODULATION_QAM_64;
				} else {
					const gchar* _tmp4_;
					_tmp4_ = constellation;
					if (g_strcmp0 (_tmp4_, "QAM128") == 0) {
						val = DVB_DVB_SRC_MODULATION_QAM_128;
					} else {
						const gchar* _tmp5_;
						_tmp5_ = constellation;
						if (g_strcmp0 (_tmp5_, "QAM256") == 0) {
							val = DVB_DVB_SRC_MODULATION_QAM_256;
						} else {
							val = DVB_DVB_SRC_MODULATION_QAM_AUTO;
						}
					}
				}
			}
		}
	}
	result = val;
	return result;
}


/**
     * @code_rate_string: "NONE", 1/2", "2/3", "3/4", "4/5", "5/6", "6/7",
     * "7/8" or "8/9".
     * If value doesn't match one of above FEC_AUTO is returned.
     */
DVBDvbSrcCodeRate dvb_get_code_rate_val (const gchar* code_rate_string) {
	DVBDvbSrcCodeRate result = 0;
	DVBDvbSrcCodeRate val = 0;
	const gchar* _tmp0_;
	g_return_val_if_fail (code_rate_string != NULL, 0);
	_tmp0_ = code_rate_string;
	if (g_strcmp0 (_tmp0_, "NONE") == 0) {
		val = DVB_DVB_SRC_CODE_RATE_FEC_NONE;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = code_rate_string;
		if (g_strcmp0 (_tmp1_, "1/2") == 0) {
			val = DVB_DVB_SRC_CODE_RATE_FEC_1_2;
		} else {
			const gchar* _tmp2_;
			_tmp2_ = code_rate_string;
			if (g_strcmp0 (_tmp2_, "2/3") == 0) {
				val = DVB_DVB_SRC_CODE_RATE_FEC_2_3;
			} else {
				const gchar* _tmp3_;
				_tmp3_ = code_rate_string;
				if (g_strcmp0 (_tmp3_, "3/4") == 0) {
					val = DVB_DVB_SRC_CODE_RATE_FEC_3_4;
				} else {
					const gchar* _tmp4_;
					_tmp4_ = code_rate_string;
					if (g_strcmp0 (_tmp4_, "4/5") == 0) {
						val = DVB_DVB_SRC_CODE_RATE_FEC_4_5;
					} else {
						const gchar* _tmp5_;
						_tmp5_ = code_rate_string;
						if (g_strcmp0 (_tmp5_, "5/6") == 0) {
							val = DVB_DVB_SRC_CODE_RATE_FEC_5_6;
						} else {
							const gchar* _tmp6_;
							_tmp6_ = code_rate_string;
							if (g_strcmp0 (_tmp6_, "6/7") == 0) {
								val = DVB_DVB_SRC_CODE_RATE_FEC_5_6;
							} else {
								const gchar* _tmp7_;
								_tmp7_ = code_rate_string;
								if (g_strcmp0 (_tmp7_, "7/8") == 0) {
									val = DVB_DVB_SRC_CODE_RATE_FEC_7_8;
								} else {
									const gchar* _tmp8_;
									_tmp8_ = code_rate_string;
									if (g_strcmp0 (_tmp8_, "8/9") == 0) {
										val = DVB_DVB_SRC_CODE_RATE_FEC_8_9;
									} else {
										val = DVB_DVB_SRC_CODE_RATE_FEC_AUTO;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = val;
	return result;
}


/**
     * @guard: 4, 8, 16 or 32.
     * If value doesn't match one of above GUARD_INTERVAL_AUTO is returned.
     */
DVBDvbSrcGuard dvb_get_guard_interval_val (guint guard) {
	DVBDvbSrcGuard result = 0;
	DVBDvbSrcGuard val = 0;
	guint _tmp0_;
	_tmp0_ = guard;
	switch (_tmp0_) {
		case 4:
		{
			val = DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_4;
			break;
		}
		case 8:
		{
			val = DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_8;
			break;
		}
		case 16:
		{
			val = DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_16;
			break;
		}
		case 32:
		{
			val = DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_32;
			break;
		}
		default:
		{
			val = DVB_DVB_SRC_GUARD_GUARD_INTERVAL_AUTO;
			break;
		}
	}
	result = val;
	return result;
}


/**
     * @transmode: "2k" or "8k"
     * If value doesn't match one of above TRANSMISSION_MODE_AUTO is returned.
     */
DVBDvbSrcTransmissionMode dvb_get_transmission_mode_val (const gchar* transmode) {
	DVBDvbSrcTransmissionMode result = 0;
	DVBDvbSrcTransmissionMode val = 0;
	const gchar* _tmp0_;
	g_return_val_if_fail (transmode != NULL, 0);
	_tmp0_ = transmode;
	if (g_strcmp0 (_tmp0_, "2k") == 0) {
		val = DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_2K;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = transmode;
		if (g_strcmp0 (_tmp1_, "8k") == 0) {
			val = DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_8K;
		} else {
			val = DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_AUTO;
		}
	}
	result = val;
	return result;
}



