.\"/*
.\" * Copyright (c) 2014-2018, NVIDIA CORPORATION.  All rights reserved.
.\" *
.\" * Licensed under the Apache License, Version 2.0 (the "License");
.\" * you may not use this file except in compliance with the License.
.\" * You may obtain a copy of the License at
.\" *
.\" *     http://www.apache.org/licenses/LICENSE-2.0
.\" *
.\" * Unless required by applicable law or agreed to in writing, software
.\" * distributed under the License is distributed on an "AS IS" BASIS,
.\" * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
.\" * See the License for the specific language governing permissions and
.\" * limitations under the License.
.\" * 
.\" */
.NS 13 "X86-32 ILI Definitions"
.sh 2 "Key to ILI Template Listing"
.lp
.de OP
.ip \f(CW\\$1\fP 12n
..
.ul
ILI Operand Types:
.OP irlnk
link to previous ili with result type ir.
.OP splnk
link to previous ili with result type sp.
.OP dplnk
link to previous ili with result type dp.
.OP arlnk
link to previous ili with result type ar.
.OP krlnk
link to previous ili with result type kr.
.OP qplnk
link to previous ili with result type qp.
.OP cslnk
link to previous ili with result type cs.
.OP cdlnk
link to previous ili with result type cd.
.OP cqlnk
link to previous ili with result type cq.
.OP 128lnk
link to previous ili with result type 128.
.OP 256lnk
link to previous ili with result type 256.
.OP 512lnk
link to previous ili with result type 512.
.OP x87lnk
link to previous ili with result type x87.
.OP cx87lnk
link to previous ili with result type cx87.
.OP lnk
link to previous ili with result type lnk.
.OP ir
integer register number (for x86-32, one of the general purpose registers).
.OP sp
floating-point register number.
.OP dp
double-precision register.
.OP kr
pair of 32 bit integer registers.
.OP cs
single(4+4 bytes) precision complex register.
.OP cd
double(8+8 bytes) precision complex register.
.OP cq
16x2 bytes complex register.
.OP qp
16x2 bytes register.
.OP 128
128 bits register.
.OP 256
256 bits register.
.OP 512
512 bits register.
.OP x87
x87 register.
.OP cx87
cx87 register.
.OP ar
Address register (for x86-32, one of the general purpose registers).
.OP stc
16 bit constant.  May be interpreted as either signed or unsigned depending
on the machine instruction operand which uses it.
.OP nme
pointer to names table entry for a load or store.
.OP sym
symbol table pointer.

.de TY
.ip \f(CW\\$1\fP 12n
..
.lp
.ul
ILI Types (1st attribute of each ILI):
.TY arth
arithmetic operation.
.TY branch
branch operation.
.TY cons
constant.
.TY load
.TY store
.TY define
register define.
.TY proc
function call.
.TY move
register move.
.TY other
.sp
.de CM
.ip \f(CW\\$1\fP 12n
..
.de RT
.ip \f(CW\\$1\fP 12n
..
.lp
.ul
Commutivity attribute (2nd attribute of each ILI):
.CM comm
Commutative operation.
.CM null
Not commutative.
.sp
.lp
.ul
ILI result type (3rd attribute of each ILI):
.RT lnk
no result, but ili is pointed-to by link.
.RT ir
result goes into an integer register.
.RT sp
result goes into a floating-point register.
.RT dp
double-precision floating-point.
.RT ar
address register result.
.RT trm
this ili does not produce a value and cannot be pointed to by any
link operand of another ili.
.de IA
.ip \f(CW\\$1\fP 12n
..
.lp
.ul
Other ILI Attributes:
.IA dom
specifies that this ili is a dominator ili.
.IA cse
specifies that this ili is a candidate for constant subexpression elimination.
An ili is not allowed to have both the cse and the dom attributes.
.IA ssenme
indicates that this is an sse operation with operand 1 an arlnk field and
operand 3 a nme field.
.sp
.de CA
.ip \f(CW\\$1\fP 12n
..
.lp
.sp 2
.br
.sp 2
.sh 2 "ILI Definitions"
.ft CW
.sz 8
.nr IN 0 1
.\"
.\"  define macro used to define ilo:
.de IL
.nr IN +1
.in 0
.ne 5
.nf
\\n(IN. \\$1 \\$2 \\$3 \\$4 \\$5 \\$6 \\$7 \\$8
.in 5
.fi
..
.de FL
.sp
.in 0
.ne 5
.nf
XX. \\$1 \\$2 \\$3 \\$4 \\$5 \\$6 \\$7 \\$8 - (Fortran only)
.in 5
.fi
..
.de CL
.sp
.in 0
.ne 5
.nf
XX. \\$1 \\$2 \\$3 \\$4 \\$5 \\$6 \\$7 \\$8 - (C only)
.in 5
.fi
..
.de OL
.sp
.in 0
.ne 5
.nf
XX. \\$1 \\$2 \\$3 \\$4 \\$5 \\$6 \\$7 \\$8 - (OpenCL only)
.in 5
.fi
..
.\"
.\"  define macro used to define ilo attributes:
.de AT
.br
Attributes:  \\$1 \\$2 \\$3 \\$4 \\$5 \\$6 \\$7 \\$8 \\$9
.br
..
.de CG
.br
Code Generator Attributes:  \\$1 \\$2 \\$3 \\$4 \\$5 \\$6 \\$7 \\$8 \\$9
.sp
.br
..
.\"
.\"  define macro used to define machine instruction for an ilo:
.ta 33 36 40 44 48 52 56 60 64 68 72 76 80
.\"  begin ilo definitions:
.\"

.IL ICON sym
32-bit integer constant.
The value is pulled from the CONVAL2 field of sym.
.AT cons null ir cse
.CG move "mov" 'l'

.IL ACON sym
Load address constant into address register.
\'sym' must be a symtab ptr to an address constant.
.AT cons null ar cse
.CG notAILI

.IL ACON_PIC_EXTRN sym
Address constant used for PIC generation.  It represents the load
of the address of an external variable from the GOT table.
\'sym' is the symbol table pointer for the external variable, NOT
an address constant symbol.
.AT cons null ar cse
.CG CGonly "mov" 'l' asm_special

.IL ACON_STATIC sym sym
Represents the address of a static or external variable, with optional
32-bit signed integer offset.  The first sym points to a static or external
variable, or a label, and the second to a symbol table 32-bit integer constant.
.AT cons null ar cse
.CG CGonly "lea" 'l'

.IL ACON_AUTO sym sym
The address of a stack variable, the first sym is a stack variable and the
second is a 32-bit integer constant.
.AT cons null ar cse
.CG CGonly "lea" 'l'

.IL KCON sym
64-bit integer constant.  'sym' is a symbol table constant of type
DT_INT or DT_INT8.
.AT cons null kr cse
.CG notAILI 'q'

.IL SCMPLXCON sym
Single-precision complex constant.
.AT cons null cs cse
.CG "movsd" move sse_avx
.SI ld double fadd fmul fst lat(3)
.SI st direct fst lat(2)
.SI direct fadd fmul lat(2)

.IL DCMPLXCON sym
Double-precision complex constant.
.AT cons null cd cse
.CG "movapd" move sse_avx
.SI ld double fadd fmul fst lat(3)
.SI st direct fst lat(2)
.SI direct fadd fmul lat(2)

.IL ACEXT sym nme
Label address.
\'sym' is address constant for label symbol.
\'nme' is zero.
.AT cons null ar cse
.CG "mov"

.IL FCON sym
Single-precision floating-point constant.
.AT cons null sp cse
.CG "movss" move

.IL DCON sym
Double-precision floating-point constant.
.AT cons null dp cse
.CG "movsd" move

.IL LD arlnk nme stc
\'arlnk' points to an address expression.
.br
\'nme' points to the names table entry of the variable being referenced.
.br
\'stc' size modifier of the memory operation - one of the MSZ_ macros
defined in ili.h.
For the code generator, possible values are:
        MSZ_SBYTE	signed byte
        MSZ_UBYTE	unsigned byte
        MSZ_SHWORD	signed half-word
        MSZ_UHWORD	unsigned half-word
        MSZ_SWORD	signed word (32-bit)
        MSZ_UWORD	unsigned word
.AT load null ir
.CG "mov" move

.IL LDSP arlnk nme stc
Load single-precision floating value.  'stc' is not used.
.AT load null sp
.CG "movss" move

.IL LDDP arlnk nme stc
Load double precision value.  'stc' is not used.
.AT load null dp
.CG "movsd" move

.IL LDSCMPLX arlnk nme stc
Load single precision complex value.  'stc' is not used.
.AT load null cs
.CG "movsd" move sse_avx
.SI ld double fadd fmul fst lat(3)
.SI st direct fst lat(2)
.SI direct fadd fmul lat(2)

.IL LDDCMPLX arlnk nme stc
Load double precision complex value.  'stc' is not used.
.AT load null cd
.CG "movups" move sse_avx
.SI ld double fadd fmul fst lat(3)
.SI st direct fst lat(2)
.SI direct fadd fmul lat(2)

.IL LDQ arlnk nme stc
Load m128 value.  'stc' is not used.
.AT load null dp
.CG "movapd" move sse_avx
.SI ld double fadd fmul fst lat(3)
.SI st direct fst lat(2)
.SI direct fadd fmul lat(2)

.IL LDQU arlnk nme stc
Load unaligned m128 value.  'stc' is not used.
.AT load null dp
.CG "movupd" move sse_avx
.SI ld double fadd fmul fst lat(3)
.SI st direct fst lat(2)
.SI direct fadd fmul lat(2)

.IL LD256 arlnk nme stc
Load m256 value.  'stc' is not used.
Will generate the aligned case for LD256.
.AT load null dp
.CG "movapd" move sse_avx
.SI ld double fadd fmul fst lat(3)
.SI st direct fst lat(2)
.SI direct fadd fmul lat(2)

.IL LD256A arlnk nme stc
Load aligned m256 value.  'stc' is not used.
Will generate the aligned case for LD256.
.AT load null dp
.CG notAILI

.IL LD256U arlnk nme stc
Load unaligned m256 value.  'stc' is not used.
.AT load null dp
.CG "movupd" move sse_avx
.SI ld double fadd fmul fst lat(3)
.SI st direct fst lat(2)
.SI direct fadd fmul lat(2

.IL LDA arlnk nme
Load address register from memory location whose address
is represented by op1.
For x86-32 compilers, LDA's are replaced by LD's by cgoptim1.
.AT load null ar
.CG notAILI

.IL LDKR arlnk nme stc
Load 64 bit integer value into register pair.  'stc' is not used.
.AT load null kr
.CG notAILI 'q'

.IL INEG irlnk
Signed integer32 negate.
.AT arth null ir cse
.CG memdest ccarith "neg" 'l'

.IL UINEG irlnk
Unsigned integer32 negate.
.AT arth null ir cse
.CG notCG replaceby INEG

.IL KNEG krlnk
Signed integer64 negate.  (note - don't allow the memdest optimization)
.AT arth null kr cse
.CG notAILI 'q'

.IL UKNEG krlnk
Unsigned integer64 negate.
.AT arth null kr cse
.CG notCG replaceby KNEG

.IL FNEG splnk
Single-precision floating-point negate.
.AT arth null sp cse
.CG notAILI

.IL SCMPLXNEG cslnk
Single-precision complex negate.
.AT arth null cs cse
.CG notAILI

.IL DCMPLXNEG cdlnk
Double-precision complex negate.
.AT arth null cd cse
.CG notAILI

.IL FXOR splnk splnk
May be used to implement FNEG operation.  This operation is non-commutative so
we can ensure that a memory operand is not used.
.AT arth null sp cse
.CG notCG "xorps" sse_avx

.IL DNEG dplnk
Double-precision negate.
.AT arth null dp cse
.CG notAILI

.IL SCMPLXXOR cslnk cslnk
This only appears in the LILIs and AILIs, not in shared ILIs.  It is
generated in cgoptim1.c:lili_peephole_opts_2() by transforming
SCMPLXNEG( op1 ) into an SCMPLXXOR LILI in order to negate 'op1' by
XORing its sign bits with 1.  This ILI is specified as non-commutative
(i.e. 'null', not 'comm') for reasons explained in that function.
.AT arth null cs cse
.CG CGonly "xorps" sse_avx

.IL DCMPLXXOR cdlnk cdlnk
This only appears in the LILIs and AILIs, not in shared ILIs.  It is
generated in cgoptim1.c:lili_peephole_opts_2() by transforming
DCMPLXNEG( op1 ) into a DCMPLXXOR LILI in order to negate 'op1' by
XORing its sign bits with 1.  This ILI is specified as non-commutative
(i.e. 'null', not 'comm') for reasons explained in that function.
.AT arth null cd cse
.CG CGonly "xorpd" sse_avx

.IL SCMPLXCONJG cslnk 
Single-precision complex conjugate.
.AT arth null cs cse 
.CG "xorps" 

.IL DCMPLXCONJG cdlnk
Double-precision complex conjugate.
.AT arth null cd cse
.CG "xorpd"

.IL DXOR dplnk dplnk
May be used to implement DNEG operation.
.AT arth null dp cse
.CG notCG "xorpd" sse_avx

.IL IABS irlnk
Integer absolute value.  Expanded into shift-xor-sub sequence.
.AT arth null ir cse
.CG notCG

.IL KABS krlnk
Integer64 absolute value.  Shift-xor-sub AILI sequence is generated.
.AT arth null kr cse
.CG notAILI 'q'

.IL FABS splnk
Real (single-precision) absolute value.
.AT arth null sp cse
.CG notAILI

.IL FAND splnk splnk
Used to implement FABS operation.  This operation is non-commutative so
we can ensure that a memory operand is not used.
.AT arth null sp cse
.CG "andps" sse_avx

.IL DABS dplnk
Double precision absolute value.
.AT arth null dp cse
.CG notAILI

.IL DAND dplnk dplnk
Used to implement DABS operation.
.AT arth null dp cse
.CG CGonly "andpd" sse_avx

.IL NOT irlnk
32 bit bitwise not.
.AT arth null ir cse
.CG memdest "not" 'l'

.IL UNOT irlnk
Unsigned bitwise negation of 32 bit bitwise not.
.AT arth null ir cse
.CG notCG replaceby NOT

.IL KNOT krlnk
64 bit bitwise not.
.AT arth null kr cse
.CG memdest notAILI 'q'

.IL UKNOT krlnk
64 bit bitwise not.
.AT arth null kr cse
.CG notCG replaceby KNOT

.IL FSQRT splnk
Single-precision floating-point square root.
.AT arth null sp cse
.CG "sqrtss"

.IL DSQRT dplnk
Double-precision square root.
.AT arth null dp cse
.CG "sqrtsd"

.IL RCPSS splnk
Single-precision approximation to reciprocal.
.AT arth null sp cse
.CG "rcpss"

.IL RSQRTSS splnk
Single-precision approximation to reciprocal square root.
.AT arth null sp cse
.CG "rsqrtss"

.IL CMPNEQSS splnk splnk
Used for single-precision square root approximation.
.AT arth null sp cse
.CG "cmpneqss" sse_avx

.IL FNSIN splnk
Utility ili: only referenced by the 'alt' field of an FSIN ili;
always points to an FSINCOS ili.
.AT arth null sp cse
.CG notAILI

.IL DNSIN dplnk
Utility ili: only referenced by the 'alt' field of an DSIN ili;
always points to an DSINCOS ili.
.AT arth null dp cse
.CG notAILI

.IL FSIN splnk
Single precision floating point sine.  Implemented as a library call (by CG).
.AT arth null sp cse
.CG notAILI

.IL DSIN dplnk
Double precision sine.  Implemented as a library call (by CG).
.AT arth null dp cse
.CG notAILI

.IL FNCOS splnk
Utility ili: only referenced by the 'alt' field of an FCOS ili;
always points to an FSINCOS ili.
.AT arth null sp cse
.CG notAILI

.IL DNCOS dplnk
Utility ili: only referenced by the 'alt' field of an DCOS ili;
always points to an DSINCOS ili.
.AT arth null dp cse
.CG notAILI

.IL FCOS splnk
Single precision floating point cosine.  Implemented as library call (by CG).
.AT arth null sp cse
.CG notAILI

.IL DCOS dplnk
Double precision cosine.  Implemented as library call (by CG).
.AT arth null dp cse
.CG notAILI

.IL FSINCOS splnk
Used to implement SINCOS optimization (single precision).  Implemented as
a library call (by CG).
.AT arth null sp cse
.CG notAILI

.IL DSINCOS dplnk
Used to implement SINCOS optimization (double precision).  Implemented as
a library call (by CG).
.AT arth null dp cse
.CG notAILI

.IL FTAN splnk
Single-precision floating-point tangent.
.AT arth null sp cse
.CG notCG

.IL DTAN dplnk
Double-precision tangent.
.AT arth null dp cse
.CG notCG

.IL FLOG splnk
Single-precision floating-point natural logarithm.
.AT arth null sp cse
.CG notCG

.IL DLOG dplnk
Double-precision natural logarithm.
.AT arth null dp cse
.CG notCG

.IL FLOG10 splnk
Single-precision floating-point common logarithm.
.AT arth null sp cse
.CG notCG

.IL DLOG10 dplnk
Double-precision common logarithm.
.AT arth null dp cse
.CG notCG

.IL FEXP splnk
Single-precision floating-point exponential.
.AT arth null sp cse
.CG notCG

.IL DEXP dplnk
Double-precision exponential.
.AT arth null dp cse
.CG notCG

.IL FACOS splnk
Single-precision floating-point arccosine.
.AT arth null sp cse
.CG notCG

.IL DACOS dplnk
Double-precision  arccosine.
.AT arth null dp cse
.CG notCG

.IL FASIN splnk
Single-precision floating-point arcsine.
.AT arth null sp cse
.CG notCG

.IL DASIN dplnk
Double-precision  arcsine.
.AT arth null dp cse
.CG notCG

.IL FATAN splnk
Single-precision floating-point arctangent.
.AT arth null sp cse
.CG notCG

.IL DATAN dplnk
Double-precision  arctangent.
.AT arth null dp cse
.CG notCG

.IL FATAN2 splnk splnk
Single-precision floating-point two-argument arctangent.
.AT arth null sp cse
.CG notCG

.IL DATAN2 dplnk dplnk
Double-precision two-argument arctangent.
.AT arth null dp cse
.CG notCG

.IL FSINH splnk
Single-precision floating-point hyperbolic sin
.AT arth null sp cse
.CG notCG

.IL DSINH dplnk
Double-precision hyperbolic sin
.AT arth null dp cse
.CG notCG

.IL FCOSH splnk
Single-precision floating-point hyperbolic cos
.AT arth null sp cse
.CG notCG

.IL DCOSH dplnk
Double-precision hyperbolic cos
.AT arth null dp cse
.CG notCG

.IL FTANH splnk
Single-precision floating-point hyperbolic tan
.AT arth null sp cse
.CG notCG

.IL DTANH dplnk
Double-precision hyperbolic tan
.AT arth null dp cse
.CG notCG

.IL FNEWT splnk splnk splnk
Single-precision floating-point multiply used for single divides.
Not used by the x86-32 compilers.
.AT arth null sp cse
.CG notCG

.IL DNEWT dplnk dplnk dplnk
Double-precision floating-point multiply used for double divides.
Not used by the x86-32 compilers.
.AT arth null dp cse
.CG notCG

.IL NINT splnk
Real NINT.
.AT arth null ir cse
.CG notCG

.IL IDNINT dplnk
Double NINT.
.AT arth null ir cse
.CG notCG

.IL ISIGN irlnk irlnk
Integer sign intrinsic.
.AT arth null ir cse
.CG notCG

.IL SIGN splnk splnk
Real sign.
.AT arth null sp cse
.CG notCG

.IL DSIGN dplnk dplnk
Double sign.
.AT arth null dp cse
.CG notCG

.IL IDIM irlnk irlnk
Integer dim intrinsic.
.AT arth null ir cse
.CG  notCG

.IL FDIM splnk splnk
Real dim.
.AT arth null sp cse
.CG notCG

.IL DDIM dplnk dplnk
Double dim.
.AT arth null dp cse
.CG notCG

.IL FFLOOR splnk
Real FLOOR.
.AT arth null sp cse
.CG "roundss" sse_avx

.IL DFLOOR dplnk
Double FLOOR.
.AT arth null dp cse
.CG "roundsd" sse_avx

.IL FCEIL splnk
Real CEILING.
.AT arth null sp cse
.CG "roundss" sse_avx

.IL DCEIL dplnk
Double CEILING.
.AT arth null dp cse
.CG "roundsd" sse_avx

.IL SCMPLXEXP cslnk
Single-precision complex exponential.
.AT arth null cs cse
.CG notCG

.IL DCMPLXEXP cdlnk
Double-precision complex exponential.
.AT arth null cd cse
.CG notCG

.IL SCMPLXCOS cslnk
Single-precision complex cosine.
.AT arth null cs cse
.CG notCG

.IL DCMPLXCOS cdlnk
Double-precision complex cosine.
.AT arth null cd cse
.CG notCG

.IL SCMPLXSIN cslnk
Single-precision complex sine.
.AT arth null cs cse
.CG notCG

.IL DCMPLXSIN cdlnk
Double-precision complex sine.
.AT arth null cd cse
.CG notCG

.IL SCMPLXTAN cslnk
Single-precision complex tangent.
.AT arth null cs cse
.CG notCG

.IL DCMPLXTAN cdlnk
Double-precision complex tangent.
.AT arth null cd cse
.CG notCG

.IL SCMPLXACOS cslnk
Single-precision complex arccosine.
.AT arth null cs cse
.CG notCG

.IL DCMPLXACOS cdlnk
Double-precision complex arccosine.
.AT arth null cd cse
.CG notCG

.IL SCMPLXASIN cslnk
Single-precision complex arcsine.
.AT arth null cs cse
.CG notCG

.IL DCMPLXASIN cdlnk
Double-precision complex arcsine.
.AT arth null cd cse
.CG notCG

.IL SCMPLXATAN cslnk
Single-precision complex arctangent.
.AT arth null cs cse
.CG notCG

.IL DCMPLXATAN cdlnk
Double-precision complex arctangent.
.AT arth null cd cse
.CG notCG

.IL SCMPLXCOSH cslnk
Single-precision complex hyperbolic cos.
.AT arth null cs cse
.CG notCG

.IL DCMPLXCOSH cdlnk
Double-precision complex hyperbolic cos.
.AT arth null cd cse
.CG notCG

.IL SCMPLXSINH cslnk
Single-precision complex hyperbolic sin.
.AT arth null cs cse
.CG notCG

.IL DCMPLXSINH cdlnk
Double-precision complex hyperbolic sin.
.AT arth null cd cse
.CG notCG

.IL SCMPLXTANH cslnk
Single-precision complex hyperbolic tan.
.AT arth null cs cse
.CG notCG

.IL DCMPLXTANH cdlnk
Double-precision complex hyperbolic tan.
.AT arth null cd cse
.CG notCG

.IL SCMPLXLOG cslnk
Single-precision complex natural logarithm.
.AT arth null cs cse
.CG notCG

.IL DCMPLXLOG cdlnk
Double-precision complex natural logarithm.
.AT arth null cd cse
.CG notCG

.IL SCMPLXSQRT cslnk
Single-precision complex square root.
.AT arth null cs cse
.CG notCG

.IL DCMPLXSQRT cdlnk
Double-precision complex square root.
.AT arth null cd cse
.CG notCG

.IL SCMPLXPOW cslnk cslnk
Single-precision complex raised to a single-precision complex power.
.AT arth null cs cse
.CG notCG

.IL DCMPLXPOW cdlnk cdlnk
Double-precision complex raised to a double-precision complex power.
.AT arth null cd cse
.CG notCG

.IL SCMPLXPOWI cslnk irlnk
Single-precision complex raised to an integer power.
.AT arth null cs cse
.CG notCG

.IL DCMPLXPOWI cdlnk irlnk
Double-precision complex raised to an integer power.
.AT arth null cd cse
.CG notCG

.IL SCMPLXPOWK cslnk krlnk
Single-precision complex raised to an integer power.
.AT arth null cs cse
.CG notCG

.IL DCMPLXPOWK cdlnk krlnk
Double-precision complex raised to an integer power.
.AT arth null cd cse
.CG notCG

.IL ITOUI irlnk
Integer to unsigned integer conversion.
Treated as a nop by cglinear.
.AT arth null ir cse
.CG notCG

.IL UITOI irlnk
Unsigned integer to integer conversion.
Treated as a nop by cglinear.
.AT arth null ir cse
.CG notCG

.IL IKMV irlnk
Move an signed integer value to a register pair with sign extension.
Used for I to K and I to UK conversions.
.AT move null kr cse
.CG notAILI 'q'

.IL UIKMV irlnk
Move an unsigned integer register to a register pair.
.AT move null kr cse
.CG notAILI 'q'

.IL KIMV krlnk
Move a value in a register pair to an integer register with truncation.
Used also for K to UI, UK to I, and UK to UI conversions.
.AT move null ir cse
.CG notAILI 'l'

.IL IAMV irlnk
Move an integer reg into an address reg.
Treated as a nop by cglinear.
.AT move null ar cse
.CG notCG

.IL AIMV arlnk
Move an address register to a integer register.
Treated as a nop by cglinear.
.AT move null ir cse
.CG notCG

.IL KAMV krlnk
Move an 64 bit integer reg into an address reg.
.AT move null ar cse
.CG notCG replaceby KIMV

.IL AKMV arlnk
Move an address register to a register pair (no sign extension).
.AT move null kr cse
.CG notCG replaceby UIKMV

.IL MOVSB irlnk
Load signed byte into 32 bit register.
.AT move null ir
.CG CGonly asm_special "movsb" 'l'

.IL MOVZB irlnk
Load unsigned byte into 32 bit register.
.AT move null ir
.CG CGonly asm_special "movzb" 'l'

.IL MOVSW irlnk
Load signed halfword into 32 bit register.
.AT move null ir
.CG CGonly asm_special "movsw" 'l'

.IL MOVZW irlnk
Load unsigned halfword into 32 bit register.
.AT move null ir
.CG CGonly asm_special "movzw" 'l'

.IL FLOAT irlnk
Integer to single-precision floating-point conversion.
.AT arth null sp cse
.CG "cvtsi2ss" 'l'

.IL FLOATU irlnk
Unsigned integer to single-precision floating-point conversion.
Implemented by library function. (?)
.AT arth null sp cse
.CG notCG

.IL FLOATK krlnk
Integer64 to single-precision real conversion.
.AT arth null sp cse
.CG notCG

.IL FLOATUK krlnk
Unsigned integer64 to single-precision real conversion.
.AT arth null sp cse
.CG notCG

.IL DFLOAT irlnk
Integer to double-precision conversion.
.AT arth null dp cse
.CG "cvtsi2sd" 'l'

.IL DFLOATU irlnk
Unsigned integer to double-precision conversion.
.AT arth null dp cse
.CG notCG

.IL DFLOATK krlnk
Integer64 to double-precision conversion.
.AT arth null dp cse
.CG notCG

.IL DFLOATUK krlnk
Unsigned integer64 to double-precision conversion.
.AT arth null dp cse
.CG notCG

.IL FIX splnk
Single precision floating-point to integer conversion.
.AT arth null ir cse
.CG "cvttss2si" 'l'

.IL UFIX splnk
Single precision floating-point to unsigned integer conversion.
Implemented by a library function.
.AT arth null ir
.CG notCG

.IL FIXK splnk
Single precision floating-point to integer64 conversion.
Implemented by a library function.
.AT arth null kr cse
.CG notCG

.IL FIXUK splnk
Single precision to unsigned integer64 conversion.
Implemented by a library function.
.AT arth null kr cse
.CG notCG

.IL DFIX dplnk
Double-precision to integer conversion.
.AT arth null ir cse
.CG "cvttsd2si" 'l'

.IL DFIXU dplnk
Double precision to unsigned integer conversion.
Implemented by a library function.
.AT arth null ir cse
.CG notCG

.IL DFIXK dplnk
Double-precision floating-point to integer64 conversion.
Implemented by a library function.
.AT arth null kr cse
.CG notCG

.IL DFIXUK dplnk
Double-precision floating-point to unsigned integer64 conversion.
Implemented by a call to a library function.
.AT arth null kr cse
.CG notCG

.IL SNGL dplnk
Double-precision to single conversion.
.AT arth null sp cse
.CG "cvtsd2ss"

.IL DBLE splnk
Single to double-precision conversion.
.AT arth null dp cse
.CG "cvtss2sd"

.IL PSNGL arlnk xmm nme
Convert 2 double-precision floating-point values from memory location
denoted by arlnk into 2 single-precision floating-point values into
the low 64-bits of the xmm register denoted by xmm.
.AT other null trm ssenme
.CG terminal "cvtpd2ps" ssedp
.SI vector lat(10)

.IL PDBLE arlnk xmm nme
Convert 2 single-precision floating-point values from memory location
denoted by arlnk into 2 double-precision floating-point values into
the xmm register denoted by xmm.
.AT other null trm ssenme
.CG terminal "cvtps2pd" ssedp
.SI double lat(5)

.IL PSNGLX xmm xmm
Convert 2 double-precision floating-point values in xmm1 into
2 single-precision floating-point values into the
low-order 64-bits of the xmm register denoted by xmm2.
.AT other null trm
.CG terminal "cvtpd2ps" ssedp
.SI vector lat(8)

.IL PDBLEX xmm xmm
Convert 2 single-precision floating-point values from the low
64-bits of xmm1 into 2 double-precision floating-point values
into the xmm register denoted by xmm2.
.AT other null trm
.CG terminal "cvtps2pd" ssedp
.SI double lat(3)

.IL IR2SP irlnk
Move integer to xmm register without floating.
.AT arth null sp cse
.CG 'l' asm_special

.IL KR2SP krlnk
To be eliminated?
.AT arth null sp
.CG notCG

.IL KR2DP krlnk
Transfer a value from a integer64 register to a dp register
(no conversion performed).
.AT arth null dp
.CG notAILI

.IL KR2CS krlnk
Transfer a value from a integer64 register to a dp register
(no conversion performed).
.AT arth null cs
.CG notAILI

.IL SP2IR splnk
Move single-precision floating-point value to integer register without
conversion.
.AT arth null ir cse
.CG 'l' asm_special

.IL SP2KR splnk
Not used.
.AT arth null kr
.CG notCG

.IL DP2KR dplnk
Transfer a value from a double floating-point register to integer64 register.
(no conversion performed).
.AT arth null kr
.CG notAILI 'q'

.IL CS2KR cslnk
Transfer a value from a double floating-point register to integer64 register.
(no conversion performed).
.AT arth null kr
.CG notAILI 'q'

.IL ROTL irlnk irlnk
.AT arth null ir cse
.CG ccarith "rol" 'l'

.IL ROTR irlnk irlnk
.AT arth null ir cse
.CG ccarith "ror" 'l'

.IL IADD irlnk irlnk
Signed integer addition.
.AT arth comm ir cse
.CG memdest ccarith "add" 'l'

.IL UIADD irlnk irlnk
Unsigned integer addition.
.AT arth comm ir cse
.CG memdest ccarith "add" 'l'

.IL KADD krlnk krlnk
Signed integer64 addition.  Implemented by IADD/ADC combination.
.AT arth comm kr cse
.CG memdest notAILI 'q'

.IL UKADD krlnk krlnk
Unsigned integer64 addition.
.AT arth comm kr cse
.CG notCG replaceby KADD

.IL ADC
Signed integer addition with carry.
.AT arth comm ir cse
.CG CGonly "adc" 'l' ccmod

.IL AADD arlnk arlnk stc
Add two address register values.
The stc operand is not used by the x86-32 code generator.
.AT arth null ar cse
.CG notCG replaceby IADD

.IL FADD splnk splnk
Single-precision floating-point addition.
.AT arth comm sp cse
.CG "addss" sse_avx

.IL DADD dplnk dplnk
Double-precision floating-point addition.
.AT arth comm dp cse
.CG "addsd" sse_avx

.IL SCMPLXADD cslnk cslnk
Single-precision complex addition.
.AT arth comm cs cse
.CG "addps" sse_avx
.SI double fadd lat(5:7)

.IL DCMPLXADD cdlnk cdlnk
Double-precision complex addition.
.AT arth comm cd cse
.CG "addpd" sse_avx
.SI double fadd lat(5:7)

.IL ISUB irlnk irlnk
Signed 32-bit integer subtraction.
.AT arth null ir cse
.CG memdest ccarith "sub" 'l'

.IL UISUB irlnk irlnk
Unsigned integer subtract.  op1 - op2.
.AT arth null ir cse
.CG memdest ccarith "sub" 'l'

.IL KSUB krlnk krlnk
Signed integer64 subtraction.  Implemented by ISUB/SBB combination.
.AT arth null kr cse
.CG memdest notAILI 'q'

.IL UKSUB krlnk krlnk
Unsigned integer64 subtraction.
.AT arth null kr cse
.CG notCG replaceby KSUB

.IL SBB
Signed 32-bit integer subtraction with borrow.
.AT arth null ir cse
.CG CGonly "sbb" 'l' ccmod

.IL ASUB arlnk arlnk stc
Subtract two address register values.  The stc operand is not used.
.AT arth null ar cse
.CG notCG replaceby ISUB

.IL FSUB splnk splnk
Single-precision floating-point subtraction.
.AT arth null sp cse
.CG "subss" sse_avx

.IL FSUBR splnk splnk
Single-precision floating-point subtraction - operands reversed
(used by llvect.c as a convenience).
.AT arth null sp cse
.CG notCG

.IL DSUB dplnk dplnk
Double-precision floating-point subtraction.
.AT arth null dp cse
.CG "subsd" sse_avx

.IL SCMPLXSUB cslnk cslnk
Single-precision complex subtraction.
.AT arth null cs cse
.CG "subps" sse_avx
.SI double fadd lat(7:5)

.IL DCMPLXSUB cdlnk cdlnk
Double-precision complex subtraction.
.AT arth null cd cse
.CG "subpd" sse_avx
.SI double fadd lat(7:5)

.IL IMUL irlnk irlnk
Integer Multiply.  It'a a bug to give this opcode the ccarith or
cclogical attribute.
.AT arth comm ir cse
.CG "imul" 'l' ccmod

.IL UIMUL irlnk irlnk
Unsigned integer multiply. Same as signed.
.AT arth comm ir cse
.CG notCG replaceby IMUL

.IL IMULH irlnk irlnk
Integer multiply, high 32-bits of product as result
.AT arth comm ir cse
.CG "imul" 'l' ccmod

.IL KMULH krlnk krlnk
Integer64 Multiply, high 64-bits of product returned.
.AT other comm kr cse
.CG "imul" 'q' ccmod
.SI direct lat(8)

.IL UIMULH irlnk irlnk
Integer multiply, high 32-bits of product as result
.AT arth comm ir cse
.CG "mul" 'l' ccmod

.IL KMUL krlnk krlnk
Integer64 Multiply.  Implemented by library function.
.AT arth comm kr cse
.CG asm_nop

.IL UKMUL krlnk krlnk
Unsigned integer64 Multiply.  Implemented by library function.
.AT arth comm kr cse
.CG notCG replaceby KMUL

.IL UKMULH krlnk krlnk
Integer64 Multiply, high 64-bits of product returned.
.AT other comm kr cse
.CG "mul" 'q' ccmod
.SI direct lat(8)

.IL FMUL splnk splnk
Single-precision floating-point multiply.
.AT arth comm sp cse
.CG "mulss" sse_avx

.IL DMUL dplnk dplnk
Double-precision multiply.
.AT arth comm dp cse
.CG "mulsd" sse_avx

.IL SCMPLXMUL cslnk cslnk
Single-complex multiply.
.AT arth comm cs cse
.CG sse_avx asm_special

.IL DCMPLXMUL cdlnk cdlnk
Double-complex multiply.
.AT arth comm cd cse
.CG sse_avx asm_special

.IL IDIV irlnk irlnk
Signed integer divide.
.AT arth null ir cse
.CG notCG

.IL UIDIV irlnk irlnk
Unsigned integer divide.
.AT arth null ir cse
.CG notCG

.IL KDIV krlnk krlnk
Signed integer64 divide.
.AT arth null kr cse
.CG notCG

.IL UKDIV krlnk krlnk
Unsigned integer64 divide.
.AT arth null kr cse
.CG notCG

.IL IDIVZ irlnk irlnk
Signed integer divide where divide by zero does not fault.
.AT arth null ir cse
.CG notCG

.IL UIDIVZ irlnk irlnk
Unsigned integer divide where divide by zero does not fault.
.AT arth null ir cse
.CG notCG

.IL KDIVZ krlnk krlnk
Signed integer64 divide where divide by zero does not fault.
.AT arth null kr cse
.CG notCG

.IL UKDIVZ krlnk krlnk
Unsigned integer64 divide where divide by zero does not fault.
.AT arth null kr cse
.CG notCG

.IL IDIVZR irlnk irlnk
Signed integer divide where the remainder is zero
.AT arth null ir cse
.CG notCG

.IL KDIVZR krlnk krlnk
Signed integer64 divide where the remainder is zero
.AT arth null kr cse
.CG notCG

.IL QUOREM irlnk irlnk
Represents an integer divide and/or mod operation.  Use of this ili allows
a single divide instruction to both a divide and mod result.
.AT arth null ir cse
.CG notAILI 'l'

.IL KQUOREM krlnk krlnk
Represents a long divide and/or mod operation.  Use of this ili allows
a single divide instruction to both a divide and mod result.
.AT arth null kr cse
.CG notCG

.IL NIDIV irlnk
Signed integer divide that points to QUOREM.  Result is in register %eax.
.AT arth null ir cse
.CG "idiv" 'l' ccmod

.IL NUIDIV irlnk
Unsigned integer divide that points to QUOREM.  Result is in register %eax.
.AT arth null ir cse
.CG "div" 'l' ccmod

.IL NKDIV krlnk
Signed integer64 divide that points to QUOREM.  Result is in register %rax.
.AT arth null kr cse
.CG notCG

.IL NUKDIV krlnk
Unsigned integer64 divide that points to QUOREM.  Result is in register %rax.
.AT arth null kr cse
.CG notCG

.IL FDIV splnk splnk
Single-precision divide.
.AT arth null sp cse
.CG "divss" sse_avx

.IL FDIVR splnk splnk
Single-precision divide - operands reversed (used by llvect.c
as a convenience).
.AT arth null sp cse
.CG notCG

.IL DDIV dplnk dplnk
Double divide.
.AT arth null dp cse
.CG "divsd" sse_avx

.IL SCMPLXDIV cslnk cslnk
Single precision complex divide.
.AT arth null cs cse
.CG notCG

.IL DCMPLXDIV cdlnk cdlnk
Double precision complex divide.
.AT arth null cd cse
.CG notCG

.IL MOD irlnk irlnk
Integer remainder.
.AT arth null ir cse
.CG notCG

.IL UIMOD irlnk irlnk
Unsigned integer mod.
.AT arth null ir cse
.CG notCG

.IL KMOD krlnk krlnk
Integer64 remainder.
.AT arth null kr
.CG notCG

.IL KUMOD krlnk krlnk
Integer64 remainder.
.AT arth null kr
.CG notCG

.IL MODZ irlnk irlnk
Integer remainder where divide by zero does not fault.
.AT arth null ir cse
.CG notCG

.IL UIMODZ irlnk irlnk
Unsigned integer mod where divide by zero does not fault.
.AT arth null ir cse
.CG notCG

.IL KMODZ krlnk krlnk
Integer64 remainder where divide by zero does not fault.
.AT arth null kr
.CG notCG

.IL KUMODZ krlnk krlnk
Integer64 remainder where divide by zero does not fault.
.AT arth null kr
.CG notCG

.IL NMOD irlnk
Integer remainder that points to a QUOREM ili.  Result is in register %edx.
.AT arth null ir cse
.CG "idiv" 'l' ccmod

.IL NUIMOD irlnk
Unsigned integer mod that points to QUOREM ili.  Result is in register %edx.
.AT arth null ir cse
.CG "div" 'l' ccmod

.IL NKMOD krlnk
Integer remainder that points to a QUOREM ili.  Result is in register %rdx.
.AT arth null kr cse
.CG notCG

.IL NUKMOD krlnk
Unsigned integer mod that points to QUOREM ili.  Result is in register %rdx.
.AT arth null kr cse
.CG notCG

.IL FMOD splnk splnk
Single-precision mod.
.AT arth null sp cse
.CG notCG

.IL DMOD dplnk dplnk
Double-precision mod.
.AT arth null dp cse
.CG notCG

.IL IMAX irlnk irlnk
Integer maximum value.  Expanded in-line by Code Generator.
.AT arth comm ir cse
.CG asm_special "cmpl" 'l' ccmod

.IL UIMAX irlnk irlnk
Unsigned integer maximum value.  Expanded in-line by Code Generator.
.AT arth comm ir cse
.CG notCG

.IL IMIN irlnk irlnk
Integer minimum value.  Expanded in-line by Code Generator.
.AT arth comm ir cse
.CG asm_special "cmpl" 'l' ccmod

.IL UIMIN irlnk irlnk
Unsigned integer minimum value.  Expanded in-line by Code Generator.
.AT arth comm ir cse
.CG notCG

.IL KMAX krlnk krlnk
Integer64 maximum value.  Implemented by library function call.
.AT arth comm kr cse
.CG notCG

.IL UKMAX krlnk krlnk
Unsigned integer64 maximum value.  Implemented by library function call.
.AT arth comm kr cse
.CG notCG

.IL KMIN krlnk krlnk
Integer64 minimum value.  Implemented by library function call.
.AT arth comm kr cse
.CG notCG

.IL UKMIN krlnk krlnk
Unsigned integer64 minimum value.  Implemented by library function call.
.AT arth comm kr cse
.CG notCG

.IL FMAX splnk splnk
Single precision maximum.
.AT arth comm sp cse
.CG "maxss" sse_avx

.IL FMIN splnk splnk
Single precision minimum.
.AT arth comm sp cse
.CG "minss" sse_avx

.IL DMAX dplnk dplnk
Double precision maximum.
.AT arth comm dp cse
.CG "maxsd" sse_avx

.IL DMIN dplnk dplnk
Double precison minimum.
.AT arth comm dp cse
.CG "minsd" sse_avx

.IL JN  irlnk splnk
float bessel_jn
.AT arth null sp cse
.CG notCG

.IL DJN  irlnk dplnk
double bessel_jn
.AT arth null dp cse
.CG notCG

.IL YN  irlnk splnk
float bessel_yn
.AT arth null sp cse
.CG notCG

.IL DYN  irlnk dplnk
double bessel_yn
.AT arth null dp cse
.CG notCG

.\"BT.IL FMACC
.\"BTThis opcode is used in the AILI to represent one of the 8
.\"BTscalar, single precision, "fmacc" instructions.
.\"BTSince the AILI allow at most 2 input operands, FMACC is always immediately
.\"BTpreceded by a USE aili which specifies the extra operand.
.\"BTThe 'src1' operand of FMACC is either an xmm reg operand, or memory operand.
.\"BT.AT arth null sp
.\"BT.CG CGonly asm_special
.\"BT
.\"BT.IL DMACC
.\"BTThis opcode is used in the AILI to represent one of the 8
.\"BTscalar, double precision, "fmacc" instructions.
.\"BTSince the AILI allow at most 2 input operands, FMACC is always immediately
.\"BTpreceded by a USE aili which specifies the extra operand.
.\"BT.AT arth null dp
.\"BT.CG CGonly asm_special
.\"BT

.IL DFMA dplnk dplnk dplnk
This opcode is only used in AILIs, not shared or linear ILIs.  It
represents a scalar double-precision FMA3 or FMA4 instruction which
computes:
    dest = <sign> (src1 * src2) <addop> src3
.br
Either 'src2' or 'src3', but not both, can be a memory operand, and
the other operands are xmm register operands.  The values of <sign>
(+/-) and <addop> (+/-) are specified by an 'FMA_...' flag set in the
cc field of the AILI.  Since AILIs allow at most 2 source operands,
this AILI is always immediately preceded by a USE AILI which specifies
the 'src1' operand.
.AT arth null dp
.CG CGonly asm_special

.IL FFMA splnk splnk splnk
This is the same as DFMA except that it represents a scalar single
precision FMA3 or FMA4 instruction.
.AT arth null sp
.CG CGonly asm_special

.IL IPOWI irlnk irlnk
Integer raised to an integer power.
.AT arth null ir cse
.CG notCG

.IL FPOWI splnk irlnk
Real raised to an integer power.
.AT arth null sp cse
.CG notCG

.IL FPOWK splnk krlnk
Real raised to an integer power.
.AT arth null sp cse
.CG notCG

.IL FPOWF splnk splnk
Real raised to a real power.
.AT arth null sp cse
.CG notCG

.IL DPOWI dplnk irlnk
Double raised to a integer power.
.AT arth null dp cse
.CG notCG

.IL DPOWK dplnk krlnk
Double raised to a integer power.
.AT arth null dp cse
.CG notCG

.IL DPOWD dplnk dplnk
Double raised to a double power.
.AT arth null dp cse
.CG notCG

.IL ICMP irlnk irlnk stc
Integer compare with result of true or false.
For C the value of true is 1, and for Fortran, -1.
\'stc' denotes condition code, as for the ICJMP ili.
.AT arth null ir cse
.CG asm_special "cmpl" 'l' ccmod

.IL UICMP irlnk irlnk stc
Unsigned integer compare.
.AT arth null ir cse
.CG notAILI 'l'

.IL KCMP krlnk krlnk stc
Integer64 compare with result of true or false.
Implemented by library function call.
.AT arth null ir cse
.CG notCG

.IL UKCMP krlnk krlnk stc
Unsigned integer64 compare with result of true or false.
.AT arth null ir cse
.CG notCG

.IL ACMP arlnk arlnk stc
Address compare with result of true or false.
The conditions (stc) are the same as for ICMP.
.AT arth null ir cse
.CG notCG replaceby UICMP

.IL FCMP splnk splnk stc
Single float compare with result of true or false.
stc is a floating point condition code: one of the 12 values defined in ili.h.
.AT arth null ir cse
.CG asm_special "ucomiss" ccmod

.IL DCMP dplnk dplnk stc
Double precision compare with result of true or false.
.AT arth null ir cse
.CG asm_special "ucomisd" ccmod

.IL SCMPLXCMP dplnk dplnk stc
Single precision complex compare with result of true or false.
.AT arth comm ir cse
.CG asm_special "ucomisd" ccmod 

.IL DCMPLXCMP dplnk dplnk stc
Double precision complex compare with result of true or false.
.AT arth comm ir cse
.CG asm_special "ucomisd" ccmod 

.IL ICMPZ irlnk stc
Integer compare with zero.
.AT arth null ir cse
.CG notAILI 'l'

.IL UICMPZ irlnk stc
Unsigned integer compare with zero.
.AT arth null ir cse
.CG notAILI 'l'

.IL KCMPZ krlnk stc
Integer64 compare with zero; returns integer value.
Implemented by library function call.
.AT arth null ir cse
.CG notCG

.IL UKCMPZ krlnk stc
Integer64 compare with zero.
.AT arth null ir cse
.CG notCG

.IL ACMPZ arlnk stc
Address compare with zero.
.AT arth null ir cse
.CG notCG replaceby UICMPZ

.IL FCMPZ splnk stc
Single float compare with zero; result is TRUE or FALSE.
.AT arth null ir cse
.CG notCG

.IL DCMPZ dplnk stc
Double precision compare with zero.
.AT arth null ir cse
.CG notCG

.IL TEST irlnk irlnk
Compare register value with 0.
.AT arth comm ir cse
.CG CGonly "testl" cclogical 'l' asm_special
.SI direct lat(4:1)

.IL KTEST krlnk krlnk
Compare register value with 0.  For 64-bit targets only.
.AT arth comm ir cse
.CG notCG

.IL ISELECT irlnk irlnk irlnk
Select either the 2nd or 3rd operand value based on the comparison
operation pointed to by the 1st operand.
.AT other null ir cse
.CG notAILI 'l'

.IL KSELECT irlnk krlnk krlnk
.AT other null kr cse
.CG notCG

.IL ASELECT irlnk arlnk arlnk
.AT other null ar cse
.CG notCG replaceby ISELECT

.IL FSELECT irlnk splnk splnk
.AT other null sp cse
.CG notAILI

.IL DSELECT irlnk dplnk dplnk
.AT other null dp cse
.CG notAILI

.IL CSSELECT irlnk cslnk cslnk
.AT other null cs cse
.CG notAILI

.IL CDSELECT irlnk cdlnk cdlnk
.AT other null cd cse
.CG notAILI

.IL AND irlnk irlnk
Bitwise 32-bit 'and' operation.
.AT arth comm ir cse
.CG memdest cclogical "and" 'l'

.IL KAND krlnk krlnk
Bitwise 64-bit 'and' operation.
.AT arth comm kr
.CG memdest notAILI 'q'

.IL OR irlnk irlnk
Bitwise 32-bit 'or' operation.
.AT arth comm ir cse
.CG memdest cclogical "or" 'l'

.IL KOR krlnk krlnk
Bitwise 64-bit 'or' operation.
.AT arth comm kr
.CG memdest notAILI 'q'

.IL XOR irlnk irlnk
Bitwise exclusive-or operation.
.AT arth comm ir cse
.CG memdest cclogical "xor" 'l'

.IL LEQV irlnk irlnk
Bitwise exclusive-or followed by not operation.
.AT arth comm ir cse
.CG memdest cclogical "leqv" 'l'

.IL KXOR krlnk krlnk
Bitwise 64-bit exclusive-or operation.
.AT arth comm kr
.CG memdest notAILI 'q'

.IL EQV irlnk irlnk
.AT arth comm ir cse
.CG notCG

.IL JISHFT irlnk irlnk
Shift op1 logically by op2.  Left if op2 is > 0; else right
(no sign extension).
This ili only shows up for Fortran, specifically for the JISHFT
intrinsic.
If 2nd operand is compile time constant, this ili will have been
replaced by either a left or right shift ili by the Expander.
Otherwise, it is implemented as a call to a run-time function.
.AT arth null ir cse
.CG notCG

.IL USHIFT irlnk irlnk
Shift op1 logically by op2.  Left if op2 is > 0; else right.
This ili should have been replaced before code generator.
.AT arth null ir cse
.CG notCG

.IL SHIFTA irlnk arlnk
Shift op1 logically by op2.  Left if op2 is > 0; else right.
.AT arth null ir cse
.CG notCG

.IL USHIFTA irlnk arlnk
Unsigned shift op1 logically by op2.  Left if op2 is > 0; else right.
.AT arth null ir cse
.CG notCG

.IL LSHIFT irlnk irlnk
Shift op1 left logically by op2.
.AT arth null ir cse
.CG memdest ccarith shiftop asm_special "shl" 'l'

.IL ULSHIFT irlnk irlnk
Shift op1 left logically by op2.
.AT arth null ir cse
.CG notCG replaceby LSHIFT

.IL LSHIFTI irlnk stc
Shift left immediate.   This opcode used only in Code Generator.
.AT arth null ir cse
.CG memdest ccarith shiftop "shl" CGonly 'l'

.IL KLSHIFTI krlnk stc
Shift left immediate of 64-bit value.
.AT arth null kr cse
.CG notAILI 'q'

.IL RSHIFT irlnk irlnk
Shift op1 logically right by op2 (sign extended).
.AT arth null ir cse
.CG notCG replaceby ARSHIFT

.IL URSHIFT irlnk irlnk
Shift op1 logically right by op2 (0 fill).
.AT arth null ir cse
.CG memdest ccarith shiftop asm_special "shr" 'l'

.IL ARSHIFT irlnk irlnk
Shift op1 arithmetically (sign extended) right by op2.
Used for right shifts (>> operator) of signed values.
.AT arth null ir cse
.CG memdest ccarith shiftop asm_special "sar" 'l'

.IL KLSHIFT krlnk irlnk
Left shift of 64-bit value.
.AT arth null kr cse
.CG notAILI 'q'

.IL KURSHIFT krlnk irlnk
Zero-fill right shift of 64-bit value.
.AT arth null kr cse
.CG notAILI 'q'

.IL KARSHIFT krlnk irlnk
Sign-extended right shift of 64-bit value.
.AT arth null kr cse
.CG notAILI 'q'

.IL ILEADZI irlnk stc
8-/16- bit integer LEADZ intrinsic.
The value, 0 or 1, of the second operand indicates
8-bit or 16-bit, respectively.
.AT arth null ir cse

.IL ILEADZ irlnk
32-bit integer LEADZ intrinsic.
.AT arth null ir cse
.CG "lzcnt" 'l'

.IL KLEADZ krlnk
64-bit integer LEADZ intrinsic.
.AT arth null kr cse
.CG "lzcnt" 'q'

.IL IPOPCNTI irlnk stc
8-/16- bit integer POPCNT intrinsic.
The value of second operand indicates 8-bit if 0 and 16-bit
if 1.
.AT arth null ir cse

.IL IPOPCNT irlnk
32-bit integer POPCNT intrinsic.
.AT arth null ir cse
.CG "popcnt" 'l'

.IL KPOPCNT krlnk
64-bit integer POPCNT intrinsic.
.AT arth null kr cse
.CG "popcnt" 'q'

.IL IPOPPARI irlnk stc
8-/16- bit integer POPPAR intrinsic.
The value of second operand indicates 8-bit if 0 and 16-bit
if 1.
.AT arth null ir cse

.IL IPOPPAR irlnk
32-bit integer POPPAR intrinsic.
.AT arth null ir cse

.IL KPOPPAR krlnk
64-bit integer POPPAR intrinsic.
.AT arth null kr cse

.IL EXTRACT irlnk stc stc
Note that this ILI is defined for machines with bit field extract
HW support (e.g. 88000).
The two stc operand definitions are architecture DEPENDENT.
.AT arth null ir cse
.CG notCG

.IL JMP sym
Unconditional jump to indicated label.
.AT branch null trm dom
.CG terminal "jmp"

.IL JMPA irlnk
Branch indirect.  Fortran only.
.AT branch null trm dom
.CG terminal "jmp" asm_special

.IL JMPM irlnk irlnk sym sym
Indexed jump from a memory table of jump addresses.
.sp
irlnk1 - integer index expression.
.br
irlnk2 - table_size
.br
sym - label for memory table containing addresses
.br
sym  - default label
.AT branch null trm dom
.CG terminal asm_special 'l'

.IL JMPMK krlnk irlnk sym sym
Indexed jump using a 64-bit integer as index value.
.AT branch null trm dom
.CG notCG 'q'

.IL JMPT irlnk irlnk
NOT USED.
Indexed jump into a table of jump instructions.
.nf
irlnk1 - integer index expression. The expression has
       already been normalized to 1 (the value 0 is
       reserved for the "default" jump). If the expression
       is not in the range 1:(n-1) where n is the jump table
       size, the default jump is taken.
irlnk2 - table_size (includes the default label).
.AT branch null trm dom
.CG notCG

.IL QSWITCH sym lnk stc
.AT proc null lnk dom
.CG notCG

.IL ICJMP irlnk irlnk stc sym
Integer compare and jump to the label 'sym'
if the condition, denoted by stc, is true.
.sp
Allowed values of stc:
.sp
    1 = CC_EQ   (jump if equal)
    2 = CC_NE   (jump if not equal)
    3 = CC_LT   (jump if less than)
    4 = CC_GE   (jump if greater than or equal to)
    5 = CC_LE   (jump if less than or equal to)
    6 = CC_GT   (jump if greater than)
.sp
.AT branch null trm dom
.CG terminal notAILI 'l' conditional_branch

.IL UICJMP irlnk irlnk stc sym
Unsigned integer compare and jump to the label 'sym'
if the condition, denoted by stc, is true.
Conditions same as for ICJMP.
.AT branch null trm dom
.CG terminal notAILI 'l' conditional_branch

.IL KCJMP krlnk krlnk stc sym
Integer64 compare and jump to the label 'sym' if the condition,
denoted by stc, is true.
Implemented by library function call.
.AT branch null trm dom
.CG notCG

.IL UKCJMP krlnk krlnk stc sym
unsigned integer64 compare and jump to the label 'sym'
if the condition, denoted by stc, is true.
.AT branch null trm dom
.CG notCG

.IL ACJMP arlnk arlnk stc sym
Address compare and jump to the label 'sym'
if the condition, denoted by stc, is true.
.AT branch null trm dom
.CG notCG replaceby UICJMP conditional_branch

.IL FCJMP splnk splnk stc sym
Single precision compare and jump to the label 'sym'
if the condition, denoted by stc, is true.
.AT branch null trm dom
.CG terminal conditional_branch notAILI

.IL DCJMP dplnk dplnk stc sym
Double precision compare and jump to the label 'sym'
if the condition, denoted by stc, is true.
.AT branch null trm dom
.CG terminal conditional_branch notAILI

.IL ICJMPZ irlnk stc sym
Integer compare with zero and branch to label 'sym' -
the allowed values (and meanings) for stc are the same as for the ICJMP ILI.
.AT branch null trm dom
.CG terminal notAILI 'l' conditional_branch

.IL UICJMPZ irlnk stc sym
Unsigned integer compare with zero and branch to label 'sym' -
the allowed values (and meanings) for stc are the same as for the ICJMP ILI.
.AT branch null trm dom
.CG terminal notAILI 'l' conditional_branch

.IL LCJMPZ irlnk stc sym
Logical compare with zero and branch to label 'sym' -
the allowed values (and meanings) for stc are the same as for the ICJMP ILI.
.AT branch null trm dom
.CG notCG replaceby UICJMPZ conditional_branch

.IL KCJMPZ krlnk stc sym
Integer64 compare with zero and branch to label 'sym'.
For EQ or NE conditions, code is generated; otherwise a library call is used.
.AT branch null trm dom
.CG terminal notAILI conditional_branch

.IL UKCJMPZ krlnk stc sym
Integer64 compare with zero and branch to label 'sym'.
For EQ or NE conditions, code is generated; otherwise a library call is used.
.AT branch null trm dom
.CG terminal notAILI conditional_branch

.IL ACJMPZ arlnk stc sym
Address compare with zero and branch to label 'sym' -
the allowed values (and meanings) for stc are the same as for the ICJMP ILI.
.AT branch null trm dom
.CG notCG replaceby UICJMPZ conditional_branch

.IL FCJMPZ splnk stc sym
Single compare with zero and branch to label 'sym'.
.AT branch null trm dom
.CG notCG conditional_branch

.IL DCJMPZ dplnk stc sym
Double compare with zero and branch to label 'sym'.
.AT branch null trm dom
.CG notCG conditional_branch

.IL JCC
Conditional jump based on immediately preceding compare operation.
Used only in the AILI.
.AT branch null trm dom
.CG CGonly asm_special conditional_branch

.IL CSEIR irlnk
Integer register cse (common subexpression). The ILI located by the cse
ILI is one whose value is to be re-used (the ILI need not be "evaluated").
This ILI is used when multiple references of an ILM occur in the same
ILM block.  The CSE ili are treated as a special case by the linearizer,
and never appear in a linear ili block.
.AT arth null ir
.CG notCG

.IL CSESP splnk
Single precision register cse.
.AT arth null sp
.CG notCG

.IL CSEDP dplnk
Double precision register cse.
.AT arth null dp
.CG notCG

.IL CSECS cslnk
Single precision complex register cse.
.AT arth null cs
.CG notCG

.IL CSECD cdlnk
Double precision complex register cse.
.AT arth null cd
.CG notCG

.IL CSEAR arlnk
Address register cse.
.AT arth null ar
.CG notCG

.IL CSEKR krlnk
Integer64 register cse.
.AT arth null kr
.CG notCG

.IL CSE lnk stc
Complex cse (common subexpression). The ILI located by the cse
ILI is one whose value is to be re-used (the ILI need not be "evaluated").
This ILI is used when multiple references of an ILM occur in the same
ILM block.
This ili is seen by the code generator but never appears in the
linear ili.
.AT arth null ir
.CG notCG

.IL APURE arlnk
Call a pure function with no arguments and returns an AR value.
Will always have an ALT which is the actual call.
arlnk is an ACON ili of the function being called.
.AT arth null ar cse
.CG notCG

.IL APUREA arlnk arlnk
Call a pure function with one AR argument and returns an AR value.
Will always have an ALT which is the actual call.
arlnk is an ACON ili of the function being called.
.AT arth null ar cse
.CG notCG

.IL APUREI arlnk irlnk
Call a pure function with one IR argument and returns an AR value.
Will always have an ALT which is the actual call.
arlnk is an ACON ili of the function being called.
.AT arth null ar cse
.CG notCG

.IL IPURE arlnk
Call a pure function with no arguments and returns an IR value.
Will always have an ALT which is the actual call.
arlnk is an ACON ili of the function being called.
.AT arth null ir cse
.CG notCG

.IL IPUREA arlnk arlnk
Call a pure function with one AR argument and returns an IR value.
Will always have an ALT which is the actual call.
arlnk is an ACON ili of the function being called.
.AT arth null ir cse
.CG notCG

.IL IPUREI arlnk irlnk
Call a pure function with one IR argument and returns an IR value.
Will always have an ALT which is the actual call.
arlnk is an ACON ili of the function being called.
.AT arth null ir cse
.CG notCG

.IL REP
Repeat prefix opcode for string operations (such as the following SMOVE).
Emitted immediately before an SMOVE operation.
.AT other null trm dom
.CG CGonly "rep"

.IL GSMOVE arlnk arlnk nme nme stc
General structure copy.
A structure store (SMOVE ILM) is expanded into the GSMOVE ILI; a phase, such as
the ACC CG, needs to have the structure assignment presented as a first-class
ILI operation. 
After the last phase requiring GSMOVE, GSMOVE will then be expanded into
lower level ILI which will be dependent on target, alignment, small vs large,
etc.
  \'op1' is the source address.
  \'op2' is the destination address.
  \'nme1' is the names table entry for source struct.
  \'nme2' is the names table entry for the destination struct.
  \'stc' is the dtype of the struct.
.AT other null trm dom
.CG notCG

.IL SMOVE arlnk arlnk arlnk nme
Structure copy.
  \'op1' is the source address.
  \'op2' is the destination address.
  \'op3' is number of 4-byte units to copy.
  \'nme' is names table entry for destination struct.
.AT other null trm dom
.CG terminal "movs"

.IL SMOVEJ arlnk arlnk nme nme stc
Simple structure copy.  (MOVS is x86 parlance.)
This is used to replace the SMOVEI/SMOVES pair, which was used when
the ILI operand count was only 4.
\'op1' is the source address
\'op2' is the destination address
\'nme1' is the names table entry for source struct.
\'nme2' is the names table entry for the destination struct.
\'op5' is actual number of bytes to copy.
This gets turned into SMOVE and load/store operations by rm_smove
.AT other null trm dom
.CG notCG

.IL SMOVEI arlnk arlnk stc nme
Simple structure copy.  (MOVS is x86 parlance.)
\'op1' is arlnk to SMOVES
\'op2' is the destination address
\'op3' is actual number of bytes to copy.
\'nme' is names table entry for destination struct.
This gets turned into SMOVE and load/store operations by rm_smove
.AT other null trm dom
.CG notCG

.IL SMOVES arlnk nme
Simple structure copy source operand (SMOVEI operand 2)
\'op1' is the source address.
\'nme' is names table entry for source struct.
This gets turned into SMOVE and load/store operations by rm_smove
.AT other null ar dom
.CG notCG

.IL XMOVE arlnk arlnk nme
Structure copy.
  \'op1' is the source address.
  \'op2' is the destination address.
  \'nme' is names table entry for destination struct.
.AT other null trm dom
.CG terminal "movapd" sse_avx

.IL ST irlnk arlnk nme stc
Store integer value.
In ILI, the value to be stored must fit without implicit truncation, i.e. immediately 
reloading using LD with the same size modifier must reproduce the value that was stored.
In LILI or AILI, ST may perform implicit truncation.
\'op1' is a pointer to an ili representing the value being stored.
.br
\'op2' is a pointer to the address expression of the variable being defined.
.br
\'nme' is a pointer to a names table entry of the variable being defined.
.br
\'stc' is the size modifier of the memory operation as described for
the LD ili above.
.AT store null trm
.CG terminal "mov" move

.IL STSP splnk arlnk nme stc
Store single precision quantity.  'stc' is not used.
.AT store null trm
.CG terminal "movss" move

.IL STDP dplnk arlnk nme stc
Store double precision quantity.  'stc' is not used.
.AT store null trm
.CG terminal "movsd" move

.IL STSCMPLX cslnk arlnk nme stc
Store single precision complex quantity.  'stc' is not used.
.AT store null trm
.CG terminal "movsd" move sse_avx
.SI ld double fadd fmul fst lat(3)
.SI st direct fst lat(2)
.SI direct fadd fmul lat(2)

.IL STDCMPLX cdlnk arlnk nme stc
Store double precision complex quantity.  'stc' is not used.
.AT store null trm
.CG terminal "movups" move sse_avx
.SI ld double fadd fmul fst lat(3)
.SI st direct fst lat(2)
.SI direct fadd fmul lat(2)

.IL STQ dplnk arlnk nme stc
Store m128 quantity.  'stc' is not used.
.AT store null trm
.CG terminal "movapd" move sse_avx
.SI ld double fadd fmul fst lat(3)
.SI st direct fst lat(2)
.SI direct fadd fmul lat(2)

.IL STQU dplnk arlnk nme stc
Store unaligned m128 quantity.  'stc' is not used.
.AT store null trm
.CG terminal "movupd" move sse_avx
.SI ld double fadd fmul fst lat(3)
.SI st direct fst lat(2)
.SI direct fadd fmul lat(2)

.IL ST256 dplnk arlnk nme stc
Store m256 quantity.  'stc' is not used.
.AT store null trm
.CG terminal "movapd" move sse_avx
.SI ld double fadd fmul fst lat(3)
.SI st direct fst lat(2)
.SI direct fadd fmul lat(2)

.IL ST256U dplnk arlnk nme stc
Store unaligned m256 quantity.  'stc' is not used.
.AT store null trm
.CG terminal "movupd" move sse_avx
.SI ld double fadd fmul fst lat(3)
.SI st direct fst lat(2)
.SI direct fadd fmul lat(2)

.IL STA arlnk arlnk nme
Store address quantity inside of op1 into op2.
Replaced by ST opcode in cgoptim1.
.AT store null trm
.CG terminal notAILI

.IL STRG1 arlnk stc
Store address quantity inside of op1 argument register described by stc.
Used in g++ style
thunks when adjusting the *this* pointer, (the first argument) just
before jumping through to the function Replaced by ST opcode in cgoptim1.
.AT store null trm
.CG terminal notAILI

.IL STKR krlnk arlnk nme stc
Store 64 bit integer value (in register pair).  'stc' is not used.
.AT store null trm
.CG terminal notAILI

.IL VZST arlnk
Special ili created by the vectorizer indicating that the variable
whose address is op1 is stored; necessary in cases where
the vectorizer replaces assignments with calls.  The optimizer will process
the ili to create store information and then delete the ili.  Code generator
will not see this ili.
.AT other null trm
.CG notCG

.IL JSR sym lnk
\'sym' is external function or subroutine being called (standard linkage).
\'op2' points to a list (terminated by NULL) of ARG ili for the
arguments.
.AT proc null lnk dom
.CG terminal "call" asm_special ccmod

.IL JSRA arlnk lnk stc stc
JSR to routine whose address is pointed to by op1.
op2 points to the list of ARG ILIs which represents the arguments.
stc1 attribute flag (stdcall in x86)
stc2 dtype 
.AT proc null lnk dom
.CG terminal notAILI ccmod

.IL QJSR sym lnk
Quick (intrinsic) call.
\'sym' is the external procedure being called.
\'op2' locates the list of arguments (define arg ILI - DAAR, DADR, DADP).
.AT proc null lnk dom
.CG terminal notAILI ccmod

.IL GJSR sym lnk
Same as JSR, but the argument list is expressed using the general argument
ILI, i.e., before applying the ABI.
.AT proc null lnk dom
.CG terminal notCG

.IL GJSRA arlnk lnk stc stc
Same as JSRA, but the argument list is expressed using the general argument
ILI, i.e., before applying the ABI.
.AT proc null lnk dom
.CG terminal notCG

.IL NULL stc
Used to mark the end of an argument list for a JSR, QJSR or JSRA ili.
.AT other null lnk
.CG notAILI

.IL GARG lnk lnk stc nme
A general argument link, used before applying the ABI
.sp
\'lnk' (first) points to the value of the argument.
\'lnk' (second) points to the next ARG ILI.
First \'stc' is the dtype.
Second \'stc' is an NME value, if set, for address arguments.
.AT define null lnk
.CG 

.IL GARGRET lnk lnk stc nme
A general argument link representing the return value of the function
.sp
\'lnk' (first) points to the value of the argument.
\'lnk' (second) points to the next ARG ILI.
\'stc' is the dtype
\'nme' is the nme
.AT define null lnk
.CG notCG

.IL VA_ARG arlnk stc
va_arg(va_list x, typeof_arg) computes the address of the argument
'arlnk' address of the va_list
'stc' the dtype of the argument being reference
.AT arth null ar
.CG notCG

.IL ARGIR irlnk lnk
Defines an integer memory argument.
\'irlnk' points to the register value of the argument.
\'lnk' points to the next ARG ILI.
.AT define null lnk
.CG memarg "mov" 'l'

.IL ARGSP splnk lnk
Defines a single-precision memory argument.
\'splnk' points to the register value of the argument.
\'lnk' points to the next ARG ILI.
.AT define null lnk
.CG memarg "movss"

.IL ARGDP dplnk lnk
Defines a double precision memory argument.
\'dplnk' points to the register value of the argument.
\'lnk' points to the next ARG ILI.
.AT define null lnk
.CG memarg "movsd"

.IL ARGAR arlnk lnk stc
A memory argument of type pointer or struct/union.
.sp
\'arlnk' points to the value of the argument.
.br
\'lnk' points to the next ARG ILI.
.br
\'stc' is the dtype if this is a struct arg, else it is 0.
If 'stc' == 1, then this argument is a pointer to the return area for a
C function returning struct, and requires special treatment.
.AT define null lnk
.CG memarg "mov" 'l'

.IL ARGKR krlnk lnk
Defines a 64 bit integer memory argument.
\'krlnk' points to the value of the argument.
\'lnk' points to the next ARG ILI.
.AT define null lnk
.CG memarg notAILI

.IL DAIR irlnk ir lnk
Define integer argument in general purpose register for a JSR.
.AT define null lnk
.CG "mov" 'l' move

.IL DASP splnk sp lnk
Define a single precision argument in xmm register for a JSR.
.AT define null lnk
.CG "movss" move

.IL DADP dplnk dp lnk
Define a double precision argument in xmm register for a JSR.
.AT define null lnk
.CG "movsd" move

.IL DACS cslnk cs lnk
Define a C struct argument of two floats, passed in the indicated xmm register.
.AT define null lnk
.CG "movsd" move sse_avx
.SI ld double fadd fmul fst lat(4)
.SI st double fst lat(4)
.SI double fadd fmul lat(2)

.IL DACD cdlnk cd lnk
Define a C struct argument of two double, passed in the indicated xmm register.
.AT define null lnk
.CG "movupd" move sse_avx
.SI ld double fadd fmul fst lat(4)
.SI st double fst lat(4)
.SI double fadd fmul lat(2)

.IL PSARG xmm stc lnk
Move symbolic register 'xmm' into actual register 'stc' (typically
XR_XMM0 or XR_XMM1) in preparation for call to vector intrinsic function.
.AT define null lnk
.CG "movaps" move sse_avx
.SI ld double lat(4)
.SI st double lat(3)
.SI double lat(2)

.IL PDARG xmm stc lnk
Move symbolic register 'xmm' into actual register 'stc' (typically
XR_XMM0 or XR_XMM1) in preparation for call to vector intrinsic function.
.AT define null lnk
.CG "movapd" move ssedp sse_avx
.SI ld double fadd fmul fst lat(2)
.SI st double fst lat(3)
.SI double fadd fmul lat(2)

.IL KISHFT krlnk krlnk
Shift op1 by op2.  Left if op2 is > 0; else right (no sign extension).
This ili only shows up for Fortran, specifically for the KISHFT intrinsic.
If 2nd operand is compile time constant, this ili will have been
replaced by either a left or right shift ili by the Expander.
Otherwise, it is implemented as a call to a run-time function.
.AT arth null kr cse
.CG notCG

.IL DAAR arlnk ar lnk
Define argument in address register for a JSR.
Lnk1 points to the expression to be moved into the specified (ar2)
address register. Lnk3 locates the next argument for the JSR.
.AT define null lnk
.CG notCG replaceby DAIR

.IL DAKR krlnk kr lnk
Define argument in register pair for a JSR.
.AT define null lnk
.CG notCG

.IL DFRIR lnk ir
Define function result in a integer register.
.AT define null ir cse
.CG terminal asm_nop 'l'

.IL DFRSP lnk sp
Define single precision function result returned in xmm register 'sp'.
.AT define null sp cse
.CG terminal asm_nop

.IL DFRDP lnk dp
Define double precision function result returned in xmm register 'dp'.
.AT define null dp cse
.CG terminal asm_nop

.IL DFRCS lnk cs
Define single precision complex function result in an xmm register.
.AT define null cs cse
.CG terminal asm_nop

.IL DFRCD lnk cd
Define double precision complex function result in an xmm register.
.AT define null cd cse
.CG terminal asm_nop

.IL DFRSPX87 lnk
Define single precision function result (on floating-point stack).
.AT define null sp cse
.CG terminal "fstps"

.IL DFRDPX87 lnk
Define double precision function result (on floating-point stack).
.AT define null dp cse
.CG terminal "fstpl"

.IL DFR128 lnk dp
Define 128-bit function result in an xmm register.
.AT define null dp cse
.CG terminal asm_nop

.IL DFR256 lnk dp
Define 256-bit function result in an ymm register.
.AT define null dp cse
.CG terminal asm_nop

.IL DFRAR lnk ar
Define function result in an address register.
\'op1' points to one of the JSR ILI.
.AT define null ar cse
.CG notCG replaceby DFRIR

.IL DFRKR lnk kr
Define integer64 function result in a register pair.
.AT define null kr cse
.CG terminal notAILI 'q'

.IL IRDF ir
Define one of the general purpose registers.
These ILI (IRDF, DPDF, ARDF)  used for global
register allocation, and for the pre-defined regs.
.AT define null ir cse
.CG terminal asm_nop 'l'

.IL SPDF sp
Define single precision register (xmm register).
.AT define null sp cse
.CG terminal asm_nop

.IL DPDF dp
Define double precision register (xmm register).
.AT define null dp cse
.CG terminal asm_nop

.IL ARDF ar
Define address register. (ar is actual register number).
.AT define null ar cse
.CG notCG replaceby IRDF

.IL KRDF kr
Define integer64 register.
.AT define null kr
.CG notCG

.IL MVIR irlnk ir
Move integer value into specific integer register, ir.
.AT move null trm
.CG terminal notAILI 'l'

.IL MVSP splnk sp
Indicates a single-precision function return value, which is to be placed
on the x87 floating point stack.  The 2nd argument, 'sp', is ignored.
.AT move null trm
.CG terminal "flds"

.IL MVDP dplnk dp
Indicates a double-precision function return value, which is to be placed
on the x87 floating point stack.  The 2nd argument, 'dp', is ignored.
.AT move null trm
.CG terminal "fldd"

.IL SPSP2SCMPLX splnk splnk
Form a single complex value out of two single precision real values.
.AT other null cs cse
.CG sse_avx asm_special

.IL SPSP2SCMPLXI0 splnk
Form a single complex value out of two single precision real values, imaginary is 0.
.AT other null cs cse
.CG sse_avx asm_special

.IL DPDP2DCMPLX dplnk dplnk
Form a double complex value out of two double precision real values.
.AT other null cd cse
.CG sse_avx asm_special

.IL DPDP2DCMPLXI0 dplnk
Form a double complex value out of two double precision real values, imaginary is 0.
.AT other null cd cse
.CG sse_avx asm_special

.IL SCMPLX2IMAG cslnk
Return single precision imaginary part of a single complex value.
.AT other null sp cse
.CG sse_avx asm_special

.IL DCMPLX2IMAG cdlnk
Return double precision imaginary part of a double complex value.
.AT other null dp cse
.CG sse_avx asm_special

.IL SCMPLX2REAL cslnk
Return single precision real part of a single complex value.
.AT other null sp cse
.CG sse_avx asm_special

.IL DCMPLX2REAL cdlnk
Return double precision real part of a double complex value.
.AT other null dp cse
.CG sse_avx asm_special

.IL MVQ dplnk dp
This ili represents a m128 function return value.
For X86_64, the value is moved into the specified xmm register.
.AT move null trm
.CG terminal "movapd" move sse_avx
.SI ld double fadd fmul fst lat(3)
.SI st direct fst lat(2)
.SI direct fadd fmul lat(2)

.IL MV256 dplnk dp
This ili represents a m256 function return value.
For X86_64, the value is moved into the specified ymm register.
.AT move null trm
.CG terminal "movapd" move sse_avx
.SI ld double fadd fmul fst lat(3)
.SI st direct fst lat(2)
.SI direct fadd fmul lat(2)

.IL MOVSP
Move a single-precision xmm register value.
.AT move null sp
.CG CGonly "movss" move

.IL MOVDP
Move a double-precision xmm register value.
.AT move null dp
.CG CGonly "movsd" move

.IL MOVCS
Move a single-precision complex xmm register value.
.AT move null cs
.CG CGonly "movsd" move

.IL MOVCD
Move a double-precision complex xmm register value.
.AT move null cd
.CG CGonly "movupd" move

.IL MVSPX87 splnk
Indicates a single-precision function return value, which is to be placed
on the x87 floating point stack.
.AT move null trm
.CG terminal "flds"

.IL MVDPX87 dplnk
Indicates a double-precision function return value, which is to be placed
on the x87 floating point stack.
.AT move null trm
.CG terminal "fldl"

.IL MOVQP
Move a __m128 xmm register value.
.AT move null dp
.CG CGonly "movapd" move sse_avx
.SI ld double fadd fmul fst lat(3)
.SI st direct fst lat(2)
.SI direct fadd fmul lat(2)

.IL MOV256
Move a __m256 xmm register value.
.AT move null dp
.CG CGonly "movapd" move sse_avx
.SI ld double fadd fmul fst lat(3)
.SI st direct fst lat(2)
.SI direct fadd fmul lat(2)

.IL MVAR arlnk ar
Move address value into specific address register, ar.
.AT move null trm
.CG terminal notCG replaceby MVIR

.IL MVKR krlnk kr
Move integer64 value into specific integer register pair, kr.
.AT move null trm
.CG terminal notAILI

.IL FREEIR irlnk
Ensures that the result reg is freed.
The FREExx ili are eliminated by the linearizer phase of the code generator.
.AT other null trm
.CG terminal notAILI

.IL FREESP splnk
.AT other null trm
.CG terminal notAILI

.IL FREEDP dplnk
.AT other null trm
.CG terminal notAILI

.IL FREECS cslnk
.AT other null trm
.CG terminal notAILI

.IL FREECD cdlnk
.AT other null trm
.CG terminal notAILI

.IL FREESPX87 splnk
If necessary, pop X87 stack after a function call which returns a
floating-point value which is not used.
.AT other null trm
.CG terminal "fstp\t%st(0)"

.IL FREEDPX87 dplnk
.AT other null trm
.CG terminal "fstp\t%st(0)"

.IL FREEAR arlnk
.AT other null trm
.CG terminal notCG replaceby FREEIR

.IL FREEKR krlnk
.AT other null trm
.CG terminal notAILI

.IL FREE lnk stc
.AT other null trm
.CG terminal notAILI

.IL ENTRY sym
Main function entry or fortran ENTRY.
.AT other null trm dom
.CG terminal asm_nop

.IL EXIT sym
Exit the procedure.
.AT other null trm dom
.CG terminal asm_special

.IL ARGSAVE sym
For varargs/stdargs functions, this ili appears immediately after ENTRY
ili.  Not used by X86_32 compiler
.AT other null trm dom
.CG notCG

.IL NOP
Null operation - used when a linear ili or aili is deleted.
.AT other null trm
.CG asm_nop

.IL ASM sym
Implements C inline assembly code, asm(), feature. Also used as
a convenience by the code generator.  'sym' is a symbol table
pointer to a string constant.
.AT other null trm dom
.CG terminal asm_special ccmod

.IL GASM sym lnk lnk lnk
Compatible ASM language representation to support asm().
sym - the asm string
lnk1 - linked list of generic GASMLNKOs of output expressions
lnk2 - linked list of specific GASMLNKI/SP/DP/As of input expressions
lnk3 - linked list of generic GASMLNKCs of clobber strings
NOTE: For now we add ccmod. In the future we may only want to indicate ccmod
if the user specifies "cc" in the clobber list.
.AT other null trm dom
.CG terminal asm_special ccmod

.IL GASMCNM sym sym
Used to represent a symbolic name for a gasm constraint
sym - identifier of constraint name. Stored as an int since we only care
      about the name, not its type.
sym - constraint number
.AT other null trm
.CG terminal asm_nop

.IL GASMLNKG sym nme lnk lnk
generic gasmlnk;
sym - descriptor string
nme - nme being stored
lnk1 - input or output expression
lnk2 - next GASMLNKG
.AT other null lnk
.CG asm_nop

.IL GASMLNKTYP stc lnk
generic gasmlnk - stores type
stc - base type of expression
lnk1 - input or output expression
.AT other null lnk
.CG asm_nop

.IL GASMLNKC sym lnk
sym - descriptor string
lnk - next GASMLNKC
.AT other null lnk
.CG asm_nop

.IL GASMLNKO sym nme lnk stc
sym - descriptor string
nme - nme being stored
lnk - next GASMLNKO
stc - data type of expression
.AT other null lnk
.CG "" asm_nop

.IL GASMLNKI sym nme irlnk lnk
sym - descriptor string
nme - nme being stored
irlnk - the input expression
lnk - next specific GASMLNK
.AT other null lnk
.CG "" asm_nop

.IL GASMLNKB sym nme irlnk lnk
Same as GASMLNKI, but represents byte reg
sym - descriptor string
nme - nme being stored
irlnk - the input expression
lnk - next specific GASMLNK
.AT other null lnk
.CG "" asm_nop

.IL GASMLNKH sym nme irlnk lnk
Same as GASMLNKI, but represents Half-word reg
sym - descriptor string
nme - nme being stored
irlnk - the input expression
lnk - next specific GASMLNK
.AT other null lnk
.CG "" asm_nop

.IL GASMLNKKR sym nme irlnk lnk
Same as GASMLNKI, but represents quad word reg (not currently used on 32-bit x86)
sym - descriptor string
nme - nme being stored
irlnk - the input expression
lnk - next specific GASMLNK
.AT other null lnk
.CG "" asm_nop

.IL GASMLNKSP sym nme splnk lnk
sym - descriptor string
nme - nme being stored
splnk - the input expression
lnk - next specific GASMLNK
.AT other null lnk
.CG "" asm_nop

.IL GASMLNKDP sym nme dplnk lnk
sym - descriptor string
nme - nme being stored
dplnk - the input expression
lnk - next specific GASMLNK
.AT other null lnk
.CG "" asm_nop

.IL GASMLNKQP sym nme dplnk lnk
sym - descriptor string
nme - nme being stored
dplnk - the input expression
lnk - next specific GASMLNK
.AT other null lnk
.CG "" asm_nop

.IL GASMLNKA sym nme arlnk lnk
sym - descriptor string
nme - nme being stored
arlnk - the input expression
lnk - next specific GASMLNK
.AT other null lnk
.CG "" asm_nop

.IL GASMLNKS sym nme arlnk lnk
the operand is a struct
sym - descriptor string
nme - nme being stored
arlnk - the input expression
lnk - next specific GASMLNK
.AT other null lnk
.CG "" asm_nop

.IL GASMLDI stc stc nme
stc - output argument number, 0..n
stc - optional field filled in by CG, this is the constaint used.
nme - nme of object we're loading
.AT other null ir
.CG asm_nop

.IL GASMLDH stc stc nme
half word register
stc - output argument number, 0..n
stc - optional field filled in by CG, this is the constaint used.
nme - nme of object we're loading
.AT other null ir
.CG asm_nop

.IL GASMLDB stc stc nme
byte register
stc - output argument number, 0..n
stc - optional field filled in by CG, this is the constaint used.
nme - nme of object we're loading
.AT other null ir
.CG asm_nop

.IL GASMLDKR stc stc nme
quad register
stc - output argument number, 0..n
stc - optional field filled in by CG, this is the constaint used.
nme - nme of object we're loading
.AT other null ir
.CG asm_nop

.IL GASMLDSP stc stc nme
stc - output argument number, 0..n
stc - optional field filled in by CG, this is the constaint used.
nme - nme of object we're loading
.AT other null sp
.CG asm_nop

.IL GASMLDDP stc stc nme
stc - output argument number, 0..n
stc - optional field filled in by CG, this is the constaint used.
nme - nme of object we're loading
.AT other null dp
.CG asm_nop

.IL GASMLDQP stc stc nme
stc - output argument number, 0..n
stc - optional field filled in by CG, this is the constaint used.
nme - nme of object we're loading
.AT other null dp
.CG asm_nop

.IL GASMLD256 stc stc nme
__m256
stc - output argument number, 0..n
stc - optional field filled in by CG, this is the constaint used.
nme - nme of object we're loading
.AT other null dp
.CG asm_nop

.IL GASMLDA stc stc nme
stc - output argument number, 0..n
stc - optional field filled in by CG, this is the constaint used.
nme - nme of object we're loading
.AT other null ar
.CG asm_nop

.IL FPSAVE arlnk
Store the frame pointer in the location whose address is specified
by op1.
.AT other null trm dom
.CG terminal notAILI

.IL VFENTER arlnk
Enter a "function" which will compute the value of an expression
used as a variable format field. op1 locates a temporary area
used to set up the environment of the expression:
\ op1+0 -- contains the fp to use for the expression
\ op1+4 -- where to save the current fp
The code for VFENTER performs the following:
\1.  save current fp in addr(op1)+4
\2.  load fp from addr(op1)+0
.AT other null trm dom
.CG terminal asm_special ccmod

.IL VFEXIT arlnk irlnk
Exit the variable format field function.  lnk1 locates the temporary
area (see VFENTER).  lnk2 is the function return value. The code for
VFEXIT performs the following:
\1.  value of lnk2 --> integer function return register
\2.  restore fp from addr(lnk1)+4
\3.  return.
.AT other null trm dom
.CG terminal asm_special ccmod

.IL PREFETCHNTA arlnk stc nme
Prefetch cache line.  Non-Temporal Access - prefetch in such a way to
minimize cache pollution.  Second operand, 'stc' is not used.
.AT other null trm ssenme
.CG terminal "prefetchnta"

.IL PREFETCHT0 arlnk stc nme
Prefetch cache line into all cache levels.
.AT other null trm ssenme
.CG terminal "prefetcht0"

.IL PREFETCHW arlnk stc nme
Prefetch cache line into L1 data cache.  Used in anticipation to subsequent
store into the cache line.
.AT other null trm ssenme
.CG terminal "prefetchw"

.IL PREFETCH arlnk stc nme
Prefetch cache line into L1 data cache.
.AT other null trm ssenme
.CG terminal "prefetch"

.IL LABEL sym
This ILI represents a label 'sym' that is within a basic block.
.AT other null trm dom
.CG terminal asm_special

.IL PSLD arlnk xmm nme
Load 16 bytes from aligned memory into xmm register denoted by xmm.
.AT pload null trm ssenme
.CG terminal "movaps" move sse_avx

.IL PDLD arlnk xmm nme
Load 16 bytes from aligned memory into xmm register denoted by xmm.
.AT pload null trm ssenme
.CG terminal "movapd" move ssedp sse_avx

.IL PILD arlnk xmm nme
Load 16 bytes, 4 or 8 byte integer, from aligned memory into xmm register
denoted by xmm.
.AT pload null trm ssenme
.CG terminal "movdqa" move ssedp sse_avx

.IL PSLDU arlnk xmm nme
Load 16 bytes from unaligned memory into xmm register denoted by xmm.
.AT pload null trm ssenme
.CG terminal "movups" move sse_avx

.IL PDLDU arlnk xmm nme
Load 16 bytes from unaligned memory into xmm register denoted by xmm.
.AT pload null trm ssenme
.CG terminal "movupd" move ssedp sse_avx

.IL PILDU arlnk xmm nme
Load 16 bytes, 4 or 8 byte integer, from unaligned memory into xmm register
denoted by xmm.
.AT pload null trm ssenme
.CG terminal "movdqu" move ssedp sse_avx

.IL PSLD_SCALAR arlnk xmm nme
Move 4-byte scalar value whose address is indicated by arlnk,
into least significant word of the 16-byte xmm register indicated by 'xmm'.
.AT other null trm ssenme
.CG terminal "movss"

.IL PDLD_LOWH arlnk xmm nme
Load 8 bytes from memory into low half of xmm register denoted by xmm.
.AT other null trm ssenme
.CG terminal "movlpd" ssedp

.IL PDLD_HIGHH arlnk xmm nme
Load 8 bytes from memory into high half of xmm register denoted by xmm.
.AT other null trm ssenme
.CG terminal "movhpd" ssedp

.IL PI1INSERT arlnk xmm nme stc
SSE4.1 and AVX instruction to load an integer*1 value from 'arlnk' and
insert it into 'xmm' at the byte offset given by 'stc'.
.AT other null trm ssenme
.CG terminal "pinsrb" sse_avx asm_special

.IL PI2INSERT arlnk xmm nme stc
SSE2 and AVX instruction to load an integer*2 value from 'arlnk' and
insert it into 'xmm' at the word offset given by 'stc' (where a 'word'
is 2 bytes).
.AT other null trm ssenme
.CG terminal "pinsrw" sse_avx asm_special

.IL PI4INSERT arlnk xmm nme stc
SSE4.1 and AVX instruction to load an integer*4 value from 'arlnk' and
insert it into 'xmm' at the dword offset given by 'stc' (where a
'dword' is 4 bytes).
.AT other null trm ssenme
.CG terminal "pinsrd" sse_avx asm_special

.IL PI8INSERT arlnk xmm nme stc
SSE4.1 and AVX instruction to load an integer*8 value from 'arlnk' and
insert it into 'xmm' at the qword offset given by 'stc' (where a
'qword' is 8 bytes).  This instruction cannot be used on x86-32.
.AT other null trm ssenme
.CG notCG

.IL PSLD_LOWH arlnk xmm nme
Load 2 single precision values to low half of xmm register.
This opcode and the next are used in combination, in place of "movups"
due to a Hammer performance penalty for using "movups".
.AT other null trm ssenme
.CG terminal "movlps"

.IL PSLD_HIGHH arlnk xmm nme
Load 2 single precision values to high half of xmm register.
.AT other null trm ssenme
.CG terminal "movhps"

.IL PSST arlnk xmm nme
Store 16 bytes from xmm register denoted by xmm into aligned memory.
.AT pstore null trm ssenme
.CG terminal "movaps" move ssest sse_avx

.IL PDST arlnk xmm nme
Store 16 bytes from xmm register denoted by xmm into aligned memory.
.AT pstore null trm ssenme
.CG terminal "movapd" move ssedp ssest sse_avx

.IL PIST arlnk xmm nme
Store 16 bytes, 4 or 8 byte integer, from xmm register denoted by xmm
into aligned memory.
.AT pstore null trm ssenme
.CG terminal "movdqa" move ssedp ssest sse_avx

.IL PSSTU arlnk xmm nme
Store 16 bytes from xmm register denoted by xmm into unaligned memory.
.AT pstore null trm ssenme
.CG terminal "movups" move ssest sse_avx

.IL PDSTU arlnk xmm nme
Store 16 bytes from xmm register denoted by xmm into unaligned memory.
.AT pstore null trm ssenme
.CG terminal "movupd" move ssedp ssest sse_avx

.IL PISTU arlnk xmm nme
Store 16 bytes, 4 or 8 byte integer, from xmm register denoted by xmm
into unaligned memory.
.AT pstore null trm ssenme
.CG terminal "movdqu" move ssedp ssest sse_avx

.IL PSSTS arlnk xmm nme
Streaming store.
Store 16 bytes from xmm register denoted by xmm into aligned memory
bypassing cache.
.AT pstore null trm ssenme
.CG terminal "movntps" move ssest sse_avx

.IL PSSTS_SCALAR arlnk xmm nme
Scalar streaming store single precision quantity.
.AT other null trm ssenme
.CG terminal "movntss" move ssest

.IL SSTS_SCALAR splnk arlnk nme stc
Scalar streaming store single precision quantity.
.AT store null trm
.CG terminal "movntss" move

.IL PDSTS arlnk xmm nme
Streaming store.
Store 16 bytes from xmm register denoted by xmm into aligned memory
bypassing cache.
.AT pstore null trm ssenme
.CG terminal "movntpd" move ssedp ssest sse_avx

.IL PDSTS_SCALAR arlnk xmm nme
Scalar streaming store double precision quantity.
.AT other null trm ssenme
.CG terminal "movntsd" move ssedp ssest

.IL DSTS_SCALAR dplnk arlnk nme
Scalar streaming store double precision quantity.
.AT store null trm
.CG terminal "movntsd" move

.IL PISTS arlnk xmm nme
Streaming store.  Store 16 bytes, 4 or byte integer, from xmm register
denoted by xmm into aligned memory, bypassing cache.
.AT pstore null trm ssenme
.CG terminal "movntdq" move ssedp ssest sse_avx

.IL PSST_SCALAR arlnk xmm nme
Store value from xmm register into 4-byte variable.
.AT other null trm ssenme
.CG terminal "movss" move ssest

.IL PDST_LOWH arlnk xmm nme
Store low half of xmm register into 8-byte memory location.
.AT other null trm ssenme
.CG terminal "movsd" move ssedp ssest

.IL PDST_HIGHH arlnk xmm nme
Store high half of xmm register into 8-byte memory location.
.AT other null trm ssenme
.CG terminal "movhpd" ssedp ssest

.IL PSST_LOWH arlnk xmm nme
Store 2 single precision values from low half of xmm register.
This opcode and the next are used in combination, in place of "movups"
due to a Hammer performance penalty for using "movups".
.AT other null trm ssenme
.CG terminal "movlps" ssest

.IL PSST_HIGHH arlnk xmm nme
Store 2 single precision values from high half of xmm register.
.AT other null trm ssenme
.CG terminal "movhps" ssest

.IL SFENCE
X86 sfence instruction used in conjunction with streaming stores.
.AT other null trm dom
.CG terminal "sfence"

.IL PSMOVX xmm xmm
Move low order 4 byte value of xmm1 into low order 4 bytes of xmm2, without
disturbing the other 12 bytes of xmm2.
.AT other null trm
.CG terminal "movss"
.SI ld double lat(4)
.SI st double lat(3)
.SI double lat(2)

.IL PSMOV xmm xmm
Move contents of one xmm register into a 2nd xmm register.
.AT other null trm
.CG terminal "movaps" move sse_avx

.IL PDMOV xmm xmm
Move contents of one xmm register into a 2nd xmm register.
.AT other null trm
.CG terminal "movapd" move ssedp sse_avx

.IL PIMOV xmm xmm
Move contents of xmm register containing 4 or 8-byte integers.
.AT other null trm
.CG terminal "movdqa" move sse_avx

.IL PSDFR stc xmm
Move 16-byte register 'stc' containing result of vector intrinsic function,
into symbolic register 'xmm'.  'stc' is typically XR_XMM0.
.AT other null trm
.CG terminal "movaps" move sse_avx

.IL PDDFR stc xmm
Move 16-byte register 'stc' containing result of vector intrinsic function,
into symbolic register 'xmm'.  'stc' is typically XR_XMM0.
.AT other null trm
.CG terminal "movapd" move ssedp sse_avx

.IL PDMV_LOWH dplnk xmm
Move d.p. value into low half of xmm register.
This operation is used for the streaming store optimization.
.AT other null trm
.CG terminal "movlpd" move ssedp

.IL PI8MV_LOW krlnk xmm
Move 8-byte integer value into low half of xmm register.
.AT other null trm
.CG terminal notAILI

.IL PDMV_HIGHH dplnk xmm
Move d.p. value into high half of xmm register.
This operation is used for the streaming store optimization.
If input operand is a register, the "unpcklpd" instruction is used
instead.
.AT other null trm
.CG terminal "movhpd" ssedp

.IL PDMV_DUP dplnk xmm
Move 1 double precision value into both high & low half of xmm register.
.AT other null trm
.CG terminal "movddup" ssedp sse_avx
.SI double fmul lat(4)

.IL PSMV_LOW splnk xmm
Load value of single precision expression into register.
.AT other null trm
.CG terminal "movss" move

.IL PI4MV_LOW irlnk xmm
Move 4-byte integer into low half of xmm register.  Used to initialize an
invariant variable in the preheader of a loop.
.AT other null trm
.CG terminal "movd"

.IL MOVHLPS xmm xmm
Move high half of sp values from one xmm register into a low half of 2nd
xmm register.
.AT other null trm
.CG terminal "movhlps"

.IL MOVLHPS xmm xmm
Move low half of sp values from one xmm register into a high half of 2nd
xmm register.
.AT other null trm
.CG terminal "movlhps"

.IL UNPCKLPS xmm xmm
.AT other null trm
.CG terminal "unpcklps"

.IL UNPCKHPS xmm xmm
.AT other null trm
.CG terminal "unpckhps"

.IL UNPCKLPD xmm xmm
Copy low halves of each operand into the destination operand.
.AT other null trm
.CG terminal "unpcklpd" ssedp

.IL UNPCKHPD xmm xmm
Copy high halves of each operand into the destination operand.
.AT other null trm
.CG terminal "unpckhpd" ssedp

.IL UNPCKLDQ xmm xmm
Take the 2 low doublewords (of 4 bytes each) of each operand and
interleave them into the destination (i.e. second) operand.  Only used
in AILIs on x86-32, where it is generated from an IL_PI8MV_LOW ILI.
Not used on x86-64.
.AT other null trm
.CG CGonly "punpckldq" ssedp

.IL UNPCKLQDQ xmm xmm
Copy low halves of each operand into the destination operand.
Input register contain 8-byte integers.
.AT other null trm
.CG terminal "punpcklqdq" ssedp

.IL HADDPS xmm xmm
Horizontal add packed single.
.AT other null trm
.CG terminal "haddps" sse_avx

.IL HSUBPS xmm xmm
Horizontal subtract packed single.
.AT other null trm
.CG terminal "hsubps" sse_avx

.IL HADDPD xmm xmm
Horizontal add packed double.
.AT other null trm
.CG terminal "haddpd" ssedp sse_avx

.IL HSUBPD xmm xmm
Horizontal subtract packed double.
.AT other null trm
.CG terminal "hsubpd" ssedp sse_avx

.IL PSSHUF xmm xmm stc
Shuffle contents of xmm registers.  Used to move value in
least significant word into the 3 other words of a register:
xmm1 and xmm2 denote the (same) xmm register, and stc3 is the
immediate constant 0.
.AT other null trm
.CG terminal "shufps" asm_special

.IL PDSHUF xmm xmm stc
Shuffle contents of xmm registers.  Used to switch 2 d.p. values
in register.
.AT other null trm
.CG terminal "shufpd" asm_special ssedp


.IL PI4SHUF xmm xmm stc
Shuffle contents of xmm register containing 4-byte integers.
.AT other null trm
.CG terminal "pshufd" asm_special

.IL PTEST xmm xmm
This sets the ZF flag if the bitwise AND of all the bits in the xmm
register operands is 0, otherwise it clears the ZF flag, and it sets
the CF flag if the bitwise ANDN of all the bits in the operands is 0,
otherwise it clears the CF flag.  Due to the latter operation its
operands are not commutative.  It clears the AF, OF, PF and SF flags.
.AT other null ir
.CG "ptest" ccmod sse_avx asm_special


.IL PI4ADD arlnk xmm nme
.AT other comm trm ssenme
.CG terminal "paddd" sse_avx

.IL PI4SUBR arlnk xmm nme
Integer reverse-subtract.
.AT other null trm ssenme
.CG terminal "psubd" sse_avx

.IL PI4AND arlnk xmm nme
.AT other comm trm ssenme
.CG terminal "pand" sse_avx

.IL PI4ANDN arlnk xmm nme
.AT other null trm ssenme
.CG terminal "pandn" sse_avx

.IL PI4OR arlnk xmm nme
.AT other comm trm ssenme
.CG terminal "por" sse_avx

.IL PI4XOR arlnk xmm nme
.AT other comm trm ssenme
.CG terminal "pxor" sse_avx

.IL PI4MAX arlnk xmm nme
SSE4.1 packed signed dword integer maximum.
.AT other comm trm ssenme
.CG terminal "pmaxsd" sse_avx

.IL PI4MIN arlnk xmm nme
SSE4.1 packed signed dword integer minimum.
.AT other comm trm ssenme
.CG terminal "pminsd" sse_avx


.IL PI8ADD arlnk xmm nme
.AT other comm trm ssenme
.CG terminal "paddq" sse_avx

.IL PI8SUBR arlnk xmm nme
Integer reverse-subtract.
.AT other null trm ssenme
.CG terminal "psubq" sse_avx

.IL PI8AND arlnk xmm nme
.AT other comm trm ssenme
.CG terminal "pand" sse_avx

.IL PI8ANDN arlnk xmm nme
.AT other null trm ssenme
.CG terminal "pandn" sse_avx

.IL PI8OR arlnk xmm nme
.AT other comm trm ssenme
.CG terminal "por" sse_avx

.IL PI8XOR arlnk xmm nme
.AT other comm trm ssenme
.CG terminal "pxor" sse_avx


.IL PI4ADDX xmm xmm
.AT other comm trm
.CG terminal "paddd" sse_avx

.IL PI4SUBRX xmm xmm
Integer reverse-subtract.
.AT other null trm
.CG terminal "psubd" sse_avx

.IL PI4ANDX xmm xmm
.AT other comm trm
.CG terminal "pand" sse_avx

.IL PI4ANDNX xmm xmm
.AT other null trm
.CG terminal "pandn" sse_avx

.IL PI4ORX xmm xmm
.AT other comm trm
.CG terminal "por" sse_avx

.IL PI4XORX xmm xmm
.AT other comm trm
.CG terminal "pxor" sse_avx


.IL PI8ADDX xmm xmm
.AT other comm trm
.CG terminal "paddq" sse_avx

.IL PI8SUBRX xmm xmm
Integer reverse-subtract.
.AT other null trm
.CG terminal "psubq" sse_avx

.IL PI8ANDX xmm xmm
.AT other comm trm
.CG terminal "pand" sse_avx

.IL PI8ANDNX xmm xmm
.AT other null trm
.CG terminal "pandn" sse_avx

.IL PI8ORX xmm xmm
.AT other comm trm
.CG terminal "por" sse_avx

.IL PI8XORX xmm xmm
.AT other comm trm
.CG terminal "pxor" sse_avx


.IL PI4CMPX xmm xmm stc
Vector dword integer compare; stc is the compare code;
one of the instructions pcmpXXd is generated for this ili.
.AT other null trm
.CG terminal asm_special

.IL PI8CMPX xmm xmm stc
Vector qword integer compare; stc is the compare code;
one of the instructions pcmpXXq is generated for this ili.
.AT other null trm
.CG terminal asm_special

.IL PI4MAXX xmm xmm
SSE4.1 packed signed dword integer maximum.
.AT other comm trm
.CG terminal "pmaxsd" sse_avx

.IL PI4MINX xmm xmm
SSE4.1 packed signed dword integer minimum.
.AT other comm trm
.CG terminal "pminsd" sse_avx

.IL PUI4MAXX xmm xmm
SSE4.1 packed unsigned dword integer maximum.
.AT other comm trm
.CG terminal "pmaxud"

.IL PUI4MINX xmm xmm
SSE4.1 packed unsigned dword integer minimum.
.AT other comm trm
.CG terminal "pminud"

.IL PUI4MAX arlnk xmm nme
SSE4.1 packed unsigned dword integer maximum.
.AT other comm trm ssenme
.CG terminal "pmaxud"

.IL PUI4MIN arlnk xmm nme
SSE4.1 packed unsigned dword integer minimum.
.AT other comm trm ssenme
.CG terminal "pminud"

.IL PSADD arlnk xmm nme
Perform 4 single-precision floating-point adds of the 4 values
in the 16-byte aligned memory location denoted by arlnk, and
the 4 values in the xmm register denoted by xmm.
The results are placed in xmm register 'xmm'.
.AT other comm trm ssenme
.CG terminal "addps" sse_avx

.IL PSSUBR arlnk xmm nme
Reverse subtract: computes 'xmm' - 'arlnk', result placed in the
xmm register denoted by 'xmm'.
.AT other null trm ssenme
.CG terminal "subps" sse_avx

.IL PSMUL arlnk xmm nme
Multiply contents of memory and 16-byte xmm register.
.AT other comm trm ssenme
.CG terminal "mulps" sse_avx

.IL PSDIVR arlnk xmm nme
Reverse divide: op2/op1 -> op2.
.AT other null trm ssenme
.CG terminal "divps" sse_avx

.IL PSAND arlnk xmm nme
Bitwise AND operation on s.p. values - used to implement absolute value.
.AT other comm trm ssenme
.CG terminal "andps" sse_avx

.IL PSXOR arlnk xmm nme
Bitwise XOR operation on s.p. values.
.AT other comm trm ssenme
.CG terminal "xorps" sse_avx

.IL PSMAX arlnk xmm nme
Single-precision packed maximum.
.AT other comm trm ssenme
.CG terminal "maxps" sse_avx

.IL PSMIN arlnk xmm nme
Single-precison packed minimum.
.AT other comm trm ssenme
.CG terminal "minps" sse_avx

.IL PSSQRT arlnk xmm nme
Compute square root of 4 s.p. values in memory and put result into
xmm register denoted by xmm.
.AT other null trm ssenme
.CG terminal "sqrtps" sse_avx

.IL RCPPS arlnk xmm nme
Compute single-precision approximations to reciprocal.
.AT other null trm ssenme
.CG terminal "rcpps" sse_avx

.IL RSQRTPS arlnk xmm nme
Compute single-precision approximations to reciprocal square root.
.AT other null trm ssenme
.CG terminal "rsqrtps" sse_avx

.IL CMPNEQPS arlnk xmm nme
Used for single-precision sqrt approximation.
.AT other null trm ssenme
.CG terminal "cmpneqps" sse_avx

.IL PSADDX xmm xmm
Perform 4 single-precision floating point additions of the 4
values in xmm register xmm1 and the 4 values in register xmm2.
The results are placed in register xmm2.
.AT other comm trm
.CG terminal "addps" sse_avx

.IL PSSUBRX xmm xmm
Reverse-subtract contents of two 16-byte xmm registers.
.AT other null trm
.CG terminal "subps" sse_avx

.IL PSMULX xmm xmm
Multiply contents of two 16-byte xmm registers.
.AT other comm trm
.CG terminal "mulps" sse_avx

.IL PSDIVRX xmm xmm
Reverse-divide contents of two 16-byte xmm registers.
.AT other null trm
.CG terminal "divps" sse_avx

.IL PSANDX xmm xmm
Bitwise AND operation on s.p. values - used to implement absolute value.
.AT other comm trm
.CG terminal "andps" sse_avx

.IL PSANDNX xmm xmm
Bitwise ANDNOT operation on s.p. values.
.AT other null trm
.CG terminal "andnps" sse_avx

.IL PSORX xmm xmm
Bitwise OR operation on s.p. values.
.AT other comm trm
.CG terminal "orps" sse_avx

.IL PSXORX xmm xmm
Compute bitwise exclusive-OR of two xmm registers and place result
in second register.
.AT other comm trm
.CG terminal "xorps" sse_avx

.IL PSMAXX xmm xmm
Single precision packed maximum.
.AT other comm trm
.CG terminal "maxps" sse_avx

.IL PSMINX xmm xmm
Single precision packed minimum.
.AT other comm trm
.CG terminal "minps" sse_avx

.IL PSSQRTX xmm xmm
Compute square root of 4 s.p. values in 1st xmm register and put result into
2nd xmm register.
.AT other null trm
.CG terminal "sqrtps" sse_avx

.IL RCPPSX xmm xmm
Compute single-precision approximations to reciprocal.
.AT other null trm
.CG terminal "rcpps" sse_avx

.IL RSQRTPSX xmm xmm
Compute single-precision approximations to reciprocal square root.
.AT other null trm
.CG terminal "rsqrtps" sse_avx

.IL CMPNEQPSX xmm xmm
Used for single-precision square root approximation.
.AT other null trm
.CG terminal "cmpneqps" sse_avx

.IL PSCMPX xmm xmm stc
Vector compare of single precision values.  'stc' is comparison code.
One of the instructions cmpXXps is generated for this ili.
.AT other null trm
.CG terminal asm_special

.IL PDADD arlnk xmm nme
Perform 2 double-precision floating-point adds of the 2 values
in the 16-byte aligned memory location denoted by arlnk, and
the 2 values in the xmm register denoted by xmm.
The results are placed in xmm register 'xmm'.
.AT other comm trm ssenme
.CG terminal "addpd" ssedp sse_avx

.IL PDSUBR arlnk xmm nme
Reverse subtract: computes 'xmm' - 'arlnk', result placed in the
xmm register denoted by 'xmm'.
.AT other null trm ssenme
.CG terminal "subpd" ssedp sse_avx

.IL PDMUL arlnk xmm nme
Multiply contents of memory and 16-byte xmm register.
.AT other comm trm ssenme
.CG terminal "mulpd" ssedp sse_avx

.IL PDDIVR arlnk xmm nme
Reverse divide: op2/op1 -> op2.
.AT other null trm ssenme
.CG terminal "divpd" ssedp sse_avx

.IL PDAND arlnk xmm nme
Bitwise AND operation on d.p. values - used to implement absolute value.
.AT other comm trm ssenme
.CG terminal "andpd" ssedp sse_avx

.IL PDXOR arlnk xmm nme
Bitwise XOR operation on d.p. values.
.AT other comm trm ssenme
.CG terminal "xorpd" ssedp sse_avx

.IL PDMAX arlnk xmm nme
Double precision packed maximum.
.AT other comm trm ssenme
.CG terminal "maxpd" ssedp sse_avx

.IL PDMIN arlnk xmm nme
Double precision packed minimum.
.AT other comm trm ssenme
.CG terminal "minpd" ssedp sse_avx

.IL PDSQRT arlnk xmm nme
Compute square root of 2 d.p. values in memory and put result into
xmm register denoted by xmm.
.AT other null trm ssenme
.CG terminal "sqrtpd" ssedp sse_avx

.IL PDADDX xmm xmm
Perform 2 double-precision floating point additions of the 2
values in xmm register xmm1 and the 2 values in register xmm2.
The results are placed in register xmm2.
.AT other comm trm
.CG terminal "addpd" ssedp sse_avx

.IL PDSUBRX xmm xmm
Reverse-subtract contents of two 16-byte xmm registers.
.AT other null trm
.CG terminal "subpd" ssedp sse_avx

.IL PSADDSUBX xmm xmm
Perform single-precision floating point additions of the 2
values in xmm register xmm1 and the 2 values in register xmm2.
The results are placed in register xmm2.
.AT other null trm
.CG terminal "addsubps"  sse_avx
.SI double fadd lat(5:7)

.IL PDADDSUBX xmm xmm
Perform double-precision floating point additions of the 2
values in xmm register xmm1 and the 2 values in register xmm2.
The results are placed in register xmm2.
.AT other null trm
.CG terminal "addsubpd" ssedp sse_avx
.SI double fadd lat(5:7)

.IL MOVSHDUPX xmm
Move packed single precision and duplicate high.  Used to get imaginary part of single complex.
Source can be memory.
.AT other null trm
.CG terminal "movshdup" ssedp sse_avx

.IL MOVSLDUPX xmm
Move packed single precision and duplicate low.  Can be used to get real part of single complex.
Source can be memory.
.AT other null trm
.CG terminal "movsldup" ssedp sse_avx

.IL PDMULX xmm xmm
Multiply contents of two 16-byte xmm registers.
.AT other comm trm
.CG terminal "mulpd" ssedp sse_avx

.IL PDDIVRX xmm xmm
Reverse-divide contents of two 16-byte xmm registers.
.AT other null trm
.CG terminal "divpd" ssedp sse_avx

.IL PDANDX xmm xmm
Bitwise AND operation on d.p. values - used to implement absolute value.
.AT other comm trm
.CG terminal "andpd" ssedp sse_avx

.IL PDANDNX xmm xmm
Bitwise ANDNOT operation on d.p. values.
.AT other null trm
.CG terminal "andnpd" ssedp sse_avx

.IL PDORX xmm xmm
Bitwise OR operation on d.p. values.
.AT other comm trm
.CG terminal "orpd" ssedp sse_avx

.IL PDXORX xmm xmm
Compute bitwise exclusive-OR of two xmm registers and place result
in second register.
.AT other comm trm
.CG terminal "xorpd" ssedp sse_avx

.IL PDMAXX xmm xmm
Double precision packed maximum.
.AT other comm trm
.CG terminal "maxpd" ssedp sse_avx

.IL PDMINX xmm xmm
Double precision packed minimum.
.AT other comm trm
.CG terminal "minpd" ssedp sse_avx

.IL PDSQRTX xmm xmm
Compute square root of 2 d.p. values in 1st xmm register and put result into
2nd xmm register.
.AT other null trm
.CG terminal "sqrtpd" ssedp sse_avx

.IL PDCMPX xmm xmm stc
Vector compare of double precision values.  'stc' is comparison code.
One of the instructions cmpXXpd is generated for this ili.
.AT other null trm
.CG terminal asm_special ssedp

.IL PSLLSH irlnk xmm
Shift packed 4-byte integers left.
.AT other null trm
.CG terminal "pslld"

.IL PSRLSH irlnk xmm
Shift packed 4-byte integers logical right (zero fill).
.AT other null trm
.CG terminal "psrld"

.IL PSRASH irlnk xmm
Shift packed 4-byte integers arithmetically right (sign extend).
.AT other null trm
.CG terminal "psrad"

.IL PDLLSH irlnk xmm
Shift packed 8-byte integers left.
.AT other null trm
.CG terminal "psllq" ssedp

.IL PDRLSH irlnk xmm
Shift packed 8-byte integers logical right (zero fill).
.AT other null trm
.CG terminal "psrlq" ssedp

.IL PDRASH irlnk xmm
Shift packed 8-byte integers arithmetically right (sign extend).
NO SUCH INSTRUCTION.
.AT other null trm
.CG notCG terminal "psraq" ssedp

.IL PBBLENDX xmm xmm xmm
SSE4.1 Variable Blend Packed Bytes
.AT other null trm
.CG terminal "pblendvb" asm_special

.IL PSBLENDX xmm xmm xmm
SSE4.1 Variable Blend Packed Single Precision Floating-Point Values
.AT other null trm
.CG terminal "blendvps" asm_special

.IL PDBLENDX xmm xmm xmm
SSE4.1 Variable Blend Packed Double Precision Floating-Point Values
.AT other null trm
.CG terminal "blendvpd" asm_special ssedp

.IL PBBLEND arlnk xmm nme xmm
SSE4.1 Variable Blend Packed Bytes
.AT other null trm ssenme
.CG terminal "pblendvb" asm_special

.IL PSBLEND arlnk xmm nme xmm
SSE4.1 Variable Blend Packed Single Precision Floating-Point Values
.AT other null trm ssenme
.CG terminal "blendvps" asm_special

.IL PDBLEND arlnk xmm nme xmm
SSE4.1 Variable Blend Packed Double Precision Floating-Point Values
.AT other null trm ssenme
.CG terminal "blendvpd" asm_special ssedp

.\"
.\" Start of AVX-only ILIs.
.\"

.IL VFEXTRACT128X xmm xmm stc
An AVX-only ILI.  Extract 128 bits of packed floating-point values
from xmm1 (a ymm register) at an offset determined by stc (0 = bits
0:127 of xmm1, 1 = bits 128:255 of xmm1), and store the result in xmm2
(an xmm register).
.AT other null trm
.CG terminal "vextractf128" avx_only asm_special

.IL VFINSERT128X xmm xmm xmm stc
Insert 128-bits of packed floatingpoint values from xmm1 and
the remaining values from xmm2(ymm register) into xmm3(ymm register)
.AT other null trm
.CG terminal "vinsertf128" avx_only asm_special

.\"
.\" End of AVX-only ILIs.
.\"

.\"BT.IL PSMACC arlnk xmm nme xmm
.\"BTRepresents one of the 8 packed single-precision FMACC instructions.
.\"BTThe type of instruction is specified by immediately preceding MACCTYPE
.\"BTili (due to limited number of ili operands).
.\"BT.AT other null trm ssenme
.\"BT.CG terminal asm_special
.\"BT
.\"BT.IL PSMACCX xmm xmm xmm stc
.\"BTRepresents one of the 8 packed single-precision FMACC instructions.
.\"BTThe last operand, 'stc' specifies which of the 8 instructions to
.\"BTuse.  It's value is created using the FMACC_ macros defined in ili.h.
.\"BT.AT other null trm
.\"BT.CG terminal asm_special
.\"BT
.\"BT.IL PDMACC arlnk xmm nme xmm
.\"BTRepresents one of the 8 packed double-precision FMACC instructions.
.\"BTThe type of instruction is specified by immediately preceding MACCTYPE
.\"BTili (due to limited number of ili operands).
.\"BT.AT other null trm ssenme
.\"BT.CG terminal asm_special ssedp
.\"BT
.\"BT.IL PDMACCX xmm xmm xmm stc
.\"BTRepresents one of the 8 packed double-precision FMACC instructions.
.\"BTThe last operand, 'stc' specifies which of the 8 instructions to
.\"BTuse.  It's value is created using the FMACC_ macros defined in ili.h.
.\"BT.AT other null trm
.\"BT.CG terminal asm_special ssedp
.\"BT
.\"BT.IL MACCTYPE stc
.\"BTUsed to specify type of immediately following PSMACC or PDMACC instruction.
.\"BTstc is created using the FMACC_ macros defined in ili.h.
.\"BT.AT other null trm
.\"BT.CG terminal notAILI
.\"BT

.IL PDFMA arlnk xmm nme xmm
A packed double-precision FMA3 or FMA4 instruction which computes:
    dest = <sign> (src1 * src2) <addop> src3
where:
    arlink = src2 or src3
    xmm1   = src1
    xmm2   = ((arlnk == src2) ? src3 : src2)
.br
Since ILIs have a maximum of 4 operands this ILI is always immediately
preceded by an FMATYPE ILI which provides other information about the
FMA instruction, namely (i) flags to specify the values of <sign>
(+/-) and <addop> (+/-), and to indicate whether 'arlnk' corresponds
to 'src2' or 'src3', and (ii) the 'dest' operand.
.AT other null trm ssenme
.CG terminal asm_special ssedp

.IL PDFMAX xmm xmm xmm xmm
A packed double-precision FMA3 or FMA4 instruction which computes:
	dest = <sign> (src1 * src2) <addop> src3
where:
	xmm1 = src1
	xmm2 = src2
	xmm3 = src3
	xmm4 = dest
.br
Note, for FMA3 'dest' must be the same as one of the source operands.
.br
Since ILIs have a maximum of 4 operands this ILI is always immediately
preceded by an FMATYPE ILI which specifies the values of <sign> (+/-)
and <addop> (+/-).
.AT other null trm
.CG terminal asm_special ssedp

.IL PSFMA arlnk xmm nme xmm
This is the same as PDFMA except that it specifies a packed single
precision FMA3 or FMA4 instruction.
.AT other null trm ssenme
.CG terminal asm_special

.IL PSFMAX xmm xmm xmm xmm
This is the same as PDFMAX except that it specifies a packed single
precision FMA3 or FMA4 instruction.
.AT other null trm
.CG terminal asm_special

.IL FMATYPE stc xmm
This provides extra information about the immediately following PDFMA,
PDFMAX, PSFMA or PSFMAX ILI.  Its operands are:
.br
stc = a set of flags which specify the values of <sign> (+/-) and
      <addop> (+/-), and for PDFMA and PSFMA, whether arlnk is src2 or
      src3.  The flags are defined by 'FMA_...' macros in "ili.h".
.br
xmm = the 'dest' operand for PDFMA or PSFMA, or 0 for PDFMAX and PSFMAX.
      For FMA3 'dest' must be the same as one of the source operands,
      i.e. one of the xmm operands in the PDFMA or PSFMA ILI.
.AT other null trm
.CG terminal notAILI

.IL CLTD
Used with signed integer divide/mod instruction.
.AT other null ir
.CG CGonly "cltd" ccmod asm_special

.IL CQTO
Not used by X86_32 compiler
.AT other null kr
.CG notCG notAILI

.IL CMOV
Conditionally copy op2 into op1 based on condition codes.
.AT load null ir
.CG CGonly asm_special "cmov"

.IL CMOVSP
Single precision conditional move.  Expanded by the CG.
.AT load null sp
.CG CGonly asm_special "movss"

.IL CMOVDP
Double precision conditional move.  Expanded by the CG.
.AT load null dp
.CG CGonly asm_special "movsd"

.IL CMOVSCMPLX
Single precision complex conditional move.  Expanded by the CG.
.AT load null cs
.CG CGonly asm_special "movsd"

.IL CMOVDCMPLX
Double precision complex conditional move.  Expanded by the CG.
.AT load null cd
.CG CGonly asm_special "movupd"

.IL CMOVLPD
Same as CMOVDP, but used when "movlpd" is preferred.
.AT load null dp
.CG CGonly asm_special "movlpd"

.IL CSETB
Conditional set of a byte
.AT store null ir
.CG CGonly asm_special "set"
.SI ld direct lat(4)
.SI direct lat(1)

.IL INC
Increment integer register or memory operand.
.AT arth null ir cse
.CG CGonly ccarith "inc"

.IL DEC
Decrement integer register or memory operand.
.AT arth null ir cse
.CG CGonly ccarith "dec"

.IL LEA irlnk stc
32-bit load effective address instruction.  This only appears in the
linear and attributed ILIs, not the shared ILIs.  The LILI is created
by 'cglinear.c:optimize_imul()', in which case 'irlnk' is used as both
the base and index register, and 'stc' is the shift count, which may
be 1, 2, 4 or 8.  The AILI may be generated from a LEA LILI or it may
be created by a peephole optimisation.
.AT arth null ir cse
.CG CGonly "lea" 'l'

.IL KLEA krlnk stc
Used by the 64-bit compiler only.
.AT arth null kr cse
.CG notCG

.IL MOV
Synonym for LD and ST, and register to register moves.
.AT move null ir cse
.CG CGonly "mov" move

.IL MOVABS
Not used by X86_32 compiler
.AT move null ir cse
.CG notCG notAILI

.IL BIH stc stc
Created by the code generator to represent, in the linear ili and the AILI,
the beginning of a basic block.  The first operand is the bih number, and
the second is the label symbol table pointer, if any.
.AT other null trm dom
.CG CGonly terminal asm_nop

.IL DEF
Placed into the AILI to indicate the definition of a register which is
otherwise not explicitly defined (by appearing in the 'dest' field of
some aili).  The register allocators need this information in certain
cases.
.AT other null trm
.CG CGonly asm_nop

.IL USE
Placed into the AILI to indicate the use of a register which is otherwise
not explicitly used.  The register allocators need to know this in order
to avoid a conflicting register allocation, etc.
.AT other null trm
.CG CGonly asm_nop

.IL STACK_ADJ
Placed into the AILI to indicate that the stack pointer has been
modified by the value specified in the src1 field of the aili.
No code is generated for this ili.
.AT other null trm
.CG CGonly asm_special

.IL ALLOC krlnk
Allocate memory for a C or C++ variable length array.
'krlnk' is the size.  Result is the address of the allocated memory.
.AT arth null ar
.CG notCG

.IL DEALLOC arlnk
Deallocate memory that was allocated by ALLOC.
'arlnk' is the memory address.
.AT other null trm
.CG notCG

.IL ALLOCA krlnk
Allocate memory with alloca
'krlnk' is the size.  Result is the address of the allocated memory.
.AT arth null ar
.CG notCG

.IL CFA arlnk nme
Materialize the outer call frame address as a builtin.  This is
placed into a load address register from a memory location whose address
is represented by op1.
.AT other null ar cse
.CG 'l' asm_special

.IL EHRET arlnk nme
Materialize the return address of the caller as a builtin.  This is
placed into a load address register from a memory location whose address
is represented by op1.
.AT other null ar cse
.CG 'l' asm_special

.IL EHREGS
Materialize the return address of the caller as a builtin.  This is
placed into a load address register from a memory location whose address
is represented by op1.
.AT other null trm
.CG terminal asm_special

.IL EHREGST sym sym
Store implicit registers into the syms: catch_clause and caught_object 
.AT other null trm 
.CG asm_special terminal

.IL EHREGLD sym sym
Materialize the syms: catch_clause and caught_object into the two symbols
from implicit registers
.AT other null trm 
.CG asm_special terminal

.IL EHRESUME sym sym
Resume propagation of an existing in-flight exception whose unwinding was
interrupted to run some cleanup code.
.AT other null trm
.CG asm_special terminal

.IL ACCEL lnk
Start a block of code to be targeted for accelerator
.AT other null trm
.CG notCG

.IL ENDACCEL lnk
End a block of code to be targeted for accelerator
.AT other null trm
.CG notCG

.IL ACCKERNELS lnk
Start a block of kernels to be targeted for accelerator
.AT other null trm
.CG notCG

.IL ACCENDKERNELS lnk
End a block of kernels to be targeted for accelerator
.AT other null trm
.CG notCG

.IL ACCPAR lnk
Start a block of parallel code to be targeted for accelerator
.AT other null trm
.CG notCG

.IL ACCENDPAR lnk
End a block of parallel code to be targeted for accelerator
.AT other null trm
.CG notCG

.IL ACCSCALARREG lnk
Start a block of code to run as a scalar kernel on the accelerator
.AT other null trm
.CG notCG

.IL ACCENDSCALARREG
End a block of code to run as a scalar kernel on the accelerator
.AT other null trm
.CG notCG

.IL ACCSERIAL lnk
Start a block of code to run as a serial kernel on the accelerator
.AT other null trm
.CG notCG

.IL ACCENDSERIAL
End a block of code to run as a serial kernel on the accelerator
.AT other null trm
.CG notCG

.IL ACCELLP lnk
The following loop is to be targeted for the accelerator
.AT other null trm
.CG notCG

.IL ACCSLOOP lnk stc
The following loop in a serial region is to be targeted for the accelerator
The second operand is one when this loop is tightly nested in the compute construct, and zero otherwise;
.AT other null trm
.CG notCG

.IL ACCKLOOP lnk stc
The following loop in a kernels region is to be targeted for the accelerator
The second operand is one when this loop is tightly nested in the compute construct, and zero otherwise;
.AT other null trm
.CG notCG

.IL ACCPLOOP lnk stc
The following loop in a parallel region is to be targeted for the accelerator
The second operand is one when this loop is tightly nested in the compute construct, and zero otherwise;
.AT other null trm
.CG notCG

.IL ACCATTACH lnk lnk lnk sym
Attach the pointer/allocatable member in an aggregate structure data variable
.AT other null lnk
.CG notCG

.IL ACCDETACH lnk lnk lnk sym
Detach the pointer/allocatable member in an aggregate structure data variable
.AT other null lnk
.CG notCG

.IL ACCCOPY lnk lnk lnk sym stc
Variable or array will be copied from host to device and back
.AT other null lnk
.CG notCG

.IL ACCCOPYIN lnk lnk lnk sym stc
Variable or array will be copied from host to device
.AT other null lnk
.CG notCG

.IL ACCCOPYOUT lnk lnk lnk sym stc
Variable or array will be copied from device to host
.AT other null lnk
.CG notCG

.IL ACCLOCAL lnk lnk lnk sym stc
Variable or array will be allocated on the device but not copied
to or from the host
.AT other null lnk
.CG notCG

.IL ACCCREATE lnk lnk lnk sym stc
Variable or array will be allocated on the device but not copied
to or from the host
.AT other null lnk
.CG notCG


.IL ACCDELETE lnk lnk lnk sym stc
Variable or array will be deleted from the device but not copied
to or from the host
.AT other null lnk
.CG notCG

.IL ACCPDELETE lnk lnk lnk sym stc
Variable or array will be deleted from the device but not copied, unless in a data region
to or from the host
.AT other null lnk
.CG notCG

.IL ACCPRESENT lnk lnk lnk sym stc
Variable or array must be present on the device
.AT other null lnk
.CG notCG

.IL ACCPCOPY lnk lnk lnk sym stc
Variable or array may be present on the device, but if not will be copied
.AT other null lnk
.CG notCG

.IL ACCPCOPYIN lnk lnk lnk sym stc
Variable or array may be present on the device, but if not will be copied in
.AT other null lnk
.CG notCG

.IL ACCPCOPYOUT lnk lnk lnk sym stc
Variable or array may be present on the device, but if not will be copied out
.AT other null lnk
.CG notCG

.IL ACCPCREATE lnk lnk lnk sym stc
Variable or array may be present on the device, but if not will be allocated,
but not copied
.AT other null lnk
.CG notCG

.IL ACCPNOT lnk lnk lnk sym stc
Variable or array may be present on the device, but if not will NOT be allocated
nor copied.
First link is to next clause.
Second link is to the array bounds.
Third link is to ACCSYMLNK.
Fourth argument is the symbol that points to the device copy, if there is such
a symbol.
Fifth arg is the policy index 
.AT other null lnk
.CG notCG

.IL ACCNO_CREATE lnk lnk lnk sym stc
Variable or array may be present on the device, but if not will NOT be allocated
nor copied.
First link is to next clause.
Second link is to the array bounds.
Third link is to ACCSYMLNK.
Fourth argument is the symbol that points to the device copy, if there is such
a symbol.
Fifth arg is the policy index 
.AT other null lnk
.CG notCG

.IL ACCUPDATEHOST lnk lnk lnk stc
Variable or array will be copied from device back to host.
First link is to next clause.
Second link is to the array bounds.
Third link is to ACCSYMLNK.
Fourth arg is the policy index 
.AT other null lnk
.CG notCG

.IL ACCUPDATESELF lnk lnk lnk stc
Variable or array will be copied from device back to the current thread.
First link is to next clause.
Second link is to the array bounds.
Third link is to ACCSYMLNK.
Fourth arg is the policy index 
.AT other null lnk
.CG notCG

.IL ACCUPDATEDEV lnk lnk lnk stc
Variable or array will be copied from host to device.
First link is to next clause.
Second link is to the array bounds.
Third link is to ACCSYMLNK.
Fourth arg is the policy index 
.AT other null lnk
.CG notCG

.IL ACCUPDATEHOSTIFP lnk lnk lnk stc
Variable or array will be copied from device back to host, if present.
First link is to next clause.
Second link is to the array bounds.
Third link is to ACCSYMLNK.
Fourth arg is the policy index 
.AT other null lnk
.CG notCG

.IL ACCUPDATESELFIFP lnk lnk lnk stc
Variable or array will be copied from device back to the current thread, if present.
First link is to next clause.
Second link is to the array bounds.
Third link is to ACCSYMLNK.
Fourth arg is the policy index 
.AT other null lnk
.CG notCG

.IL ACCUPDATEDEVIFP lnk lnk lnk stc
Variable or array will be copied from host to device, if present.
First link is to next clause.
Second link is to the array bounds.
Third link is to ACCSYMLNK.
Fourth arg is the policy index 
.AT other null lnk
.CG notCG

.IL ACCUPDATE lnk
Head of a list of update clauses
.AT other null trm
.CG notCG

.IL ACCCOMP lnk
Head of a list of compare clauses.
.AT other null trm
.CG notCG

.IL ACCCOMPARE lnk lnk lnk stc
Variable or array will be copied from device back to host.
First link is to next clause.
Second link is to the array bounds.
Third link is to ACCSYMLNK.
Fourth arg is the policy index
.AT other null lnk
.CG notCG

.IL PGICOMPARE lnk lnk lnk stc
Variable or array will be copied from device back to host.
First link is to next clause.
Second link is to the array bounds.
Third link is to ACCSYMLNK.
Fourth arg is the policy index
.AT other null lnk
.CG notCG

.IL ACCPRIVATE lnk lnk lnk
Variable or array is private to an iteration of the loop or to a worker
.AT other null lnk
.CG notCG

.IL ACCFIRSTPRIV lnk lnk lnk
Variable or array is private to the workers, but initialize with values from the host
.AT other null lnk
.CG notCG

.IL ACCCACHE lnk lnk lnk
The compiler should move the array to the highest level of the
software-managed cache
.AT other null lnk
.CG notCG

.IL ACCDEVICEPTR lnk lnk lnk sym stc
Variable or array will be copied from device to host
.AT other null lnk
.CG notCG

.IL ACCAUTO lnk stc
The execution mode will be selected by the compiler (gang/worker/vector/seq)
First link is to next clause.
Last argument is the device_type argument.
.AT other null lnk
.CG notCG


.IL ACCVECTOR lnk lnk stc
The iterations of the loop will be executed in vector mode on the accelerator
.AT other null lnk
.CG notCG

.IL ACCPARALLEL lnk lnk stc
The iterations of the loop will be executed in parallel on the accelerator
.AT other null lnk
.CG notCG

.IL ACCGANG lnk lnk stc stc
The iterations of the loop will be executed in across gangs on the accelerator.
First argument is the link to the next clause.
Second argument is the number of gangs.
Third argument is the device_type argument.
Fourth argument is the dimension, where the default is dimension zero (cuda X dimension).
.AT other null lnk
.CG notCG

.IL ACCGANGCHUNK lnk lnk stc
The gang static-scheduling chunk size.
First argument is the link to the next clause.
Second argument is the chunk size.
Last argument is the device_type argument.
.AT other null lnk
.CG notCG

.IL ACCWORKER lnk lnk stc
The iterations of the loop will be executed in across workers on the accelerator
.AT other null lnk
.CG notCG

.IL ACCSEQ lnk lnk stc
The iterations of the loop will be executed sequentially on the accelerator
.AT other null lnk
.CG notCG

.IL ACCHOST lnk lnk stc
The iterations of the loop will be executed on the host
.AT other null lnk
.CG notCG

.IL ACCSHORTLOOP lnk stc
Trip count is less than the maximum size of a vector operation
(for vector schedule) or less than the maximum number of
simultaneously active parallel iterations (for parallel schedule)
.AT other null lnk
.CG notCG


.IL ACCTILE lnk lnk stc stc
Tile this loop.
First link is to the next clause.
Second link is to a list of ACCSIZE ILI.
Third argument is the tile depth.
Last argument is the device_type argument.
.AT other null lnk
.CG notCG

.IL ACCSIZE lnk lnk
A size expression.
The first link is to the next size expression, if any, or to NULL.
The second link is the expression, if any, or to NULL.
.AT other null lnk
.CG notCG

.IL ACCINDEPENDENT lnk
The iterations of the loop are data-independent
.AT other null lnk
.CG notCG

.IL ACCNUMGANGS lnk lnk stc stc
How many gangs to instantiate
First link is the link to the next clause.
Second argument is the number of gangs.
Third argument is the device_type argument.
Fourth argument is the dimension, where the default is dimension zero (cuda X dimension).
.AT other null lnk
.CG notCG

.IL ACCNUMWORKERS lnk lnk stc
How many workers to instantiate
.AT other null lnk
.CG notCG

.IL ACCVLENGTH lnk lnk stc
How long a vector to instantiate
.AT other null lnk
.CG notCG

.IL ACCIF lnk lnk
Region will execute conditionally on host or accelerator.
.AT other null lnk
.CG notCG

.IL ACCDEVID lnk lnk stc
Device ID of the device to use for this directive or construct.
.AT other null lnk
.CG notCG

.IL ACCUNROLL lnk lnk stc stc
Control loop unrolling; the 3rd element tells whether it's the parallel, vector, or sequential loop to be unrolled
.AT other null lnk
.CG notCG

.IL ACCKERNEL lnk
.AT other null lnk
.CG notCG

.IL ACCTRIPLE lnk lnk lnk lnk
Specify bounds of sub-arrays in accelerator clauses.
.AT other null lnk
.CG notCG

.IL ACCDATAREG lnk
Generate data movement to/from accelerator
.AT other null trm
.CG notCG

.IL ACCENTERDATA lnk
Generate data movement at enter data directive
.AT other null trm
.CG notCG

.IL ACCEXITDATA lnk
Generate data movement at exit data directive
.AT other null trm
.CG notCG

.IL ACCFINALEXITDATA lnk
Generate data movement at exit data directive with finalize clause.
Link to list of arguments.
.AT other null trm
.CG notCG

.IL ACCENDDATAREG
Generate matching data movement to/from accelerator
.AT other null trm
.CG notCG

.IL ACCPHI lnk stc stc
PHI operator used in accelerator optimizing code generator.
Link points to ACCPHILINK, and the 2nd operand is a symbol numbering.
3rd operand is nonzero for loop header phi
.AT other null trm
.CG notCG notAILI accel

.IL ACCLHPHI lnk stc
PHI operator for loop headers used in accelerator optimizing code generator.
Link points to ACCPHILINK, and the 2nd operand is a symbol numbering.
.AT other null trm
.CG notCG notAILI accel

.IL ACCPHILINK lnk lnk
PHI operator for loop headers used in accelerator optimizing code generator.
First link is to next PHILINK, 2nd link is the chain to the reaching def.
.AT other null lnk
.CG notCG notAILI accel

.IL ACCINIT
Dummy initial value for factored use-def chains.
First link is to next PHILINK, 2nd link is the chain to the reaching def.
.AT other null trm
.CG notCG notAILI accel


.IL ACCVAR stc
Used in accelerator optimizing code generator, a builtin variable ref.
.AT other null lnk
.CG notCG notAILI accel

.IL ACCLDSYM stc stc
Used in accelerator optimizing code generator, a load of a temp variable
.AT other null lnk
.CG notCG notAILI accel

.IL ACCSTSYM lnk stc stc
Used in accelerator optimizing code generator, a load of a temp variable
.AT other null trm
.CG notCG notAILI accel

.IL ACCIVAL stc stc
Used in accelerator optimizing code generator, a literal constant;
uses two operands to hold an ISZ_T value.
.AT other null lnk
.CG notCG notAILI accel

.IL ACCJSR stc lnk
Used in accelerator optimizing code generator, special routine call
.AT other null lnk
.CG notCG notAILI accel

.IL ACCRETURN stc lnk
Used in accelerator optimizing code generator, return value from a function call
Short constant holds the return datatype.
.AT other null lnk
.CG notCG notAILI accel

.IL ACCLOR lnk lnk
Used in accelerator optimizing code generator, logical OR
.AT other null lnk
.CG notCG notAILI accel

.IL ACCCAST lnk stc
Used in accelerator optimizing code generator, type casting
.AT other null lnk
.CG notCG notAILI accel

.IL ACCJMP lnk sym
Used in accelerator optimizing code generator, conditional jump
The 'sym' is a normally an ACBLK index.  During linearization, the 'stc' will
be a symbol index if positive and an ACBLK index negated if negative, until
'acc_replace_labels'.
.AT branch null lnk
.CG notCG notAILI accel

.IL ACCARG lnk lnk
Used in accelerator optimizing code generator, argument list
.AT other null lnk
.CG notCG notAILI accel

.IL ACCBOUND lnk lnk stc stc
Used in accelerator optimizing code generator, array bounds check.
Fields are subscript expression, ACCBOUND2, line number, array symbol
.AT other null lnk
.CG notCG notAILI accel

.IL ACCBOUND2 lnk lnk stc
Used in accelerator optimizing code generator, array bounds check.
Fields are lower bound, upper bound, subscript number.
.AT other null lnk
.CG notCG notAILI accel

.IL ACCWAIT lnk stc
Used in accelerator code, wait on the host for each kernel to finish
.AT other null lnk
.CG notCG notAILI

.IL ACCNOWAIT lnk
Used in accelerator code, don't wait on the host for each kernel to finish
.AT other null lnk
.CG notCG notAILI

.IL ACCASYNC lnk lnk stc
Used in accelerator code, perform this activity asynchronously
.AT other null lnk
.CG notCG notAILI

.IL ACCWAITDIR lnk
Used in accelerator code, wait on the host for async activities to finish
.AT other null trm
.CG notCG notAILI

.IL ACCWAITARG lnk lnk stc
Used in accelerator code, wait on the host for async activities to finish
.AT other null lnk
.CG notCG notAILI

.IL ACCLOOP lnk stc sym
Used in accelerator code, to generate an explicit 'vector' loop.
The first argument is the trip count, the second is an accelerator symbol number of the loop variable.
The third argument is the label of the exit branch.
.AT branch null trm
.CG notCG notAILI accel

.IL ACCENDLOOP sym
Used in accelerator code, to end an explicit 'vector' loop.
The argument is the label of the top of the loop.
.AT branch null trm
.CG notCG notAILI accel

.IL KERNEL lnk
Start a nest of loops to be turned into CUDA kernels
.AT other null trm
.CG notCG

.IL ENDKERNEL lnk
End a nest of loops to be turned into CUDA kernels
.AT other null trm
.CG notCG

.IL KERNELBLOCK lnk lnk stc
Block size for one kernel loop.
The constant is the loop nest level.
.AT other null trm
.CG notCG

.IL KERNELGRID lnk lnk stc
Grid size for one kernel loop.
The constant is the loop nest level.
.AT other null trm
.CG notCG

.IL KERNELNEST lnk stc
nest depth of kernel loops
.AT other null trm
.CG notCG

.IL KERNELSTREAM lnk stc
stream argument to CUF kernel
.AT other null trm
.CG notCG

.IL KERNELDEVICE lnk stc
device argument to CUF kernel
.AT other null trm
.CG notCG


.IL ACCIMPDATAREG lnk stc
Generate data movement to/from accelerator.
This is for the implicit data region; the constant is normally zero,
but is '1' when there is a need for a pgi_cu_init call regardless of
whether there is any data to move or allocate
.AT other null trm
.CG notCG

.IL ACCENDIMPDATAREG stc
Generate matching data movement to/from accelerator
This is for the implicit data region
The short constant tells how many implicit data regions were generated
.AT other null trm
.CG notCG

.IL ACCMIRROR lnk lnk lnk sym
Variable or array will be mirrored on the device as on the host
.AT other null lnk
.CG notCG

.IL ACCREFLECT lnk lnk lnk sym
Variable or array has been reflected on the device as on the host
.AT other null lnk
.CG notCG

.IL ACCREDUCTION lnk lnk lnk stc
Variable is a reduction variable.  'stc' is the operator.
.AT other null lnk
.CG notCG

.IL ACCCACHEDIR lnk stc
Accelerator CACHE directive.
The 'stc' argument is normally zero, but is set to '1' if this is a 'readonly' cache directive.
.AT other null lnk
.CG notCG

.IL ACCCACHEARG lnk lnk lnk
Accelerator CACHE argument.
.AT other null lnk
.CG notCG

.IL ACCHOSTDATA lnk
Begin host data region.
.AT other null trm
.CG notCG

.IL ACCENDHOSTDATA
End host data region.
.AT other null trm
.CG notCG

.IL ACCUSEDEVICE lnk lnk lnk sym
Use the device address of a variable or array.
.AT other null lnk
.CG notCG

.IL ACCUSEDEVICEIFP lnk lnk lnk sym
Use the device address of a variable or array, if present
.AT other null lnk
.CG notCG

.IL ACCSYMLNK sym lnk lnk nme
This is used from a link from many other accelerator ILI to
recover the original symbol as well as a link to the address tree,
if appropriate.
Symbol is a symbol pointer.
The first link is a link to reference the symbol.
The second link is a link to reference the parent of the symbol, if the symbol was a member.
The constant value is the NME of the parent, if the symbol was a member.
.AT other null lnk
.CG notCG

.IL ACCCOLLAPSE lnk stc stc stc
Number of loops associated with the loop construct.
First link to next argument.
Second argument is the collapse depth.
Third argument is set if this is a nontightly nested loop (force)
Last argument is the device_type argument.
.AT other null lnk
.CG notCG

.IL ACCDEFNONE lnk
Tells the accelerator CG that a default-none clause is in effect.
The link is to other clauses.
.AT other null lnk
.CG notCG

.IL ACCDEFPRESENT lnk
Tells the accelerator CG that a default-present clause is in effect.
The link is to other clauses.
.AT other null lnk
.CG notCG

.IL ACCDEVICERES lnk lnk lnk sym
Variable or array will be resident on the device.
.AT other null lnk
.CG notCG

.IL ACCLINK lnk lnk lnk sym
A link to the variable or array will be resident on the device.
.AT other null lnk
.CG notCG

.IL ACCLOOPPRIVATE sym
The symbol must be made implicitly private in the containing loop.
.AT other null trm
.CG notCG

.IL ACCJMPTABLE lnk lnk stc
Used in the Accelerator CG.
A jump table.
The first link is to a linked list of ACCJMPENTRY ACLILI.
The second link is to the expression used to index the table.
The 'stc' is an ACBLK index of the default jump target.
.AT other null trm
.CG notCG

.IL ACCJMPENTRY lnk lnk stc 
Used in the Accelerator CG.
A jump table entry.
The first link is to the next entry in a linked list of ACCJMPENTRY ACLILI.
The second link is to an ACCIVAL that contains the value to match for this jump table entry.
The 'stc' is an ACBLK index of this jump target.
.AT other null lnk
.CG notCG


.IL ARGQP dplnk lnk
Defines a quad precision memory argument used in m128 support
\'dplnk' points to the register value of the argument.
\'lnk' points to the next ARG ILI.
.AT define null lnk
.CG memarg "movupd"

.IL ARG256 dplnk lnk
Defines a 256-bit argument used in m256 support
\'dplnk' points to the register value of the argument.
\'lnk' points to the next ARG ILI.
.AT define null lnk
.CG memarg "movupd" sse_avx

.IL GENARG lnk lnk stc stc
Define an argument for a function call.
The ARG ILIs for all of a function's arguments are linked together.
\'lnk1' points to the argument.
\'lnk2' points to the next ARG ILI.
\'stc1' is the datatype of the argument, if available
\'stc2' is the NME
.AT define null lnk
.CG notCG

.IL GENARG2 lnk lnk stc stc
Define 2nd argument of an argument pair for a function call.
This will be linked immediately to the matching GENARG
The ARG ILIs for all of a function's arguments are linked together.
\'lnk1' points to the argument.
\'lnk2' points to the next ARG ILI.
\'stc1' is the datatype of the argument, if available
\'stc2' is the NME
.AT define null lnk
.CG notCG

.IL RETURN lnk stc nme
Define return value from a function.
\'lnk' points to the return value.
\'stc' is the datatype of the argument.
\'nme' is the nme of the argument
.AT move null trm
.CG notCG

.IL VCON sym
.AT cons null lnk cse vect
.CG notCG
.IL VLD arlnk nme stc
For all vector ILI except VCON the last operand is the vector dtype
.AT load null lnk vect
.CG notCG
.IL VLDU arlnk nme stc
.AT load null lnk vect
.CG notCG
.IL VNEG lnk stc
.AT arth null lnk cse vect
.CG notCG
.IL VADD lnk lnk stc
.AT arth comm lnk cse vect
.CG notCG
.IL VSUB lnk lnk stc
.AT arth null lnk cse vect
.CG notCG
.IL VMUL lnk lnk stc
.AT arth comm lnk cse vect
.CG notCG
.IL VDIV lnk lnk lnk stc
.AT arth null lnk cse vect
.CG notCG
.IL VDIVZ lnk lnk lnk stc
Vector divide where divide by zero does not fault.
.AT arth null lnk cse vect
.CG notCG
.IL VMOD lnk lnk lnk stc
.AT arth null lnk cse vect
.CG notCG
.IL VMODZ lnk lnk lnk stc
Vector remainder where divide by zero does not fault.
.AT arth null lnk cse vect
.CG notCG
.IL VCVTV lnk stc stc
.AT arth null lnk cse vect
.IL VCVTS lnk stc
.AT arth null lnk cse vect
.CG notCG
.IL VCVTR lnk stc stc
Reinterpret the bits of a vector as if they were a different vector type.
This should always be a no-op at runtime.
.AT arth null lnk cse vect
.IL VNOT lnk stc
.AT arth null lnk cse vect
.CG notCG
.IL VAND lnk lnk stc
.AT arth comm lnk cse vect
.CG notCG
.IL VOR lnk lnk stc
.AT arth comm lnk cse vect
.CG notCG
.IL VXOR lnk lnk stc
.AT arth comm lnk cse vect
.CG notCG
.IL VCMPNEQ lnk lnk stc
Used for single-precision square root approximation.
.AT arth comm lnk cse vect
.CG notCG
.IL VLSHIFTV lnk lnk stc
.AT arth null lnk cse vect
.CG notCG
.IL VRSHIFTV lnk lnk stc
.AT arth null lnk cse vect
.CG notCG
.IL VLSHIFTS lnk lnk stc
.AT arth null lnk cse vect
.CG notCG
.IL VRSHIFTS lnk lnk stc
.AT arth null lnk cse vect
.CG notCG
.IL VURSHIFTS lnk lnk stc
Vector unsigned (logical) right shift by a scalar
.AT arth null lnk cse vect
.CG notCG
.IL VMIN lnk lnk stc
Vector minimum
.AT arth null lnk cse vect
.CG notCG
.IL VMAX lnk lnk stc
Vector maximum
.AT arth null lnk cse vect
.CG notCG
.IL VABS lnk stc
Vector absolute value
.AT arth null lnk cse vect
.CG notCG
.IL VSQRT lnk lnk stc
Vector square root
.AT arth null lnk cse vect
.CG notCG
.IL VCOS lnk lnk stc
Vector cosine - final link is potential mask as it is
for all the math intrinsic calls (will be IL_NULL if no mask)
.AT arth null lnk cse vect
.CG notCG
.IL VSIN lnk lnk stc
Vector sine
.AT arth null lnk cse vect
.CG notCG
.IL VSINCOS lnk lnk stc
Vector sine-cosine
.AT arth null lnk cse vect
.CG notCG
.IL VASIN lnk lnk stc
Vector arc sine
.AT arth null lnk cse vect
.CG notCG
.IL VACOS lnk lnk stc
Vector arc cosine
.AT arth null lnk cse vect
.CG notCG
.IL VATAN lnk lnk stc
Vector arctangent
.AT arth null lnk cse vect
.CG notCG
.IL VATAN2 lnk lnk lnk stc
Vector arctangent2
.AT arth null lnk cse vect
.CG notCG
.IL VTAN lnk lnk stc
Vector tangent
.AT arth null lnk cse vect
.CG notCG
.IL VSINH lnk lnk stc
Vector hyperbolic sine
.AT arth null lnk cse vect
.CG notCG
.IL VCOSH lnk lnk stc
Vector hyperbolic cosine
.AT arth null lnk cse vect
.CG notCG
.IL VTANH lnk lnk stc
Vector hyperbolic tangent
.AT arth null lnk cse vect
.CG notCG
.IL VEXP lnk lnk stc
Vector natural exponential
.AT arth null lnk cse vect
.CG notCG
.IL VLOG lnk lnk stc
Vector natural logarithm
.AT arth null lnk cse vect
.CG notCG
.IL VLOG10 lnk lnk stc
Vector logarithm base 10
.AT arth null lnk cse vect
.CG notCG
.IL VPOW lnk lnk lnk stc
Vector pow float
.AT arth null lnk cse vect
.CG notCG
.IL VPOWI lnk lnk lnk stc
Vector pow float to integer
.AT arth null lnk cse vect
.CG notCG
.IL VPOWK lnk lnk lnk stc
Vector pow float to integer*8
.AT arth null lnk cse vect
.CG notCG
.IL VPOWIS lnk lnk lnk stc
Vector pow float to scalar integer
.AT arth null lnk cse vect
.CG notCG
.IL VPOWKS lnk lnk lnk stc
Vector pow float to scalar integer*8
.AT arth null lnk cse vect
.CG notCG
.IL VFPOWK lnk lnk lnk stc
Vector pow float to integer*8
.AT arth null lnk cse vect
.CG notCG
.IL VFPOWKS lnk lnk lnk stc
Vector pow float to scalar integer*8
.AT arth null lnk cse vect
.CG notCG
.IL VDPOWI lnk lnk lnk stc
Vector pow double to integer
.AT arth null lnk cse vect
.CG notCG
.IL VDPOWIS lnk lnk lnk stc
Vector pow double to scalar integer
.AT arth null lnk cse vect
.CG notCG
.IL VRSQRT lnk lnk stc
Vector reciprocal square root
.AT arth null lnk cse vect
.CG notCG
.IL VRCP lnk lnk stc
Vector reciprocal
.AT arth null lnk cse vect
.CG notCG
.IL VST lnk arlnk nme stc
.AT store null trm vect
.CG terminal notCG
.IL VSTU lnk arlnk nme stc
.AT store null trm vect
.CG terminal notCG
.IL VFMA1 lnk lnk lnk stc
Vector FMA for LLVM intrinsic - lnk1*lnk2+lnk3, with stc the dtype
.AT arth null lnk cse vect
.CG notCG
.IL VFMA2 lnk lnk lnk stc
Vector FMA for LLVM intrinsic - lnk1*lnk2-lnk3, with stc the dtype
.AT arth null lnk cse vect
.CG notCG
.IL VFMA3 lnk lnk lnk stc
Vector FMA for LLVM intrinsic - -lnk1*lnk2+lnk3, with stc the dtype
.AT arth null lnk cse vect
.CG notCG
.IL VFMA4 lnk lnk lnk stc
Vector FMA for LLVM intrinsic - -lnk1*lnk2-lnk3, with stc the dtype
.AT arth null lnk cse vect
.CG notCG
.IL VPERMUTE lnk lnk lnk stc
Shuffle contents of vector registers. lnk1 and lnk2 can be the same vector
or lnk2 can be null. lnk1 dtype is used as dtype for both lnk1 and lnk2,
unless lnk2 is null. stc is the result dtype, lnk3 is a vector constant
representing a mask where each field represents which L-to-R element of
concatenated <lnk1,lnk2> vector is to be placed in corresponding result
field. lnk3 size must match the size of the result vector, but can be
different than lnk1 and lnk2's size.
.AT other null lnk vect
.CG notCG
.IL VBLEND lnk lnk lnk stc
Vector blend/select of lnk2 & lnk3. lnk1 is the mask, stc is the dtype
.AT other null lnk cse vect
.CG notCG
.IL VCMP stc lnk lnk stc
Vector compare of lnk1 & lnk2. stc1 is the condition code, stc2 is the dtype
.AT arth null lnk cse vect
.CG notCG

.IL BCONCUR sym lnk
Start auto parallel region of an outlined function sym.
.AT other null trm
.CG notCG

.IL ECONCUR sym
End auto parallel region  of an outliend function sym.
.AT other null trm
.CG notCG

.so ilitp_atomic.n

.so ilitp_longdouble.n
