/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import visad.Set;
import visad.SimpleSet;
import visad.TypeException;
import visad.VisADException;
import visad.data.netcdf.Quantity;
import visad.data.units.ParseException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryGeneric;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinarySerializedObject;
import visad.data.visad.object.BinaryString;

public class BinaryQuantity
implements BinaryObject {
    public static final int computeBytes(Quantity qt) {
        return 5 + BinaryString.computeBytes(qt.getName()) + BinaryString.computeBytes(qt.getDefaultUnitString()) + (qt.getDefaultSet() == null ? 0 : 1) + 1;
    }

    public static final Quantity read(BinaryReader reader, int index) throws IOException, VisADException {
        Quantity q;
        String name = BinaryString.read(reader);
        String unitSpec = BinaryString.read(reader);
        boolean setFollowsType = false;
        BinaryObjectCache cache = reader.getTypeCache();
        DataInput file = reader.getInput();
        boolean reading = true;
        block10: while (reading) {
            byte directive;
            try {
                directive = file.readByte();
            }
            catch (EOFException eofe) {
                return null;
            }
            switch (directive) {
                case 70: {
                    setFollowsType = true;
                    continue block10;
                }
                case 80: {
                    reading = false;
                    continue block10;
                }
            }
            throw new IOException("Unknown RealType directive " + directive);
        }
        try {
            q = Quantity.getQuantity(name, unitSpec);
        }
        catch (ParseException pe) {
            throw new VisADException("Couldn't parse Quantity unitSpec \"" + unitSpec + "\"");
        }
        if (q == null) {
            throw new VisADException("Couldn't create Quantity named \"" + name + "\"");
        }
        cache.add(index, q);
        if (setFollowsType) {
            SimpleSet set = (SimpleSet)BinaryGeneric.read(reader);
            try {
                q.setDefaultSet(set);
            }
            catch (TypeException te) {
                // empty catch block
            }
        }
        return q;
    }

    public static final int write(BinaryWriter writer, Quantity qt, Object token) throws IOException {
        BinaryObjectCache cache = writer.getTypeCache();
        int index = cache.getIndex(qt);
        if (index < 0) {
            index = cache.add(qt);
            if (index < 0) {
                throw new IOException("Couldn't cache Quantity " + qt);
            }
            if (!(qt.getClass().equals(Quantity.class) || qt instanceof Quantity && qt instanceof Saveable)) {
                BinarySerializedObject.write(writer, (byte)6, qt, token);
                return index;
            }
            DataOutput file = writer.getOutput();
            String nameStr = qt.getName();
            String unitStr = qt.getDefaultUnitString();
            Set dfltSet = qt.getDefaultSet();
            int objLen = BinaryQuantity.computeBytes(qt);
            file.writeByte(5);
            file.writeInt(objLen);
            file.writeInt(index);
            file.writeByte(7);
            BinaryString.write(writer, nameStr, token);
            BinaryString.write(writer, unitStr, token);
            if (dfltSet != null) {
                file.writeByte(70);
            }
            file.writeByte(80);
            if (dfltSet != null) {
                BinaryGeneric.write(writer, dfltSet, SAVE_DATA);
            }
        }
        return index;
    }
}

