/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.point;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.event.EventListenerList;
import thredds.ui.BAMutil;
import thredds.ui.IndependentDialog;
import thredds.ui.PopupManager;
import thredds.ui.RangeDateSelector;
import thredds.viewer.ui.Renderer;
import thredds.viewer.ui.RubberbandRectangleHandles;
import thredds.viewer.ui.event.ActionSourceListener;
import thredds.viewer.ui.event.ActionValueEvent;
import thredds.viewer.ui.event.ActionValueListener;
import thredds.viewer.ui.geoloc.GeoSelectionEvent;
import thredds.viewer.ui.geoloc.GeoSelectionListener;
import thredds.viewer.ui.geoloc.NPController;
import thredds.viewer.ui.geoloc.NavigatedPanel;
import thredds.viewer.ui.geoloc.Navigation;
import thredds.viewer.ui.geoloc.PickEvent;
import thredds.viewer.ui.geoloc.PickEventListener;
import ucar.nc2.ui.point.StationRenderer;
import ucar.nc2.units.DateRange;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.Station;
import ucar.unidata.util.Format;
import ucar.util.prefs.ui.Field;
import ucar.util.prefs.ui.PrefPanel;

public class StationRegionDateChooser
extends NPController {
    private boolean regionSelect = true;
    private boolean stationSelect = true;
    private boolean dateSelect = true;
    private StationRenderer stnRender = null;
    private Station selectedStation;
    private ProjectionRect geoBounds;
    private ProjectionRect geoSelection;
    private boolean geoSelectionMode = false;
    private Color outlineColor = Color.black;
    private int nfracDig = 3;
    private RangeDateSelector dateSelector;
    private IndependentDialog dateWindow;
    private AbstractAction dateAction;
    private PrefPanel minmaxPP;
    private Field.Double minLonField;
    private Field.Double maxLonField;
    private Field.Double minLatField;
    private Field.Double maxLatField;
    private EventListenerList listenerList = new EventListenerList();
    private ActionSourceListener actionSource;
    private PopupManager popupInfo = new PopupManager("Station Info");
    private StringBuffer sbuff = new StringBuffer();
    private boolean debugEvent = false;
    private boolean debug = false;

    public StationRegionDateChooser() {
        this(true, true, true);
    }

    public StationRegionDateChooser(boolean stationSelect, boolean regionSelect, boolean dateSelect) {
        this.regionSelect = regionSelect;
        this.stationSelect = stationSelect;
        this.dateSelect = dateSelect;
        this.np.setGeoSelectionMode(regionSelect && this.geoSelectionMode);
        if (stationSelect) {
            this.stnRender = new StationRenderer();
            this.addRenderer(this.stnRender);
            this.np.addPickEventListener(new PickEventListener(){

                public void actionPerformed(PickEvent e) {
                    StationRegionDateChooser.this.selectedStation = StationRegionDateChooser.this.stnRender.pick(e.getLocation());
                    if (StationRegionDateChooser.this.selectedStation != null) {
                        StationRegionDateChooser.this.redraw();
                        StationRegionDateChooser.this.firePropertyChangeEvent(StationRegionDateChooser.this.selectedStation, "Station");
                        StationRegionDateChooser.this.actionSource.fireActionValueEvent("selected", StationRegionDateChooser.this.selectedStation);
                    }
                }
            });
            this.np.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseMoved(MouseEvent e) {
                    Point p = e.getPoint();
                    StationRenderer.StationUI sui = StationRegionDateChooser.this.stnRender.isOnStation(p);
                    if (sui != null) {
                        Station s = sui.getStation();
                        StationRegionDateChooser.this.sbuff.setLength(0);
                        StationRegionDateChooser.this.sbuff.append(s.getName());
                        StationRegionDateChooser.this.sbuff.append(" ");
                        StationRegionDateChooser.this.sbuff.append("\n");
                        if (null != s.getDescription()) {
                            StationRegionDateChooser.this.sbuff.append(s.getDescription()).append("\n");
                        }
                        StationRegionDateChooser.this.sbuff.append(LatLonPointImpl.latToString(s.getLatitude(), 4));
                        StationRegionDateChooser.this.sbuff.append(" ");
                        StationRegionDateChooser.this.sbuff.append(LatLonPointImpl.lonToString(s.getLongitude(), 4));
                        StationRegionDateChooser.this.sbuff.append(" ");
                        double alt = s.getAltitude();
                        if (!Double.isNaN(alt)) {
                            StationRegionDateChooser.this.sbuff.append(Format.d(alt, 0));
                            StationRegionDateChooser.this.sbuff.append(" m");
                        }
                        StationRegionDateChooser.this.popupInfo.show(StationRegionDateChooser.this.sbuff.toString(), p, StationRegionDateChooser.this, s);
                    } else {
                        StationRegionDateChooser.this.popupInfo.hide();
                    }
                }
            });
            this.np.addMouseListener(new MouseAdapter(){

                public void mouseExited(MouseEvent e) {
                    StationRegionDateChooser.this.popupInfo.hide();
                }
            });
            this.actionSource = new ActionSourceListener("station"){

                public void actionPerformed(ActionValueEvent e) {
                    if (StationRegionDateChooser.this.debugEvent) {
                        System.out.println(" StationdatasetChooser: actionSource event " + e);
                    }
                    StationRegionDateChooser.this.selectedStation = (Station)e.getValue();
                    StationRegionDateChooser.this.redraw();
                }
            };
        }
        if (regionSelect) {
            double defArea = 0.125;
            LatLonRect llbb = this.np.getProjectionImpl().getDefaultMapAreaLL();
            LatLonPointImpl left = llbb.getLowerLeftPoint();
            LatLonPointImpl right = llbb.getUpperRightPoint();
            double centerLon = llbb.getCenterLon();
            double width = llbb.getWidth();
            double centerLat = (right.getLatitude() + left.getLatitude()) / 2.0;
            double height = right.getLatitude() - left.getLatitude();
            right = new LatLonPointImpl(centerLat + height * defArea, centerLon + width * defArea);
            left = new LatLonPointImpl(centerLat - height * defArea, centerLon - width * defArea);
            LatLonRect selected = new LatLonRect(left, right);
            this.setGeoSelection(selected);
            this.np.addGeoSelectionListener(new GeoSelectionListener(){

                public void actionPerformed(GeoSelectionEvent e) {
                    StationRegionDateChooser.this.setGeoSelection(e.getProjectionRect());
                    if (StationRegionDateChooser.this.debugEvent) {
                        System.out.println("GeoSelectionEvent=" + StationRegionDateChooser.this.geoSelection);
                    }
                    StationRegionDateChooser.this.firePropertyChangeEvent(StationRegionDateChooser.this.geoSelection, "GeoRegion");
                    StationRegionDateChooser.this.redraw();
                }
            });
        }
        if (dateSelect) {
            DateRange range = null;
            try {
                range = new DateRange();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.dateSelector = new RangeDateSelector(null, range, true, false, null, false, true);
            this.dateWindow = new IndependentDialog(null, false, "Date Selection", this.dateSelector);
            this.dateAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    StationRegionDateChooser.this.dateWindow.setVisible(true);
                }
            };
            BAMutil.setActionProperties(this.dateAction, "selectDate", "select date range", false, 68, -1);
        }
        this.makeMyUI();
    }

    protected void makeUI() {
    }

    private void makeMyUI() {
        AbstractAction incrFontAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                StationRegionDateChooser.this.stnRender.incrFontSize();
                StationRegionDateChooser.this.redraw();
            }
        };
        BAMutil.setActionProperties(incrFontAction, "FontIncr", "increase font size", false, 73, -1);
        AbstractAction decrFontAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                StationRegionDateChooser.this.stnRender.decrFontSize();
                StationRegionDateChooser.this.redraw();
            }
        };
        BAMutil.setActionProperties(decrFontAction, "FontDecr", "decrease font size", false, 68, -1);
        JCheckBox declutCB = new JCheckBox("Declutter", true);
        declutCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StationRegionDateChooser.this.setDeclutter(((JCheckBox)e.getSource()).isSelected());
            }
        });
        AbstractAction bbAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                StationRegionDateChooser.this.geoSelectionMode = !StationRegionDateChooser.this.geoSelectionMode;
                StationRegionDateChooser.this.np.setGeoSelectionMode(StationRegionDateChooser.this.geoSelectionMode);
                StationRegionDateChooser.this.redraw();
            }
        };
        BAMutil.setActionProperties(bbAction, "geoselect", "select geo region", true, 66, -1);
        bbAction.putValue("state", this.geoSelectionMode ? Boolean.TRUE : Boolean.FALSE);
        if (this.regionSelect) {
            this.minmaxPP = new PrefPanel(null, null);
            this.minLonField = this.minmaxPP.addDoubleField("minLon", "minLon", this.geoSelection.getMinX(), this.nfracDig, 0, 0, null);
            this.maxLonField = this.minmaxPP.addDoubleField("maxLon", "maxLon", this.geoSelection.getMaxX(), this.nfracDig, 2, 0, null);
            this.minLatField = this.minmaxPP.addDoubleField("minLat", "minLat", this.geoSelection.getMinY(), this.nfracDig, 4, 0, null);
            this.maxLatField = this.minmaxPP.addDoubleField("maxLat", "maxLat", this.geoSelection.getMaxY(), this.nfracDig, 6, 0, null);
            this.minmaxPP.finish(true, "East");
            this.minmaxPP.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    double minLon = StationRegionDateChooser.this.minLonField.getDouble();
                    double minLat = StationRegionDateChooser.this.minLatField.getDouble();
                    double maxLon = StationRegionDateChooser.this.maxLonField.getDouble();
                    double maxLat = StationRegionDateChooser.this.maxLatField.getDouble();
                    LatLonRect llbb = new LatLonRect(new LatLonPointImpl(minLat, minLon), new LatLonPointImpl(maxLat, maxLon));
                    StationRegionDateChooser.this.setGeoSelection(llbb);
                    StationRegionDateChooser.this.redraw();
                }
            });
        }
        this.setLayout(new BorderLayout());
        if (this.stationSelect) {
            BAMutil.addActionToContainer(this.toolPanel, incrFontAction);
            BAMutil.addActionToContainer(this.toolPanel, decrFontAction);
            this.toolPanel.add(declutCB);
        }
        if (this.regionSelect) {
            BAMutil.addActionToContainer(this.toolPanel, bbAction);
        }
        if (this.dateSelect) {
            BAMutil.addActionToContainer(this.toolPanel, this.dateAction);
        }
        JPanel upperPanel = new JPanel(new BorderLayout());
        if (this.regionSelect) {
            upperPanel.add((Component)this.minmaxPP, "North");
        }
        upperPanel.add((Component)this.toolPanel, "South");
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.setBorder(new EtchedBorder());
        JLabel positionLabel = new JLabel("position");
        statusPanel.add((Component)positionLabel, "Center");
        this.np.setPositionLabel(positionLabel);
        this.add((Component)upperPanel, "North");
        this.add((Component)this.np, "Center");
        this.add((Component)statusPanel, "South");
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listenerList.add(PropertyChangeListener.class, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listenerList.remove(PropertyChangeListener.class, l);
    }

    public void addToolbarAction(AbstractAction act) {
        BAMutil.addActionToContainer(this.toolPanel, act);
    }

    private void firePropertyChangeEvent(Object newValue, String propertyName) {
        PropertyChangeEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PropertyChangeListener.class) continue;
            if (event == null) {
                event = new PropertyChangeEvent(this, propertyName, null, newValue);
            }
            ((PropertyChangeListener)listeners[i + 1]).propertyChange(event);
        }
    }

    public void addActionValueListener(ActionValueListener l) {
        this.actionSource.addActionValueListener(l);
    }

    public void removeActionValueListener(ActionValueListener l) {
        this.actionSource.removeActionValueListener(l);
    }

    public ActionSourceListener getActionSourceListener() {
        return this.actionSource;
    }

    public void setMapArea(ProjectionRect ma) {
        this.np.getProjectionImpl().setDefaultMapArea(ma);
    }

    public void setStations(List stns) {
        this.stnRender.setStations(stns);
        this.redraw(true);
    }

    public void setSelectedStation(String id) {
        this.stnRender.setSelectedStation(id);
        this.selectedStation = this.stnRender.getSelectedStation();
        this.np.setLatLonCenterMapArea(this.selectedStation.getLatitude(), this.selectedStation.getLongitude());
        this.redraw();
    }

    public Station getSelectedStation() {
        return this.selectedStation;
    }

    public NavigatedPanel getNavigatedPanel() {
        return this.np;
    }

    public void setDeclutter(boolean declut) {
        this.stnRender.setDeclutter(declut);
        this.redraw();
    }

    public boolean getDeclutter() {
        return this.stnRender.getDeclutter();
    }

    protected void redraw() {
        long tstart = System.currentTimeMillis();
        Graphics2D gNP = this.np.getBufferedImageGraphics();
        if (gNP == null) {
            return;
        }
        gNP.setBackground(this.np.getBackgroundColor());
        Rectangle r = gNP.getClipBounds();
        gNP.clearRect(r.x, r.y, r.width, r.height);
        if (this.regionSelect && this.geoSelectionMode) {
            if (this.geoSelection != null) {
                this.drawBB(gNP, this.geoSelection, Color.cyan);
            }
            if (this.geoBounds != null) {
                this.drawBB(gNP, this.geoBounds, null);
            }
            if (this.geoSelection != null) {
                Navigation navigate = this.np.getNavigation();
                double handleSize = RubberbandRectangleHandles.handleSizePixels / navigate.getPixPerWorld();
                RubberbandRectangleHandles.drawHandledRect(gNP, this.geoSelection, handleSize);
                if (this.debug) {
                    System.out.println("GeoRegionChooser.drawHandledRect=" + handleSize + " = " + this.geoSelection);
                }
            }
        }
        for (int i = 0; i < this.renderers.size(); ++i) {
            Renderer rend = (Renderer)this.renderers.get(i);
            rend.draw(gNP, this.atI);
        }
        gNP.dispose();
        if (this.debug) {
            long tend = System.currentTimeMillis();
            System.out.println("StationRegionDateChooser draw time = " + (double)(tend - tstart) / 1000.0 + " secs");
        }
        this.np.repaint();
    }

    private void drawBB(Graphics2D g, ProjectionRect bb, Color fillColor) {
        if (null != fillColor) {
            g.setColor(fillColor);
            g.fill(bb);
        }
        g.setColor(this.outlineColor);
        g.draw(bb);
    }

    public void setGeoBounds(LatLonRect llbb) {
        this.np.setMapArea(llbb);
        this.geoBounds = this.np.getProjectionImpl().latLonToProjBB(llbb);
        this.np.getProjectionImpl().setDefaultMapArea(this.geoBounds);
        this.setGeoSelection(this.geoBounds);
    }

    public void setGeoBounds(ProjectionRect bb) {
        this.geoBounds = new ProjectionRect(bb);
        this.np.setMapArea(bb);
        this.np.getProjectionImpl().setDefaultMapArea(this.geoBounds);
    }

    public void setGeoSelection(LatLonRect llbb) {
        this.np.setGeoSelection(llbb);
        this.setGeoSelection(this.np.getGeoSelection());
    }

    public void setGeoSelection(ProjectionRect bb) {
        this.geoSelection = bb;
        if (this.minLonField != null) {
            this.minLonField.setDouble(this.geoSelection.getMinX());
            this.minLatField.setDouble(this.geoSelection.getMinY());
            this.maxLonField.setDouble(this.geoSelection.getMaxX());
            this.maxLatField.setDouble(this.geoSelection.getMaxY());
        }
        this.np.setGeoSelection(this.geoSelection);
    }

    public LatLonRect getGeoSelectionLL() {
        return this.np.getGeoSelectionLL();
    }

    public ProjectionRect getGeoSelection() {
        return this.np.getGeoSelection();
    }

    public boolean getGeoSelectionMode() {
        return this.geoSelectionMode;
    }

    public DateRange getDateRange() {
        if (!(this.dateSelect && this.dateWindow.isShowing() && this.dateSelector.isEnabled())) {
            return null;
        }
        return this.dateSelector.getDateRange();
    }

    public void setDateRange(DateRange range) {
        this.dateSelector.setDateRange(range);
    }

    public JDialog makeDialog(RootPaneContainer parent, String title, boolean modal) {
        return new Dialog(parent, title, modal);
    }

    public static void main(String[] args) {
        StationRegionDateChooser slm = new StationRegionDateChooser();
        slm.setBounds(new Rectangle(10, 10, 400, 200));
        JFrame frame = new JFrame("StationRegionChooser Test");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.getContentPane().add(slm);
        frame.pack();
        frame.setVisible(true);
    }

    private class Dialog
    extends JDialog {
        private Dialog(RootPaneContainer parent, String title, boolean modal) {
            super(parent instanceof Frame ? (Frame)((Object)parent) : null, title, modal);
            UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("lookAndFeel")) {
                        SwingUtilities.updateComponentTreeUI(Dialog.this);
                    }
                }
            });
            JPanel buttPanel = new JPanel();
            JButton dismissButton = new JButton("Dismiss");
            dismissButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Dialog.this.setVisible(false);
                }
            });
            buttPanel.add((Component)dismissButton, null);
            Container cp = this.getContentPane();
            cp.setLayout(new BorderLayout());
            cp.add((Component)StationRegionDateChooser.this, "Center");
            cp.add((Component)buttPanel, "South");
            this.pack();
        }
    }
}

