/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.plaf;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;
import org.bounce.QLabel;
import org.bounce.plaf.BounceGraphicsUtils;

public class BounceLabelUI
extends BasicLabelUI {
    private static Rectangle paintIconR = new Rectangle();
    private static Rectangle paintTextR = new Rectangle();
    private static Rectangle paintViewR = new Rectangle();
    private static Insets paintViewInsets = new Insets(0, 0, 0, 0);
    private static Rectangle iconR = new Rectangle();
    private static Rectangle textR = new Rectangle();
    private static Rectangle viewR = new Rectangle();
    private static Insets viewInsets = new Insets(0, 0, 0, 0);
    private static LabelUI labelUI;

    public static ComponentUI createUI(JComponent c) {
        if (labelUI == null) {
            labelUI = new BounceLabelUI();
        }
        return labelUI;
    }

    public void installUI(JComponent c) {
        JLabel p = (JLabel)c;
        super.installUI(p);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    public void paint(Graphics g, JComponent c) {
        Icon icon;
        QLabel label = (QLabel)c;
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        paintViewInsets = c.getInsets(paintViewInsets);
        BounceLabelUI.paintViewR.x = BounceLabelUI.paintViewInsets.left;
        BounceLabelUI.paintViewR.y = BounceLabelUI.paintViewInsets.top;
        BounceLabelUI.paintViewR.width = c.getWidth() - (BounceLabelUI.paintViewInsets.left + BounceLabelUI.paintViewInsets.right);
        BounceLabelUI.paintViewR.height = c.getHeight() - (BounceLabelUI.paintViewInsets.top + BounceLabelUI.paintViewInsets.bottom);
        BounceLabelUI.paintIconR.height = 0;
        BounceLabelUI.paintIconR.width = 0;
        BounceLabelUI.paintIconR.y = 0;
        BounceLabelUI.paintIconR.x = 0;
        BounceLabelUI.paintTextR.height = 0;
        BounceLabelUI.paintTextR.width = 0;
        BounceLabelUI.paintTextR.y = 0;
        BounceLabelUI.paintTextR.x = 0;
        String[] clippedText = BounceGraphicsUtils.layoutMultilineCompoundLabel(c, fm, text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), paintViewR, paintIconR, paintTextR, label.getIconTextGap(), label.getMinimumLines(), label.getMaximumLines());
        if (icon != null) {
            icon.paintIcon(c, g, BounceLabelUI.paintIconR.x, BounceLabelUI.paintIconR.y);
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, paintTextR);
            } else {
                if (label.isEnabled()) {
                    g.setColor(label.getForeground());
                } else {
                    g.setColor(UIManager.getColor("Label.disabledForeground"));
                }
                int y = BounceLabelUI.paintTextR.y + fm.getAscent();
                for (int i = 0; i < clippedText.length; ++i) {
                    BounceGraphicsUtils.drawLine(g, fm, paintTextR, clippedText[i], label.getHorizontalAlignment(), y, label.getDisplayedMnemonic());
                    y += fm.getHeight();
                }
            }
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        QLabel label = (QLabel)c;
        String text = label.getText();
        Icon icon = label.getIcon();
        Insets insets = label.getInsets(viewInsets);
        Font font = label.getFont();
        int dx = insets.left + insets.right;
        int dy = insets.top + insets.bottom;
        if (icon == null && (text == null || text != null && font == null)) {
            return new Dimension(dx, dy);
        }
        if (text == null || icon != null && font == null) {
            return new Dimension(icon.getIconWidth() + dx, icon.getIconHeight() + dy);
        }
        Graphics gc = label.getGraphics();
        if (gc != null) {
            FontMetrics fm = gc.getFontMetrics();
            BounceLabelUI.iconR.height = 0;
            BounceLabelUI.iconR.width = 0;
            BounceLabelUI.iconR.y = 0;
            BounceLabelUI.iconR.x = 0;
            BounceLabelUI.textR.height = 0;
            BounceLabelUI.textR.width = 0;
            BounceLabelUI.textR.y = 0;
            BounceLabelUI.textR.x = 0;
            Insets i = c.getInsets();
            if (label.getMaximumLines() == 1) {
                BounceLabelUI.viewR.x = i.left + i.right;
                BounceLabelUI.viewR.y = i.top + i.bottom;
                BounceLabelUI.viewR.height = Short.MAX_VALUE;
                BounceLabelUI.viewR.width = Short.MAX_VALUE;
            } else {
                BounceLabelUI.viewR.x = i.left;
                BounceLabelUI.viewR.y = i.top;
                BounceLabelUI.viewR.width = label.getWidth() - (i.right + BounceLabelUI.viewR.x);
                BounceLabelUI.viewR.height = label.getHeight() - (i.bottom + BounceLabelUI.viewR.y);
            }
            BounceGraphicsUtils.layoutMultilineCompoundLabel(c, fm, text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewR, iconR, textR, label.getIconTextGap(), label.getMinimumLines(), label.getMaximumLines());
            int x1 = Math.min(BounceLabelUI.iconR.x, BounceLabelUI.textR.x);
            int x2 = Math.max(BounceLabelUI.iconR.x + BounceLabelUI.iconR.width, BounceLabelUI.textR.x + BounceLabelUI.textR.width);
            int y1 = Math.min(BounceLabelUI.iconR.y, BounceLabelUI.textR.y);
            int y2 = Math.max(BounceLabelUI.iconR.y + BounceLabelUI.iconR.height, BounceLabelUI.textR.y + BounceLabelUI.textR.height);
            Dimension rv = new Dimension(x2 - x1, y2 - y1);
            rv.width += dx;
            rv.height += dy;
            return rv;
        }
        return new Dimension(0, 0);
    }
}

