/*
 * Copyright (C) 2005-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_SHUGART_BUS_H_INCLUDED
#define __SIG_SHUGART_BUS_H_INCLUDED

#include "sig_gen.h"

struct sig_shugart_bus_funcs {
	/*
	 * Controller -> Drive
	 */
	void (*writeid)(void *s, unsigned char cyl, unsigned char sec);
	void (*writedata)(void *s, unsigned char *buf, unsigned int bufsize);
	void (*read_start)(void *s);

	/*
	 * Drive -> Controller
	 */
	void (*readid)(void *s, unsigned char cyl, unsigned char sec);
	void (*readdata)(void *s, unsigned char *buf, unsigned int bufsize);
};

struct sig_shugart_bus {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_shugart_bus_funcs *f;
	} member[5];
	unsigned int nmembers;
};

struct sig_shugart_bus_merge {
	struct sig_shugart_bus *s0;
	struct sig_shugart_bus *s1;
};

/* Controller -> Drive */
extern void
sig_shugart_bus_writeid(struct sig_shugart_bus *b, void *s,
		unsigned char cyl, unsigned char sec);
extern void
sig_shugart_bus_writedata(struct sig_shugart_bus *b, void *s,
		unsigned char *data, unsigned int bufsize);

extern void
sig_shugart_bus_read_start(struct sig_shugart_bus *b, void *s);

/* Drive -> Controller */
extern void
sig_shugart_bus_readid(struct sig_shugart_bus *b, void *s,
		unsigned char cyl, unsigned char sec);
extern void
sig_shugart_bus_readdata(struct sig_shugart_bus *b, void *s,
		unsigned char *buf, unsigned int bufsize);

extern void
sig_shugart_bus_connect(struct sig_shugart_bus *b, void *s,
		const struct sig_shugart_bus_funcs *f);

extern struct sig_shugart_bus_merge *
sig_shugart_bus_merge(struct sig_shugart_bus *s0, struct sig_shugart_bus *s1);
extern void
sig_shugart_bus_split(struct sig_shugart_bus_merge *m);

extern struct sig_shugart_bus *
sig_shugart_bus_create(const char *name);
extern void
sig_shugart_bus_destroy(struct sig_shugart_bus *sig);

extern void
sig_shugart_bus_suspend(struct sig_shugart_bus *b, FILE *fSig);
extern void
sig_shugart_bus_resume(struct sig_shugart_bus *b, FILE *fSig);

#endif /* __SIG_SHUGART_BUS_H_INCLUDED */
