/*
 * The Doomsday Engine Project
 *
 * Copyright (c) 2011-2013 Jaakko Keränen <jaakko.keranen@iki.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#ifndef LIBDENG2_DELEGATERULE_H
#define LIBDENG2_DELEGATERULE_H

#include "../ConstantRule"

namespace de {

/**
 * The value of a delegate rule is generated by a separate source.
 *
 * @ingroup widgets
 */
class DENG2_PUBLIC DelegateRule : public ConstantRule
{
public:
    /**
     * Source of the delegate, responsible for setting the delegate's value.
     */
    class ISource
    {
    public:
        virtual ~ISource() {}

        /**
         * During this, the source is expected to call ConstantRule::set() on
         * the delegate.
         *
         * @param id  Delegate id.
         */
        virtual void delegateUpdate(int id) = 0;

        virtual void delegateInvalidation(int id) = 0;
    };

public:
    /**
     * Constructs a new delegate rule.
     *
     * @param source      Source.
     * @param delegateId  Id passed to the source to identify this delegate.
     */
    DelegateRule(ISource &source, int delegateId = 0);

    void update();

    /**
     * Changes the source of the delegate.
     *
     * @param source  Source.
     */
    void setSource(ISource *source);

    void invalidate();

protected:
    ~DelegateRule(); // Counted

private:
    ISource *_source;
    int _delegateId;
};

} // namespace de

#endif // LIBDENG2_DELEGATERULE_H
