// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ASH_SYSTEM_SCREEN_SECURITY_SCREEN_CAPTURE_OBSERVER_H_
#define ASH_SYSTEM_SCREEN_SECURITY_SCREEN_CAPTURE_OBSERVER_H_

#include "base/callback.h"
#include "base/strings/string16.h"

namespace ash {

class ScreenCaptureObserver {
 public:
  // Called when screen capture is started.
  // |stop_callback| is a callback to stop the stream.
  // |source_callback| is a callback to change the desktop capture source.
  virtual void OnScreenCaptureStart(
      base::RepeatingClosure stop_callback,
      base::RepeatingClosure source_callback,
      const base::string16& screen_capture_status) = 0;

  // Called when screen capture is stopped.
  virtual void OnScreenCaptureStop() = 0;

 protected:
  virtual ~ScreenCaptureObserver() {}
};

}  // namespace ash

#endif  // ASH_SYSTEM_SCREEN_SECURITY_SCREEN_CAPTURE_OBSERVER_H_
