/* BudgieMenu.c generated by valac 0.32.1, the Vala compiler
 * generated from BudgieMenu.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <libpeas/peas.h>
#include <plugin.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_BUDGIE_MENU (budgie_menu_get_type ())
#define BUDGIE_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUDGIE_MENU, BudgieMenu))
#define BUDGIE_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUDGIE_MENU, BudgieMenuClass))
#define IS_BUDGIE_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUDGIE_MENU))
#define IS_BUDGIE_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUDGIE_MENU))
#define BUDGIE_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUDGIE_MENU, BudgieMenuClass))

typedef struct _BudgieMenu BudgieMenu;
typedef struct _BudgieMenuClass BudgieMenuClass;
typedef struct _BudgieMenuPrivate BudgieMenuPrivate;

#define TYPE_BUDGIE_MENU_APPLET (budgie_menu_applet_get_type ())
#define BUDGIE_MENU_APPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUDGIE_MENU_APPLET, BudgieMenuApplet))
#define BUDGIE_MENU_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUDGIE_MENU_APPLET, BudgieMenuAppletClass))
#define IS_BUDGIE_MENU_APPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUDGIE_MENU_APPLET))
#define IS_BUDGIE_MENU_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUDGIE_MENU_APPLET))
#define BUDGIE_MENU_APPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUDGIE_MENU_APPLET, BudgieMenuAppletClass))

typedef struct _BudgieMenuApplet BudgieMenuApplet;
typedef struct _BudgieMenuAppletClass BudgieMenuAppletClass;

#define TYPE_BUDGIE_MENU_SETTINGS (budgie_menu_settings_get_type ())
#define BUDGIE_MENU_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUDGIE_MENU_SETTINGS, BudgieMenuSettings))
#define BUDGIE_MENU_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUDGIE_MENU_SETTINGS, BudgieMenuSettingsClass))
#define IS_BUDGIE_MENU_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUDGIE_MENU_SETTINGS))
#define IS_BUDGIE_MENU_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUDGIE_MENU_SETTINGS))
#define BUDGIE_MENU_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUDGIE_MENU_SETTINGS, BudgieMenuSettingsClass))

typedef struct _BudgieMenuSettings BudgieMenuSettings;
typedef struct _BudgieMenuSettingsClass BudgieMenuSettingsClass;
typedef struct _BudgieMenuSettingsPrivate BudgieMenuSettingsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _BudgieMenuAppletPrivate BudgieMenuAppletPrivate;

#define TYPE_BUDGIE_MENU_WINDOW (budgie_menu_window_get_type ())
#define BUDGIE_MENU_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUDGIE_MENU_WINDOW, BudgieMenuWindow))
#define BUDGIE_MENU_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUDGIE_MENU_WINDOW, BudgieMenuWindowClass))
#define IS_BUDGIE_MENU_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUDGIE_MENU_WINDOW))
#define IS_BUDGIE_MENU_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUDGIE_MENU_WINDOW))
#define BUDGIE_MENU_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUDGIE_MENU_WINDOW, BudgieMenuWindowClass))

typedef struct _BudgieMenuWindow BudgieMenuWindow;
typedef struct _BudgieMenuWindowClass BudgieMenuWindowClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BudgieMenu {
	PeasExtensionBase parent_instance;
	BudgieMenuPrivate * priv;
};

struct _BudgieMenuClass {
	PeasExtensionBaseClass parent_class;
};

struct _BudgieMenuSettings {
	GtkGrid parent_instance;
	BudgieMenuSettingsPrivate * priv;
};

struct _BudgieMenuSettingsClass {
	GtkGridClass parent_class;
};

struct _BudgieMenuSettingsPrivate {
	GtkSwitch* switch_menu_label;
	GtkSwitch* switch_menu_compact;
	GtkSwitch* switch_menu_headers;
	GtkSwitch* switch_menu_categories_hover;
	GtkEntry* entry_label;
	GSettings* settings;
};

struct _BudgieMenuApplet {
	BudgieApplet parent_instance;
	BudgieMenuAppletPrivate * priv;
	GtkToggleButton* widget;
	BudgieMenuWindow* popover;
	GSettings* settings;
};

struct _BudgieMenuAppletClass {
	BudgieAppletClass parent_class;
};

struct _BudgieMenuAppletPrivate {
	GtkImage* img;
	GtkLabel* label;
	BudgiePopoverManager* manager;
	gchar* _uuid;
};


static gpointer budgie_menu_parent_class = NULL;
static BudgiePluginIface* budgie_menu_budgie_plugin_parent_iface = NULL;
static GType budgie_menu_type_id = 0;
static gpointer budgie_menu_settings_parent_class = NULL;
static GType budgie_menu_settings_type_id = 0;
static gpointer budgie_menu_applet_parent_class = NULL;
static GType budgie_menu_applet_type_id = 0;

GType budgie_menu_get_type (void) G_GNUC_CONST;
GType budgie_menu_register_type (GTypeModule * module);
enum  {
	BUDGIE_MENU_DUMMY_PROPERTY
};
static BudgieApplet* budgie_menu_real_get_panel_widget (BudgiePlugin* base, const gchar* uuid);
BudgieMenuApplet* budgie_menu_applet_new (const gchar* uuid);
BudgieMenuApplet* budgie_menu_applet_construct (GType object_type, const gchar* uuid);
GType budgie_menu_applet_get_type (void) G_GNUC_CONST;
GType budgie_menu_applet_register_type (GTypeModule * module);
BudgieMenu* budgie_menu_new (void);
BudgieMenu* budgie_menu_construct (GType object_type);
GType budgie_menu_settings_get_type (void) G_GNUC_CONST;
GType budgie_menu_settings_register_type (GTypeModule * module);
#define BUDGIE_MENU_SETTINGS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUDGIE_MENU_SETTINGS, BudgieMenuSettingsPrivate))
enum  {
	BUDGIE_MENU_SETTINGS_DUMMY_PROPERTY
};
BudgieMenuSettings* budgie_menu_settings_new (GSettings* settings);
BudgieMenuSettings* budgie_menu_settings_construct (GType object_type, GSettings* settings);
static void budgie_menu_settings_finalize (GObject* obj);
GType budgie_menu_window_get_type (void) G_GNUC_CONST;
GType budgie_menu_window_register_type (GTypeModule * module);
#define BUDGIE_MENU_APPLET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUDGIE_MENU_APPLET, BudgieMenuAppletPrivate))
enum  {
	BUDGIE_MENU_APPLET_DUMMY_PROPERTY,
	BUDGIE_MENU_APPLET_UUID
};
static GtkWidget* budgie_menu_applet_real_get_settings_ui (BudgieApplet* base);
const gchar* budgie_menu_applet_get_uuid (BudgieMenuApplet* self);
static gboolean budgie_menu_applet_real_supports_settings (BudgieApplet* base);
void budgie_menu_applet_on_settings_changed (BudgieMenuApplet* self, const gchar* key);
static void _budgie_menu_applet_on_settings_changed_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
BudgieMenuWindow* budgie_menu_window_new (GSettings* settings, GtkWidget* leparent);
BudgieMenuWindow* budgie_menu_window_construct (GType object_type, GSettings* settings, GtkWidget* leparent);
static gboolean __lambda13_ (BudgieMenuApplet* self, GdkEventButton* e);
static gboolean ___lambda13__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void __lambda14_ (BudgieMenuApplet* self, gint p, gint i, gint s);
static void ___lambda14__budgie_applet_panel_size_changed (BudgieApplet* _sender, gint panel_size, gint icon_size, gint small_icon_size, gpointer self);
static gboolean __lambda15_ (BudgieMenuApplet* self, GdkEventKey* e);
static gboolean ___lambda15__gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void budgie_menu_applet_real_invoke_action (BudgieApplet* base, BudgiePanelAction action);
static void budgie_menu_applet_real_update_popovers (BudgieApplet* base, BudgiePopoverManager* manager);
void budgie_menu_applet_set_uuid (BudgieMenuApplet* self, const gchar* value);
static void budgie_menu_applet_finalize (GObject* obj);
static void _vala_budgie_menu_applet_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_budgie_menu_applet_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
void peas_register_types (GTypeModule* module);


static BudgieApplet* budgie_menu_real_get_panel_widget (BudgiePlugin* base, const gchar* uuid) {
	BudgieMenu * self;
	BudgieApplet* result = NULL;
	const gchar* _tmp0_ = NULL;
	BudgieMenuApplet* _tmp1_ = NULL;
	self = (BudgieMenu*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = uuid;
	_tmp1_ = budgie_menu_applet_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	result = (BudgieApplet*) _tmp1_;
	return result;
}


BudgieMenu* budgie_menu_construct (GType object_type) {
	BudgieMenu * self = NULL;
	self = (BudgieMenu*) g_object_new (object_type, NULL);
	return self;
}


BudgieMenu* budgie_menu_new (void) {
	return budgie_menu_construct (TYPE_BUDGIE_MENU);
}


static void budgie_menu_class_init (BudgieMenuClass * klass) {
	budgie_menu_parent_class = g_type_class_peek_parent (klass);
}


static void budgie_menu_budgie_plugin_interface_init (BudgiePluginIface * iface) {
	budgie_menu_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*)(BudgiePlugin*, const gchar*)) budgie_menu_real_get_panel_widget;
}


static void budgie_menu_instance_init (BudgieMenu * self) {
}


GType budgie_menu_get_type (void) {
	return budgie_menu_type_id;
}


GType budgie_menu_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (BudgieMenuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_menu_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieMenu), 0, (GInstanceInitFunc) budgie_menu_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) budgie_menu_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	budgie_menu_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "BudgieMenu", &g_define_type_info, 0);
	g_type_module_add_interface (module, budgie_menu_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return budgie_menu_type_id;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


BudgieMenuSettings* budgie_menu_settings_construct (GType object_type, GSettings* settings) {
	BudgieMenuSettings * self = NULL;
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	GtkSwitch* _tmp3_ = NULL;
	GSettings* _tmp4_ = NULL;
	GtkSwitch* _tmp5_ = NULL;
	GSettings* _tmp6_ = NULL;
	GtkSwitch* _tmp7_ = NULL;
	GSettings* _tmp8_ = NULL;
	GtkSwitch* _tmp9_ = NULL;
	GSettings* _tmp10_ = NULL;
	GtkEntry* _tmp11_ = NULL;
	self = (BudgieMenuSettings*) g_object_new (object_type, NULL);
	_tmp0_ = settings;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	_tmp2_ = settings;
	_tmp3_ = self->priv->switch_menu_label;
	g_settings_bind (_tmp2_, "enable-menu-label", (GObject*) _tmp3_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp4_ = settings;
	_tmp5_ = self->priv->switch_menu_compact;
	g_settings_bind (_tmp4_, "menu-compact", (GObject*) _tmp5_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp6_ = settings;
	_tmp7_ = self->priv->switch_menu_headers;
	g_settings_bind (_tmp6_, "menu-headers", (GObject*) _tmp7_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp8_ = settings;
	_tmp9_ = self->priv->switch_menu_categories_hover;
	g_settings_bind (_tmp8_, "menu-categories-hover", (GObject*) _tmp9_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp10_ = settings;
	_tmp11_ = self->priv->entry_label;
	g_settings_bind (_tmp10_, "menu-label", (GObject*) _tmp11_, "text", G_SETTINGS_BIND_DEFAULT);
	return self;
}


BudgieMenuSettings* budgie_menu_settings_new (GSettings* settings) {
	return budgie_menu_settings_construct (TYPE_BUDGIE_MENU_SETTINGS, settings);
}


static void budgie_menu_settings_class_init (BudgieMenuSettingsClass * klass) {
	gint BudgieMenuSettings_private_offset;
	budgie_menu_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgieMenuSettingsPrivate));
	G_OBJECT_CLASS (klass)->finalize = budgie_menu_settings_finalize;
	BudgieMenuSettings_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/solus-project/budgie-menu/settings.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_menu_label", FALSE, BudgieMenuSettings_private_offset + G_STRUCT_OFFSET (BudgieMenuSettingsPrivate, switch_menu_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_menu_compact", FALSE, BudgieMenuSettings_private_offset + G_STRUCT_OFFSET (BudgieMenuSettingsPrivate, switch_menu_compact));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_menu_headers", FALSE, BudgieMenuSettings_private_offset + G_STRUCT_OFFSET (BudgieMenuSettingsPrivate, switch_menu_headers));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_menu_categories_hover", FALSE, BudgieMenuSettings_private_offset + G_STRUCT_OFFSET (BudgieMenuSettingsPrivate, switch_menu_categories_hover));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "entry_label", FALSE, BudgieMenuSettings_private_offset + G_STRUCT_OFFSET (BudgieMenuSettingsPrivate, entry_label));
}


static void budgie_menu_settings_instance_init (BudgieMenuSettings * self) {
	self->priv = BUDGIE_MENU_SETTINGS_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void budgie_menu_settings_finalize (GObject* obj) {
	BudgieMenuSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BUDGIE_MENU_SETTINGS, BudgieMenuSettings);
	_g_object_unref0 (self->priv->switch_menu_label);
	_g_object_unref0 (self->priv->switch_menu_compact);
	_g_object_unref0 (self->priv->switch_menu_headers);
	_g_object_unref0 (self->priv->switch_menu_categories_hover);
	_g_object_unref0 (self->priv->entry_label);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (budgie_menu_settings_parent_class)->finalize (obj);
}


GType budgie_menu_settings_get_type (void) {
	return budgie_menu_settings_type_id;
}


GType budgie_menu_settings_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (BudgieMenuSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_menu_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieMenuSettings), 0, (GInstanceInitFunc) budgie_menu_settings_instance_init, NULL };
	budgie_menu_settings_type_id = g_type_module_register_type (module, gtk_grid_get_type (), "BudgieMenuSettings", &g_define_type_info, 0);
	return budgie_menu_settings_type_id;
}


static GtkWidget* budgie_menu_applet_real_get_settings_ui (BudgieApplet* base) {
	BudgieMenuApplet * self;
	GtkWidget* result = NULL;
	const gchar* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	BudgieMenuSettings* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	self = (BudgieMenuApplet*) base;
	_tmp0_ = self->priv->_uuid;
	_tmp1_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = budgie_menu_settings_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = (GtkWidget*) _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}


static gboolean budgie_menu_applet_real_supports_settings (BudgieApplet* base) {
	BudgieMenuApplet * self;
	gboolean result = FALSE;
	self = (BudgieMenuApplet*) base;
	result = TRUE;
	return result;
}


static void _budgie_menu_applet_on_settings_changed_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	budgie_menu_applet_on_settings_changed ((BudgieMenuApplet*) self, key);
}


static gboolean __lambda13_ (BudgieMenuApplet* self, GdkEventButton* e) {
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	BudgieMenuWindow* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = e;
	_tmp1_ = _tmp0_->button;
	if (_tmp1_ != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp2_ = self->popover;
	_tmp3_ = gtk_widget_get_visible ((GtkWidget*) _tmp2_);
	if (_tmp3_) {
		BudgieMenuWindow* _tmp4_ = NULL;
		_tmp4_ = self->popover;
		gtk_widget_hide ((GtkWidget*) _tmp4_);
	} else {
		BudgieMenuWindow* _tmp5_ = NULL;
		GtkWidget* _tmp6_ = NULL;
		BudgiePopoverManager* _tmp7_ = NULL;
		GtkToggleButton* _tmp8_ = NULL;
		_tmp5_ = self->popover;
		_tmp6_ = gtk_bin_get_child ((GtkBin*) _tmp5_);
		gtk_widget_show_all (_tmp6_);
		_tmp7_ = self->priv->manager;
		_tmp8_ = self->widget;
		budgie_popover_manager_show_popover (_tmp7_, (GtkWidget*) _tmp8_);
	}
	result = GDK_EVENT_STOP;
	return result;
}


static gboolean ___lambda13__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = __lambda13_ ((BudgieMenuApplet*) self, event);
	return result;
}


static void __lambda14_ (BudgieMenuApplet* self, gint p, gint i, gint s) {
	GtkImage* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	_tmp0_ = self->priv->img;
	_tmp1_ = i;
	gtk_image_set_pixel_size (_tmp0_, (gint) _tmp1_);
}


static void ___lambda14__budgie_applet_panel_size_changed (BudgieApplet* _sender, gint panel_size, gint icon_size, gint small_icon_size, gpointer self) {
	__lambda14_ ((BudgieMenuApplet*) self, panel_size, icon_size, small_icon_size);
}


static gboolean __lambda15_ (BudgieMenuApplet* self, GdkEventKey* e) {
	gboolean result = FALSE;
	GdkEventKey* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = e;
	_tmp1_ = _tmp0_->keyval;
	if (_tmp1_ == ((guint) GDK_KEY_Escape)) {
		BudgieMenuWindow* _tmp2_ = NULL;
		_tmp2_ = self->popover;
		gtk_widget_hide ((GtkWidget*) _tmp2_);
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static gboolean ___lambda15__gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = __lambda15_ ((BudgieMenuApplet*) self, event);
	return result;
}


BudgieMenuApplet* budgie_menu_applet_construct (GType object_type, const gchar* uuid) {
	BudgieMenuApplet * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	GSettings* _tmp3_ = NULL;
	GtkToggleButton* _tmp4_ = NULL;
	GtkToggleButton* _tmp5_ = NULL;
	GtkImage* _tmp6_ = NULL;
	GtkImage* _tmp7_ = NULL;
	GtkImage* _tmp8_ = NULL;
	GtkBox* layout = NULL;
	GtkBox* _tmp9_ = NULL;
	GtkImage* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkToggleButton* _tmp14_ = NULL;
	GtkStyleContext* st = NULL;
	GtkToggleButton* _tmp15_ = NULL;
	GtkStyleContext* _tmp16_ = NULL;
	GtkStyleContext* _tmp17_ = NULL;
	GSettings* _tmp18_ = NULL;
	GtkToggleButton* _tmp19_ = NULL;
	BudgieMenuWindow* _tmp20_ = NULL;
	BudgieMenuWindow* _tmp21_ = NULL;
	GtkToggleButton* _tmp22_ = NULL;
	GtkToggleButton* _tmp23_ = NULL;
	BudgieMenuWindow* _tmp24_ = NULL;
	GtkWidget* _tmp25_ = NULL;
	GtkToggleButton* _tmp26_ = NULL;
	BudgieMenuWindow* _tmp27_ = NULL;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = uuid;
	self = (BudgieMenuApplet*) g_object_new (object_type, "uuid", _tmp0_, NULL);
	budgie_applet_set_settings_schema ((BudgieApplet*) self, "com.solus-project.budgie-menu");
	budgie_applet_set_settings_prefix ((BudgieApplet*) self, "/com/solus-project/budgie-panel/instance/budgie-menu");
	_tmp1_ = uuid;
	_tmp2_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, _tmp1_);
	_g_object_unref0 (self->settings);
	self->settings = _tmp2_;
	_tmp3_ = self->settings;
	g_signal_connect_object (_tmp3_, "changed", (GCallback) _budgie_menu_applet_on_settings_changed_g_settings_changed, self, 0);
	_tmp4_ = (GtkToggleButton*) gtk_toggle_button_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->widget);
	self->widget = _tmp4_;
	_tmp5_ = self->widget;
	gtk_button_set_relief ((GtkButton*) _tmp5_, GTK_RELIEF_NONE);
	_tmp6_ = (GtkImage*) gtk_image_new_from_icon_name ("view-grid-symbolic", GTK_ICON_SIZE_INVALID);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->img);
	self->priv->img = _tmp6_;
	_tmp7_ = self->priv->img;
	gtk_image_set_pixel_size (_tmp7_, 32);
	_tmp8_ = self->priv->img;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp8_, TRUE);
	_tmp9_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp9_);
	layout = _tmp9_;
	_tmp10_ = self->priv->img;
	gtk_box_pack_start (layout, (GtkWidget*) _tmp10_, FALSE, FALSE, (guint) 3);
	_tmp11_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->label);
	self->priv->label = _tmp11_;
	_tmp12_ = self->priv->label;
	gtk_widget_set_halign ((GtkWidget*) _tmp12_, GTK_ALIGN_START);
	_tmp13_ = self->priv->label;
	gtk_box_pack_start (layout, (GtkWidget*) _tmp13_, TRUE, TRUE, (guint) 3);
	_tmp14_ = self->widget;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) layout);
	_tmp15_ = self->widget;
	_tmp16_ = gtk_widget_get_style_context ((GtkWidget*) _tmp15_);
	_tmp17_ = _g_object_ref0 (_tmp16_);
	st = _tmp17_;
	gtk_style_context_add_class (st, "budgie-menu-launcher");
	gtk_style_context_add_class (st, "panel-button");
	_tmp18_ = self->settings;
	_tmp19_ = self->widget;
	_tmp20_ = budgie_menu_window_new (_tmp18_, (GtkWidget*) _tmp19_);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->popover);
	self->popover = _tmp20_;
	_tmp21_ = self->popover;
	_tmp22_ = self->widget;
	g_object_bind_property_with_closures ((GObject*) _tmp21_, "visible", (GObject*) _tmp22_, "active", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp23_ = self->widget;
	g_signal_connect_object ((GtkWidget*) _tmp23_, "button-press-event", (GCallback) ___lambda13__gtk_widget_button_press_event, self, 0);
	_tmp24_ = self->popover;
	_tmp25_ = gtk_bin_get_child ((GtkBin*) _tmp24_);
	gtk_widget_show_all (_tmp25_);
	g_object_set ((BudgieApplet*) self, "supported-actions", BUDGIE_PANEL_ACTION_MENU, NULL);
	_tmp26_ = self->widget;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp26_);
	gtk_widget_show_all ((GtkWidget*) self);
	gtk_widget_set_valign ((GtkWidget*) layout, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_FILL);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_FILL);
	budgie_menu_applet_on_settings_changed (self, "enable-menu-label");
	budgie_menu_applet_on_settings_changed (self, "menu-icon");
	budgie_menu_applet_on_settings_changed (self, "menu-label");
	g_signal_connect_object ((BudgieApplet*) self, "panel-size-changed", (GCallback) ___lambda14__budgie_applet_panel_size_changed, self, 0);
	_tmp27_ = self->popover;
	g_signal_connect_object ((GtkWidget*) _tmp27_, "key-release-event", (GCallback) ___lambda15__gtk_widget_key_release_event, self, 0);
	_g_object_unref0 (st);
	_g_object_unref0 (layout);
	return self;
}


BudgieMenuApplet* budgie_menu_applet_new (const gchar* uuid) {
	return budgie_menu_applet_construct (TYPE_BUDGIE_MENU_APPLET, uuid);
}


static void budgie_menu_applet_real_invoke_action (BudgieApplet* base, BudgiePanelAction action) {
	BudgieMenuApplet * self;
	BudgiePanelAction _tmp0_ = 0;
	self = (BudgieMenuApplet*) base;
	_tmp0_ = action;
	if ((_tmp0_ & BUDGIE_PANEL_ACTION_MENU) != 0) {
		BudgieMenuWindow* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		_tmp1_ = self->popover;
		_tmp2_ = gtk_widget_get_visible ((GtkWidget*) _tmp1_);
		if (_tmp2_) {
			BudgieMenuWindow* _tmp3_ = NULL;
			_tmp3_ = self->popover;
			gtk_widget_hide ((GtkWidget*) _tmp3_);
		} else {
			BudgieMenuWindow* _tmp4_ = NULL;
			GtkWidget* _tmp5_ = NULL;
			BudgiePopoverManager* _tmp6_ = NULL;
			GtkToggleButton* _tmp7_ = NULL;
			_tmp4_ = self->popover;
			_tmp5_ = gtk_bin_get_child ((GtkBin*) _tmp4_);
			gtk_widget_show_all (_tmp5_);
			_tmp6_ = self->priv->manager;
			_tmp7_ = self->widget;
			budgie_popover_manager_show_popover (_tmp6_, (GtkWidget*) _tmp7_);
		}
	}
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


void budgie_menu_applet_on_settings_changed (BudgieMenuApplet* self, const gchar* key) {
	gboolean should_show = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	should_show = TRUE;
	_tmp0_ = key;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("menu-icon")))) {
		switch (0) {
			default:
			{
				gchar* icon = NULL;
				GSettings* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				GtkImage* _tmp18_ = NULL;
				gboolean _tmp19_ = FALSE;
				_tmp4_ = self->settings;
				_tmp5_ = key;
				_tmp6_ = g_settings_get_string (_tmp4_, _tmp5_);
				icon = _tmp6_;
				_tmp7_ = icon;
				_tmp8_ = string_contains (_tmp7_, "/");
				if (_tmp8_) {
					GdkPixbuf* pixbuf = NULL;
					const gchar* _tmp9_ = NULL;
					GdkPixbuf* _tmp10_ = NULL;
					GtkImage* _tmp11_ = NULL;
					GdkPixbuf* _tmp12_ = NULL;
					GdkPixbuf* _tmp13_ = NULL;
					GdkPixbuf* _tmp14_ = NULL;
					_tmp9_ = icon;
					_tmp10_ = gdk_pixbuf_new_from_file (_tmp9_, &_inner_error_);
					pixbuf = _tmp10_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_free0 (icon);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp11_ = self->priv->img;
					_tmp12_ = pixbuf;
					_tmp13_ = gdk_pixbuf_scale_simple (_tmp12_, 32, 32, GDK_INTERP_BILINEAR);
					_tmp14_ = _tmp13_;
					gtk_image_set_from_pixbuf (_tmp11_, _tmp14_);
					_g_object_unref0 (_tmp14_);
					_g_object_unref0 (pixbuf);
				} else {
					const gchar* _tmp15_ = NULL;
					_tmp15_ = icon;
					if (g_strcmp0 (_tmp15_, "") == 0) {
						should_show = FALSE;
					} else {
						GtkImage* _tmp16_ = NULL;
						const gchar* _tmp17_ = NULL;
						_tmp16_ = self->priv->img;
						_tmp17_ = icon;
						gtk_image_set_from_icon_name (_tmp16_, _tmp17_, GTK_ICON_SIZE_INVALID);
					}
				}
				_tmp18_ = self->priv->img;
				_tmp19_ = should_show;
				gtk_widget_set_visible ((GtkWidget*) _tmp18_, _tmp19_);
				_g_free0 (icon);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("menu-label")))) {
		switch (0) {
			default:
			{
				GtkLabel* _tmp20_ = NULL;
				GSettings* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				_tmp20_ = self->priv->label;
				_tmp21_ = self->settings;
				_tmp22_ = key;
				_tmp23_ = g_settings_get_string (_tmp21_, _tmp22_);
				_tmp24_ = _tmp23_;
				gtk_label_set_label (_tmp20_, _tmp24_);
				_g_free0 (_tmp24_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("enable-menu-label")))) {
		switch (0) {
			default:
			{
				GtkLabel* _tmp25_ = NULL;
				GSettings* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				gboolean _tmp28_ = FALSE;
				_tmp25_ = self->priv->label;
				_tmp26_ = self->settings;
				_tmp27_ = key;
				_tmp28_ = g_settings_get_boolean (_tmp26_, _tmp27_);
				gtk_widget_set_visible ((GtkWidget*) _tmp25_, _tmp28_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
}


static void budgie_menu_applet_real_update_popovers (BudgieApplet* base, BudgiePopoverManager* manager) {
	BudgieMenuApplet * self;
	BudgiePopoverManager* _tmp0_ = NULL;
	BudgiePopoverManager* _tmp1_ = NULL;
	GtkToggleButton* _tmp2_ = NULL;
	BudgieMenuWindow* _tmp3_ = NULL;
	self = (BudgieMenuApplet*) base;
	_tmp0_ = manager;
	self->priv->manager = _tmp0_;
	_tmp1_ = manager;
	_tmp2_ = self->widget;
	_tmp3_ = self->popover;
	budgie_popover_manager_register_popover (_tmp1_, (GtkWidget*) _tmp2_, (GtkPopover*) _tmp3_);
}


const gchar* budgie_menu_applet_get_uuid (BudgieMenuApplet* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uuid;
	result = _tmp0_;
	return result;
}


void budgie_menu_applet_set_uuid (BudgieMenuApplet* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_uuid);
	self->priv->_uuid = _tmp1_;
	g_object_notify ((GObject *) self, "uuid");
}


static void budgie_menu_applet_class_init (BudgieMenuAppletClass * klass) {
	budgie_menu_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgieMenuAppletPrivate));
	((BudgieAppletClass *) klass)->get_settings_ui = budgie_menu_applet_real_get_settings_ui;
	((BudgieAppletClass *) klass)->supports_settings = budgie_menu_applet_real_supports_settings;
	((BudgieAppletClass *) klass)->invoke_action = budgie_menu_applet_real_invoke_action;
	((BudgieAppletClass *) klass)->update_popovers = budgie_menu_applet_real_update_popovers;
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_menu_applet_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_menu_applet_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_menu_applet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_MENU_APPLET_UUID, g_param_spec_string ("uuid", "uuid", "uuid", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void budgie_menu_applet_instance_init (BudgieMenuApplet * self) {
	self->priv = BUDGIE_MENU_APPLET_GET_PRIVATE (self);
	self->priv->manager = NULL;
}


static void budgie_menu_applet_finalize (GObject* obj) {
	BudgieMenuApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BUDGIE_MENU_APPLET, BudgieMenuApplet);
	_g_object_unref0 (self->widget);
	_g_object_unref0 (self->popover);
	_g_object_unref0 (self->settings);
	_g_object_unref0 (self->priv->img);
	_g_object_unref0 (self->priv->label);
	_g_free0 (self->priv->_uuid);
	G_OBJECT_CLASS (budgie_menu_applet_parent_class)->finalize (obj);
}


GType budgie_menu_applet_get_type (void) {
	return budgie_menu_applet_type_id;
}


GType budgie_menu_applet_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (BudgieMenuAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_menu_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieMenuApplet), 0, (GInstanceInitFunc) budgie_menu_applet_instance_init, NULL };
	budgie_menu_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "BudgieMenuApplet", &g_define_type_info, 0);
	return budgie_menu_applet_type_id;
}


static void _vala_budgie_menu_applet_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BudgieMenuApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BUDGIE_MENU_APPLET, BudgieMenuApplet);
	switch (property_id) {
		case BUDGIE_MENU_APPLET_UUID:
		g_value_set_string (value, budgie_menu_applet_get_uuid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_budgie_menu_applet_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BudgieMenuApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BUDGIE_MENU_APPLET, BudgieMenuApplet);
	switch (property_id) {
		case BUDGIE_MENU_APPLET_UUID:
		budgie_menu_applet_set_uuid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


void peas_register_types (GTypeModule* module) {
	PeasObjectModule* objmodule = NULL;
	GTypeModule* _tmp0_ = NULL;
	PeasObjectModule* _tmp1_ = NULL;
	g_return_if_fail (module != NULL);
	budgie_menu_register_type (module);
	budgie_menu_settings_register_type (module);
	budgie_menu_applet_register_type (module);
	category_button_register_type (module);
	menu_button_register_type (module);
	budgie_menu_window_register_type (module);
	_tmp0_ = module;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, peas_object_module_get_type ()) ? ((PeasObjectModule*) _tmp0_) : NULL);
	objmodule = _tmp1_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), TYPE_BUDGIE_MENU);
	_g_object_unref0 (objmodule);
}



