/* osd.c generated by valac 0.32.1, the Vala compiler
 * generated from osd.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define BUDGIE_TYPE_OSD (budgie_osd_get_type ())
#define BUDGIE_OSD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_OSD, BudgieOSD))
#define BUDGIE_OSD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_OSD, BudgieOSDClass))
#define BUDGIE_IS_OSD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_OSD))
#define BUDGIE_IS_OSD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_OSD))
#define BUDGIE_OSD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_OSD, BudgieOSDClass))

typedef struct _BudgieOSD BudgieOSD;
typedef struct _BudgieOSDClass BudgieOSDClass;
typedef struct _BudgieOSDPrivate BudgieOSDPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define BUDGIE_TYPE_OSD_MANAGER (budgie_osd_manager_get_type ())
#define BUDGIE_OSD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_OSD_MANAGER, BudgieOSDManager))
#define BUDGIE_OSD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_OSD_MANAGER, BudgieOSDManagerClass))
#define BUDGIE_IS_OSD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_OSD_MANAGER))
#define BUDGIE_IS_OSD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_OSD_MANAGER))
#define BUDGIE_OSD_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_OSD_MANAGER, BudgieOSDManagerClass))

typedef struct _BudgieOSDManager BudgieOSDManager;
typedef struct _BudgieOSDManagerClass BudgieOSDManagerClass;
typedef struct _BudgieOSDManagerPrivate BudgieOSDManagerPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BudgieParamSpecOSDManager BudgieParamSpecOSDManager;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _BudgieOSD {
	GtkWindow parent_instance;
	BudgieOSDPrivate * priv;
};

struct _BudgieOSDClass {
	GtkWindowClass parent_class;
};

struct _BudgieOSDPrivate {
	GtkLabel* label_title;
	GtkImage* image_icon;
	GtkProgressBar* progressbar;
	gint primary_monitor;
};

struct _BudgieOSDManager {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BudgieOSDManagerPrivate * priv;
};

struct _BudgieOSDManagerClass {
	GTypeClass parent_class;
	void (*finalize) (BudgieOSDManager *self);
};

struct _BudgieOSDManagerPrivate {
	BudgieOSD* osd_window;
	guint32 expire_timeout;
};

struct _BudgieParamSpecOSDManager {
	GParamSpec parent_instance;
};


static gpointer budgie_osd_parent_class = NULL;
static gpointer budgie_osd_manager_parent_class = NULL;

#define BUDGIE_OSD_SIZE 350
#define BUDGIE_OSD_EXPIRE_TIME 2500
#define BUDGIE_OSD_DBUS_NAME "com.solus_project.BudgieOSD"
#define BUDGIE_OSD_DBUS_OBJECT_PATH "/com/solus_project/BudgieOSD"
GType budgie_osd_get_type (void) G_GNUC_CONST;
#define BUDGIE_OSD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_OSD, BudgieOSDPrivate))
enum  {
	BUDGIE_OSD_DUMMY_PROPERTY,
	BUDGIE_OSD_OSD_TITLE,
	BUDGIE_OSD_OSD_ICON,
	BUDGIE_OSD_OSD_PROGRESS
};
BudgieOSD* budgie_osd_new (void);
BudgieOSD* budgie_osd_construct (GType object_type);
static void budgie_osd_on_monitors_changed (BudgieOSD* self);
static void _budgie_osd_on_monitors_changed_gdk_screen_monitors_changed (GdkScreen* _sender, gpointer self);
void budgie_osd_set_osd_title (BudgieOSD* self, const gchar* value);
void budgie_osd_set_osd_icon (BudgieOSD* self, const gchar* value);
void budgie_osd_set_osd_progress (BudgieOSD* self, gint32 value);
void budgie_osd_move_osd (BudgieOSD* self);
gchar* budgie_osd_get_osd_title (BudgieOSD* self);
gchar* budgie_osd_get_osd_icon (BudgieOSD* self);
gint32 budgie_osd_get_osd_progress (BudgieOSD* self);
static void budgie_osd_finalize (GObject* obj);
static void _vala_budgie_osd_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_budgie_osd_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
gpointer budgie_osd_manager_ref (gpointer instance);
void budgie_osd_manager_unref (gpointer instance);
GParamSpec* budgie_param_spec_osd_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void budgie_value_set_osd_manager (GValue* value, gpointer v_object);
void budgie_value_take_osd_manager (GValue* value, gpointer v_object);
gpointer budgie_value_get_osd_manager (const GValue* value);
GType budgie_osd_manager_get_type (void) G_GNUC_CONST;
guint budgie_osd_manager_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
#define BUDGIE_OSD_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_OSD_MANAGER, BudgieOSDManagerPrivate))
enum  {
	BUDGIE_OSD_MANAGER_DUMMY_PROPERTY
};
BudgieOSDManager* budgie_osd_manager_new (void);
BudgieOSDManager* budgie_osd_manager_construct (GType object_type);
void budgie_osd_manager_setup_dbus (BudgieOSDManager* self);
static void budgie_osd_manager_on_bus_acquired (BudgieOSDManager* self, GDBusConnection* conn);
static void _budgie_osd_manager_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void __lambda5_ (BudgieOSDManager* self);
static void ___lambda5__gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void __lambda6_ (BudgieOSDManager* self);
static void ___lambda6__gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self);
void budgie_osd_manager_ShowOSD (BudgieOSDManager* self, GHashTable* params);
static void budgie_osd_manager_reset_osd_expire (BudgieOSDManager* self, gint timeout_length);
static gboolean budgie_osd_manager_osd_expire (BudgieOSDManager* self);
static gboolean _budgie_osd_manager_osd_expire_gsource_func (gpointer self);
static void budgie_osd_manager_finalize (BudgieOSDManager* obj);
static void _dbus_budgie_osd_manager_ShowOSD (BudgieOSDManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void budgie_osd_manager_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* budgie_osd_manager_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean budgie_osd_manager_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _budgie_osd_manager_unregister_object (gpointer user_data);

static const GDBusArgInfo _budgie_osd_manager_dbus_arg_info_ShowOSD_params = {-1, "params", "a{sv}"};
static const GDBusArgInfo * const _budgie_osd_manager_dbus_arg_info_ShowOSD_in[] = {&_budgie_osd_manager_dbus_arg_info_ShowOSD_params, NULL};
static const GDBusArgInfo * const _budgie_osd_manager_dbus_arg_info_ShowOSD_out[] = {NULL};
static const GDBusMethodInfo _budgie_osd_manager_dbus_method_info_ShowOSD = {-1, "ShowOSD", (GDBusArgInfo **) (&_budgie_osd_manager_dbus_arg_info_ShowOSD_in), (GDBusArgInfo **) (&_budgie_osd_manager_dbus_arg_info_ShowOSD_out)};
static const GDBusMethodInfo * const _budgie_osd_manager_dbus_method_info[] = {&_budgie_osd_manager_dbus_method_info_ShowOSD, NULL};
static const GDBusSignalInfo * const _budgie_osd_manager_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_osd_manager_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_osd_manager_dbus_interface_info = {-1, "com.solus_project.BudgieOSD", (GDBusMethodInfo **) (&_budgie_osd_manager_dbus_method_info), (GDBusSignalInfo **) (&_budgie_osd_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_osd_manager_dbus_property_info)};
static const GDBusInterfaceVTable _budgie_osd_manager_dbus_interface_vtable = {budgie_osd_manager_dbus_interface_method_call, budgie_osd_manager_dbus_interface_get_property, budgie_osd_manager_dbus_interface_set_property};

/**
     * Construct a new BudgieOSD widget
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _budgie_osd_on_monitors_changed_gdk_screen_monitors_changed (GdkScreen* _sender, gpointer self) {
	budgie_osd_on_monitors_changed ((BudgieOSD*) self);
}


BudgieOSD* budgie_osd_construct (GType object_type) {
	BudgieOSD * self = NULL;
	GdkVisual* vis = NULL;
	GdkScreen* _tmp0_ = NULL;
	GdkScreen* _tmp1_ = NULL;
	GdkVisual* _tmp2_ = NULL;
	GdkVisual* _tmp3_ = NULL;
	GdkVisual* _tmp4_ = NULL;
	GdkScreen* _tmp6_ = NULL;
	GdkScreen* _tmp7_ = NULL;
	GtkWidget* _tmp8_ = NULL;
	self = (BudgieOSD*) g_object_new (object_type, "type", GTK_WINDOW_POPUP, "type-hint", GDK_WINDOW_TYPE_HINT_NOTIFICATION, NULL);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	gtk_window_set_skip_pager_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_decorated ((GtkWindow*) self, FALSE);
	gtk_window_set_keep_above ((GtkWindow*) self, TRUE);
	gtk_window_stick ((GtkWindow*) self);
	_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gdk_screen_get_rgba_visual (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	vis = _tmp3_;
	_tmp4_ = vis;
	if (_tmp4_ != NULL) {
		GdkVisual* _tmp5_ = NULL;
		_tmp5_ = vis;
		gtk_widget_set_visual ((GtkWidget*) self, _tmp5_);
	}
	_tmp6_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp7_ = _tmp6_;
	g_signal_connect_object (_tmp7_, "monitors-changed", (GCallback) _budgie_osd_on_monitors_changed_gdk_screen_monitors_changed, self, 0);
	gtk_window_set_default_size ((GtkWindow*) self, BUDGIE_OSD_SIZE, -1);
	gtk_widget_realize ((GtkWidget*) self);
	budgie_osd_set_osd_title (self, NULL);
	budgie_osd_set_osd_icon (self, NULL);
	budgie_osd_set_osd_progress (self, (gint32) -1);
	_tmp8_ = gtk_bin_get_child ((GtkBin*) self);
	gtk_widget_show_all (_tmp8_);
	budgie_osd_on_monitors_changed (self);
	_g_object_unref0 (vis);
	return self;
}


BudgieOSD* budgie_osd_new (void) {
	return budgie_osd_construct (BUDGIE_TYPE_OSD);
}


/**
     * Monitors changed, find out the primary monitor, and schedule move of OSD
     */
static void budgie_osd_on_monitors_changed (BudgieOSD* self) {
	GdkScreen* _tmp0_ = NULL;
	GdkScreen* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gdk_screen_get_primary_monitor (_tmp1_);
	self->priv->primary_monitor = _tmp2_;
	budgie_osd_move_osd (self);
}


/**
     * Move the OSD into the correct position
     */
void budgie_osd_move_osd (BudgieOSD* self) {
	GdkScreen* sc = NULL;
	GdkScreen* _tmp0_ = NULL;
	GdkScreen* _tmp1_ = NULL;
	GdkRectangle bounds = {0};
	gint _tmp2_ = 0;
	GdkRectangle _tmp3_ = {0};
	GtkAllocation alloc = {0};
	GtkWidget* _tmp4_ = NULL;
	GtkAllocation _tmp5_ = {0};
	gint x = 0;
	GdkRectangle _tmp6_ = {0};
	gint _tmp7_ = 0;
	GdkRectangle _tmp8_ = {0};
	gint _tmp9_ = 0;
	GtkAllocation _tmp10_ = {0};
	gint _tmp11_ = 0;
	gint y = 0;
	GdkRectangle _tmp12_ = {0};
	gint _tmp13_ = 0;
	GdkRectangle _tmp14_ = {0};
	gint _tmp15_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	sc = _tmp1_;
	_tmp2_ = self->priv->primary_monitor;
	gdk_screen_get_monitor_geometry (sc, _tmp2_, &_tmp3_);
	bounds = _tmp3_;
	_tmp4_ = gtk_bin_get_child ((GtkBin*) self);
	gtk_widget_get_allocation (_tmp4_, &_tmp5_);
	alloc = _tmp5_;
	_tmp6_ = bounds;
	_tmp7_ = _tmp6_.x;
	_tmp8_ = bounds;
	_tmp9_ = _tmp8_.width;
	_tmp10_ = alloc;
	_tmp11_ = _tmp10_.width;
	x = _tmp7_ + ((_tmp9_ / 2) - (_tmp11_ / 2));
	_tmp12_ = bounds;
	_tmp13_ = _tmp12_.y;
	_tmp14_ = bounds;
	_tmp15_ = _tmp14_.height;
	y = _tmp13_ + ((gint) (_tmp15_ * 0.85));
	gtk_window_move ((GtkWindow*) self, x, y);
	_g_object_unref0 (sc);
}


gchar* budgie_osd_get_osd_title (BudgieOSD* self) {
	gchar* result;
	GtkLabel* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkLabel* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->label_title;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	if (!_tmp1_) {
		result = NULL;
		return result;
	}
	_tmp2_ = self->priv->label_title;
	_tmp3_ = gtk_label_get_label (_tmp2_);
	_tmp4_ = g_strdup (_tmp3_);
	result = _tmp4_;
	return result;
}


void budgie_osd_set_osd_title (BudgieOSD* self, const gchar* value) {
	gchar* r = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	r = _tmp1_;
	_tmp2_ = r;
	if (_tmp2_ == NULL) {
		GtkLabel* _tmp3_ = NULL;
		_tmp3_ = self->priv->label_title;
		gtk_widget_set_visible ((GtkWidget*) _tmp3_, FALSE);
	} else {
		GtkLabel* _tmp4_ = NULL;
		GtkLabel* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp4_ = self->priv->label_title;
		gtk_widget_set_visible ((GtkWidget*) _tmp4_, TRUE);
		_tmp5_ = self->priv->label_title;
		_tmp6_ = r;
		gtk_label_set_markup (_tmp5_, _tmp6_);
	}
	_g_free0 (r);
	g_object_notify ((GObject *) self, "osd-title");
}


gchar* budgie_osd_get_osd_icon (BudgieOSD* self) {
	gchar* result;
	GtkImage* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* ret = NULL;
	GtkIconSize _icon_size = 0;
	GtkImage* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkIconSize _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->image_icon;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	if (!_tmp1_) {
		result = NULL;
		return result;
	}
	_tmp2_ = self->priv->image_icon;
	gtk_image_get_icon_name (_tmp2_, &_tmp3_, &_tmp4_);
	_g_free0 (ret);
	_tmp5_ = g_strdup (_tmp3_);
	ret = _tmp5_;
	_icon_size = _tmp4_;
	result = ret;
	return result;
}


void budgie_osd_set_osd_icon (BudgieOSD* self, const gchar* value) {
	gchar* r = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	r = _tmp1_;
	_tmp2_ = r;
	if (_tmp2_ == NULL) {
		GtkImage* _tmp3_ = NULL;
		_tmp3_ = self->priv->image_icon;
		gtk_widget_set_visible ((GtkWidget*) _tmp3_, FALSE);
	} else {
		GtkImage* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GtkImage* _tmp6_ = NULL;
		GtkImage* _tmp7_ = NULL;
		_tmp4_ = self->priv->image_icon;
		_tmp5_ = r;
		gtk_image_set_from_icon_name (_tmp4_, _tmp5_, GTK_ICON_SIZE_INVALID);
		_tmp6_ = self->priv->image_icon;
		gtk_image_set_pixel_size (_tmp6_, 48);
		_tmp7_ = self->priv->image_icon;
		gtk_widget_set_visible ((GtkWidget*) _tmp7_, TRUE);
	}
	_g_free0 (r);
	g_object_notify ((GObject *) self, "osd-icon");
}


gint32 budgie_osd_get_osd_progress (BudgieOSD* self) {
	gint32 result;
	GtkProgressBar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->progressbar;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	if (!_tmp1_) {
		result = (gint32) -1;
		return result;
	} else {
		GtkProgressBar* _tmp2_ = NULL;
		gdouble _tmp3_ = 0.0;
		_tmp2_ = self->priv->progressbar;
		_tmp3_ = gtk_progress_bar_get_fraction (_tmp2_);
		result = (gint32) (_tmp3_ * 100);
		return result;
	}
}


void budgie_osd_set_osd_progress (BudgieOSD* self, gint32 value) {
	gint32 v = 0;
	gint32 _tmp0_ = 0;
	gint32 _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	v = _tmp0_;
	_tmp1_ = v;
	if (_tmp1_ < ((gint32) 0)) {
		GtkProgressBar* _tmp2_ = NULL;
		_tmp2_ = self->priv->progressbar;
		gtk_widget_set_visible ((GtkWidget*) _tmp2_, FALSE);
	} else {
		gdouble fraction = 0.0;
		gint32 _tmp3_ = 0;
		gint32 _tmp4_ = 0;
		GtkProgressBar* _tmp5_ = NULL;
		gdouble _tmp6_ = 0.0;
		GtkProgressBar* _tmp7_ = NULL;
		_tmp3_ = v;
		_tmp4_ = CLAMP (_tmp3_, (gint32) 0, (gint32) 100);
		fraction = _tmp4_ / 100.0;
		_tmp5_ = self->priv->progressbar;
		_tmp6_ = fraction;
		gtk_progress_bar_set_fraction (_tmp5_, _tmp6_);
		_tmp7_ = self->priv->progressbar;
		gtk_widget_set_visible ((GtkWidget*) _tmp7_, TRUE);
	}
	g_object_notify ((GObject *) self, "osd-progress");
}


static void budgie_osd_class_init (BudgieOSDClass * klass) {
	gint BudgieOSD_private_offset;
	budgie_osd_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgieOSDPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_osd_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_osd_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_osd_finalize;
	/**
	     * Current text to display. NULL hides the widget.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_OSD_OSD_TITLE, g_param_spec_string ("osd-title", "osd-title", "osd-title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Current icon to display. NULL hides the widget
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_OSD_OSD_ICON, g_param_spec_string ("osd-icon", "osd-icon", "osd-icon", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Current value for the progressbar. Values less than 1 hide the bar
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_OSD_OSD_PROGRESS, g_param_spec_int ("osd-progress", "osd-progress", "osd-progress", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	BudgieOSD_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/solus-project/budgie/daemon/osd.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_title", FALSE, BudgieOSD_private_offset + G_STRUCT_OFFSET (BudgieOSDPrivate, label_title));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "image_icon", FALSE, BudgieOSD_private_offset + G_STRUCT_OFFSET (BudgieOSDPrivate, image_icon));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "progressbar", FALSE, BudgieOSD_private_offset + G_STRUCT_OFFSET (BudgieOSDPrivate, progressbar));
}


static void budgie_osd_instance_init (BudgieOSD * self) {
	self->priv = BUDGIE_OSD_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void budgie_osd_finalize (GObject* obj) {
	BudgieOSD * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_OSD, BudgieOSD);
	_g_object_unref0 (self->priv->label_title);
	_g_object_unref0 (self->priv->image_icon);
	_g_object_unref0 (self->priv->progressbar);
	G_OBJECT_CLASS (budgie_osd_parent_class)->finalize (obj);
}


/**
 * The BudgieOSD provides a very simplistic On Screen Display service, complying with the
 * private GNOME Settings Daemon -> GNOME Shell protocol.
 *
 * In short, all elements of the permanently present window should be able to hide or show
 * depending on the updated ShowOSD message, including support for a progress bar (level),
 * icon, optional label.
 *
 * This OSD is used by gnome-settings-daemon to portray special events, such as brightness/volume
 * changes, physical volume changes (disk eject/mount), etc. This special window should remain
 * above all other windows and be non-interactive, allowing unobtrosive overlay of information
 * even in full screen movies and games.
 *
 * Each request to ShowOSD will reset the expiration timeout for the OSD's current visibility,
 * meaning subsequent requests to the OSD will keep it on screen in a natural fashion, allowing
 * users to "hold down" the volume change buttons, for example.
 */
GType budgie_osd_get_type (void) {
	static volatile gsize budgie_osd_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_osd_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieOSDClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_osd_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieOSD), 0, (GInstanceInitFunc) budgie_osd_instance_init, NULL };
		GType budgie_osd_type_id;
		budgie_osd_type_id = g_type_register_static (gtk_window_get_type (), "BudgieOSD", &g_define_type_info, 0);
		g_once_init_leave (&budgie_osd_type_id__volatile, budgie_osd_type_id);
	}
	return budgie_osd_type_id__volatile;
}


static void _vala_budgie_osd_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BudgieOSD * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_OSD, BudgieOSD);
	switch (property_id) {
		case BUDGIE_OSD_OSD_TITLE:
		g_value_take_string (value, budgie_osd_get_osd_title (self));
		break;
		case BUDGIE_OSD_OSD_ICON:
		g_value_take_string (value, budgie_osd_get_osd_icon (self));
		break;
		case BUDGIE_OSD_OSD_PROGRESS:
		g_value_set_int (value, budgie_osd_get_osd_progress (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_budgie_osd_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BudgieOSD * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_OSD, BudgieOSD);
	switch (property_id) {
		case BUDGIE_OSD_OSD_TITLE:
		budgie_osd_set_osd_title (self, g_value_get_string (value));
		break;
		case BUDGIE_OSD_OSD_ICON:
		budgie_osd_set_osd_icon (self, g_value_get_string (value));
		break;
		case BUDGIE_OSD_OSD_PROGRESS:
		budgie_osd_set_osd_progress (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


BudgieOSDManager* budgie_osd_manager_construct (GType object_type) {
	BudgieOSDManager* self = NULL;
	BudgieOSD* _tmp0_ = NULL;
	self = (BudgieOSDManager*) g_type_create_instance (object_type);
	_tmp0_ = budgie_osd_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->osd_window);
	self->priv->osd_window = _tmp0_;
	return self;
}


BudgieOSDManager* budgie_osd_manager_new (void) {
	return budgie_osd_manager_construct (BUDGIE_TYPE_OSD_MANAGER);
}


/**
     * Own the OSD_DBUS_NAME
     */
static void _budgie_osd_manager_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	budgie_osd_manager_on_bus_acquired ((BudgieOSDManager*) self, connection);
}


static void __lambda5_ (BudgieOSDManager* self) {
}


static void ___lambda5__gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	__lambda5_ ((BudgieOSDManager*) self);
}


static void __lambda6_ (BudgieOSDManager* self) {
	g_warning ("osd.vala:239: BudgieOSD could not take dbus!");
}


static void ___lambda6__gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	__lambda6_ ((BudgieOSDManager*) self);
}


void budgie_osd_manager_setup_dbus (BudgieOSDManager* self) {
	g_return_if_fail (self != NULL);
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, BUDGIE_OSD_DBUS_NAME, G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT | G_BUS_NAME_OWNER_FLAGS_REPLACE, (GClosure*) ((_budgie_osd_manager_on_bus_acquired_gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_osd_manager_on_bus_acquired_gbus_acquired_callback, budgie_osd_manager_ref (self), budgie_osd_manager_unref)), (GClosure*) ((___lambda5__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda5__gbus_name_acquired_callback, budgie_osd_manager_ref (self), budgie_osd_manager_unref)), (GClosure*) ((___lambda6__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda6__gbus_name_lost_callback, budgie_osd_manager_ref (self), budgie_osd_manager_unref)));
}


/**
     * Acquired OSD_DBUS_NAME, register ourselves on the bus
     */
static void budgie_osd_manager_on_bus_acquired (BudgieOSDManager* self, GDBusConnection* conn) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	{
		GDBusConnection* _tmp0_ = NULL;
		_tmp0_ = conn;
		budgie_osd_manager_register_object (self, _tmp0_, BUDGIE_OSD_DBUS_OBJECT_PATH, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		FILE* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = stderr;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		fprintf (_tmp1_, "Error registering BudgieOSD: %s\n", _tmp3_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
     * Show the OSD on screen with the given parameters:
     * icon: string Icon-name to use
     * label: string Text to display, if any
     * level: int32 Progress-level to display in the OSD
     * monitor: int32 The monitor to display the OSD on (currently ignored)
     */
void budgie_osd_manager_ShowOSD (BudgieOSDManager* self, GHashTable* params) {
	gchar* icon_name = NULL;
	gchar* label = NULL;
	gint32 level = 0;
	GHashTable* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GHashTable* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GHashTable* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	BudgieOSD* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	BudgieOSD* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	BudgieOSD* _tmp21_ = NULL;
	gint32 _tmp22_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (params != NULL);
	icon_name = NULL;
	label = NULL;
	level = (gint32) -1;
	_tmp0_ = params;
	_tmp1_ = g_hash_table_contains (_tmp0_, "icon");
	if (_tmp1_) {
		GHashTable* _tmp2_ = NULL;
		gconstpointer _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp2_ = params;
		_tmp3_ = g_hash_table_lookup (_tmp2_, "icon");
		_tmp4_ = g_variant_get_string ((GVariant*) _tmp3_, NULL);
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (icon_name);
		icon_name = _tmp5_;
	}
	_tmp6_ = params;
	_tmp7_ = g_hash_table_contains (_tmp6_, "label");
	if (_tmp7_) {
		GHashTable* _tmp8_ = NULL;
		gconstpointer _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp8_ = params;
		_tmp9_ = g_hash_table_lookup (_tmp8_, "label");
		_tmp10_ = g_variant_get_string ((GVariant*) _tmp9_, NULL);
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (label);
		label = _tmp11_;
	}
	_tmp12_ = params;
	_tmp13_ = g_hash_table_contains (_tmp12_, "level");
	if (_tmp13_) {
		GHashTable* _tmp14_ = NULL;
		gconstpointer _tmp15_ = NULL;
		gint32 _tmp16_ = 0;
		_tmp14_ = params;
		_tmp15_ = g_hash_table_lookup (_tmp14_, "level");
		_tmp16_ = g_variant_get_int32 ((GVariant*) _tmp15_);
		level = _tmp16_;
	}
	_tmp17_ = self->priv->osd_window;
	_tmp18_ = label;
	budgie_osd_set_osd_title (_tmp17_, _tmp18_);
	_tmp19_ = self->priv->osd_window;
	_tmp20_ = icon_name;
	budgie_osd_set_osd_icon (_tmp19_, _tmp20_);
	_tmp21_ = self->priv->osd_window;
	_tmp22_ = level;
	budgie_osd_set_osd_progress (_tmp21_, _tmp22_);
	budgie_osd_manager_reset_osd_expire (self, BUDGIE_OSD_EXPIRE_TIME);
	_g_free0 (label);
	_g_free0 (icon_name);
}


/**
     * Reset and update the expiration for the OSD timeout
     */
static gboolean _budgie_osd_manager_osd_expire_gsource_func (gpointer self) {
	gboolean result;
	result = budgie_osd_manager_osd_expire ((BudgieOSDManager*) self);
	return result;
}


static void budgie_osd_manager_reset_osd_expire (BudgieOSDManager* self, gint timeout_length) {
	guint32 _tmp0_ = 0U;
	BudgieOSD* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	BudgieOSD* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	guint _tmp7_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->expire_timeout;
	if (_tmp0_ > ((guint32) 0)) {
		guint32 _tmp1_ = 0U;
		_tmp1_ = self->priv->expire_timeout;
		g_source_remove ((guint) _tmp1_);
		self->priv->expire_timeout = (guint32) 0;
	}
	_tmp2_ = self->priv->osd_window;
	_tmp3_ = gtk_widget_get_visible ((GtkWidget*) _tmp2_);
	if (!_tmp3_) {
		BudgieOSD* _tmp4_ = NULL;
		_tmp4_ = self->priv->osd_window;
		budgie_osd_move_osd (_tmp4_);
	}
	_tmp5_ = self->priv->osd_window;
	gtk_widget_show ((GtkWidget*) _tmp5_);
	_tmp6_ = timeout_length;
	_tmp7_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp6_, _budgie_osd_manager_osd_expire_gsource_func, budgie_osd_manager_ref (self), budgie_osd_manager_unref);
	self->priv->expire_timeout = (guint32) _tmp7_;
}


/**
     * Expiration timeout was met, so hide the OSD Window
     */
static gboolean budgie_osd_manager_osd_expire (BudgieOSDManager* self) {
	gboolean result = FALSE;
	guint32 _tmp0_ = 0U;
	BudgieOSD* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->expire_timeout;
	if (_tmp0_ == ((guint32) 0)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->osd_window;
	gtk_widget_hide ((GtkWidget*) _tmp1_);
	self->priv->expire_timeout = (guint32) 0;
	result = FALSE;
	return result;
}


static void budgie_value_osd_manager_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void budgie_value_osd_manager_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		budgie_osd_manager_unref (value->data[0].v_pointer);
	}
}


static void budgie_value_osd_manager_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = budgie_osd_manager_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer budgie_value_osd_manager_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* budgie_value_osd_manager_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		BudgieOSDManager* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = budgie_osd_manager_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* budgie_value_osd_manager_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	BudgieOSDManager** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = budgie_osd_manager_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* budgie_param_spec_osd_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	BudgieParamSpecOSDManager* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BUDGIE_TYPE_OSD_MANAGER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer budgie_value_get_osd_manager (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_OSD_MANAGER), NULL);
	return value->data[0].v_pointer;
}


void budgie_value_set_osd_manager (GValue* value, gpointer v_object) {
	BudgieOSDManager* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_OSD_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_OSD_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		budgie_osd_manager_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_osd_manager_unref (old);
	}
}


void budgie_value_take_osd_manager (GValue* value, gpointer v_object) {
	BudgieOSDManager* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_OSD_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_OSD_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_osd_manager_unref (old);
	}
}


static void budgie_osd_manager_class_init (BudgieOSDManagerClass * klass) {
	budgie_osd_manager_parent_class = g_type_class_peek_parent (klass);
	((BudgieOSDManagerClass *) klass)->finalize = budgie_osd_manager_finalize;
	g_type_class_add_private (klass, sizeof (BudgieOSDManagerPrivate));
}


static void budgie_osd_manager_instance_init (BudgieOSDManager * self) {
	self->priv = BUDGIE_OSD_MANAGER_GET_PRIVATE (self);
	self->priv->osd_window = NULL;
	self->priv->expire_timeout = (guint32) 0;
	self->ref_count = 1;
}


static void budgie_osd_manager_finalize (BudgieOSDManager* obj) {
	BudgieOSDManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_OSD_MANAGER, BudgieOSDManager);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->osd_window);
}


/**
 * BudgieOSDManager is responsible for managing the BudgieOSD over d-bus, receiving
 * requests, for example, from budgie-wm
 */
GType budgie_osd_manager_get_type (void) {
	static volatile gsize budgie_osd_manager_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_osd_manager_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { budgie_value_osd_manager_init, budgie_value_osd_manager_free_value, budgie_value_osd_manager_copy_value, budgie_value_osd_manager_peek_pointer, "p", budgie_value_osd_manager_collect_value, "p", budgie_value_osd_manager_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BudgieOSDManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_osd_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieOSDManager), 0, (GInstanceInitFunc) budgie_osd_manager_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType budgie_osd_manager_type_id;
		budgie_osd_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BudgieOSDManager", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_type_set_qdata (budgie_osd_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_osd_manager_register_object);
		g_once_init_leave (&budgie_osd_manager_type_id__volatile, budgie_osd_manager_type_id);
	}
	return budgie_osd_manager_type_id__volatile;
}


gpointer budgie_osd_manager_ref (gpointer instance) {
	BudgieOSDManager* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void budgie_osd_manager_unref (gpointer instance) {
	BudgieOSDManager* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BUDGIE_OSD_MANAGER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _dbus_budgie_osd_manager_ShowOSD (BudgieOSDManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GHashTable* params = NULL;
	GVariant* _tmp9_;
	GHashTable* _tmp10_;
	GVariantIter _tmp11_;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp9_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp10_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp11_, _tmp9_);
	while (g_variant_iter_loop (&_tmp11_, "{?*}", &_tmp12_, &_tmp13_)) {
		g_hash_table_insert (_tmp10_, g_variant_dup_string (_tmp12_, NULL), g_variant_get_variant (_tmp13_));
	}
	params = _tmp10_;
	g_variant_unref (_tmp9_);
	budgie_osd_manager_ShowOSD (self, params);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_hash_table_unref0 (params);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void budgie_osd_manager_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ShowOSD") == 0) {
		_dbus_budgie_osd_manager_ShowOSD (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* budgie_osd_manager_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean budgie_osd_manager_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint budgie_osd_manager_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = budgie_osd_manager_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_osd_manager_dbus_interface_info), &_budgie_osd_manager_dbus_interface_vtable, data, _budgie_osd_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _budgie_osd_manager_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	budgie_osd_manager_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}



