/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.file.attribute;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.sf.jiapi.file.ConstantPool;
import net.sf.jiapi.file.SignatureUtil;
import net.sf.jiapi.file.attribute.Attribute;

public class AnnotationBase
extends Attribute {
    protected AnnotationBase(ConstantPool cp, short nameIndex, int length, DataInputStream dis) throws IOException {
        super(nameIndex, length, dis);
        this.setConstantPool(cp);
    }

    protected Annotation readAnnotation(DataInputStream dis) throws IOException {
        short type_index = dis.readShort();
        Annotation a = new Annotation(type_index);
        int num_element_value_pairs = dis.readShort();
        for (int i = 0; i < num_element_value_pairs; ++i) {
            short element_name_index = dis.readShort();
            Value element_value = this.readElementValue(dis);
            a.addElement(new Element(element_name_index, element_value));
        }
        return a;
    }

    protected Value readElementValue(DataInputStream dis) throws IOException {
        byte tag = dis.readByte();
        Value ev = null;
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 99: 
            case 115: {
                short const_value_index = dis.readShort();
                ev = new Value((short)tag, const_value_index);
                break;
            }
            case 101: {
                short type_name_index = dis.readShort();
                short const_name_index = dis.readShort();
                ev = new Value(tag, type_name_index, const_name_index);
                break;
            }
            case 64: {
                Annotation a = this.readAnnotation(dis);
                ev = new Value(tag, a);
                break;
            }
            case 91: {
                LinkedList<Value> values = new LinkedList<Value>();
                int num_values = dis.readShort();
                for (int i = 0; i < num_values; ++i) {
                    values.add(this.readElementValue(dis));
                }
                ev = new Value(tag, values);
                break;
            }
            default: {
                throw new RuntimeException("Do not know how to handle reading of annotations element_value with tag " + tag);
            }
        }
        return ev;
    }

    public class Annotation {
        private short type_index;
        private LinkedList<Element> elements = new LinkedList();

        public Annotation(short typeIndex) {
            this.type_index = typeIndex;
        }

        public void addElement(Element e) {
            this.elements.add(e);
        }

        public String getAnnotationType() {
            return SignatureUtil.toSimpleName(AnnotationBase.this.cp.getUtf8(this.type_index));
        }

        public List<Element> getElements() {
            return this.elements;
        }

        public String toString() {
            return this.getAnnotationType() + this.elements;
        }
    }

    public class Element {
        public short name_index;
        public Value value;

        public Element(short name, Value value) {
            this.name_index = name;
            this.value = value;
        }

        public String getName() {
            return AnnotationBase.this.cp.getUtf8(this.name_index);
        }

        public Value getValue() {
            return this.value;
        }

        public String toString() {
            return AnnotationBase.this.cp.getUtf8(this.name_index) + "=" + this.value;
        }
    }

    public class Value {
        public short tag;
        public short constValueIndex;
        public List<Value> values;
        public short typeNameIndex;
        public short constNameIndex;
        public Annotation ann;

        public Value(short tag, short constValueIndex) {
            this.tag = tag;
            this.constValueIndex = constValueIndex;
        }

        public Value(byte tag, List<Value> values) {
            this.tag = tag;
            this.values = values;
        }

        public Value(byte tag, short typeNameIndex, short constNameIndex) {
            this.tag = tag;
            this.typeNameIndex = typeNameIndex;
            this.constNameIndex = constNameIndex;
        }

        public Value(byte tag, Annotation a) {
            this.tag = tag;
            this.ann = a;
        }

        public Object getValue() {
            if (this.ann != null) {
                return this.ann;
            }
            if (this.typeNameIndex != 0) {
                return null;
            }
            if (this.values != null) {
                return this.values;
            }
            return AnnotationBase.this.cp.get(this.constValueIndex);
        }

        public String toString() {
            if (this.typeNameIndex != 0) {
                return AnnotationBase.this.cp.getUtf8(this.typeNameIndex) + ":" + AnnotationBase.this.cp.getUtf8(this.constNameIndex);
            }
            if (this.constValueIndex != 0) {
                return AnnotationBase.this.cp.get(this.constValueIndex).toString();
            }
            if (this.ann != null) {
                return this.ann.toString();
            }
            if (this.values != null) {
                return this.values.toString();
            }
            return "tag: " + (char)this.tag;
        }
    }
}

