/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.sigfile;

import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.AnnotationItemEx;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import java.util.StringTokenizer;

public class AnnotationParser {
    private static final String CLASS_PREFIX = "java.lang.Class";
    private static I18NResourceBundle i18n;
    static /* synthetic */ Class class$com$sun$tdk$signaturetest$sigfile$AnnotationParser;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AnnotationItem parse(String str) {
        if (!str.startsWith("anno")) {
            throw new IllegalArgumentException(i18n.getString("AnnotationParser.error.bad_annotation_descr") + str);
        }
        AnnotationItem item = str.startsWith("annoEx") ? new AnnotationItemEx() : new AnnotationItem();
        int pos = str.indexOf(32);
        str = str.substring(pos).trim();
        pos = str.indexOf(32);
        String specificData = str.substring(0, pos);
        if (item instanceof AnnotationItemEx) {
            this.parseAnnExData((AnnotationItemEx)item, specificData);
        } else {
            this.parseAnnData(item, specificData);
        }
        str = str.substring(pos + 1);
        pos = str.indexOf(40);
        item.setName(str.substring(0, pos).trim());
        int endPos = this.findCorresponding(str, '(', ')');
        str = str.substring(pos + 1, endPos);
        if (str.length() != 0) {
            while (str.length() > 0 && str.charAt(0) != ')') {
                pos = this.parseMember(item, str);
                if ((str = str.substring(pos)).length() <= 0 || str.charAt(0) != ',') continue;
                str = str.substring(1).trim();
            }
        }
        return item;
    }

    private int findCorresponding(String str, char open, char close) {
        char[] chars = str.toCharArray();
        int count = 0;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == open) {
                ++count;
            } else if (chars[i] == close && --count == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void parseAnnData(AnnotationItem item, String specificData) {
        item.setTarget(Integer.valueOf(specificData));
    }

    private void parseAnnExData(AnnotationItemEx item, String specificData) {
        if (!$assertionsDisabled && !specificData.startsWith("[")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !specificData.endsWith("]")) {
            throw new AssertionError();
        }
        specificData = specificData.substring(1, specificData.length() - 1);
        StringTokenizer st = new StringTokenizer(specificData, ";");
        while (st.hasMoreTokens()) {
            String set = st.nextToken();
            int delPos = set.indexOf("=");
            if (!$assertionsDisabled && delPos <= 0) {
                throw new AssertionError();
            }
            String name = set.substring(0, delPos);
            String val = set.substring(delPos + 1, set.length());
            if ("type".equals(name)) {
                item.setTargetType(Integer.parseInt(val.substring(2), 16));
                continue;
            }
            if ("typeIndex".equals(name)) {
                item.setTypeIndex(Integer.parseInt(val));
                continue;
            }
            if ("boundIndex".equals(name)) {
                item.setBoundIndex(Integer.parseInt(val));
                continue;
            }
            if ("locations".equals(name)) {
                if (!$assertionsDisabled && !val.startsWith("[")) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !val.endsWith("]")) {
                    throw new AssertionError();
                }
                val = val.substring(1, val.length() - 1);
                StringTokenizer st2 = new StringTokenizer(val, ",");
                int[] locs = new int[st2.countTokens()];
                int i = 0;
                while (i < locs.length) {
                    locs[i] = Integer.parseInt(st2.nextToken());
                    ++i;
                }
                item.setLocations(locs);
                continue;
            }
            if ("parameterIndex".equals(name)) {
                item.setParameterIndex(Integer.parseInt(val));
                continue;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
    }

    protected int parseMember(AnnotationItem item, String str) {
        int result = 0;
        AnnotationItem.Member m = new AnnotationItem.Member();
        int pos = str.indexOf(32);
        if (str.startsWith("java.lang.Class<")) {
            char[] strChar = str.toCharArray();
            int level = 0;
            int i = CLASS_PREFIX.length();
            while (i < strChar.length) {
                if (strChar[i] == '<') {
                    ++level;
                } else if (strChar[i] == '>') {
                    --level;
                }
                if (level == 0 && strChar[i + 1] == ' ') {
                    pos = i + 1;
                    break;
                }
                ++i;
            }
        }
        m.type = str.substring(0, pos);
        str = str.substring(pos + 1).trim();
        result += pos + 1;
        pos = str.indexOf(61);
        m.name = str.substring(0, pos);
        str = str.substring(pos + 1).trim();
        result += pos + 1;
        char ch = str.charAt(0);
        switch (ch) {
            case '[': {
                pos = this.findClosingBracket(str, 1, '[', ']') + 1;
                break;
            }
            case '\"': 
            case '\'': {
                pos = str.indexOf(ch, 1) + 1;
                break;
            }
            case 'a': {
                if (str.startsWith("anno")) {
                    AnnotationItem a = this.parse(str);
                    pos = a.toString().length();
                    break;
                }
            }
            default: {
                pos = str.indexOf(44);
                if (pos == -1) {
                    pos = str.indexOf(41);
                }
                if (pos != -1) break;
                pos = str.length();
            }
        }
        m.value = str.substring(0, pos);
        item.addMember(m);
        return result += pos;
    }

    private int findClosingBracket(String str, int startPos, char openingChar, char closingChar) {
        int level = 0;
        int len = str.length();
        int i = startPos;
        while (i < len) {
            char ch = str.charAt(i);
            if (ch == openingChar) {
                ++level;
            } else if (ch == closingChar) {
                if (level == 0) {
                    return i;
                }
                --level;
            }
            ++i;
        }
        return -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$tdk$signaturetest$sigfile$AnnotationParser == null ? (class$com$sun$tdk$signaturetest$sigfile$AnnotationParser = AnnotationParser.class$("com.sun.tdk.signaturetest.sigfile.AnnotationParser")) : class$com$sun$tdk$signaturetest$sigfile$AnnotationParser).desiredAssertionStatus();
        CLASS_PREFIX = CLASS_PREFIX;
        i18n = I18NResourceBundle.getBundleForClass(class$com$sun$tdk$signaturetest$sigfile$AnnotationParser == null ? (class$com$sun$tdk$signaturetest$sigfile$AnnotationParser = AnnotationParser.class$("com.sun.tdk.signaturetest.sigfile.AnnotationParser")) : class$com$sun$tdk$signaturetest$sigfile$AnnotationParser);
    }
}

