########################################################################
#
#	File:			EmFunctions.pm
#
#	Purpose:		Perl wrappers for Palm OS functions
#
#	Description:	This file contains Perl equivalents of Palm OS
#					functions like DmNumDatabases, FrmGetActiveForm,
#					etc.  Currently, the functions here are generated
#					by hand, and so only a small subset of Palm OS
#					functions are wrapped.  In the future, this file
#					(or files) may be automatically generated by
#					a script that converts the SDK headers.
#
#					In general, functions follow the calling
#					conventions in the SDK headers.  However, there
#					are exceptions.  See the comments before each
#					subroutine for details.
#
########################################################################

package EmFunctions;

use EmRPC;
use EmSysTraps;

use strict;
use vars qw(@ISA @EXPORT);

use Exporter;
@ISA = qw(Exporter);

@EXPORT = qw(
	CtlGetLabel

	DmNumDatabases DmFindDatabase DmGetDatabase DmDatabaseInfo
	DmNextOpenDatabase DmOpenDatabaseInfo

	EvtEnqueuePenPoint EvtEnqueueKey

	FrmGetActiveForm FrmGetLabel FrmGetNumberOfObjects FrmGetObjectBounds
	FrmGetObjectId FrmGetObjectIndex FrmGetObjectPtr FrmGetObjectType FrmGetTitle

	FtrGet

	HwrDisplayAttributes

	MemChunkFree MemPtrFree MemPtrNew MemPtrSetOwner MemStoreInfo MemCardInfo
	MemNumCards MemNumHeaps MemNumRAMHeaps
	MemHeapID MemHeapDynamic MemHeapFlags MemHeapSize

	SysUIAppSwitch SysCurAppDatabase

	WinDisplayToWindowPt WinWindowToDisplayPt

	dmModeReadOnly dmModeWrite dmModeReadWrite
	dmModeLeaveOpen dmModeExclusive dmModeShowSecret

	frmFieldObj frmControlObj frmListObj frmTableObj frmBitmapObj frmLineObj
	frmFrameObj frmRectangleObj frmLabelObj frmTitleObj frmPopupObj
	frmGraffitiStateObj frmGadgetObj frmScrollBarObj

	hwrDispType			hwrDispRev			hwrDispVers			hwrDispAllDepths	hwrDispMaxDepth
	hwrDispBootDepth	hwrDispMaxGrays		hwrDispHorizontal	hwrDispVertical		hwrDispVRAMBaseAddr
	hwrDispVRAMSize		hwrDispColor		hwrDispName			hwrDispBaseAddr		hwrDispDepth
	hwrDispWidth		hwrDispHeight		hwrDispRowBytes		hwrDispBacklight	hwrDispBrightness
	hwrDispContrast		hwrDispDbgIndicator	hwrDispEndAddr		hwrDispBufferMask	hwrDispResolutionX
	hwrDispResolutionY	hwrDispMemAccessOK
);

use constant dmModeReadOnly			=> 0x01;
use constant dmModeWrite			=> 0x02;
use constant dmModeReadWrite		=> 0x03;
use constant dmModeLeaveOpen		=> 0x04;
use constant dmModeExclusive		=> 0x08;
use constant dmModeShowSecret		=> 0x10;

use constant frmFieldObj			=> 0;
use constant frmControlObj			=> 1;
use constant frmListObj				=> 2;
use constant frmTableObj			=> 3;
use constant frmBitmapObj			=> 4;
use constant frmLineObj				=> 5;
use constant frmFrameObj			=> 6;
use constant frmRectangleObj		=> 7;
use constant frmLabelObj			=> 8;
use constant frmTitleObj			=> 9;
use constant frmPopupObj			=> 10;
use constant frmGraffitiStateObj	=> 11;
use constant frmGadgetObj			=> 12;
use constant frmScrollBarObj		=> 13;

use constant hwrDispType			=> 0;	# (4) Get 4-char code for controller/display combination.
use constant hwrDispRev				=> 1;	# (2) Get Hardware Revision
use constant hwrDispVers			=> 2;	# (2) Get Display driver HAL version.
use constant hwrDispAllDepths		=> 3;	# (2) Get All display depths in bitmap format.
use constant hwrDispMaxDepth		=> 4;	# (2) Get Maximum supported bit depth.
use constant hwrDispBootDepth		=> 5;	# (2) The preset boot depth of the device.
use constant hwrDispMaxGrays		=> 6;	# (2) Get Maximum number of grays supported by HW.
use constant hwrDispHorizontal		=> 7;	# (2) Get Maximum hortizontal pixels supported by Display.
use constant hwrDispVertical		=> 8;	# (2) Get Maximum vertical pixels supported by Display.
use constant hwrDispVRAMBaseAddr	=> 9;	# (4) Get Base address of video memory if any (if 0, no VRAM)
use constant hwrDispVRAMSize		=> 10;	# (4) Get Size of VRAM (if 0, no VRAM)
use constant hwrDispColor			=> 11;	# (2) Get True if controller AND display supprt color.
use constant hwrDispName			=> 12;	#(32) Get 32 character string for controller and Hardware.
	
use constant hwrDispBaseAddr		=> 13;	# (4) Get/Set Base Address for current screen memory (somewhere in VRAM or main RAM)
use constant hwrDispDepth			=> 14;	# (2) Get/Set Depth of display
use constant hwrDispWidth			=> 15;	# (2) Get/Set current display width
use constant hwrDispHeight			=> 16;	# (2) Get/Set current display height
use constant hwrDispRowBytes		=> 17;	# (2) Get/Set bytes in a row of display (changed when depth or width change)
use constant hwrDispBacklight		=> 18;	# (1) Get/Set Backlight status: 0 = off, 1 = on (returns 0 on Austin)
use constant hwrDispBrightness		=> 19;	# (1) Get/Set Brightness level: 0(min/off)...255(max)
use constant hwrDispContrast		=> 20;	# (1) Get/Set Contrast Level: 0(min)...255(max)
use constant hwrDispDbgIndicator	=> 21;	# (2) Turn Debug Indicator on/off
use constant hwrDispEndAddr			=> 22;	# (4) Get last byte of screen memory
use constant hwrDispBufferMask		=> 23;	# (4) Mask for determining required display address alignment
use constant hwrDispResolutionX		=> 24;	# (?) Screen resolution
use constant hwrDispResolutionY		=> 25;	# (?) Screen resolution
use constant hwrDispMemAccessOK		=> 26;	# (1) true if controller can be accessed when bus clock disabled


########################################################################
#
#	FUNCTION:		CtlGetLabel
#
#	DESCRIPTION:	Return a string pointer to the control's text label.
#
#	PARAMETERS:		Memory address on the remote device of the control
#					object.  Usually the result of something like
#					FrmGetObjectPtr on a control object.
#
#	RETURNED:		A list containing the memory address on the remote
#					device of the label, and the label string itself.
#
########################################################################

sub CtlGetLabel
{
	# const Char* CtlGetLabel (const ControlType * ctlP)

	my ($return, $format) = ("string", "rptr");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapCtlGetLabel, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		DmNumDatabases
#
#	DESCRIPTION:	Returns the number of databases on a card
#
#	PARAMETERS:		card number
#
#	RETURNS:		Number of databases found
#
########################################################################

sub DmNumDatabases
{
	# UInt DmNumDatabases (UInt cardNo)

	my ($return, $format) = ("int16", "int16");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapDmNumDatabases, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		DmDatabaseInfo
#
#	DESCRIPTION:	Retrieves database information
#
#	PARAMETERS:		Card number, database LocalID
#
#	RETURNS:		Result code from function, as well as the components
#					of a hash.  To get the result, assign the result
#					of this function to ($err, %results).  You can
#					then extract individual values from %results using
#					hash operators and the following keys: name
#					attributes, version, crDate, modDate, bckUpDate,
#					modNum, appInfoID, sortInfoID, type, and creator.
#					Example: $name = $results{name}.
#
########################################################################

sub DmDatabaseInfo
{
	# Err DmDatabaseInfo (UInt cardNo, LocalID	dbID, const CharPtr nameP,
	#				UIntPtr attributesP, UIntPtr versionP, ULongPtr crDateP,
	#				ULongPtr modDateP, ULongPtr bckUpDateP,
	#				ULongPtr modNumP, LocalID* appInfoIDP,
	#				LocalID* sortInfoIDP, ULongPtr typeP,
	#				ULongPtr creatorP)

	my ($cardNo, $dbID) = @_;

	my ($format) = "int16 LocalID string32 int16* int16* int32* int32* " .
					"int32* int32* LocalID* LocalID* int32* int32*";
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapDmDatabaseInfo, $format,
						$cardNo, $dbID, "", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

	($D0,	name		=> $params[2],
			attributes	=> $params[3],
			version		=> $params[4],
			crDate		=> $params[5],
			modDate		=> $params[6],
			bckUpDate	=> $params[7],
			modNum		=> $params[8],
			appInfoID	=> $params[9],
			sortInfoID	=> $params[10],
			type		=> $params[11],
			creator		=> $params[12]);
}


########################################################################
#
#	FUNCTION:		DmFindDatabase
#
#	DESCRIPTION:	Searches for a database by name
#
#	PARAMETERS:		card number, database name
#
#	RETURNS:		LocalID of database header
#
########################################################################

sub DmFindDatabase
{
	# LocalID DmFindDatabase (UInt cardNo, const CharPtr nameP)

	my ($return, $format) = ("LocalID", "int16 string");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapDmFindDatabase, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		DmGetDatabase
#
#	DESCRIPTION:	Finds the nth database on the card
#
#	PARAMETERS:		card number, database index
#
#	RETURNS:		LocalID of database header
#
########################################################################

sub DmGetDatabase
{
	# LocalID DmGetDatabase (UInt16 cardNo, Uint16 index)

	my ($return, $format) = ("LocalID", "int16 int16");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapDmGetDatabase, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		DmNextOpenDatabase
#
#	DESCRIPTION:	Returns the next open database
#
#	PARAMETERS:		A DmOpenRef (or 0 the first time)
#
#	RETURNS:		The next DmOpenRef, or 0 at the end of the chain
#
########################################################################

sub DmNextOpenDatabase
{
	# DmOpenRef DmNextOpenDatabase (DmOpenRef currentP)

	my ($return, $format) = ("rptr", "rptr");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapDmNextOpenDatabase, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		DmOpenDatabaseInfo
#
#	DESCRIPTION:	Retrieves database information
#
#	PARAMETERS:		DmOpenRef
#
#	RETURNS:		Result code from function, as well as the components
#					of a hash.  To get the result, assign the result
#					of this function to ($err, %results).  You can
#					then extract individual values from %results using
#					hash operators and the following keys: cardNo, dbID,
#					openCount, mode, resDB.
#					Example: $name = $results{name}.
#
########################################################################

sub DmOpenDatabaseInfo
{
	# Err DmOpenDatabaseInfo (DmOpenRef dbP, LocalID *dbIDP,
	#				UInt16 *openCountP, UInt16 *modeP, UInt16 *cardNoP,
	#				Boolean *resDBP)

	my ($format) = "rptr LocalID* int16* int16* int16* int16*";
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapDmOpenDatabaseInfo, $format, @_, 0, 0, 0, 0, 0);

	($D0,	dbID		=> $params[1],
			openCount	=> $params[2],
			mode		=> $params[3],
			cardNo		=> $params[4],
			resDB		=> $params[5]);
}


########################################################################
#
#	FUNCTION:		EvtEnqueuePenPoint
#
#	DESCRIPTION:	Called by the digitizer interrupt routine to enqueue
#					a pen coordinate into the pen queue.
#
#	PARAMETERS:		x and y coordinates, subtracted from 256.
#					Example: EvtEnqueuePoint (256 - 100, 256 - 80)
#					Pass in (-1, -1) to enqueue a Pen Up.
#
#	RETURNS:		size of queue in bytes
#
########################################################################

sub EvtEnqueuePenPoint
{
	# Err EvtEnqueuePenPoint (PointType* ptP)

	my ($return, $format) = ("Err", "point");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapEvtEnqueuePenPoint, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		EvtEnqueueKey
#
#	DESCRIPTION:	Called by the digitizer interrupt routine to enqueue
#					a key into the key queue.
#
#	PARAMETERS:		WChar ascii, UInt16 keycode, UInt16 modifiers
#
#	RETURNS:		size of queue in bytes
#
########################################################################

sub EvtEnqueueKey
{
	# Err EvtEnqueueKey (WChar ascii, UInt16 keycode, UInt16 modifiers)

	my ($return, $format) = ("Err", "int16 int16 int16");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapEvtEnqueueKey, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		FrmGetActiveForm
#
#	DESCRIPTION:	This routine returns the currently active form.
#
#	PARAMETERS:		nothing
#
#	RETURNED:		Memory address on the remote device of the form.
#
########################################################################

sub FrmGetActiveForm
{
	# FormPtr FrmGetActiveForm (void)

	my ($return, $format) = ("rptr", "");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapFrmGetActiveForm, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		FrmGetLabel
#
#	DESCRIPTION:	This routine return the text of the specified label object
#					in the specified form.
#
#	PARAMETERS:		formP		- memory block that contains the form.
#					labelID		- id of the label object.
#
#	RETURNED:		A list containing the memory address on the remote
#					device of the label, and the label string itself.
#
########################################################################

sub FrmGetLabel
{
	# CharPtr FrmGetLabel (const FormPtr frm, const Word lableID)

	my ($return, $format) = ("string", "rptr int16");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapFrmGetLabel, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		FrmGetNumberOfObjects
#
#	DESCRIPTION:	This routine returns the number of objects in a form.
#
#	PARAMETERS:		formP		memory block that contains the form.
#
#	RETURNED:		number of object in the form specified
#
########################################################################

sub FrmGetNumberOfObjects
{
	# Word FrmGetNumberOfObjects (const FormPtr frm)

	my ($return, $format) = ("int16", "rptr");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapFrmGetNumberOfObjects, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		FrmGetObjectBounds
#
#	DESCRIPTION:	This routine returns the bounds of the specified form object
#
#	PARAMETERS:		formP		memory block that contains the form.
#					objIndex	index of the object
#
#	RETURNS:		The components of a hash.  To get the result, assign
#					the result of this function to %results.  You can
#					then extract individual values from %results using
#					hash operators and the following keys: top, left
#					bottom, right, width, height.
#					Example: $top = $results{top}.
#
########################################################################

sub FrmGetObjectBounds
{
	# void FrmGetObjectBounds (const FormPtr frm, const Word pObjIndex, const RectanglePtr r)

	my ($form, $obj_index) = @_;

	my ($return, $format) = ("", "rptr int16 rect");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapFrmGetObjectBounds, $format,
											$form, $obj_index, {});

	my ($foo) = $params[2];
	%$foo;
}


########################################################################
#
#	FUNCTION:		FrmGetObjectId
#
#	DESCRIPTION:	This routine returns the id of the object specified.  
#					An id is a value specified by the application developer 
#					that uniquely identifies an object.
#
#	PARAMETERS:		formP		memory block that contains the form.
#					objIndex	item number of the object
#
#	RETURNED:		Object ID.
#
########################################################################

sub FrmGetObjectId
{
	# UInt16 FrmGetObjectId (const FormType * formP, UInt16 objIndex)

	my ($return, $format) = ("int16", "rptr int16");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapFrmGetObjectId, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		FrmGetObjectIndex
#
#	DESCRIPTION:	This routine returns the item number of an object, the
#					item number is the position of the object in the objects
#					list.
#
#	PARAMETERS:		formP		memory block that contains the form.
#					objId		id of an object in the form.
#
#	RETURNED:		item number of an object (the first item number is 0).
#
########################################################################

sub FrmGetObjectIndex
{
	# UInt16 FrmGetObjectIndex (const FormType * formP, UInt16 objId)

	my ($return, $format) = ("int16", "rptr int16");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapFrmGetObjectIndex, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		FrmGetObjectPtr
#
#	DESCRIPTION:	This routine returns a pointer to the data structure of an 
#					object in a form.
#
#	PARAMETERS:		formP		memory block that contains the form.
#					objIndex	item number of the object
#
#	RETURNED:		Memory address on the remote device of the object.
#					The contents of the object depend on the object type.
#
########################################################################

sub FrmGetObjectPtr
{
	# VoidPtr FrmGetObjectPtr (const FormPtr frm, const Word objIndex)

	my ($return, $format) = ("rptr", "rptr int16");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapFrmGetObjectPtr, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		FrmGetObjectType
#
#	DESCRIPTION:	This routine returns the type of an object.
#
#	PARAMETERS:		formP		memory block that contains the form.
#					objIndex	item number of the object
#
#	RETURNED:		FormObjectType of the item specified
#
########################################################################

sub FrmGetObjectType
{
	# FormObjectKind FrmGetObjectType (const FormPtr frm, const Word objIndex)

	my ($return, $format) = ("int16", "rptr int16");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapFrmGetObjectType, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		FrmGetTitle
#
#	DESCRIPTION:	This routine returns a pointer to the title string of a 
#					form.
#
#	PARAMETERS:		formP	  - memory block that contains the form.
#
#	RETURNED:		A list containing the memory address on the remote
#					device of the title, and the title string itself.
#
########################################################################

sub FrmGetTitle
{
	# const Char * FrmGetTitle (const FormType * formP)

	my ($return, $format) = ("string", "rptr");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapFrmGetTitle, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		FtrGet
#
#	DESCRIPTION:	Get a PalmOS feature setting
#
#	PARAMETERS:		creator - creator id
#					featureNum - number of feature requested
#
#	RETURNS:		Result code and value of feature
#
########################################################################

sub FtrGet
{
	# Err FtrGet(UInt32 creator, UInt16 featureNum, UInt32 *valueP)

	my ($creator, $featureNum) = @_;

	my ($return, $format) = ("Err", "int32 int16 int32*");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapFtrGet, $format, $creator, $featureNum, 0);
	($D0, $params[2]);
}


########################################################################
#
#	FUNCTION:		HwrDisplayAttributes
#
#	DESCRIPTION:	Get or set Info about the Hwr display and controller
#
#	PARAMETERS:		set - true to set, false to get.  Ignored for read-only attributes
#					attr - HwrDisplayAttrType
#					dataP - data to get or set.  Must be non-NULL, as read-only
#						attributes are always read, regardless of 'set' param.
#
#	RETURNS:		
#
########################################################################

sub HwrDisplayAttributes
{
	# Err HwrDisplayAttributes(Boolean set, HwrDisplayAttrType attr, void* dataP)

	my ($set, $attr, $data) = @_;

	my ($return, $format) = ("Err", "int8 int8 block");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapHwrDisplayAttributes, $format, $set, $attr, $data);
	($D0, $params[2]);
}


########################################################################
#
#	FUNCTION:		MemChunkFree
#
#	DESCRIPTION:	Disposes of a chunk
#
#	PARAMETERS:		Pointer to chunk
#
#	RETURNS:		0 if no error
#
########################################################################

sub MemChunkFree
{
	my ($return, $format) = ("Err", "rptr");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapMemChunkFree, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		MemPtrFree
#
#	DESCRIPTION:	Disposes of a chunk
#
#	PARAMETERS:		Pointer to chunk
#
#	RETURNS:		0 if no error
#
########################################################################

sub MemPtrFree
{
	MemChunkFree (@_);
}


########################################################################
#
#	FUNCTION:		MemPtrNew
#
#	DESCRIPTION:	Allocates a non-movable chunk in the dynamic heap
#
#	PARAMETERS:		requested size of chunk
#
#	RETURNS:		Ptr to chunk, or 0 if error
#
########################################################################

sub MemPtrNew
{
	my ($return, $format) = ("rptr", "int32");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapMemPtrNew, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		MemPtrSetOwner
#
#	DESCRIPTION:	Sets the owner ID of a chunk
#
#	PARAMETERS:		chunk data pointer
#
#	RETURNS:		0 if no error
#
########################################################################

sub MemPtrSetOwner
{
	#	Err  MemPtrSetOwner (void* p, UInt16 owner)

	my ($return, $format) = ("Err", "rptr int16");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapMemPtrSetOwner, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


#/*******************************************************************
#
#	FUNCTION:		MemStoreInfo
#
#	DESCRIPTION:	Returns information on either the RAM store or
#                      the ROM store for a memory card.
#
#	PARAMETERS:		1) cardNo - either 0 or 1
#                   2) storeNumber - 0 for ROM, 1 for RAM
#                   3) versionP - Pointer to version variable, or 0.
#                   4) flagsP - Pointer to flags variable, or 0.
#                   5) nameP - Pointer to character array (32 bytes), or 0.
#                   6) crDateP - Pointer to creation date variable, or 0.
#                   7) bckUpDateP - Pointer to backup date variable, or 0.
#                   8) heapListOffsetP - Pointer to heapListOffset variable, or 0.
#                   9) initCodeOffset1P - Pointer to initCodeOffset1 variable, or 0.
#                   10) initCodeOffset2P - Pointer to initCodeOffset2 variable, or 0.
#                   11) databaseDirIDP - Pointer to database directory chunk ID variable, or 0.
#
#	RETURNS:		0 if no error, error number otherwise
#
#*******************************************************************/
sub MemStoreInfo
{
	my ($cardNo, $storeNumber) = @_;
	my ($return, $format) = ("Err", "int16 int16 int16* int16* string int32* int32* int32* int32* int32* LocalID*");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapMemStoreInfo, $format, $cardNo, $storeNumber, 0, 0, 0, 0, 0, 0, 0, 0, 0);
	($D0,	version			=> $params[2],
			flags			=> $params[3],
			name			=> $params[4],
			crDate			=> $params[5],
			bckUpDate		=> $params[6],
			heapListOffset	=> $params[7],
			initCodeOffset1	=> $params[8],
			initCodeOffset2	=> $params[9],
			databaseDirID	=> $params[10]);
}


#/*******************************************************************
#
#	FUNCTION:		MemCardInfo
#
#	DESCRIPTION:	Returns information on either the RAM store or
#                      the ROM store for a memory card.
#
#	PARAMETERS:		
#
#	RETURNS:		0 if no error, error number otherwise
#
#*******************************************************************/
sub MemCardInfo
{
	my ($cardNo) = @_;
	my ($return, $format) = ("Err", "int16 string32 string32 int16* int32* int32* int32* int32*");
	my ($D0, $A0, @params) = EmRPC::DoRPC(EmSysTraps::sysTrapMemCardInfo, $format, $cardNo, 0, 0, 0, 0, 0, 0, 0);

	($D0, 	cardName		=> $params[1],
			manufName		=> $params[2],
			version			=> $params[3],
			crDate			=> $params[4],
			romSize			=> $params[5],
			ramSize			=> $params[6],
			freeBytes		=> $params[7]);
}


########################################################################
#
#	FUNCTION:		MemNumCards
#
#	DESCRIPTION:	Counts the cards on the device.
#
#	PARAMETERS:		none
#
#	RETURNS:		Usually 1.  :-)
#
########################################################################
sub MemNumCards
{
	my ($return, $format) = ("int16", "");
	my ($D0, $A0) = EmRPC::DoRPC (EmSysTraps::sysTrapMemNumCards, $format);
	EmRPC::ReturnValue ($return, $D0, $A0);
}


########################################################################
#
#	FUNCTION:		MemNumHeaps
#
#	DESCRIPTION:	Counts the heaps on the given card.
#
#	PARAMETERS:		Card number
#
#	RETURNS:		How many
#
########################################################################
sub MemNumHeaps
{
	my ($return, $format) = ("int16", "int16");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapMemNumHeaps, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		MemNumRAMHeaps
#
#	DESCRIPTION:	Counts the RAM heaps on the given card.
#
#	PARAMETERS:		Card number
#
#	RETURNS:		How many
#
########################################################################
sub MemNumRAMHeaps
{
	my ($return, $format) = ("int16", "int16");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapMemNumRAMHeaps, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		MemHeapID
#
#	DESCRIPTION:	Returns the heap ID of the j'th heap on the i'th card.
#
#	PARAMETERS:		Card number, heap index
#
#	RETURNS:		A heap ID
#
########################################################################
sub MemHeapID
{
	my ($return, $format) = ("int16", "int16 int16");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapMemHeapID, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		MemHeapDynamic
#
#	DESCRIPTION:	Returns whether the given heap is dynamic.
#
#	PARAMETERS:		A heap ID
#
#	RETURNS:		Boolean
#
########################################################################
sub MemHeapDynamic
{
	my ($return, $format) = ("int16", "int16");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapMemHeapDynamic, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		MemHeapFlags
#
#	DESCRIPTION:	Returns the given heap's flags.
#
#	PARAMETERS:		A heap ID
#
#	RETURNS:		The flags
#
########################################################################
sub MemHeapFlags
{
	my ($return, $format) = ("int16", "int16");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapMemHeapFlags, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		MemHeapSize
#
#	DESCRIPTION:	Returns the size of the given heap.
#
#	PARAMETERS:		A heap ID
#
#	RETURNS:		The size
#
########################################################################
sub MemHeapSize
{
	my ($return, $format) = ("int32", "int16");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapMemHeapSize, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


########################################################################
#
#	FUNCTION:		SysUIAppSwitch
#
#	DESCRIPTION:	Tries to make the current UI application quit and
#					then launches the given UI application by card
#					number and database ID.
#
#	PARAMETERS:		cardNo, dbID, launchCmd, cmdPBP
#
#					Note that in order to utilize the cmdPBP, you need
#					to first create a buffer on the remote side with
#					MemPtrNew and fill in its contents with
#					EmRPC::WriteBlock.  If you want to pass NULL for
#					cmdPBP, specify zero for the last parameter.
#
#	RETURNS:		errNone if no err
#
########################################################################

sub SysUIAppSwitch
{
	# Err SysUIAppSwitch(UInt16 cardNo, LocalID dbID, UInt16 cmd, MemPtr cmdPBP)

	my ($return, $format) = ("Err", "int16 LocalID int16 rptr");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapSysUIAppSwitch, $format, @_);
	EmRPC::ReturnValue ($return, $D0, $A0, @params);
}


#/*******************************************************************
#
#	FUNCTION:		SysCurAppDatabase
#
#	DESCRIPTION:	
#
#	PARAMETERS:		
#
#	RETURNS:		
#
#*******************************************************************/
sub SysCurAppDatabase {
	my ($return, $format) = ("Err", "int16* LocalID*");
	my ($D0, $A0, @params) = EmRPC::DoRPC(EmSysTraps::sysTrapSysCurAppDatabase, $format, 0, 0);

	($D0, 	cardNum		=> $params[0],
			databaseID	=> $params[1]);
}


########################################################################
#
#	FUNCTION:		WinDisplayToWindowPt
#
#	DESCRIPTION:	This routine converts a display-relative coordinate to
#					a window-relative coordinate.  The coordinate returned is 
#					relative to the draw window.
#
#	PARAMETERS:		xP	<->	x coordinate to convert
#					yP	<->	y coordinate to convert
#
#	RETURNED:		nothing
#
########################################################################

sub WinDisplayToWindowPt
{
	# void WinDisplayToWindowPt (Coord * xP, Coord * yP)

	my ($return, $format) = ("void", "Coord* Coord*");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapWinDisplayToWindowPt, $format, @_);
	($params[0], $params[1]);
}


########################################################################
#
#	FUNCTION:		WinWindowToDisplayPt
#
#	DESCRIPTION:	This routine converts a window-relative coordinate to
#					a display-relative coordinate.  The coordinate passed is 
#					assumed to be relative to the draw window.
#
#	PARAMETERS:		xP	<->	x coordinate to convert
#					yP	<->	y coordinate to convert
#
#	RETURNED:		nothing
#
########################################################################

sub WinWindowToDisplayPt
{
	# void WinWindowToDisplayPt (Coord * xP, Coord * yP)

	my ($return, $format) = ("void", "Coord* Coord*");
	my ($D0, $A0, @params) = EmRPC::DoRPC (EmSysTraps::sysTrapWinWindowToDisplayPt, $format, @_);
	($params[0], $params[1]);
}

1;
