// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/mains/orp/Dll_Jit_intf.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//



#ifndef _DLL_JIT_INTF_H_
#define _DLL_JIT_INTF_H_


#include "jit_intf_cpp.h"

//#define USE_METHOD_TABLE

#ifdef USE_METHOD_TABLE
#include "..\Level_3_JIT\mtable.h"
#endif // USE_METHOD_TABLE


class Dll_JIT: public JIT {

public:

    Dll_JIT(const char *dll_filename);

    ~Dll_JIT() { if (_deinit != NULL) _deinit(); }


    void
    next_command_line_argument(const char *option,
                               const char *arg
                               )
    {
#ifdef USE_METHOD_TABLE
        if (!strcmp(option, "-jitdll"))
        {
            char *method_str = "METHODS=";
            if (strncmp(arg, method_str, strlen(method_str)) == 0)
                envvar_METHODS = arg + strlen(method_str);
            return;
        }
#endif // USE_METHOD_TABLE
        if (_next_command_line_argument != NULL)
            _next_command_line_argument(option, arg);
    }


    JIT_Result 
    gen_method_info(Compile_Handle     compilation,
                    Method_Handle      method,
                    JIT_Flags          flags
                    )
    {
        return _gen_method_info(compilation, method, flags);
    }

    JIT_Result 
    compile_method(Compile_Handle     compilation,
                   Method_Handle      method,
                   JIT_Flags          flags
                   )
    {
#ifdef USE_METHOD_TABLE
        if (call_count++==0)
        {
            mtable = new O3_Method_Table(envvar_METHODS, "METHODS", true);
        }
        if (!mtable->accept_this_method(method))
            return JIT_FAILURE;
#endif // USE_METHOD_TABLE
        if (_compile_method == NULL)
            return JIT_FAILURE;
        return _compile_method(compilation, method, flags);
    }


    void
    unwind_stack_frame(Method_Handle       method,
                       Frame_Context      *context,
                       Boolean             is_first
                       )
    {
        _unwind_stack_frame(method, context, is_first);
    }


    void 
    get_root_set_from_stack_frame(Method_Handle         method,
                                  GC_Enumeration_Handle enum_handle,
                                  Frame_Context        *context,
                                  Boolean               is_first
                                  )
    {
        _get_root_set_from_stack_frame(method, enum_handle, context, is_first);
    }



    Boolean
    can_enumerate(Method_Handle method,
                  uint32        eip
                  )
    {
        return _can_enumerate(method, eip);
    }


    unsigned
    num_breakpoints(Method_Handle method,
                    uint32        eip
                    )
    {
        return _num_breakpoints(method, eip);
    }


    void
    get_breakpoints(Method_Handle  method,
                    uint32        *bp,
                    Frame_Context *context
                    )
    {
        _get_breakpoints(method, bp, context);
    }


    void
    fix_handler_context(Method_Handle      method,
                        Frame_Context     *context,
                        Boolean            is_first
                        )
    {
        _fix_handler_context(method, context, is_first);
    }


    void *
    get_address_of_this(Method_Handle       method,
                        const Frame_Context *context,
                        Boolean             is_first
                        )
    {
        return (void *)_get_address_of_this(method, context, is_first);
    }


    Boolean
    call_returns_a_reference(Method_Handle         method,
                             const Frame_Context  *context
                             )
    {
        return _call_returns_a_reference(method, context);
    }

    int
    get_break_point_offset(Compile_Handle comp, 
                           Method_Handle  mh, 
                           JIT_Flags      flags, 
                           unsigned       bc_location)
    {
        return _get_break_point_offset(comp,mh,flags,bc_location);
    }

   void *get_address_of_var(Frame_Context *context,
                            Boolean       is_first,
                            unsigned      var_no)
   {
       return _get_address_of_var(context,is_first,var_no);
   }

   void thread_recompile_methods()
   {
       _thread_recompile_methods();
   }

#ifdef _DEBUG
    void
    gc_start()
    {
        if (_gc_start != NULL)
            _gc_start();
    }

    void
    gc_end()
    {
        if (_gc_end != NULL)
            _gc_end();
    }

    void
    gc_object_died(void *java_ref)
    {
        if (_gc_object_died != NULL)
            _gc_object_died(java_ref);
    }
#endif


private:
    void (*_init)(JIT_Handle j);

    void (*_deinit)();

    void
    (*_next_command_line_argument)(const char *,
                                   const char *
                                   );

    JIT_Result 
    (*_gen_method_info)(Compile_Handle     compilation,
                        Method_Handle      method,
                        JIT_Flags          flags
                        );

    JIT_Result 
    (*_compile_method)(Compile_Handle     compilation,
                       Method_Handle      method,
                       JIT_Flags          flags
                       );

    void
    (*_unwind_stack_frame)(Method_Handle   method,
                           Frame_Context  *context,
                           Boolean         is_first
                           );

    void 
    (*_get_root_set_from_stack_frame)(Method_Handle         method,
                                      GC_Enumeration_Handle enum_handle,
                                      Frame_Context        *context,
                                      Boolean               is_first
                                      );

    Boolean
    (*_can_enumerate)(Method_Handle method,
                      uint32        eip
                      );

    unsigned
    (*_num_breakpoints)(Method_Handle method,
                        uint32        eip
                        );

    void
    (*_get_breakpoints)(Method_Handle method,
                        uint32        *bp,
                        Frame_Context *context
                        );

    void
    (*_fix_handler_context)(Method_Handle      method,
                            Frame_Context     *context,
                            Boolean            is_first
                            );

    void *
    (*_get_address_of_this)(Method_Handle       method,
                            const Frame_Context *context,
                            Boolean             is_first
                            );

    Boolean
    (*_call_returns_a_reference)(Method_Handle         method,
                                 const Frame_Context  *context
                                 );

    int32
    (*_get_break_point_offset)(Compile_Handle comp, 
                               Method_Handle  mh, 
                               JIT_Flags      flags, 
                               unsigned       bc_location);

    void *
    (*_get_address_of_var)(Frame_Context *context,
                           Boolean       is_first,
                           unsigned      var_no);

    void *
    (*_thread_recompile_methods)();

    void
    (*_gc_start)();

    void
    (*_gc_end)();

    void
    (*_gc_object_died)(void *java_ref);

#ifdef USE_METHOD_TABLE
    const char *envvar_METHODS;
    unsigned call_count;
    O3_Method_Table *mtable;
#endif // USE_METHOD_TABLE
};



#endif
