// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/interface/orp_types.h,v 1.10 2001/12/11 16:18:12 rlhudson Exp $
//



#ifndef _ORP_TYPES_H_
#define _ORP_TYPES_H_


//::For long long int, add the LL 
# if __WORDSIZE == 64 || defined(WIN32)
#  define __INT64_C(c)  c ## L
#  define __UINT64_C(c) c ## UL
# else
#  define __INT64_C(c)  c ## LL
#  define __UINT64_C(c) c ## ULL
# endif

//#ifdef FAST_INSTOF
#define MAX_FAST_INSTOF_DEPTH 3
//#endif

//
// DLL stuff
//
#if defined(BUILDING_ORP)
#define ORPExport __declspec(dllexport)
#define JITExport __declspec(dllimport)
#else
#define ORPExport __declspec(dllimport)
#define JITExport __declspec(dllexport)
#endif

typedef unsigned char    Byte;

#ifdef ORP_POSIX
typedef unsigned char uint8;
typedef unsigned short uint16;
typedef unsigned int uint32;
typedef unsigned long long uint64;

typedef   signed char  int8;
typedef   signed short int16;
typedef   signed int  int32; 
typedef   signed long long int64;

#else

typedef unsigned __int8  uint8;
typedef unsigned __int16 uint16;
typedef unsigned __int32 uint32;
typedef unsigned __int64 uint64;
typedef   signed __int8  int8;
typedef   signed __int16 int16;
#if (_MSC_VER != 1100 || !defined _WINSOCK2API_)
typedef   signed __int32 int32;
#endif
typedef   signed __int64 int64;

#endif // ORP_POSIX

// We can't use bool in non-C++ code
#define TRUE  1
#define FALSE 0
typedef unsigned Boolean;

// Define some Java Types. This is used by ini.h and
// array element size calculations among other places.

typedef uint8  J_Boolean;
typedef  int8  J_Byte;
typedef uint16 J_Char;
typedef  int16 J_Short;
typedef  int32 J_Int;
typedef  int64 J_Long;
typedef  float J_Float;
typedef double J_Double;
typedef void*  J_Reference;


typedef void *GC_Enumeration_Handle;


#if 1 //def CLI_TESTING

enum ORP_Data_Type {
    ORP_DATA_TYPE_INT8    = 'B',
    ORP_DATA_TYPE_UINT8   = 'b',
    ORP_DATA_TYPE_INT16   = 'S',
    ORP_DATA_TYPE_UINT16  = 's',
    ORP_DATA_TYPE_INT32   = 'I',
    ORP_DATA_TYPE_UINT32  = 'i',
    ORP_DATA_TYPE_INT64   = 'J',
    ORP_DATA_TYPE_UINT64  = 'j',
    ORP_DATA_TYPE_INTPTR  = 'N',
    ORP_DATA_TYPE_UINTPTR = 'n',
    ORP_DATA_TYPE_F8      = 'D',
    ORP_DATA_TYPE_F4      = 'F',
    ORP_DATA_TYPE_BOOLEAN = 'Z',
    ORP_DATA_TYPE_CHAR    = 'C',
    ORP_DATA_TYPE_CLASS   = 'L',
    ORP_DATA_TYPE_ARRAY   = '[',
    ORP_DATA_TYPE_VOID    = 'V',
    ORP_DATA_TYPE_STAR    = '*',
    ORP_DATA_TYPE_VALUE   = 'K',
    //
    ORP_DATA_TYPE_STRING  = '$',        // For constant strings
    //
    ORP_DATA_TYPE_INVALID = '?',
    ORP_DATA_TYPE_END     = ')'         // For the iterator
}; //ORP_Data_Type

#endif

// Based on Sec. 4.3.2.  For this interface it's irrelevant what the actual values are
// ('B', 'C', etc are just an example).
enum Java_Type {
    JAVA_TYPE_BYTE    = 'B',
    JAVA_TYPE_CHAR    = 'C',
    JAVA_TYPE_DOUBLE  = 'D',
    JAVA_TYPE_FLOAT   = 'F',
    JAVA_TYPE_INT     = 'I',
    JAVA_TYPE_LONG    = 'J',
    JAVA_TYPE_SHORT   = 'S',
    JAVA_TYPE_BOOLEAN = 'Z',
    JAVA_TYPE_CLASS   = 'L',
    JAVA_TYPE_ARRAY   = '[',
    JAVA_TYPE_VOID    = 'V',
#ifdef CLI_TESTING
    JAVA_TYPE_STAR    = '*',
#endif
    //
    JAVA_TYPE_STRING  = '$',        // For constant strings
    //
    JAVA_TYPE_INVALID = '?',
    JAVA_TYPE_END     = ')'         // For the iterator
}; //Java_Type


enum Java_Newarray_Type {
    JAVA_NEWARRAY_TYPE_BOOLEAN = 4,
    JAVA_NEWARRAY_TYPE_CHAR    = 5,
    JAVA_NEWARRAY_TYPE_FLOAT   = 6,
    JAVA_NEWARRAY_TYPE_DOUBLE  = 7,
    JAVA_NEWARRAY_TYPE_BYTE    = 8,
    JAVA_NEWARRAY_TYPE_SHORT   = 9,
    JAVA_NEWARRAY_TYPE_INT     = 10,
    JAVA_NEWARRAY_TYPE_LONG    = 11
}; //Java_Newarray_Type



#ifdef POINTER64
#ifndef OLD_OBJ_LAYOUT
#define OBJECT_HEADER_SIZE 0
#else
// Size of the header. Holds a pointer during Garbage Collection. Hence size = sizeof(POINTER)
#define OBJECT_HEADER_SIZE 8
#endif
// The size of an object reference. Used by arrays of object to determine
// the size of an element.
#define OBJECT_REF_SIZE 8

// The size of the VTable pointer
#define OBJECT_VTABLE_POINTER_SIZE 8

// The integer datatype on the platform that can hold a pointer.
#define POINTER_SIZE_INT uint64

// USed as default in pointer fields = to represent -1
#define POINTER_SIZE_MINUS_ONE 0xFFFFffffFFFFffff

// Used to ensure that the value one has is pointer aligned.
#define POINTER_ALIGNMENT_CHECK_MASK 0x07

#else
#ifndef OLD_OBJ_LAYOUT
#define OBJECT_HEADER_SIZE 0
#else
#define OBJECT_HEADER_SIZE 4
#endif
#define OBJECT_REF_SIZE 4
#define OBJECT_VTABLE_POINTER_SIZE 4
#define POINTER_SIZE_INT uint32
#define POINTER_SIZE_MINUS_ONE 0xFFFFffff
#define POINTER_ALIGNMENT_CHECK_MASK 0x03

#endif // POINTER64

#ifdef _IA64_

struct Registers {

    uint64 gr[32];
    uint64 preds;
    uint64 nats;
    uint64 pfs;
    uint64 *bsp;
    uint64 ip;

}; //Registers

struct Frame_Context {
    uint64 *p_ar_pfs;
    uint64 *p_eip;
    uint64 sp;
    uint64 *bsp;
    uint64 eip;
    uint64 *p_gr[128];
    uint64 *p_fp[128];
    uint64 nats_lo;
    uint64 nats_hi;

    // Those two fields are used to extract NaT bits for
    // RSE registers near the top of stack.
    uint64 *last_legal_rsnat;
    uint64 extra_nats;

    // KEN!
    // true if the frame the first frame on the stack
    // Right now, only jvmdi support uses this field.  It should be used by
    // gc enumeration and exception throwing routines.
    Boolean is_first;
}; //Frame_Context

#else

struct Registers {
    uint32 eax;
    uint32 ebx;
    uint32 ecx;
    uint32 edx;
    uint32 edi;
    uint32 esi;
    uint32 ebp;
    uint32 esp;
    uint32 eip;
}; //Registers


struct Frame_Context {
    uint32 esp;
    uint32 *p_ebp;
    uint32 *p_eip;

    // Callee-saved registers
    uint32 *p_edi;
    uint32 *p_esi;
    uint32 *p_ebx;

    uint32 ljf;        // This JIT must not touch this field!

    // This is only used as a placeholder if we don't want to allocate the memory
    // for eip somewhere else.  If this field contains a valid value, it is
    // pointed to by the p_eip field.
    uint32 eip;

    // The scratch registers are currently only valid during GC enumeration.
    uint32 *p_eax;
    uint32 *p_ecx;
    uint32 *p_edx;

    // KEN!
    // true if the frame the first frame on the stack
    // Right now, only jvmdi support uses this field.  It should be used by
    // gc enumeration and exception throwing routines.
    Boolean is_first;
}; //Frame_Context

#endif

#ifdef GC_REWORK
// opaque ref to Class strucutre.

typedef struct Class Class;
typedef struct Intfc_Table Intfc_Table;

// This is available to the GC.
typedef struct VTable {
	Class			*clss;          // the class - see above before change
    //
    // See the masks in orp_for_gc.h.
    //
    uint32 class_properties;

    // This typically holds an array of offsets to the pointers in 
    // and instance of this class. What is here is totally up to the
    // garbage collector side of the interface. It would be nice if this
    // was located immediately prior to the vtable, since that would 
    // eliminate a dereference.
    unsigned int *gc_information;

    // Offset from the top by CLASS_ALLOCATED_SIZE_OFFSET
    // The number of bytes allocated for this object. It is the same as
    // instance_data_size with the constraint bit cleared. This includes
    // the OBJECT_HEADER_SIZE as well as the OBJECT_VTABLE_POINTER_SIZE
    unsigned int allocated_size;

    unsigned int array_element_size;
	Intfc_Table		*intfc_table;	// interface table; NULL if no intfc table
//#ifdef FAST_INSTOF
	Class *superclasses[MAX_FAST_INSTOF_DEPTH]; //::
//#endif
	unsigned char	*methods[1];	// code for method
} VTable;

#endif


#endif //_ORP_TYPES_H_
