// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/orp_threads.h,v 1.15 2002/01/11 11:31:48 xli18 Exp $
//



#ifndef included_orp_threads
#define included_orp_threads

#include "platform.h"
#include "orp_types.h"
#include "stack_manipulation.h"
#include "root_set_enum.h"
 
#include "gc_for_orp.h"
#include "orp_for_gc.h"

#ifdef _DEBUG

// stolen from line 72 of orp_types.h
enum Slot_Type {
    SLOT_TYPE_ADDRESS = 'A',
    SLOT_TYPE_BYTE    = 'B',
    SLOT_TYPE_CHAR    = 'C',
    SLOT_TYPE_DOUBLE  = 'D',
    SLOT_TYPE_FLOAT   = 'F',
    SLOT_TYPE_INT     = 'I',
    SLOT_TYPE_LONG    = 'J',
    SLOT_TYPE_SHORT   = 'S',
    SLOT_TYPE_BOOLEAN = 'Z',
    SLOT_TYPE_CLASS   = 'L',
    SLOT_TYPE_ARRAY   = '[',
    SLOT_TYPE_VOID    = 'V',
    SLOT_TYPE_NULL = 0,
}; //Slot_Type

#endif


// for SMP use the below
#define orp_lock_prefix lock

// for UP use the below
//#define orp_lock_prefix

enum safepoint_state {
    nill = 0,
    enumerate_the_universe, // for sapphire just means sapphire is running.
    java_suspend_one_thread,
    java_debugger,
};

extern volatile safepoint_state global_safepoint_status;

#ifndef USE_GC_DLL
extern volatile int global_gc_count;
#endif

enum trap_state {
    x_nothing = 0,
    x_the_safepoint_control_thread,
    x_lock_enum,
    x_lock_enum_or_null,
    x_orp_enable_gc,
    x_suspend_in_java_frame,
    x_java_suspended,
    x_at_breakpoint,
    x_orp_stop_thread_for_gc_ret,
    x_orp_throw,
    x_orp_execute_java_method_array,
    x_native_wrapper,
    x_java_sleep,
    x_java_wait,
};

enum java_state {
    zip = 0,
    thread_is_sleeping,
    thread_is_waiting,
    thread_is_birthing,
    thread_is_running,
    thread_is_dying,
};
// These are thread level gc states. 
enum gc_state {
    zero = 0,
    gc_moving_to_safepoint,
    gc_at_safepoint,
    gc_enumeration_done,
};

// These are thread level gc states. 
enum gc_debug_state {
    gc_resumed = 0,
    gc_waiting_for_resume,
    gc_trying_to_stop_thread,
    gc_thread_being_stopped,
};


#ifdef GC_SAPPHIRE

//
// If Sapphire wants a thread to stop it changes the gc_state as follows 
// Current state              New state
// zero                       gc_moving_to_safepoint
// gc_moving_to_safepoint     gc_at_safepoint
// gc_at_safepoint            gc_enumeration_done
//
// When sapphire is done it does the following transition
// gc_enumeration_done        zero
//
// Sapphire may repeat this process several times but when
// it is started Sapphire will expect a zero state and when
// it is over Sapphire will have a zero state.
//

//
// Once the global_safepoint_status is enumerate_the_universe then
// we manipulate gc_state as appropriate. The gc_sapphire_state is
// a thread specific state that is used to indicate what sapphire
// is either doing or attempting to do.
//

enum gc_sapphire_state {
    sapphire_normal,            // Sapphire collection not happening at this time.
	sapphire_releasing_nursery, // mark_copy
	sapphire_nursery_released,  // mark_copy
	sapphire_enumerate,         // mark_copy
    sapphire_enumeration_done,
	sapphire_between_enumerations,
    sapphire_flip,
    sapphire_flipped,
	sapphire_suspend,
    sapphire_stabilize,
};
#endif

enum lock_or_wait {
	zilch = 0,
    holding_the_lock,
    waiting_for_the_lock,
    waiting_for_the_notify,
    owning_thread_needs_to_call_free_routine,
};

enum lock_or_link_discriminator {
    lock_or_link_descriminator_is_bogus,
    normal_lock_block,
    sapphire_link_block,
};

typedef struct Lock_Block {
   
    volatile POINTER_SIZE_INT          *p_object_header;       // points to the object header
                                                               // Sapphire depends on this being
                                                               // being the first slot in a
                                                               // lock block (see below)
    volatile POINTER_SIZE_INT          old_object_header;
    struct Lock_Block *p_forward_link;
    struct Lock_Block *p_back_link;
    struct Lock_Block *p_active_or_free;              // link list on p_active_lock_blocks
                                                      // or on p_free_lock_blocks
    lock_or_link_discriminator       discriminator;   // *** Must be at the same location
                                                      // in the Lock_Block as in the 
                                                      // Sapphire_Link_Block.
    lock_or_wait            lock_or_wait_state;
    POINTER_SIZE_INT        lock_recursion_count_shifted_left;
    class ORP_thread        *p_orp_thread;

} Lock_Block;

#ifdef GC_SAPPHIRE
//
//  The header in an object is overloaded by Sapphire to either hold a Lock_Block (defined
//  above) or a Sapphire_Link_Block (defined below). Since the number of bits in the header
//  is at a premium for IA32, Sapphire distinquishes the difference between the pointer
//  to a Lock_Block and to Sapphire_Link_Block by inspecting the first slot in the block.
//  If the slot holds a pointer back to the header from whence it came then we have a
//  Lock_Block. If it holds a pointer to another object (not the header), 
//  in this case the "to" object used by Sapphire, then we know we have 
//  a Sapphire_Link_Block.
//  The Sapphire_Link_Block holds a pointer back to the "from" object in the second slot
//  a value that will never be found in the second slot of a Lock_Block. This fact can
//  be used in an assert to assist in debugging.
typedef struct Sapphire_Link_Block {
    Java_java_lang_Object   *sapphire_to_object;
    Java_java_lang_Object   *sapphire_from_object;
    volatile Sapphire_Link_Block     *p_next_sapphire_link_block;
    void *ignore;
    void *ignore1; // Pad so that lock_or_link_descriminator is the 6th field. in 
                   // both Sapphire_Link_Block and Lock_Block.
    lock_or_link_discriminator       discriminator;// *** Must be at the same location
                                                      // in the Lock_Block as in the 
                                                      // Sapphire_Link_Block.
	sapphire_tri_color      sapphire_color;
    bool sapphire_using;
} Sapphire_Link_Block;
#endif // GC_SAPPHIRE

typedef struct _thread_array {
    ORP_thread *p_orpthread;
} thread_array;
extern thread_array quick_thread_id[];

class ORP_thread {

public:

    void *get_last_java_frame() { return last_java_frame; };


    volatile                Java_java_lang_Thread   *p_java_lang_thread;
    volatile                Java_java_lang_Object   *p_current_object;
    volatile                Java_java_lang_Object   *p_exception_object;

    ORP_thread                *p_free;
    ORP_thread                *p_active;

    Lock_Block              *p_free_lock_blocks;        
    Lock_Block              *p_active_lock_blocks;  // used by 'L' command in debugger

    POINTER_SIZE_INT        quick_thread_index;
    POINTER_SIZE_INT        quick_thread_index_shifted_left;
    POINTER_SIZE_INT        quick_thread_index_shifted_left_with_recursion_set_to_one;

    java_state              app_status;
    gc_state                gc_status; 
    gc_debug_state          gc_debug_status; 
#ifdef GC_SAPPHIRE
    // gc_sapphire_state plus gc_state gives sapphire state. 
    gc_sapphire_state       gc_sapphire_status;
#endif // GC_SAPPHIRE
    uint32                  lock_bit_for_gc_status;  // must atomically move gc_moving_to_safepoint
                                                     // to gc_at_safepoint

    bool                    interrupt_thread_api_support; // see lang.Thread.interrupt()
    bool                    interrupt_a_waiting_thread;
    bool                    thread_is_java_suspended;

    Registers               regs;

    // This is for IA32 only
    J2N_Saved_State *       last_java_frame;

    // This is for IA64 only
    void *                  saved_ar_bsp;

    void *                  p_stop_object;

    // support for "malloc" style heap (for debugging only)
    uint8 *                 p_memory_start;
    uint8 *                 p_memory_end;
    uint8 *                 p_memory_free;
 
    // This is a (Nursery *) but the type is not revealed in this context.
	// p_nursery is always null for GC_NONE_V0 and GC_FIXED_V1
    void                    *p_nursery;
 
    // For stack trace creation
    Frame_Context *throw_context;
    Boolean        throw_context_is_first;

    // RNI-style GC approach for native methods
    gc_enable_disable_state gc_enabled_status;
    GC_Frame                *gc_frames;

    // gc enumeration support
    uint32 *hijack_p_eip;
    uint32 hijack_old_eip;
    Method *hijack_returning_from;
    bool restore_context_after_gc;
    Frame_Context gc_frame_context;
	// gc frame throw_context
	Frame_Context gc_frame_throw_context;
#ifndef _IA64_
	uint32 gc_frame_context_eax_var;
	uint32 gc_frame_context_eip_var;
#endif
    trap_state which_trap;

#define LH_MALLOC_FREE          0x0001
    unsigned locks_held;
    void locks_held_add(unsigned mask) { locks_held |= mask; };
    void locks_held_remove(unsigned mask) { locks_held &= ~mask; };
    void set_locks_held(unsigned mask) { locks_held = mask; };
    unsigned get_locks_held() { return locks_held; };


#ifdef _DEBUG
//
// put all system-wide performance analysis 
// instrumentation here
//
    int32                   number_of_recursion_depth;
    int32                   number_of_lock_blocks_allocated;
    int32                   number_of_monitor_enters;
    int32                   number_of_monitor_exits;
    int32                   number_of_waiting_for_the_lock;
    int32                   number_of_total_recursions;
    int32                   number_of_wait;
    int32                   number_of_notifyAll;
    int32                   number_of_notify;
    int32                   number_of_timed_wait_for_lock_SleepEx;
    int32                   number_of_enter_SleepEx;
    int32                   number_of_exit_SleepEx;
    int32                   number_of_objects_allocated;
    int32                   number_of_clone;
    int32                   number_of_hashCode;
	//
	// for Milind
	//
	uint32                  allocation_count;

    Lock_Block              *p_latest_mon_enter_lock_block;
    Lock_Block              *p_latest_wait_lock_block;

    // support for JVMDI (java debugger interface)
    bool    report_jvmdi_event_single_step;
    bool    report_jvmdi_event_exception_catch;
    bool    report_jvmdi_event_method_entry;
    bool    report_jvmdi_event_method_exit;
#endif

// below are OS specific fields of 

#if defined(ORP_NT)

    HANDLE                  event_handle_monitor;
    HANDLE                  event_handle_sleep;
    HANDLE                  event_handle_interrupt;
	HANDLE					event_handle_suspend0;
    HANDLE                  thread_handle;
    HANDLE                  gc_resume_event_handle;
    DWORD                   thread_id;

#elif defined (ORP_POSIX)

    int                  event_handle_monitor;
    int                  event_handle_sleep;
    int                  event_handle_interrupt;
	int				   	 event_handle_suspend0;
    int                  thread_handle;
    int                  gc_resume_event_handle;
    int                  thread_id;


#else
#error
#endif

#ifdef OBJECT_LOCK_V2
    int thread_index;
    int notify_recursion_count;
    HANDLE  event_handle_notify_or_interrupt;
	unsigned short stack_key;
#endif //#ifdef OBJECT_LOCK_V2

#ifdef GC_SAPPHIRE
    void    *ssb_container;  // points to the ssb related to this thread
#endif
};



#ifdef __cplusplus
extern "C" {
#endif

#ifdef ORP_POSIX
#define STACK_MASK 0xffE00000
#define STACK_KEY_SHIFT 21
#else
#define STACK_MASK 0xffFF0000
#define STACK_KEY_SHIFT 16
#endif 

extern unsigned int thread_local_storage_offset;
extern int next_thread_index;

inline ORP_thread *get_thread_ptr()
{
	ORP_thread **p_thr;

    unsigned int stk = (unsigned int)&p_thr;

    stk = stk & STACK_MASK;

    p_thr = (ORP_thread **)(stk + thread_local_storage_offset);
	return *p_thr;
}

#if defined(ORP_NT)

#ifndef OBJECT_LOCK_V2
extern __declspec(thread) ORP_thread *p_TLS_orpthread;
#else
#define p_TLS_orpthread (get_thread_ptr())
#endif 

#define SUSPEND_THREAD(orpthread) SuspendThread((orpthread)->thread_handle)
#define RESUME_THREAD(orpthread) ResumeThread((orpthread)->thread_handle)

#elif defined(ORP_POSIX)

// Linux asserts if these are called, signal logic TBD
inline DWORD _enum_bad_call(){assert(0); return 1;}
#define SUSPEND_THREAD(orpthread) _enum_bad_call()
#define RESUME_THREAD(orpthread) _enum_bad_call()

#ifndef OBJECT_LOCK_V2

#if( defined LINUX_TLS_OPT && defined REDHAT_RELEASE )
#define p_TLS_orpthread ((ORP_thread *)get_specific00())
#else
#define p_TLS_orpthread ((ORP_thread *)pthread_getspecific(thread_local_storage_key))
#endif

#else //#ifndef OBJECT_LOCK_V2

#define p_TLS_orpthread (get_thread_ptr())
#endif //#ifndef OBJECT_LOCK_V2

#endif //defined(ORP_POSIX)


extern ORP_thread *p_free_thread_blocks;

extern ORP_thread *p_active_threads_list;
extern volatile ORP_thread *p_the_safepoint_control_thread;

extern unsigned non_daemon_thread_count;

extern HANDLE non_daemon_threads_dead_handle;

void object_locks_init();
Lock_Block *get_a_block(ORP_thread *);
void free_this_block(ORP_thread *, Lock_Block *p_block);
void internal_suspend_utility(ORP_thread * p_thr);
// toss this void try_crit_section(void **pp_this);  // <<-- TOSS THIS

unsigned __stdcall call_the_run_method( void * p_xx );

bool in_busybit_critical_zone(ORP_thread *);

void start_of_object_busybit_critical_zone();
void end_of_object_busybit_critical_zone();

void start_of_thread_busybit_critical_zone();
void end_of_thread_busybit_critical_zone();

void  start_of_thread_manager_busybit_critical_zone();
void  end_of_thread_manager_busybit_critical_zone();


void thread_gc_suspend_one(ORP_thread *);
#ifdef USE_GC_DLL
ORPExport
#endif
uint32 thread_gc_number_of_threads(); 
ORP_thread *thread_gc_enumerate_one();
Registers *thread_gc_get_context(ORP_thread *);
void thread_gc_set_context(ORP_thread *);
void thread_gc_run_to_safepoint(ORP_thread *, unsigned int);
bool check_threads_gc_status(ORP_thread *);

void wait_until_non_daemon_threads_are_dead();

#ifdef ORP_POSIX
#else
#ifdef _DEBUG
// This code is used only for debugging purposes so no code
// should relie on the gc_debug_state being accurate when _DEBUG is
// not defined.
inline void thread_set_gc_debug_status (gc_debug_state state)
{
    p_TLS_orpthread->gc_debug_status = state;
}
#else
// For fast code inline nothing.
inline void thread_set_gc_debug_status (gc_debug_state state)
{
    // In release code gc_debug_status is not valid.
}

#endif
#endif
 
#ifdef CONCURRENCY_ANALYSIS
    extern FILE *f_concur;
#endif //#ifdef CONCURRENCY_ANALYSIS

uint64 readTimeStampCounter();

#ifdef __cplusplus
}
#endif

     
#endif

