// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/orp_stats.h,v 1.2 2001/10/25 08:44:00 xli18 Exp $
//




#ifndef _ORP_STATS_H_
#define _ORP_STATS_H_


#include "orp_types.h"


class ORP_Statistics
{
public:
    uint64 num_exceptions;
    uint64 num_exceptions_caught_same_frame;
    uint64 num_exceptions_object_not_created;
    uint64 num_exceptions_dead_object;
    uint64 num_array_index_throw;
    uint64 num_native_methods;
    uint64 num_java_methods;
    uint64 num_fill_in_stack_trace;
    uint64 num_unwind_java_frames_gc;
    uint64 num_unwind_native_frames_gc;
    uint64 num_unwind_java_frames_non_gc;
    uint64 num_unwind_native_frames_all;
    uint64 max_stack_trace;

    uint64 num_instanceof;
    uint64 num_instanceof_non_null;
    uint64 num_instanceof_equal;
    uint64 num_instanceof_class;
    uint64 num_instanceof_class_recursive;
    uint64 num_instanceof_s_is_array;
    uint64 num_instanceof_t_is_intf;
    uint64 num_instanceof_t_is_intf_success;
    uint64 num_instanceof_class_reversed;
    uint64 num_instanceof_class_reversed_recursive;

    uint64 num_optimistic_depth_success;
    uint64 num_optimistic_depth_failure;
    uint64 num_method_lookup_cache_hit;
    uint64 num_method_lookup_cache_miss;

    uint64 num_aastores;
    uint64 num_instanceof_in_aastore;
    uint64 num_aastore_exceptions;
    uint64 num_aastore_instanceof;

    uint64 num_invokeinterface_calls;
    uint64 num_invokeinterface_calls_size_1;
    uint64 num_invokeinterface_calls_searched_1;
    uint64 num_invokeinterface_calls_size_2;
    uint64 num_invokeinterface_calls_searched_2;
    uint64 num_invokeinterface_calls_size_many;
    uint64 num_invokeinterface_calls_searched_many;
    uint64 invokeinterface_calls_size_max;
    uint64 invokeinterface_calls_searched_max;

    uint64 num_instantiate_cp_string_fast;
    uint64 num_instantiate_cp_string_fast_returned_interned;
    uint64 num_instantiate_cp_string_fast_success_long_path;
    uint64 num_instantiate_cp_string_slow;

    uint64 num_class_alloc_new_object_or_null;
    uint64 num_class_alloc_new_object;
    uint64 num_class_alloc_new_object_with_finalizer_or_null;
    uint64 num_class_alloc_new_object_with_finalizer;

    uint64 num_anewarray;
    uint64 num_multianewarray;
    uint64 num_newarray;
    uint64 num_newarray_char;
    uint64 num_newarray_float;
    uint64 num_newarray_double;
    uint64 num_newarray_boolean;
    uint64 num_newarray_byte;
    uint64 num_newarray_short;
    uint64 num_newarray_int;
    uint64 num_newarray_long;

    uint64 num_is_class_initialized;

    uint64 num_get_addr_of_orp_last_java_frame;

    uint64 num_f2i;
    uint64 num_f2l;
    uint64 num_d2i;
    uint64 num_d2l;

#ifdef _DEBUG
    uint64 num_lazy_monitor_enter;
    uint64 num_lazy_monitor_exit;
#endif

    uint64 num_monitor_enter_fastcall;
    uint64 num_monitor_exit_fastcall;
    uint64 num_monitor_enter;
    uint64 num_monitor_exit;

    uint64 num_monitor_enter_wait;
    uint64 num_sleep_monitor_enter;
    uint64 num_sleep_monitor_exit;
    uint64 num_sleep_notify_all;
    uint64 num_sleep_notify;
    uint64 num_sleep_interrupt_the_wait;
    uint64 num_sleep_wait;
    uint64 num_sleep_java_thread_yield;
    uint64 num_wait_WaitForSingleObject;
    uint64 num_sleep_hashcode;
    uint64 num_sleep_monitor_ownership;

    uint64 num_monitor_enters_with_zero_headers;
    uint64 num_monitor_enters_with_nonzero_headers;

    ORP_Statistics();

    void print();
}; //ORP_Statistics


ORPExport extern ORP_Statistics orp_stats_total;

extern bool orp_print_total_stats;
extern int orp_print_total_stats_level;


#endif
