// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/method_lookup.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//




#ifndef _METHOD_LOOKUP_H_
#define _METHOD_LOOKUP_H_


#include "Class.h"


enum ORP_Code_Type {
    ORP_TYPE_JAVA,
    ORP_TYPE_NATIVE_STUB,
    ORP_TYPE_UNKNOWN,
};


ORPExport ORP_Code_Type orp_identify_eip(void *addr);
ORP_Code_Type orp_identify_eip_deadlock_free(void *addr);



class Method_Lookup_Table
{
public:

    Method_Lookup_Table();

    void add(JIT_Specific_Info *m);

    ORPExport JIT_Specific_Info *find(void *addr);
    JIT_Specific_Info *find_deadlock_free(void *addr);

    void unload_all();

    // An iterator for methods compiled by the specific JIT.
    JIT_Specific_Info *get_first_method_jit(JIT *jit);
    JIT_Specific_Info *get_next_method_jit(JIT_Specific_Info *jit);

#ifdef _DEBUG
    void dump();
    void verify();
#endif

#ifdef ORP_STATS
    void print_stats();
#endif

private:

    void reallocate(unsigned new_capacity);
    unsigned find_index(void *addr);

    unsigned _capacity;
    unsigned _next_entry;
    JIT_Specific_Info **_table;

    JIT_Specific_Info **_cache;
}; //Method_Lookup_Table



ORPExport extern Method_Lookup_Table methods;



#endif
