// Copyright (C)  2001 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/GlobalClassIterator.h,v 1.1 2001/11/12 10:29:14 gwu2 Exp $
//

#ifndef __GlobalClassIterator__
#define __GlobalClassIterator__

/*
class GlobalClassIterator {
public:
	static void first();
	static Class** next();
private:
	GlobalClassIterator(){
	}
	static long _loader_index;
	static Class **_ppclass;
	static Class_Table *_table;
};

#define INIT_GLOBAL_CLASS_ITERATOR() \
	long GlobalClassIterator::_loader_index = -1; \
	Class **GlobalClassIterator::_ppclass = NULL;	\
	Class_Table *GlobalClassIterator::_table = NULL;

*/

class GlobalClassIterator {
public:
	void first();
	Class** next();
private:
	long _loader_index;
	Class **_ppclass;
	Class_Table *_table;
};

void GlobalClassIterator::first(){
	_loader_index = -1;
	_ppclass = NULL;
	_table = NULL;
}

Class** GlobalClassIterator::next(){
	if(_loader_index < -1 || _loader_index >= (long)Class_Loader::_next_entry)
		return NULL;
	if(!_table){
		if(_loader_index == -1)
			_table = &(ORP_Global_State::loader_env->class_table);
		else
			_table = Class_Loader::_table[_loader_index]->class_table;
	}
	Class **ppclass;
	if(!_ppclass)
		ppclass = _table->get_first_class();
	else
		ppclass = _table->get_next_class(*_ppclass);
	if(ppclass)
		return _ppclass = ppclass;
	++_loader_index;
	_table = NULL;
	_ppclass = NULL;
	return next();
}

#endif