// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/step.cpp,v 1.8 2002/01/11 15:47:38 weldon Exp $
//

#include "step.h"
#include "card_table.h"
#include "gc_asserts.h"
#include "gc_hooks.h"
#include "gc_debug.h"
#include "gc_globals.h"
#include "gc_plan.h"
#include "nursery_step_gen.h"
#include "block_store.h"
// 
// Alloc up a new step block.
//
block_info *p_add_new_step_block(block_list_info *the_block_list_info)
{
    block_info *a_block = p_get_new_block(true, false, true);  
    assert (gc_block_status_table[a_block->block_status_table_index] == block_in_free);
    gc_block_status_table[a_block->block_status_table_index] = block_in_step;
    a_block->in_step_p = true;
    a_block->in_free_p =false;
    assert (a_block->train_birthday == 0);
    assert (a_block->car_birthday == 0);
    //    a_block->is_in_young_object_space = true;
    a_block->list_info = the_block_list_info;
    return a_block;
}

//
// Initialize the step data structure.
//
block_list_info *add_new_step ()
{
    block_list_info *result = (block_list_info *)malloc (sizeof(block_list_info));
    if (!result) {
        orp_cout << "Malloc failed for new_step." << endl;
//       orp_exit  (911);
        assert (0);
    }

    memset ((void *)result, 0, (sizeof (block_list_info)));
    result->blocks = p_add_new_step_block(result);
    result->scan_block = result->blocks;
    result->alloc_block = result->blocks;
    return result;
}

//
// Before the stop-the-world collection, our containing generation
// gives an opportunity to set up cheney spaces.
//
void 
set_up_step_cheney_spaces(step_info *step, block_info **pp_step_from_blocks)
{
    *pp_step_from_blocks = step->blocks;
    // reset all the fields, the from blocks will be freed in cleanup.
    step->blocks = p_add_new_step_block(step);
    step->scan_block = step->blocks;
    step->alloc_block = step->blocks;
    step->next = NULL;
}

//
// Create a step (done by Step_Plus_Nursery_Generation).
//
Step::Step(unsigned long step_id,
     Gc_Fast_Hooks *p_gc_hooks,
     Gc_Plan       *p_gc_plan,
	 Generation    *p_container,
	 Gc_Space      *p_superior,
     Card_Table    *p_card_table,
	 Block_Store   *p_block_store)

   : Block_List(step_id, 
                p_gc_hooks,
                p_gc_plan,
                p_container, 
                p_superior, 
                p_card_table,
                p_block_store)	{
    assert(0);
}




// end file gc\step.cpp
