// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/include/scan_set.h,v 1.2 2001/10/12 14:47:04 rlhudson Exp $
//

#ifndef _Scan_Set_H_
#define _Scan_Set_H_

//
// A Scan Set maintains a list of steps or cars which have scan pointers
// which lag free pointers, thereby requiring a cheney scan.
//

#include "platform.h"
#include "object_layout.h"
#include "hash_table.h"

class Scan_Set :public Hash_Table {
public:
    inline unsigned add_entry(Gc_Space *p_gc_space) {
		return Hash_Table::add_entry((void *)p_gc_space);
	}

	inline int delete_entry(Gc_Space *p_gc_space) {
		return Hash_Table::delete_entry((void *)p_gc_space);
	}

    inline bool is_present(Gc_Space *p_gc_space) {
		return Hash_Table::is_present((void *)p_gc_space);
	}

	inline Gc_Space *next(void) {
		return (Gc_Space *)Hash_Table::next();
	}

	inline Gc_Space *next_delete(void) {
		return (Gc_Space *)Hash_Table::next_delete();
	}

};

#endif // _Scan_Set_H_

