// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/include/obsolete_space.h,v 1.4 2001/11/05 13:36:35 rlhudson Exp $
//

#ifndef _obsolete_space_H_
#define _obsolete_space_H_

//
// This is a fake space that is associated with unallocated or invalid
// blocks in the block table.
//


#include "block_store.h"
#include "remembered_set.h"
#include "object_layout.h"
#include "train_generation.h"

#include "gc_space.h"

class Card_Table;
class Train;

class Obsolete_Space : public Gc_Space {
public:
	Gc_Space *p_previous;
    Obsolete_Space(Gc_Space *p_current)
		: Gc_Space(0, NULL, NULL, NULL, NULL, NULL, NULL)
	{
		p_previous = p_current;
	}

    ~Obsolete_Space() {
	}
	//
	// Do any required cleanup at the end of the collection.
	//
	virtual void cleanup() {
		orp_exit(1); // illegal
	}

	//
	// routines for introspection
	//

	virtual bool is_car() {
		return p_previous->is_car();
	}

	virtual bool is_large_object_space() {
		return p_previous->is_large_object_space();
	}

	virtual bool is_nursery() {
		return p_previous->is_nursery();
	}

    virtual bool is_train() {
        return false;
    }


	virtual bool is_step() {
		return p_previous->is_step();
	}
	virtual bool is_obsolete() {
		return true;
	}



	//
	// Merge the entries in the incoming remembered set with entry.
    // This is only valid for GC Spaces with their own remembered sets.
    // (Such as cars, and unlike nurseries and steps.)
	//
	virtual void update_remembered_set(Java_java_lang_Object **pp_obj) {
		cout << "Error: attempt to add entry to a Obsolete Space rs" << endl;
        orp_exit(1);
	}

private:

};

#endif // _obsolete_space_H_

