// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/include/object_set.h,v 1.1 2001/09/14 18:01:59 rlhudson Exp $
//


#ifndef _object_set_H_
#define _object_set_H_

//
// Holds a database of object for bookkeeping or debugging
//


#include "platform.h"
#include "object_layout.h"
#include "hash_table.h"

//
// Object Databases inherit from Hash Table and enhance it
// by typing the entries of the Hash Table to be pointers
// to Java_lang_Object.
//
class Object_Set : public Hash_Table {
public:
    inline unsigned add_entry(Java_java_lang_Object *address) {
		return Hash_Table::add_entry((void *)address);
	}

	inline int delete_entry(Java_java_lang_Object *address) {
		return Hash_Table::delete_entry((void *)address);
	}

    Object_Set *merge(Object_Database *rs) {
		return (Object_Set *)Hash_Table::merge((Hash_Table *)rs);
	}

    inline bool is_present(Java_java_lang_Object *address) {
		return Hash_Table::is_present((void *)address);
	}

	inline Java_java_lang_Object *next(void) {
		return (Java_java_lang_Object *)Hash_Table::next();
	}

	inline Java_java_lang_Object *next_delete(void) {
		return (Java_java_lang_Object *)Hash_Table::next_delete();
	}

    void update(Java_java_lang_Object *p_source,
                Java_java_lang_Object *p_target);
};

#endif // _object_set_H_

