// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/gc_globals.cpp,v 1.9 2002/01/11 15:47:38 weldon Exp $
//

#include "platform.h"
#include "block_store.h"
#include "gc_hooks.h"
#include "card_table.h"
#include "remembered_set.h"
#include "pair_table.h"

char *p_plan_file_name;
bool verbose_gc = false;
bool fixed_gc   = false;
bool copy_gc   = false;
bool stats_gc = false;
bool use_zeroing_thread   = false;
bool use_fetcher_thread   = false;
bool use_cheney_clock   = false;
int  fetcher_gap = 65536;
//
// If the user's command line doesn't set this, then the
// default from the plan file will.
//
unsigned long initial_heap_size_bytes = 0;
unsigned long final_heap_size_bytes = 0;
unsigned long current_heap_size_bytes = 0;

unsigned long large_object_size = 1024;

// Put some counts here so that we don't have to redo them at the start of 
// each GC.
// THESE ARE NOT THREAD SAFE SO DON"T USE WITH ++ or --
int gc_global_free_count = 0;
int gc_global_used_count = 0;
int gc_global_step_count = 0;
int gc_global_los_count = 0;
int gc_global_train_count = 0;
int gc_global_nursery_count = 0;

// Set to true if the heap has been extended. This will make the algorithm more paranoid.
boolean heap_was_extended = false;

//
// This is a global pointer to the base of the GC heap for debugging.
//
void *p_gc_base;

//
// This debugging pointer is to the top of the reserved virtual space
// for the GC heap.
//
void *p_gc_ceiling;

#ifdef SPACE_DEMOGRAPHICS
    //
    // Determine the size distribution of the java objects of a workload.
    //
volatile unsigned space_demographics_size[DEMOGRAPHICS_ARRAY_SIZE];

#endif

//
// This remembered set has an entry per loaded class.
// It is used for determining valid vtable pointers
// when examining candidate objects.
//

Pair_Table *p_loaded_vtable_directory = NULL;

//
// Global to specify the size differentiating
//
unsigned los_threshold_bytes;

//
// Made global for debugging purposes.
//
unsigned int incremental_collection_count;

//
// This is there so that C code can call Gc Hooks.
//
Gc_Fast_Hooks    *p_global_hooks;
//
// Similarly for block store access from C code.
//
Block_Store *p_global_bs;

//
// The following flag is turned on if the user specifies
// -verbosegc at the command line. It triggers descriptive
// messages related to the progress of the garbage collector.
//
bool global_verbose_gc;

bool garbage_collector_is_initialized = false;

#ifdef GC_TORTURE_1
//
// If this is set to true then execute a gc during the next gc_malloc
// and set it to false. Use the routine force_gc to set this to true.
//

bool force_gc_flag = false;

#endif // GC_TORTURE_1

// 
// An unsigned counter used to determine the number of write barrier calls made
// during a run.
//

#ifdef GC_COUNT_WRITE_BARRIERS
unsigned int gc_write_barrier_count = 0;
#endif

//
// This variable points to the base of the garbage collected heap.
// It is used by the write barrier implementation code, which
// uses this global to avoid making a function call.
//
POINTER_SIZE_INT global_heap_base;

#if (GC_DEBUG>3)
CRITICAL_SECTION _printCriticalSection;
bool do_init_print = true;
#endif

//
// This flag is initially false, and is set to true when the
// ORP is fully initialized. This signals that any stop-the-world
// collections can occur.
//
bool orp_initialized;

// The SDK0.5 seems happier if I put a procedure in this file.
// REMOVE THIS ONCE WE GET A NEWER VERSION OF THE SDK.
// RLH 4-8-99 
void ia64_needs_a_procedure_here () {
	assert (0); // it had better never be called
}
// GC_INTERIOR_POINTERS
// 
// This is the table holding all the interior pointers used in any given execution 
// of a GC. It is reused each time a GC is done.

slot_offset_list *interior_pointer_table;

#ifdef GC_PT_WB
UINT (*func_GetWriteWatch) (IN DWORD dwFlags,          // write-tracking state
							  IN PVOID lpBaseAddress,    // base address of region
							  IN SIZE_T dwRegionSize,    // size of region
							  IN OUT PVOID  *lpAddresses,    // array of page addresses
							  IN OUT PULONG lpdwCount,   //  IN OUT PULONG_PTR lpdwCount,   // number of addresses returned
							  OUT PULONG lpdwGranularity  // page size
							  );

UINT (*func_ResetWriteWatch)(PVOID lpBaseAddress,
							   SIZE_T dwRegionSize
							   ); 
#endif // GC_PT_WB


// Current train creation day. Incremented when you create a new train. Will never overflow.
// 0 is used by YOS - nurseries and steps.

POINTER_SIZE_INT current_train_creation_date = 1;

block_info *nurseries[MAX_NURSERIES];

int allocated_nurseries = 0;

int free_nursery_hint = 0;

// All nurseries are either on the spent_nurseries list or on the free_nurseries list.

// nurseries on the spent nurseries list need are available for collection, if the
// active flag is set they are being used by threads so need to be cleared at the
// end of the collection.

// block_info *spent_nurseries;

// active nurseries are nurseries being used by the threads. Nurseries start on the free_nurseries list,
// move to the active_nurseries list and when full move to the spent_nurseries list. After a GC
// nurseries move from the spent_nurseries list to the free_nurseries list. Those on the active_nurseries
// list remain there to be reused by the threads.

// block_info *active_nurseries;

// nurseries on the free_nurseries list are available to be assigned to a thread
// block_info *free_nurseries;


// This is the step that is used to age objects that are from nurseries. It is a list
// of blocks linked through the next field.


step_info *step;
block_info *step_from_blocks;

// We have several block lists each taking object of a given size.

block_info *los_buckets[GC_LOS_BUCKETS];


// We have several block lists each taking object of a given size.

block_info *los_buckets_free_hint[GC_LOS_BUCKETS];

// The train structure is a linked list of train_info structs with pointers to cars.

train_info *trains;

// end file gc\gc_globals.cpp
