// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/gc_component.cpp,v 1.1 2001/09/14 18:01:59 rlhudson Exp $
//
 
#include "gc_for_orp.h"
 
#include "gc_component.h"
#include "gc_hooks.h"
#include "gc_plan.h"
#include "block_store.h"
 

Gc_Component::Gc_Component(Gc_Fast_Hooks  *p_gc_hooks,
                           Gc_Plan        *p_gc_plan,
                           Block_Store    *p_block_store) 
{
    _p_gc_hooks = p_gc_hooks;

    _p_gc_plan  = p_gc_plan;

    _p_block_store = p_block_store;

    //
    // Needed for multi-thread collectors.
    //
    InitializeCriticalSection(&_lock);
}

Gc_Component::~Gc_Component() 
{
    DeleteCriticalSection(&_lock);
}

void
Gc_Component::lock()
{
	assert(0);
}

//
// Use the lock manager instead of this code.
//
void
Gc_Component::lock(CRITICAL_SECTION *p_cs)
{
    assert(0); 
}

void 
Gc_Component::unlock()
{
    assert(0);
}

//
// Again, a temporary hack to work around an impure design.
//
void
Gc_Component::unlock(CRITICAL_SECTION *p_cs)
{
    LeaveCriticalSection(p_cs);
}

// end file gc\gc_component.cpp
