// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/win32_api.cpp,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//

#include "win32_api.h"
#include "iostream.h"

//
// This routine elevates the level of the invoking worker (GC)
// thread above those of the Java threads. 
//
void Win32_Api::_p_os_boost_gc_thread_priority() {
    HANDLE ThreadHandle = GetCurrentThread();

    if (SetThreadPriority(ThreadHandle, 
        THREAD_PRIORITY_ABOVE_NORMAL)) {
        return;
    }

#if (GC_DEBUG>2)
    cerr << "Failed to boost GC thread priority. Error = ";
    cerr << GetLastError() << endl;
#endif
}

//
// This routine returns the level of the invoking worker thread
// to normal.
//
void Win32_Api::_p_os_drop_gc_thread_priority()
{
    HANDLE ThreadHandle = GetCurrentThread();

    if (SetThreadPriority(ThreadHandle, 
        THREAD_PRIORITY_NORMAL)) {
        return;
    }

#if (GC_DEBUG>2)
    cerr << "Failed to restore GC thread priority. Error = ";
    cerr << GetLastError() << endl;
#endif
}

// end file gc\win32.cpp
