// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/gc_header.cpp,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//

#include "platform.h"
#include "gc_header.h"
#include "orp_types.h"
//#include "native.h"    /* in ..\native\include\ */
#include "gc_debug.h"
#include "gc_space.h"
 
#ifdef OBJECT_SPLITTING
#include "gc_plan.h"
#endif // OBJECT_SPLITTING

#include "gc_globals.h"

//#if (GC_DEBUG>0)
#include "Block_Store.h"
#include "step.h"
#include "los.h"
 
#include "gc_for_orp.h"

#ifdef GC_SAPPHIRE
// Yet another kludge to keep sapphire code seperated.
#include "sapphire.h"
#endif // GC_SAPPHIRE
 
extern Block_Store *p_global_bs;
//#endif // _DEBUG

#include <string.h>
static int object_hash = 0;


#ifdef NOTDEF // USE FOR DEBUGGING DOUBLE_ALIGN
//
// gc_header.h/cpp: check if instances of this class
// require double alignment
//
bool is_double_alignment_required(Class *p_class)
{
	if (p_class->alignment == 8) {
		return true;
	}
	return false;
}

//
// gc_header.h/cpp: check if instances of this class
// require double alignment
//
bool is_double_alignment_required(VTable *p_vtable)
{
	if (p_vtable->clss->alignment == 8) {
		return true;
	}
	return false;
}

//
// gc_header.h/cpp: check to see if the specified address
// is aligned on a double word boundary.
// INLINE THIS WHEN DONE DEBUGGING.
//
bool is_double_aligned(void *p_address)
{
    if ((POINTER_SIZE_INT)p_address & 0x7)
        return true;

    return false;
}


// INLINE THIS WHEN DONE DEBUGGING
bool is_not_double_aligned(void *p_address)
{
    if (((POINTER_SIZE_INT)p_address) & 0x7)
        return false;

    return true;
}


#endif // NOTDEF // DOUBLE_ALIGN



unsigned int
*get_object_descendents_offset_map(Object_Gc_Header *p_gc_hdr)
{
	Partial_Reveal_Class *p_class = get_object_class(p_gc_hdr);
    return p_class->gc_information;
}

unsigned int
*get_object_descendents_offset_map(Partial_Reveal_VTable *p_vtable) 
{
	Partial_Reveal_Class *p_class = get_object_class(p_vtable);
    return p_class->gc_information;
}

//
// initialize_free_block is used for creating the initial large
// block of free space. Subsequently, when returning objects to
// the free list, reinitialize_free_block is called, which sets
// all the free words to a distinct pattern, when the right 
// debugging level is set. This split is done to speed up startup
// of the ORP, which is slowed down if you try to initialize the
// entire heap.
//
void initialize_free_block(void *p_block_ptr, 
						   unsigned int size, 
						   void *p_next)
{
#if (GC_DEBUG>1)
    //
    // If the free block isn't at least three words, then
    // we can't link it into the free list.
    //
    assert(size>=(sizeof(void *) * 3));
#endif

#if 0 // (GC_DEBUG>3)
	//
	// Add a distinct pattern during debugging to spot free
	// blocks, and detect rogue over-writes.
	//
	memset(p_block_ptr, 
		   DEBUG_FREE_FIXED_BLOCK_PATTERN,
		   size);
#endif

	set_free_block_header(p_block_ptr);
	set_free_block_size(p_block_ptr, size);
	set_free_block_link(p_block_ptr, p_next);
}

void reinitialize_free_block(void *p_block_ptr, 
						   unsigned int size, 
						   void *p_next)
{
    //
    // If the free block isn't at least three words, then
    // we can't link it into the free list.
    //
    assert(size>=(sizeof(void *) * 3));

#if 0 // (GC_DEBUG>3)
	//
	// Add a distinct pattern during debugging to spot free
	// blocks, and detect rogue over-writes.
	//
	memset(p_block_ptr, 
		   DEBUG_FREE_FIXED_BLOCK_PATTERN,
		   size);
#endif

	set_free_block_header(p_block_ptr);
	set_free_block_size(p_block_ptr, size);
	set_free_block_link(p_block_ptr, p_next);
}

 
#ifdef GC_REVEAL_CLASS
bool
is_array_of_primitives_check(Class *p_class)
{
	// rds temporary hack: since I can't rely on the
	// class flag is_array_of_primitives to tell the truth,
	// I parse the following character of the class name
	// to see if it is an array of arrays.
	if (*(p_class->name->bytes + 1) == '[')
		return false;
	if (*(p_class->name->bytes + 1) == 'L')
		return false;
	if (p_class->is_array_of_primitives == 0)
		return false;

	return true;
}
#endif


 

void *get_free_block_link(void *p_block_ptr)
{
	return *(void **)((char *)p_block_ptr + sizeof(POINTER_SIZE_INT) * 2);
}

unsigned int get_free_block_size(void *p_block_ptr)
{
	return *(int *)((char *)p_block_ptr + sizeof(POINTER_SIZE_INT));
}



 
#ifdef GC_REVEAL_CLASS
// Do it both ways to make sure we got it right.
unsigned int
get_object_size_bytes_check(Class *p_class, Java_java_lang_Object *p_obj)
{
	if (is_array((Partial_Reveal_Class *)p_class)) {
        unsigned int array_length =  *(unsigned int *)((Byte *)p_obj + OBJECT_VTABLE_POINTER_SIZE);
        unsigned int sz;
        // NO: zero is OK for null strings! assert(array_length > 0);
		if (is_array_of_primitives_check(p_class)) {
			const String *elt_type = p_class->name;
            const element_size = p_class->array_element_size; 
            char elt = elt_type->bytes[1];
			switch (elt) {
			case 'C' :
                assert (element_size == 2);
				sz = sizeof(JavaArrayOfChar) + (array_length - 1) * 2;
				break;			
			case 'B':
                assert (element_size == 1);
				sz = sizeof(JavaArrayOfByte) + (array_length - 1);
				break;
			case 'D':
                assert (element_size == 8);
				sz = sizeof(JavaArrayOfDouble) + (array_length - 1) * 8;
                break;
			case 'F':
                assert (element_size == 4);
				sz = sizeof(JavaArrayOfFloat) + (array_length - 1) * 4;
                break;
			case 'I':
                assert (element_size == 4);
				sz = sizeof(JavaArrayOfInt) + (array_length - 1) * 4;
                break;
			case 'J':
                assert (element_size == 8);
				sz = sizeof(JavaArrayOfLong) + (array_length - 1) * 8;
                break;
			case 'S':
                assert (element_size == 2);
				sz = sizeof(JavaArrayOfShort) + (array_length - 1) * 2;
                break;
			case 'Z' : // boolean
                assert (element_size == 1);
				sz = sizeof(JavaArrayOfBoolean) + (array_length - 1);
                break;
			case '[':
                assert (element_size == 4);
				sz = sizeof(int) * 2 + (array_length) * 4; // was 3 ==
                break;
			default:
				printf("Unimplemented %c\n", elt);
				orp_exit(1);
				return 0;
			}
 
            sz = sz + OBJECT_HEADER_SIZE;
            // align the object upwards
            sz = (((sz + (GC_OBJECT_ALIGNMENT - 1)) 
                    / GC_OBJECT_ALIGNMENT) * GC_OBJECT_ALIGNMENT);
            return sz;
 
		} else {
 
			// array size in bytes + vtable pointer + array size arg + object header
			return array_length * sizeof(int) + sizeof (uint32) +
                + OBJECT_HEADER_SIZE + OBJECT_VTABLE_POINTER_SIZE;
 
        }
	} else {
 
        // This needs to use CLASS_ARRAY_SIZE_OFFSET.....
//        unsigned int allocated_size = 
//            (unsigned int)*((unsigned int *)((char *)p_temp_vtable->clss + 
//                                             CLASS_ALLOCATION_SIZE_OFFSET));
        assert (p_class->allocated_size == get_instance_data_size(p_class));
		return get_instance_data_size(p_class); // ->instance_data_size;
 
	}
}

#endif // GC_REVEAL_CLASS

unsigned int
get_object_size_bytes(Partial_Reveal_Class *p_class, Java_java_lang_Object *p_obj)
{
#ifdef GC_REVEAL_CLASS
    unsigned int old_way = get_object_size_bytes_check ((Class *)p_class, p_obj);
#endif

    assert (p_class != 0);
    assert (p_class == (Partial_Reveal_Class *)((Partial_Reveal_VTable *)(p_obj->vt))->clss);
    bool arrayp = is_array (p_class);
	if (arrayp) {
        unsigned int array_length = ((Partial_Reveal_JavaArray *)p_obj)->length;
        // NO: zero is an OK length for null strings! assert(array_length > 0);
        unsigned int element_size = p_class->array_element_size;
        assert (element_size <= 8);
        assert (element_size > 0); // Do we have any primitive sizes <0 and >8?
        unsigned int sz = sizeof (Partial_Reveal_JavaArray) + OBJECT_HEADER_SIZE +
            array_length * element_size;
        sz = (((sz + (GC_OBJECT_ALIGNMENT - 1)) 
                    / GC_OBJECT_ALIGNMENT) * GC_OBJECT_ALIGNMENT);
        // Why am I not adding (GC_OBJECT_ALIGNMENT - 1) and clearing the bottom bits?

#ifdef GC_REVEAL_CLASS
        if (sz != old_way) {
//            orp_cout << "In gc_header - Size difference sz is " << sz << " old_way is "
//                << old_way << endl;
            return sz;
        } 
#endif // GC_REVEAL_CLASS

#ifdef OBJECT_SPLITTING
        // Objects allocated in the Large Object Space (LOS) are not split.
        if (p_global_bs->is_object_in_large_object_space(p_obj)) 
            return sz;
        else
            return 2 * sz;
#else
        return sz; 
#endif // OBJECT_SPLITTING
    
    } else {
#ifdef GC_REVEAL_CLASS
        assert (old_way == p_class->allocated_size);
#endif
        return p_class->allocated_size;
    }
}

 

 
Partial_Reveal_VTable *
get_object_vtable(Java_java_lang_Object *p_obj)
{
    return (Partial_Reveal_VTable *)p_obj->vt;
}

Partial_Reveal_VTable *
get_object_vtable(Object_Gc_Header *p_gc_hdr)
{
    return get_object_vtable(get_object_from_gc_header(p_gc_hdr));
}
 






 

VTable_Gc_Header *
get_vtable_gc_header(Java_java_lang_Object *p_obj)
{
	Partial_Reveal_VTable *p_vtable =
		get_object_vtable(p_obj);

	return get_vtable_gc_header(p_vtable);
}

VTable_Gc_Header *
get_vtable_gc_header(Object_Gc_Header *p_gc_hdr)
{
	Partial_Reveal_VTable *p_vtable =
		get_object_vtable(p_gc_hdr);

	return get_vtable_gc_header(p_vtable);
}

VTable_Gc_Header *
get_vtable_gc_header(IN Partial_Reveal_VTable *pVTable)
{
    VTable_Gc_Header *p_vtable_hdr = 
		(VTable_Gc_Header *)((Byte *)pVTable 
                         - sizeof(VTable_Gc_Header));
    return p_vtable_hdr;
}
 
//
// NOTE NOTE NOTE : need to collapse init_gc_header_and_return_object
// and initialize_object since they duplicate functionality
//

Java_java_lang_Object *
init_gc_header_and_return_object(Object_Gc_Header *p_header,
								 unsigned real_size_bytes)
{

#if (GC_DEBUG>0)
	// Add an extra trailer and a distinct header for debugging heap
    *(int *)((char *)p_header + real_size_bytes - 4) = OBJECT_DEBUG_TRAILER;
#endif // _DEBUG

    return get_object_from_gc_header(p_header);
}

// Given a pointer to the start of an empty byte array populate the header fields.
 
void initialize_byte_array(void *the_space,
                           unsigned int length,
                           Partial_Reveal_VTable *the_vt) 
{
    memset(the_space, 0, (sizeof (Partial_Reveal_JavaArray) + OBJECT_HEADER_SIZE + length));
    Partial_Reveal_JavaArray *the_array = 
        (Partial_Reveal_JavaArray *)((byte *)the_space + OBJECT_HEADER_SIZE);
    // Fill the vtable and dope vector.
    the_array->length = length;
    the_array->vt = the_vt;
}
 

 
Java_java_lang_Object *initialize_object(void *p_return, 
						unsigned int real_size_bytes,
						Partial_Reveal_VTable *p_vtable)
{
    // LOS object are cleared when they are allocated.
	// clear the object
	memset((void *)p_return, 0, real_size_bytes);

#if (GC_DEBUG>2)
	// debug: mark the trailer padding
	*(int *)((Byte *)p_return + real_size_bytes - 4) = OBJECT_DEBUG_TRAILER;
#endif

	// bump handle past header
	p_return = (Java_java_lang_Object *)((Byte *)p_return + OBJECT_HEADER_SIZE);

	// insert the VTable pointer
	*(Partial_Reveal_VTable **)p_return = p_vtable;

	return (Java_java_lang_Object *)p_return;
}
 
bool is_free_block(void *p_block_ptr)
{
	if (*(POINTER_SIZE_INT *)p_block_ptr == FREE_BLOCK_HEADER)
		return true;

	return false;
}

bool is_object_gc_header(void *p_thing)
{
	Object_Gc_Header *p_hdr = (Object_Gc_Header *)p_thing;
	return is_object_gc_header(p_hdr);
}

bool is_object_gc_header(Object_Gc_Header *p_header)
{
    Java_java_lang_Object *p_obj = get_object_from_gc_header(p_header);
    return is_java_object(p_obj);
}


bool is_java_object(void *p_thing)
{
	Java_java_lang_Object *p_obj = (Java_java_lang_Object *)p_thing;
	return is_java_object(p_obj);
}

 
bool is_vtable(Partial_Reveal_VTable *p_vtable)
{
    if (p_vtable == 0)
		return false;

    if (p_loaded_vtable_directory->is_present((Java_java_lang_Object **)p_vtable)) 
        return true;

    return false;
}

bool is_java_object(Java_java_lang_Object *p_obj)
{
    Partial_Reveal_VTable *p_vtable = get_object_vtable(p_obj);
    return is_vtable(p_vtable);
}
 
bool 
is_object_not_forwarded(IN Object_Gc_Header *p_gc_header)
{
    if (is_object_forwarded(p_gc_header)) {
		return false;
	} else {
		return true;
	}
}

bool 
is_object_not_forwarded(IN Java_java_lang_Object *p_obj)
{
	if (is_object_forwarded(p_obj)) {
		return false;
	} else {
		return true;
	}
}

// #ifdef GC_MARK_FLAGS - implements non-resident marking bits.

//
// Code for marking LOS objects...
//
// Make a mark available for every 8 bytes (on IA64 make if every 16 bytes)
// This does not need to be exact, in fact since it is conservative we
// can collect objects in this are only if all objects are free.
// So to shrink the size of the mark table just shift by say 8 (256 bytes)
// But be careful not to clear the bits after you look at the first object
// in the card.

int get_mark_flag_index (Object_Gc_Header *p_gc_header)
{
	assert (p_global_bs->is_address_in_large_object_space((void *)p_gc_header));
	Large_Object_Store *this_los = p_global_bs->p_get_address_los ((void *)p_gc_header);
    int index = 
        ((POINTER_SIZE_INT)p_gc_header - (POINTER_SIZE_INT)(this_los->_p_base))
            >> MARK_SHIFT;
    assert (index != 1); // There can be not object starting at this location since
    // it would mean the first object takes up only 1 mark.
    assert (index >= 0);
    assert (index < 
                (int)(((POINTER_SIZE_INT)(this_los->_p_ceiling) - 
                       (POINTER_SIZE_INT)(this_los->_p_base)) >> MARK_SHIFT));
    return index;       
}

bool
is_object_header_marked(Object_Gc_Header *p_gc_header)
{
    Large_Object_Store *this_los = p_global_bs->p_get_address_los ((void *)p_gc_header);
    int index = get_mark_flag_index (p_gc_header);
    if (this_los->_mark_flags[index] == 0) {
        return false;
	} else {
        return true;
	}
}

void
set_object_header_marked (Object_Gc_Header *p_gc_header)
{
//    assert ((int)((get_object_from_gc_header (p_gc_header))->vt) > 0x800000); // Is it no a size field. 
    if (*p_gc_header == FREE_BLOCK_HEADER) {
        orp_cout << "Internal BUG BUG Bad object NOT being marked " << p_gc_header << endl;
        assert (0);
    }
    gc_trace (get_object_from_gc_header(p_gc_header),
        "Object header is being marked gc_header ln. 744");
	Large_Object_Store *this_los = p_global_bs->p_get_address_los ((void *)p_gc_header);
    int index = get_mark_flag_index (p_gc_header);
    if (index == 0) {
        index = 0;
    }
    assert (index != 1); // 1 would mean the header was at word 1 and object at word 0
    // is too small to be valid.
	this_los->_mark_flags[index] = 1;
    
    //	orp_cout << "Marking LOS object." << endl;
}

void
set_object_header_unmarked (Object_Gc_Header *p_gc_header)
{
    gc_trace (get_object_from_gc_header(p_gc_header),
        "Object header is being marked gc_header ln. 756");
	Large_Object_Store *this_los = p_global_bs->p_get_address_los ((void *)p_gc_header);
    int index = get_mark_flag_index (p_gc_header);
	this_los->_mark_flags[index] = 0;
}

bool is_object_header_unmarked(Object_Gc_Header *p_gc_header)
{
    if (is_object_header_marked(p_gc_header)) {
        return false;
    } else {
        return true;
    }
}


bool is_object_marked(Java_java_lang_Object *p_obj)
{
	if (p_global_bs->is_object_in_large_object_space(p_obj)) {
    	Object_Gc_Header *p_gc_header = get_object_gc_header(p_obj);
	    return is_object_header_marked(p_gc_header);
    } else {
#if GC_FIXED_V1
        assert (0);
#endif
        return false;
    }
}


bool
is_object_unmarked(Java_java_lang_Object *p_obj)
{
    if (is_object_marked(p_obj)) {
        return false;
    } else {
        return true;
    }
}


void set_free_block_header(void *p_block_ptr)
{
   	*((POINTER_SIZE_INT *)p_block_ptr) = FREE_BLOCK_HEADER;
}

void set_free_block_link(void *p_block_ptr, void *p_next_block)
{
	*(void **)((Byte *)p_block_ptr + sizeof(POINTER_SIZE_INT) * 2) = p_next_block;	
}

void set_free_block_size(void *p_block_ptr, unsigned int size)
{
    assert (size != 0);
	*((POINTER_SIZE_INT *)((Byte *)p_block_ptr + sizeof(POINTER_SIZE_INT))) = size;
}

//
// Set the header of the old object to point to the new
// and set the forward bit.
//
void 
set_object_forwarded(IN Object_Gc_Header  *p_old_hdr,
                     IN Java_java_lang_Object *p_new_obj)
{
    *p_old_hdr = ((POINTER_SIZE_INT)p_new_obj) | 0x1; 
}


void
set_object_marked(Java_java_lang_Object *p_obj)
{
    gc_trace (p_obj, "Object is being marked gc_header ln. 844");
    Object_Gc_Header *p_gc_hdr = get_object_gc_header(p_obj);
	set_object_header_marked(p_gc_hdr);
}

void
set_object_unmarked(Java_java_lang_Object *p_obj)
{
    gc_trace (p_obj, "Object is being *un*marked gc_header ln. 852");
	Object_Gc_Header *p_gc_hdr = get_object_gc_header(p_obj);
	set_object_header_unmarked(p_gc_hdr);
    return;
}


Object_Gc_Header *
p_scan_forward_over_object(IN Object_Gc_Header *pObjectGcHeader)
{
    long RealSize = get_real_object_size_bytes(pObjectGcHeader);

#ifdef OBJECT_SPLITTING
    return (Object_Gc_Header *)((POINTER_SIZE_INT)pObjectGcHeader + (RealSize / 2));
#else
	return (Object_Gc_Header *)((POINTER_SIZE_INT)pObjectGcHeader + RealSize);
#endif // OBJECT_SPLITTING
}

Java_java_lang_Object *
get_forwarded_object(Java_java_lang_Object *p_obj)
{
    assert(is_object_forwarded(p_obj));
    Gc_Space *p_gc_space = p_global_bs->p_get_object_container(p_obj);
    assert(!p_gc_space->is_large_object_space());

    Object_Gc_Header *p_gc_hdr =
        get_object_gc_header(p_obj);

    Java_java_lang_Object *p_new_obj =
#ifdef POINTER64
        (Java_java_lang_Object *)((POINTER_SIZE_INT)*p_gc_hdr & 0xFFFFffffFFFFfffe);
#else
        (Java_java_lang_Object *)((POINTER_SIZE_INT)*p_gc_hdr & 0xFFFFfffe);
#endif
    return p_new_obj;
}

void
update_reference_forwarded(Java_java_lang_Object **pp_obj)
{
	Java_java_lang_Object *p_old_obj = *pp_obj;
	Object_Gc_Header  *p_old_hdr = 
                get_object_gc_header(p_old_obj);
    assert (*p_old_hdr);
    Gc_Space *p_old_container =
        p_global_bs->p_get_object_container(p_old_obj);

    if (p_old_container->is_large_object_space()) {
        return;
    }

    Java_java_lang_Object *p_new_obj = get_forwarded_object(p_old_obj);

    *pp_obj = p_new_obj;

    return;
}

 
//
// This routine is called when checking the consistency of a space.
// Need to add more consistency checks.
//
bool
verify_is_object(Java_java_lang_Object *p_obj,
				 Remembered_Set *p_rs)
{
	// 
	// Need to add more checking
	//
	return is_java_object(p_obj);
}

//
// This routine is called when checking the consistency of a space.
// Need to add more consistency checks.
//
bool
verify_is_object(Object_Gc_Header *p_gc_hdr,
				 Remembered_Set *p_rs)
{
	//
	// Need to add more checking
	//
	return is_object_gc_header(p_gc_hdr);
}
// end file gc_header.cpp


