// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/gc_globals.cpp,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//

#include "platform.h"
#include "Block_Store.h"
#include "gc_hooks.h"
#include "card_table.h"
#include "remembered_set.h"
#include "pair_table.h"

char *p_plan_file_name;
bool verbose_gc = false;
bool fixed_gc   = false;
bool stats_gc = false;
//
// If the user's command line doesn't set this, then the
// default from the plan file will.
//
unsigned long initial_heap_size_bytes = 0;
unsigned long final_heap_size_bytes = 0;
unsigned long current_heap_size_bytes = 0;

unsigned long large_object_size = 1024;

//
// This is a global pointer to the base of the GC heap for debugging.
//
void *p_gc_base;

//
// This debugging pointer is to the top of the reserved virtual space
// for the GC heap.
//
void *p_gc_ceiling;

#ifdef SPACE_DEMOGRAPHICS
    //
    // Determine the size distribution of the java objects of a workload.
    //
volatile unsigned space_demographics_size[DEMOGRAPHICS_ARRAY_SIZE];

#endif

//
// This remembered set has an entry per loaded class.
// It is used for determining valid vtable pointers
// when examining candidate objects.
//

Pair_Table *p_loaded_vtable_directory = NULL;

//
// This is a hack for Milind which reclaims every
// 'N' allocations (specified on the command line
// using an undocumented "-rf" argument).
// NOTE THIS CURRENTLY ONLY WORKS FOR GC_FIXED_V1
//
unsigned debug_reclaim_frequency;
unsigned debug_reclaim_count;


//
// Global to specify the size differentiating
//
unsigned los_threshold_bytes;

//
// Made global for debugging purposes.
//
unsigned int incremental_collection_count;

//
// This is there so that C code can call Gc Hooks.
//
Gc_Fast_Hooks    *p_global_hooks;
//
// Similarly for block store access from C code.
//
Block_Store *p_global_bs;

//
// The following flag is turned on if the user specifies
// -verbosegc at the command line. It triggers descriptive
// messages related to the progress of the garbage collector.
//
bool global_verbose_gc;

bool garbage_collector_is_initialized = false;

#ifdef GC_TORTURE_1
//
// If this is set to true then execute a gc during the next gc_malloc
// and set it to false. Use the routine force_gc to set this to true.
//

bool force_gc_flag = false;

#endif // GC_TORTURE_1

// 
// An unsigned counter used to determine the number of write barrier calls made
// during a run.
//

#ifdef GC_COUNT_WRITE_BARRIERS
unsigned int gc_write_barrier_count = 0;
#endif

//
// This is the array of card table entries (not the Card Table
// manager). This needs to be global so that the JITs can get 
// to it.
//
byte *p_global_card_table;

//
// This is the virtual p_global_card_table_base. The card is 
// normally marked using the following algorithm where pp_obj_ref
// is the pointer in the card being marked.
//    unsigned int card = 
//        ((unsigned long)pp_obj_ref - global_heap_base) >> 
//                GC_CARD_SHIFT_COUNT;
//    p_global_card_table[card] = 0xFF;
// Now we can fold the " - global_heap_base" into the p_global_card_table
// here and avoid the subtraction. 
//
// I have no idea how much time this saves but I suspect it is critical.
// See the Hosking-Moss OOPSLA paper (or the Hosking-Hudson workshop paper)
//
// The code can now read
//
//    unsigned int card = 
//        ((unsigned long)pp_obj_ref) >> 
//                GC_CARD_SHIFT_COUNT;
//    p_virtual_global_card_table[card] = 0xFF;
//
// I will note that it is this kind of hack that breaks conservative collectors.
//

byte *p_virtual_global_card_table;

//
// This is the manager of the card table.
//
Card_Table *p_global_card_table_manager;

//
// This variable points to the base of the garbage collected heap.
// It is used by the write barrier implementation code, which
// uses this global to avoid making a function call.
//
POINTER_SIZE_INT global_heap_base;

#if (GC_DEBUG>3)
CRITICAL_SECTION _printCriticalSection;
bool do_init_print = true;
#endif

//
// This flag is initially false, and is set to true when the
// ORP is fully initialized. This signals that any stop-the-world
// collections can occur.
//
bool orp_initialized;

// The SDK0.5 seems happier if I put a procedure in this file.
// REMOVE THIS ONCE WE GET A NEWER VERSION OF THE SDK.
// RLH 4-8-99 
void ia64_needs_a_procedure_here () {
	assert (0); // it had better never be called
}

#if 1
// 
// This is the table holding all the interior pointers used in any given execution 
// of a GC. It is reused each time a GC is done.

slot_offset_list *interior_pointer_table;
#endif // was GC_INTERIOR_POINTERS

#ifdef GC_PT_WB
UINT (*func_GetWriteWatch) (IN DWORD dwFlags,          // write-tracking state
							  IN PVOID lpBaseAddress,    // base address of region
							  IN SIZE_T dwRegionSize,    // size of region
							  IN OUT PVOID  *lpAddresses,    // array of page addresses
							  IN OUT PULONG lpdwCount,   //  IN OUT PULONG_PTR lpdwCount,   // number of addresses returned
							  OUT PULONG lpdwGranularity  // page size
							  );

UINT (*func_ResetWriteWatch)(PVOID lpBaseAddress,
							   SIZE_T dwRegionSize
							   ); 
#endif // GC_PT_WB
// end file gc\gc_globals.cpp
