// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/exit.cpp,v 1.1.1.1 2001/07/23 07:25:38 xli18 Exp $
//
 
#include "gc_for_orp.h"
 


#include "platform.h"
#include "gc_globals.h"
#include "iostream.h"
#include "gc_profile.h"
#include "gc_hooks.h"
#include "gc_interface.h"

extern Pair_Table *p_loaded_vtable_directory;

#ifdef SPACE_DEMOGRAPHICS
#include "gc_consts.h"
#include "gc_globals.h"

void dump_object_demographics()
{
    cout << endl << "Object Demographics:" << endl;
    for (unsigned idx=0;idx<DEMOGRAPHICS_ARRAY_SIZE;idx++) {
    //for (unsigned idx=0;idx<1024;idx++) {
#if 1
        if (space_demographics_size[idx]>0) {
            cout << idx << "         " << space_demographics_size[idx] << endl;
        }
#else
    cout << space_demographics_size[idx] << endl; 
#endif
    }
    cout << endl << "END Object Demographics" << endl;
}
#endif

void wrapup_gc()
{

#ifdef GC_NONE_V0
    return;
#else

    gc_system_end_hook();

    //
    // We run all the finalizers upon exit if the application
    // specifies this by invoking runFinalizersOnExit on System.
    //
    p_gc->run_all_finalizers();

#ifdef SPACE_DEMOGRAPHICS
    dump_object_demographics();
#endif

#ifdef GC_COUNT_WRITE_BARRIERS
    orp_cout << " --- Number of write barriers encountered is " << gc_write_barrier_count << endl;
#endif

#if 0 // NOTE NOTE NOTE - NEED TO FIND OUT WHY RAYTRACE
      // BREAKS THIS
    delete p_loaded_vtable_directory;
#endif

#ifndef GC_SAPPHIRE
    // Sapphire has problems when on thread exits and others are still trying to do work.
	delete p_gc;
#endif
    
#endif
}

// end file gc\exit.cpp
