// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/java_util_TimeZone.cpp,v 1.1.1.1 2001/07/23 07:25:38 xli18 Exp $
//



#include "platform.h"
#include "jni.h"
#include "assert.h"
#include <time.h>

#include "java_util_TimeZone.h"



/*
 * Class:     java_util_TimeZone
 * Method:    getDefaultTimeZoneId
 * Signature: ()Ljava/lang/String;
 */

JNIEXPORT jstring JNICALL Java_java_util_TimeZone_getDefaultTimeZoneId
  (JNIEnv *jenv, jclass clazz)
{
#ifdef ORP_NT
    //return jenv->NewStringUTF("PST");

    // We need to return a Time Zone string which will be used by the parent
    // class to create a default Time Zone instance.

    time_t current_time;

    // Get system time for "0" and correct for the local time zone.
    current_time = time(0);
    struct tm *my_tm = localtime(&current_time);
    // Convert local time to the calendar value.
    mktime(my_tm);

    // Use the environment variables _tzname and _timezone which have now 
    // been changed by the call to "localtime"
    
    // Difference in secs between coordinated universal time and local time
    long tzdiff = _timezone;
    // _tzname[0] has the three-letter time-zone name , and _tzname[1] the 
    // three-letter DST zone name derived from TZ environment variable. 
    char **tzinfo = _tzname;
    
    // Check if perfect number of hours
    if ((tzdiff % 3600) == 0) 
        tzdiff = tzdiff / 3600;
    char *ret;

    if (strcmp(tzinfo[0], tzinfo[1]) == 0) {
        // If the same zone ---
        ret = (char *) malloc(strlen(tzinfo[0]) + 8);
        assert(ret);

        char *p = tzinfo[0];
        char xst[5];
        xst[0] = *p;
        while (*p++ != ' ');
        xst[1] = *p;
        while (*p++ != ' ');
        xst[2] = *p;
        xst[3] = '\0';

        sprintf(ret, "%s%ld", xst, tzdiff);

    } else {
        // Need to encode both 0 and 1 strings
        ret = (char *) malloc(strlen(tzinfo[0]) + strlen(tzinfo[1]) + 8);
        assert(ret);
        
        // Code to abbreviate the time zone name to 3 letters.

        char *p = tzinfo[0];
        char xst[5];
        xst[0] = *p;
        while (*p++ != ' ');
        xst[1] = *p;
        while (*p++ != ' ');
        xst[2] = *p;
        xst[3] = '\0';

        p = tzinfo[1];
        char yst[5];
        yst[0] = *p;
        while (*p++ != ' ');
        yst[1] = *p;
        while (*p++ != ' ');
        yst[2] = *p;
        yst[3] = '\0';

        sprintf(ret, "%s%ld%s", xst, tzdiff, yst);
    }

    jstring ret_string = jenv->NewStringUTF(ret);
    assert(ret_string);
    free(ret);
    return(ret_string);
#else

    // Need to find the right calls for Linux.
    jstring ret_string = jenv->NewStringUTF("PST8PDT");
    assert(ret_string);
    return ret_string;
#endif

} // Java_java_util_TimeZone_getDefaultTimeZoneId
