// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/java_lang_reflect_Constructor.cpp,v 1.5 2001/12/19 08:22:58 gwu2 Exp $
//



#ifdef ORP_POSIX
#include <unistd.h>
#endif

#include "platform.h"
#include <assert.h>
#include "object_layout.h"
#include "orp_utils.h"
#include "exceptions.h"
#include "jni.h"

#include <sys/types.h>
#include <sys/stat.h>

#ifdef ORP_NT
#include <io.h>
#endif

#include "native_utils.h"
#include "jni_direct.h"
#include "jni_utils.h"
#include "object_layout.h"

#include <fcntl.h>

#ifdef ORP_NT
#include <direct.h>
#endif

#include <errno.h>
#include "VMSystem.h"
#include "java_lang_reflect_Constructor.h"
#include "environment.h"



// MOVE THIS CODE TO base_natives\common\xx.cpp
jobject JNICALL Java_java_lang_reflect_Constructor_newInstance
  (JNIEnv *env, jobject constructor, jobjectArray initargs)
{
	int  aprim =0;
	int  pprim =0;
	char asig;
	
	int isStatic =0;

	int total_args =0;
    unsigned arg_number = 0;
	jvalue* args_array = NULL;

	Method* m = GetConstructor (env, constructor);
	assert (m);

	jobject newInst;

	jclass clazz = GetConstructorClass (env, constructor);
	// Acquire handle to internal class handle (Class):
	Object_Handle_Struct *clazz_h = (Object_Handle_Struct *)clazz;
	Class *clss = (Class *)clazz_h->java_reference;

	// Throw exception if constructor of abstract class:
	if (class_is_abstract(clss)) {            // if abstract declaring class
		ThrowNew_Quick (env, "java/lang/InstantiationException", 0);	
		return (jobject)0;
	}
	// Throw exception if private constructor:
	if (m->is_private()) { 
		ThrowNew_Quick (env, "java/lang/IllegalAccessException",
			                 clss->name->bytes);
		return (jobject)0;
	}

	// Get the *parameterTypes* field of this constructor
	jfieldID parameterTypes_id = GetFieldID_Quick 
		(env, "java/lang/reflect/Constructor", "parameterTypes", "[Ljava/lang/Class;");
	jclass parameterTypes = (jclass) GetObjectField (env, constructor, parameterTypes_id);

	// Get the number of parameters (also: arguments expected):
	jsize n_parameters = GetArrayLength (env, parameterTypes);

	if (n_parameters > 0) { // if method has (and expects) any parameters

		// Throw exception if null arguments array:
		if (!initargs) {
			ThrowNew_Quick (env, "java/lang/IllegalArgumentException",
			                     "wrong number of arguments");
			return (jobject)0;
		}

		// Number of arguments passed:
		jsize n_arguments = GetArrayLength (env, initargs);

		// Throw exception if wrong number of arguments:
		if (n_parameters != n_arguments) {
			ThrowNew_Quick (env, "java/lang/IllegalArgumentException",
			                     "wrong number of arguments");
			return (jobject)0;
		}
			
		// Allocate space for argument array to be passed to the
		// constructor being invoked:
		args_array = (jvalue*) malloc (sizeof(jvalue) * n_parameters);			

		// Argument vs. parameter list comparison and type checking:
		
		// For each actual parameter in the supplied args array:
		for (int i =0; i < n_parameters; i++) {
			
			// Access the class pointer of the parameter (declared)
			jclass pclazz =	GetObjectArrayElement (env, parameterTypes, i);	
			// Acquire handle to internal class handle (Class):
			Object_Handle_Struct *pclazz_h = (Object_Handle_Struct *)pclazz;
			Class *pcl = (Class *)pclazz_h->java_reference;

			// Access the class pointer of the argument (passed):
			jobject arg_i = GetObjectArrayElement (env, initargs, i);
            if(!arg_i) {
                // null is compatible with any type
	            args_array[arg_number++].l = arg_i;
                continue;
            }
			jclass aclazz = GetObjectClass (env, arg_i);
			// Acquire handle to internal class handle (Class):
			Object_Handle_Struct *aclazz_h = (Object_Handle_Struct *)aclazz;
			Class *acl = (Class *)aclazz_h->java_reference;
			
			// Check if the supplied argument represents a wrapper
			// class instance for a primitive type (i.e., one of java/lang/Boolean, 
			// java/lang/Byte, java/lang/Character, etc.):
			pprim = ((asig = IsWrapperClass (acl->name->bytes)) != '\0');
			
			// Check if the corresponding (expected) argument has a primitive type:
			aprim = pcl->is_primitive;
			
			// If the argument is of primitive type, but the provided parameter
			// is not (a wrapper for a primitive type), then throw an
			// IllegalArgumentException:
			if (aprim && !pprim) {
				ThrowNew_Quick (env, "java/lang/IllegalArgumentException", 
				                     "unwrapping conversion failed");
				return (jobject)0;
			}
			
			if (!aprim) {
				// Argument type is not primitive:
				
				// See if the argument type is assignable by the parameter object:
				// search class chain of the parameter for the (Class) type of this
				// argument. Throw an exception if the `located class pointer' is NULL.
				
				if (!IsInstanceOf (env, arg_i, aclazz)) {
					ThrowNew_Quick (env, "java/lang/IllegalArgumentException",
					                     "object is not an instance of declaring class");
					return (jobject)0;
				}
				
				// Argument type is assignable by the parameter object type;
				// place the object in the call parameter slot:

	            args_array[arg_number++].l = arg_i;
			}
			else {	// Both argument and object represent a primitive type:
				// Apply type checking and appropriate widening type conversion:

				// Get parameter type:
				char psig = PrimitiveNameToSignature (pcl->name->bytes); 
				
				if (!PrimitiveIsAssignableFrom (psig, asig)) {
					ThrowNew_Quick (env, "java/lang/IllegalArgumentException",
									     "argument type mismatch");
					return (jobject)0;
				}

				jvalue avalue;

				switch (asig) {
				case 'Z':
					avalue = UnwrapWrapperObject (env, arg_i, 'Z');
					args_array[arg_number++].z = avalue.z;
					break;
				case 'B':
					avalue = UnwrapWrapperObject (env, arg_i, 'B');				
					switch (psig) {
					case 'B':
						args_array[arg_number++].b = avalue.b;
						break;
					case 'C':
						args_array[arg_number++].c = avalue.b;
						break;
					case 'S':
						args_array[arg_number++].s = avalue.b;
						break;
					case 'I':
						args_array[arg_number++].i = avalue.b;
						break;
					case 'J': 
						args_array[arg_number++].j = avalue.b;
						break;
					case 'F':
						args_array[arg_number++].f = avalue.b;
						break;
					case 'D':
						args_array[arg_number++].d = avalue.b;
						break;
					}
					break;
				case 'C':
					avalue = UnwrapWrapperObject (env, arg_i, 'C');					
					switch (psig) {
					case 'C':
						args_array[arg_number++].c = avalue.c;
						break;
					case 'S':
						args_array[arg_number++].s = avalue.c;
						break;
					case 'I':
						args_array[arg_number++].i = avalue.c;
						break;
					case 'J': 
						args_array[arg_number++].j = avalue.c;
						break;
					case 'F':
						args_array[arg_number++].f = avalue.c;
						break;
					case 'D':
						args_array[arg_number++].d = avalue.c;
						break;
					}
					break;
				case 'S':
					avalue = UnwrapWrapperObject (env, arg_i, 'S');					
					switch (psig) {
					case 'S':
						args_array[arg_number++].s = avalue.s;
						break;
					case 'I':
						args_array[arg_number++].i = avalue.s;
						break;
					case 'J': 
						args_array[arg_number++].j = avalue.s;
						break;
					case 'F':
						args_array[arg_number++].f = avalue.s;
						break;
					case 'D':
						args_array[arg_number++].d = avalue.s;
						break;
					}
					break;
				case 'I':
					avalue = UnwrapWrapperObject (env, arg_i, 'I');					
					switch (psig) {
					case 'I':
						args_array[arg_number++].i = avalue.i;
						break;
					case 'J': 
						args_array[arg_number++].j = avalue.i;
						break;
					case 'F':
						args_array[arg_number++].f = (jfloat)avalue.i;
						break;
					case 'D':
						args_array[arg_number++].d = avalue.i;
						break;
					}
					break;
				case 'J':
					avalue = UnwrapWrapperObject (env, arg_i, 'J');					
					switch (psig) {
					case 'J': 
						args_array[arg_number++].j = avalue.j;
						break;
					case 'F':
						args_array[arg_number++].f = (jfloat)avalue.j;
						break;
					case 'D':
						args_array[arg_number++].d = (jdouble)avalue.j;
						break;
					}
					break;
				case 'F':
					avalue = UnwrapWrapperObject (env, arg_i, 'F');					
					switch (psig) {
					case 'F':
						args_array[arg_number++].f = avalue.f;
						break;
					case 'D':
						args_array[arg_number++].d = avalue.f;
						break;
					}
					break;
				case 'D':
					avalue = UnwrapWrapperObject (env, arg_i, 'D');					
					args_array[arg_number++].d = avalue.d;
					break;
				default:
					assert (0);
                }
			}
		}
	}

	jmethodID methodID = GetMethodID (env, clazz, "<init>", m->get_descriptor());
    set_current_thread_exception(0);
    
	// Construct a new Java object with with the initial arguments:
	newInst = NewObjectA (env, clazz, methodID, args_array);
	if(args_array)
		free(args_array);
	
	Java_java_lang_Object *expobj; 
	if(expobj = (Java_java_lang_Object*)get_current_thread_exception()) {
		orp_enable_gc();  
		set_current_thread_exception(0);
		jclass clzz = FindClass (env, "java/lang/reflect/InvocationTargetException");
		clss = (Class*)((Object_Handle)clzz)->java_reference;
		assert(clss);
		Method *m = LookupMethod(clss, "<init>", "(Ljava/lang/Throwable;)V");
		assert(m);
		Object_Handle exp = orp_create_local_object_handle();
		exp->java_reference = expobj;
		jobject nexp = NewObject(env, clzz, (jmethodID)m, exp);
		Java_java_lang_Throwable *nexpobj = ((Object_Handle)nexp)->java_reference;
		orp_disable_gc(); //??
		throw_java_exception_from_native(nexpobj);
		return 0;
	}

	return newInst;
}


/*
 * Class:     Constructor
 * Method:    constructNative
 * Signature: ([Ljava/lang/Object;Ljava/lang/Class;I)Ljava/lang/Object;
 */
JNIEXPORT jobject JNICALL Java_java_lang_reflect_Constructor_constructNative
  (JNIEnv *jenv, jobject p_this, jobjectArray args, jclass declaringClass, jint slot)
{
#if 0
    Class *declaring_class = unbox_class(declaringClass);
    printf("Java_java_lang_reflect_Constructor_constructNative: %s\n", declaring_class->name->bytes);

	jclass jlrc_class = jenv->FindClass("java/lang/reflect/Constructor");
	assert(jlrc_class);
	jfieldID pt_field_id = jenv->GetFieldID(jlrc_class, "parameterTypes", "[Ljava/lang/Class;");
	assert(pt_field_id);

    Method *constr = GetConstructor(jenv, p_this);
    printf("%s.%s%s\n",
           constr->get_class()->name->bytes,
           constr->get_name()->bytes,
           constr->get_descriptor());
#endif
    jobject result = Java_java_lang_reflect_Constructor_newInstance(jenv, p_this, args);

    return result;
} //Java_java_lang_reflect_Constructor_constructNative

JNIEXPORT jint JNICALL Java_java_lang_reflect_Constructor_getModifiers(JNIEnv *jenv, jobject p_this)
{
	Method *m = GetConstructor(jenv, p_this);
	if(!m){
		return 0;
	}
	jint modifiers = m->get_access_flags();
	return modifiers;
}






