// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/common_olv2/find_natives_olv2.h,v 1.2 2001/12/19 06:35:05 xli18 Exp $
//

#ifdef  OBJECT_LOCK_V2
#ifndef _FIND_NATIVES_H_
#define _FIND_NATIVES_H_


#include "Class_Loader.h"


#ifdef __cplusplus
extern "C" {
#endif

///////////////////////////////////////////////////////////////////////////
// begin public interface

#if 1

enum NI_TYPE {
    NI_IS_RNI,
    NI_IS_JNI,
    NI_IS_DIRECT,
    NI_IS_PINVOKE
};

#else

#define NI_IS_RNI     0
#define NI_IS_JNI     1
#define NI_IS_DIRECT  2
#define NI_IS_PINVOKE 3

#endif

void find_native_method(Method *method, void **func, NI_TYPE *native_intf);
Boolean use_native_implementation(Method *method);

void register_native_method(Class *clss, String *name, String *sig, void *f);
void unregister_native_methods(Class *clss);


#ifdef CLI_TESTING
void *find_a_cli_native(Method *method, NI_TYPE *native_intf);
#ifdef CLI_OCL
void *find_orp_internal_function_address(Method *method, NI_TYPE *native_intf);
void *find_orp_cli_native_address(const char *, const char *, const char *, NI_TYPE *);
#endif
#endif


#ifdef __cplusplus
}
#endif



typedef struct _Built_In_Method_Entry {
    char    *pname;
    void    *pfunc;
    NI_TYPE  native_intf;
} Built_In_Method_Entry;


extern Built_In_Method_Entry _built_ins_base [];
extern int sizeof_built_ins_base;

#ifndef NON_ORP_NATIVE_LIBS
extern Built_In_Method_Entry _built_ins_extra [];
extern int sizeof_built_ins_extra;
#endif

// end public interface
///////////////////////////////////////////////////////////////////////////

#endif
#endif //#ifdef  OBJECT_LOCK_V2
