// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/common/thread_manager.cpp,v 1.7 2001/12/07 00:16:00 xli18 Exp $
//

#ifndef  OBJECT_LOCK_V2
#include "platform.h"
#include <assert.h>
#include <iostream.h>

#ifndef ORP_POSIX
#include "orp_process.h"
#endif

#include "orp_utils.h"
#include "nogc.h"
#include "sync_bits.h"
#include "orp_synch.h"

#include "thread_manager.h"
#ifdef GC_SAPPHIRE
#include "ssb.h"
#endif
// wjw -- following lines needs to be generic for all OSs
#ifdef ORP_POSIX
#define N_T_S_H NULL
#define E_H_M NULL
#define E_H_S NULL
#define E_H_I NULL
#define E_H_S0 NULL
#define G_S_R_E_H NULL
#define E_H_RECOMP NULL
#define OS_THREAD_INIT_1()
#define OS_SYNC_SUPPORT()
#define OS_THREAD_INIT_2() p_TLS_orpthread = p_orp_thread; 
#define OS_THREAD_GET_CONTEXT_CHECK()
#define THREAD_CLEANUP() 
#define BEGINTHREADEX_SUSPENDSTATE 1
#define SET_THREAD_DATA_MACRO()
#define CHECK_HIJACK_SUPPORT_MACRO()
#define DIR_SEPARATOR_MACRO() path[i++] = DIR_SEPARATOR;  path[i++] = '*';
#define SUSPEND_THREAD(__a) 0
#else
#include "java_lang_thread_nt.h"
#endif

#ifdef POINTER64
#include "java_lang_thread_ia64.h"
#else
#include "java_lang_thread_ia32.h"
#endif

#ifdef ORP_NT
__declspec(thread) ORP_thread *p_TLS_orpthread;
#endif

ORP_thread *p_threads_iterator;
ORP_thread *p_free_thread_blocks;
ORP_thread *p_active_threads_list;


volatile ORP_thread *p_the_safepoint_control_thread = 0;  // only set when a gc is happening
volatile safepoint_state global_safepoint_status = nill;
// Incremented at the start and at the end of each GC. The total number
// of GC is this number * 2. This is done so that when a lot of application
// threads discover that they need a GC only on is done.
#ifdef USE_GC_DLL
ORPExport
#endif
volatile int global_gc_count = 0;

unsigned non_daemon_thread_count = 0;

HANDLE non_daemon_threads_dead_handle = 0;
HANDLE new_thread_started_handle = 0;

HANDLE non_daemon_threads_are_all_dead;

thread_array quick_thread_id[1<<QUICK_THREAD_INDEX_WIDTH];
POINTER_SIZE_INT hint_free_quick_thread_id;


#ifdef _DEBUG
////////////Object_Handle orp_create_global_object_handle();  // bugbug -- where does this go?
#include "jni.h"
#include "jvmdi_clean.h"
#endif



///////////////////////////////////////////////////////////////////////////////
///////////////
/////////////// WARNING: start_of_thread_manager_busybit_critical_zone() MUST BE  THE FIRST
///////////////
/////////////// PROCEDURE IN thread_manager.cpp
///////////////
///////////////////////////////////////////////////////////////////////////////


void start_of_thread_manager_busybit_critical_zone()
{
////////////// THIS MUST BE THE FIRST PROCEDURE IN java_lang_Object.cpp
////////////// SEE in_busybit_critical_zone() for details
}



void orp_thread_init(Global_Env *p_env___not_used)
{
	new_thread_started_handle = CreateEvent( 
            NULL,   // pointer to security attributes 
            FALSE,  // flag for manual-reset event  -- auto reset mode 
            FALSE,  // flag for initial state 
            N_T_S_H // pointer to event-object name 
        ); 

    ORP_thread *orpthread;
    orpthread = (ORP_thread *)gc_malloc_fixed_data_C(sizeof(ORP_thread));
    memset(orpthread, 0, sizeof(ORP_thread) );

    // This is the main thread...set its status to "birthing" until it really 
    // starts executing Java code, at which point it will be changed to "running".
	orpthread->app_status = thread_is_birthing;

    OS_THREAD_INIT_1();

#ifdef ORP_NT
    p_TLS_orpthread = orpthread;
    assert(p_TLS_orpthread);

#elif ORP_POSIX
    orpthread->thread_handle = (int) pthread_self();
    pthread_setspecific(thread_local_storage_key, orpthread);

#endif

    p_TLS_orpthread->event_handle_monitor = CreateEvent( 
            NULL,   // pointer to security attributes 
            FALSE,  // flag for manual-reset event  -- auto reset mode 
            FALSE,  // flag for initial state 
            E_H_M   // pointer to event-object name 
        ); 
    assert(p_TLS_orpthread->event_handle_monitor);

    p_TLS_orpthread->event_handle_sleep = CreateEvent( 
            NULL,   // pointer to security attributes 
            FALSE,  // flag for manual-reset event  -- auto reset mode 
            FALSE,  // flag for initial state 
            E_H_S    // pointer to event-object name 
        ); 
    assert(p_TLS_orpthread->event_handle_sleep);

    p_TLS_orpthread->event_handle_interrupt = CreateEvent( 
            NULL,   // pointer to security attributes 
            FALSE,  // flag for manual-reset event  -- auto reset mode 
            FALSE,  // flag for initial state 
            E_H_I   // pointer to event-object name 
        ); 
    assert(p_TLS_orpthread->event_handle_interrupt);

    p_TLS_orpthread->event_handle_suspend0 = CreateEvent( 
            NULL,   // pointer to security attributes 
            FALSE,  // flag for manual-reset event  -- auto reset mode 
            FALSE,  // flag for initial state 
            E_H_S0  // pointer to event-object name 
        ); 
    assert(p_TLS_orpthread->event_handle_suspend0);

    p_active_threads_list = p_TLS_orpthread;

    p_TLS_orpthread->gc_resume_event_handle = CreateEvent( 
            NULL,   // pointer to security attributes 
            TRUE,  // flag for manual-reset event  -- manual mode
            TRUE,  // flag for initial state 
            G_S_R_E_H  // pointer to event-object name 
        ); 
    assert(p_TLS_orpthread->gc_resume_event_handle);

	gc_thread_init();
    assert (p_TLS_orpthread->p_nursery == NULL);
    // Current implementation does one nursery per thread. Future implementation
    // might do one thread per CPU.
    p_TLS_orpthread->p_nursery = gc_get_new_nursery(); 
// In the case that we are using gc_fixed_v1 there is no nursery.
//    assert (p_TLS_orpthread->p_nursery != NULL);

    // NOTE: quick_thread_id[0] is never used. Index of 0 is used instead to
    // signal that no thread holds the quick lock
    quick_thread_id[0].p_orpthread = (ORP_thread *) 0xffFFffFF;

    quick_thread_id[1].p_orpthread = (ORP_thread *) p_TLS_orpthread;

    p_TLS_orpthread->quick_thread_index = 1;
    p_TLS_orpthread->quick_thread_index_shifted_left = 1 << QUICK_THREAD_INDEX_LEFT_SHIFT_COUNT;
    p_TLS_orpthread->quick_thread_index_shifted_left_with_recursion_set_to_one = 
        1 << QUICK_THREAD_INDEX_LEFT_SHIFT_COUNT | QUICK_RECURSION_INC_DEC_REMENT;

    OS_SYNC_SUPPORT();

    hint_free_quick_thread_id = 2;

}



void orp_thread_shutdown()
{
    // No action needed on Windows and Linux.
} //orp_thread_shutdown



ORP_thread * get_a_thread_block()
{
    ORP_thread *p_orpthread;
    if (p_free_thread_blocks) {
        p_orpthread = p_free_thread_blocks;
        p_free_thread_blocks = p_free_thread_blocks->p_free;
        p_orpthread->p_free = 0;

        // If thread block is being reused, set app_status to "birthing".
	    p_orpthread->app_status = thread_is_birthing;
     }
    else {
        p_orpthread = (ORP_thread *)gc_malloc_fixed_data_C(sizeof(ORP_thread));
        memset(p_orpthread, 0, sizeof(ORP_thread) );

        // If new thread block is being created, set app_status to "birthing" here too.
	    p_orpthread->app_status = thread_is_birthing;

        p_orpthread->event_handle_monitor = CreateEvent( 
                NULL,   // pointer to security attributes 
                FALSE,  // flag for manual-reset event  -- auto reset mode 
                FALSE,  // flag for initial state 
                E_H_M   // pointer to event-object name 
            ); 
        assert(p_orpthread->event_handle_monitor);

        p_orpthread->event_handle_sleep = CreateEvent( 
                NULL,   // pointer to security attributes 
                FALSE,  // flag for manual-reset event  -- auto reset mode 
                FALSE,  // flag for initial state 
                E_H_S   // pointer to event-object name 
            ); 
        assert(p_orpthread->event_handle_sleep);

        p_orpthread->event_handle_interrupt = CreateEvent( 
                NULL,   // pointer to security attributes 
                FALSE,  // flag for manual-reset event  -- auto reset mode 
                FALSE,  // flag for initial state 
                E_H_I   // pointer to event-object name 
            ); 
        assert(p_orpthread->event_handle_interrupt);

        p_orpthread->event_handle_suspend0 = CreateEvent( 
                NULL,   // pointer to security attributes 
                FALSE,  // flag for manual-reset event  -- auto reset mode 
                FALSE,  // flag for initial state 
                E_H_S0  // pointer to event-object name 
            ); 
        assert(p_orpthread->event_handle_suspend0);

        p_orpthread->gc_resume_event_handle = CreateEvent( 
                NULL,   // pointer to security attributes 
                TRUE,  // flag for manual-reset event  -- manual mode
                TRUE,  // flag for initial state 
                G_S_R_E_H // pointer to event-object name 
            ); 
        assert(p_orpthread->gc_resume_event_handle);
    }

    // There'll be an assertion failure when adding shutdown hooks support.
    // But I wonder if it's necessary.
    //?? assert(p_active_threads_list);
    p_orpthread->p_active = p_active_threads_list;
    p_active_threads_list = p_orpthread;

    //p_orpthread->p_java_lang_thread = (Java_java_lang_Thread *)tt;

    //tt->PrivateInfo = (POINTER_SIZE_INT)p_orpthread;

    uint32 pass = 0;

    if (hint_free_quick_thread_id >= (1 << QUICK_THREAD_INDEX_WIDTH)) {
        hint_free_quick_thread_id = 1;
    }

    while (pass < 2) {
        if (quick_thread_id[hint_free_quick_thread_id].p_orpthread == 0) {
            break;
        }
        hint_free_quick_thread_id++;
        if (hint_free_quick_thread_id == (1 << QUICK_THREAD_INDEX_WIDTH) )
        {
            hint_free_quick_thread_id = 1;
            pass++;
        }
    }

    if (pass == 2)
    {
        assert(0);
        printf("out of java threads\n");
        orp_exit(12);
    }

    // the following line was moved to call_the_run_method so that P_TLS_orpthread is
    // in the CORRECT context
    //quick_thread_id[hint_free_quick_thread_id].p_orpthread = p_TLS_orpthread;

    p_orpthread->quick_thread_index = hint_free_quick_thread_id;
    p_orpthread->quick_thread_index_shifted_left = hint_free_quick_thread_id << QUICK_THREAD_INDEX_LEFT_SHIFT_COUNT;
    p_orpthread->quick_thread_index_shifted_left_with_recursion_set_to_one = 
        hint_free_quick_thread_id << QUICK_THREAD_INDEX_LEFT_SHIFT_COUNT | QUICK_RECURSION_INC_DEC_REMENT;

    return p_orpthread;
}


void free_this_thread_block(ORP_thread *p_orpthread)
{
    assert(quick_thread_id[p_TLS_orpthread->quick_thread_index].p_orpthread == p_orpthread);

    ORP_thread *p_thr = p_active_threads_list;
    ORP_thread *p_old_thr = p_active_threads_list;

    // pull thread out of active threads list
    if (p_thr == p_orpthread) 
        p_active_threads_list = p_thr->p_active;

    else {
        while (1) {
            if(p_thr == p_orpthread) break;
            p_old_thr = p_thr;
            p_thr = p_thr->p_active;
        }
        assert(p_thr);
        assert(p_old_thr);
        p_old_thr->p_active = p_thr->p_active;
    }

    // put it back in the free threads pool
    quick_thread_id[p_TLS_orpthread->quick_thread_index].p_orpthread = 0;

    // copy the handles into a temporary place 
	// and put them back after zeroing whole data struct
	HANDLE aa = p_orpthread->event_handle_monitor;
	HANDLE bb = p_orpthread->event_handle_sleep;
	HANDLE cc = p_orpthread->event_handle_interrupt;
	HANDLE dd = p_orpthread->event_handle_suspend0;
	HANDLE ee = p_orpthread->gc_resume_event_handle;

	memset(p_orpthread, 0, sizeof(ORP_thread) );

	p_orpthread->event_handle_monitor = aa;
	p_orpthread->event_handle_sleep = bb;
	p_orpthread->event_handle_interrupt = cc;
    p_orpthread->event_handle_suspend0 = dd;
    p_orpthread->gc_resume_event_handle = ee;

    p_orpthread->p_free = p_free_thread_blocks;
    p_free_thread_blocks = p_orpthread;

    //tt->PrivateInfo = 0;
}


void thread_gc_suspend_one(ORP_thread *p_thr)
{
    assert(p_TLS_orpthread != p_thr);

    if (p_thr->thread_is_java_suspended) {
        assert(p_thr->gc_status == gc_at_safepoint);
        return;
    }

    DWORD stat = SUSPEND_THREAD(p_thr);

    switch (stat) {
    case 0:
        // the thread was running and is now suspended, do nothing more
        break;
    case 1:
        assert(0);  // CAN THIS EVER HAPPEN?? 
        break;
    default:
        // by ORP design, the underlying OS suspend API can be called
        // only once between calls to OS resume API
        DWORD error = GetLastError();
        assert(0);
        break;
    }

    CONTEXT nt_registers;
    nt_registers.ContextFlags = //  CONTEXT_DEBUG_REGISTERS |
                                    CONTEXT_FLOATING_POINT |
                                //  CONTEXT_SEGMENTS |
                                    CONTEXT_INTEGER |
                                    CONTEXT_CONTROL ;

    BOOL stat2 = GetThreadContext(p_thr->thread_handle, &nt_registers);
    assert(stat2);
}


uint32 thread_gc_number_of_threads()
{

    ORP_thread *p_thr = p_active_threads_list;
    assert(p_thr);
    uint32 xx;
    for(xx = 0; ; xx++) {
        p_thr = p_thr->p_active;
        if (!p_thr) break;
    }
    // do NOT enumerate the current thread thus its
    // return xx; instead of return xx + 1;
    // setup iterator for thread_gc_enumerate_one();
    p_threads_iterator = p_active_threads_list; 

    return xx;
}


ORP_thread *thread_gc_enumerate_one()
{
    assert(p_threads_iterator);

    // skip over the current thread which is already at
    // a gc safepoint.  Also, doing a Get/SetThreadContext()
    // on the current thread will cause a crash (for good reason)

    if(p_TLS_orpthread == p_threads_iterator)
        p_threads_iterator = p_threads_iterator->p_active;

    ORP_thread *p_cookie = p_threads_iterator;
    if(p_threads_iterator)
        p_threads_iterator = p_threads_iterator->p_active;

    return p_cookie;
}


Registers *thread_gc_get_context(ORP_thread *p_thr)
{
    CONTEXT nt_registers;
    nt_registers.ContextFlags = //  CONTEXT_DEBUG_REGISTERS |
                                    CONTEXT_FLOATING_POINT |
                                //  CONTEXT_SEGMENTS |
                                    CONTEXT_INTEGER |
                                    CONTEXT_CONTROL ;

    BOOL stat = GetThreadContext(p_thr->thread_handle, &nt_registers);
    assert(stat);

    OS_HW_REGS_TO_ORP_THREAD_REGS();

    return &(p_thr->regs);
} //thread_gc_get_context


void thread_gc_set_context(ORP_thread *p_thr)
{
    OS_THREAD_GET_CONTEXT_CHECK();

    CONTEXT nt_registers;
    nt_registers.ContextFlags = //  CONTEXT_DEBUG_REGISTERS |
                                    CONTEXT_FLOATING_POINT |
                                //  CONTEXT_SEGMENTS |
                                    CONTEXT_INTEGER |
                                    CONTEXT_CONTROL ;

    BOOL stat = GetThreadContext(p_thr->thread_handle, &nt_registers);
    assert(stat);

    OS_ORP_THREAD_REGS_TO_HW_REGS();


    nt_registers.ContextFlags = //  CONTEXT_DEBUG_REGISTERS |
                                    CONTEXT_FLOATING_POINT |
                                //  CONTEXT_SEGMENTS |
                                    CONTEXT_INTEGER |
                                    CONTEXT_CONTROL ;
    stat = SetThreadContext(p_thr->thread_handle, &nt_registers);
    assert(stat);
} //thread_gc_set_context


///////////////////////////////////////////////////////////////////////////////
///////////////
/////////////// WARNING: end_of_thread_busybit_critical_zone() MUST BE  THE LAST
///////////////
/////////////// PROCEDURE IN java_lang_Thread.cpp
///////////////
///////////////////////////////////////////////////////////////////////////////

void end_of_thread_manager_busybit_critical_zone()
{
////////////// THIS MUST BE THE LAST PROCEDURE IN java_lang_Thread.cpp
////////////// SEE in_busybit_critical_zone() for details
}

//M:
ORP_thread * get_p_active_threads_list()
{
    return p_active_threads_list;
}

#endif //#ifndef  OBJECT_LOCK_V2
