// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/common/thread_generic.cpp,v 1.11 2001/12/10 09:40:44 gwu2 Exp $
//

#ifndef  OBJECT_LOCK_V2
#include "platform.h"
#include <assert.h>
#include <iostream.h>

#ifndef ORP_POSIX
#include "orp_process.h"
#endif

#include "environment.h"
#include "orp_types.h"
#include "orp_utils.h"
#include "object_layout.h"
#include "Class.h"
#include "orp_threads.h"
#include "nogc.h"
#include "root_set_enum.h"
#include "ini.h"
#include "stack_manipulation.h"
#include "exceptions.h"
#include "jit_intf.h"
#include "orp_synch.h"
#include "exception_filter.h"
#include "orp_threads.h"


#include "enum_trampoline.h"
#include "sync_bits.h"
#include "orp_stats.h"

#ifdef ORP_NT
// wjw -- following lines needs to be generic for all OSs
#include "java_lang_thread_nt.h"
#endif

#ifdef POINTER64
#include "java_lang_thread_ia64.h"
#else
#include "java_lang_thread_ia32.h"
#endif

#include "thread_manager.h"
#include "object_generic.h"
#include "thread_generic.h"

#include "mon_enter_exit.h"

#include "jni.h"
#include "jvmdi_clean.h"

#ifdef ORP_POSIX
#define SUSPEND_THREAD(x) 1
#define RESUME_THREAD(x) 1
#define OS_THREAD_INIT_2()
#define SET_THREAD_DATA_MACRO()
#define THREAD_CLEANUP()
#define BEGINTHREADEX_SUSPENDSTATE 1
unsigned __stdcall call_the_run_method2(void *p_xx);

#endif //ORP_POSIX

void orp_change_nursery(void *p_nursery) 
{

    p_TLS_orpthread->p_nursery = p_nursery;
#ifdef RECLAIM_EVERY_ALLOCATION
	p_TLS_orpthread->allocation_count = 0;
#endif

}


void *orp_get_nursery()
{
	// For GC_NONE_V0 and GC_FIXED_V1 this will be NULL.
	return p_TLS_orpthread->p_nursery;
}



void internal_suspend_utility(ORP_thread * p_thr)
{ 
    if (p_thr == p_TLS_orpthread)
        return;  // trying to suspend ourself

    if (p_thr == 0)
        return;  // trying to suspend non-existant thread

    DWORD stat = SUSPEND_THREAD(p_thr);

    if (stat == 0xffFFffFF)
        return; // trying to suspend non-existant thread

    assert(stat != 0xffFFffFF); 

    int xx;
    for (xx = 0; xx < 10; xx ++) {

        if (in_busybit_critical_zone(p_thr) ) {

            stat = RESUME_THREAD(p_thr);
            if (stat == 0xffFFffFF)
                return; // trying to resume non-existant thread
            Sleep(10);  // allow target thread to get out of busybit area

            stat = SUSPEND_THREAD(p_thr);
            if (stat == 0xffFFffFF)
                return; // trying to suspend non-existant thread
        }
        else break;
    }
    assert(xx < 10);  // must be totally stuck in a busybit_critical_zone
}


void java_lang_Thread_sleep_generic(int64 msec) 
{
    setup_gc_frame_context();
    
    assert(p_TLS_orpthread->gc_enabled_status == disabled);

    orp_enable_gc();

    // GC can happen in the lock enum, thread_is_running 
    // and p_TLS_orpthread->gc_frame_context.ljf is
    // never reset before we return from the GC.

    p_thread_lock->_lock_enum();  
//    orp_disable_gc();
    assert(!((uint32)(msec >> 32))); // We currently ignore high 32 bits of msec.

    setup_gc_frame_context();
    p_TLS_orpthread->app_status = thread_is_sleeping;
    // ONLY monitor enter/exit use event_handle_monitor
    // ONLY the following line waits on event_handle_sleep,

    // the following should never happen but to be safe...
    // the following reset flushes any _Thread_interrupt0()'s that happened while
    // the thread was not in a Thread_sleep() or _Object_wait() state.
    DWORD stat = ResetEvent(p_TLS_orpthread->event_handle_sleep);
    assert(stat);
    
    p_TLS_orpthread->interrupt_a_waiting_thread = false;

    p_TLS_orpthread->which_trap = x_java_sleep;
    p_TLS_orpthread->gc_status = gc_at_safepoint;

    active_thread_count --;

    p_thread_lock->_unlock_enum();
 
    assert(p_TLS_orpthread->gc_status == gc_at_safepoint);
    assert(p_TLS_orpthread->which_trap == x_java_sleep);
    
//    orp_enable_gc();

    stat = WaitForSingleObject(p_TLS_orpthread->event_handle_sleep,  
                                        (unsigned long)msec);
    assert(stat != WAIT_FAILED);
	// If a GC happens during the wait and the sleep ends then 
	// the gc_status could be gc_enumeration_done which is OK since
	// the GC thread will change it back to gc_at_safepoint.
	assert((p_TLS_orpthread->gc_status == gc_at_safepoint) ||
		(p_TLS_orpthread->gc_status == gc_enumeration_done) );
    assert(p_TLS_orpthread->which_trap == x_java_sleep);

	// Since this lock and the GC lock is the same we will just block if
	// a GC is going on. When the GC is done we should come out with
	// (p_TLS_orpthread->gc_status == gc_at_safepoint)
    p_thread_lock->_lock_enum();
	assert(p_TLS_orpthread->gc_status == gc_at_safepoint);
    orp_disable_gc();

    if (stat == WAIT_TIMEOUT)
    {
        assert(p_TLS_orpthread->which_trap == x_java_sleep);
        p_TLS_orpthread->which_trap = x_nothing;

        assert(p_TLS_orpthread->gc_status == gc_at_safepoint);
        p_TLS_orpthread->gc_status = zero;

        assert(p_TLS_orpthread->app_status == thread_is_sleeping);
        p_TLS_orpthread->app_status = thread_is_running;
    }

    Boolean java_suspend_happened_while_sleeping = p_TLS_orpthread->thread_is_java_suspended;

    p_TLS_orpthread->interrupt_a_waiting_thread = false;

    active_thread_count ++;

    p_thread_lock->_unlock_enum();

    if (java_suspend_happened_while_sleeping) { 

        assert(0); // diagnostic -- toss when hit
        orp_enable_gc();

        DWORD wstat = WaitForSingleObject(p_TLS_orpthread->event_handle_suspend0, INFINITE); 
        assert(wstat != WAIT_FAILED);

        orp_disable_gc();
    }

    if (stat == WAIT_TIMEOUT)
        return;
    else {
        throw_java_exception("java/lang/InterruptedException");
    }

    assert(0);  // the throw should always work
} //java_lang_Thread_sleep_generic


unsigned java_lang_Thread_countStackFrames_generic(ORP_thread *p_orpthread) 
{
    assert(0); //DEPRICATED
    unsigned ret_val;
    assert(p_TLS_orpthread->gc_enabled_status == disabled);

    setup_gc_frame_context();

    orp_enable_gc();

    p_thread_lock->_lock_enum();

    orp_disable_gc();

    if (p_orpthread != p_TLS_orpthread) {
        p_thread_lock->_unlock_enum();
        throw_java_exception("java/lang/IlegalThreadState");
    }

    Frame_Context context;

    COUNTSTACKFRAME_MACRO();

    ret_val = orp_get_stack_depth(&context);

    p_thread_lock->_unlock_enum();
 
    return ret_val;
}


void java_lang_Thread_setPriority_generic(ORP_thread *p_orp_thread, long pri)
{
    assert(p_TLS_orpthread->gc_enabled_status == disabled);

    orp_enable_gc();

    p_thread_lock->_lock_enum();

    orp_disable_gc();

    assert(0); // fix next line
//    p_this->priority = pri;

    // NOTE: setPriority0 is actually called before the thread is started
    // in which case, p_orp_thread is null... Thread_start will then set the priority
    
    if(p_orp_thread == 0) {
        p_thread_lock->_unlock_enum();
        return;
    }
    if (p_orp_thread->app_status == zip) {
        p_thread_lock->_unlock_enum();
        return;
    }    
    
    int status = SetThreadPriority(p_orp_thread->thread_handle,
		                    THREAD_PRIORITY_NORMAL + pri - 5);
    if(status == 0) {
        DWORD error = GetLastError();
        printf ("java_lang_Thread_setPriority error = 0x%x\n", error);   
    }
    p_thread_lock->_unlock_enum();
} //java_lang_Thread_setPriority0


unsigned __stdcall call_the_run_method( void * p_xx )
{
    ORP_thread *p_orp_thread = get_orp_thread_ptr(p_xx);

    assert(p_orp_thread);

#ifdef ORP_POSIX
    pthread_setspecific(thread_local_storage_key, p_orp_thread);
#endif

    OS_THREAD_INIT_2();

    quick_thread_id[hint_free_quick_thread_id].p_orpthread = p_TLS_orpthread;
    hint_free_quick_thread_id++;  // to avoid rescanning an already occupied slot

    // The new created thread (which is "birthing") starts by executing this method, 
    // i.e. "call_the_run_method". So assert that this thread is still "birthing".
    // This check is needed because ljf is set to zero in the next statement, and 
    // a few statements after that the call to "gc_get_new_nursery" might force GC 
    // and then ljf being zero will be OKAY because the thread is still "birthing".

    assert(p_orp_thread->app_status == thread_is_birthing);

    // turned off for now --> orp_monitor_multithread();

    set_orp_last_java_frame(0);

    DWORD rstat = SetEvent(p_orp_thread->gc_resume_event_handle);
    assert(rstat);
    rstat = ResetEvent(p_orp_thread->event_handle_suspend0);
    assert(rstat);

    // the thread that originally called java_lang_Thread_start() will wait for this event
    // DWORD stat = SetEvent(new_thread_started_handle);
    // assert(stat);

	gc_thread_init();
    // Current implementation does one nursery per thread. 
	// GC_FIXED_V1 and GC_NONE_V0 gets NULL.


/**************************************************************** 
  Temporarily move gc_get_new_nursery() to the beginning of java_lang_Thread_start_generic()

    // It is possible that a GC could result from this call but since there is not
    // an ljf set up since one doesn't exist the GC will get confused. For this reason
    // we place the informational number 411 into the ljf.
#ifndef POINTER64
    assert (p_TLS_orpthread->gc_frame_context.ljf == 0); // No frames no ljf
    p_TLS_orpthread->gc_frame_context.ljf = 411;         // For information only.
#endif

    p_TLS_orpthread->p_nursery = gc_get_new_nursery();

#ifndef POINTER64
    p_TLS_orpthread->gc_frame_context.ljf = 0;           // Reset to 0.
#endif

******************************************************************/
    SET_THREAD_DATA_MACRO();

    // Invoke Thread.run()  -- BUGBUG its an interface method but we cheat
    // by looking up "run" in the instance method instead of
    // going thru interface lookup
    String *name   = ORP_Global_State::loader_env->string_pool.lookup("run");
    String *descr  = ORP_Global_State::loader_env->string_pool.lookup("()V");
    Signature *sig = ORP_Global_State::loader_env->sig_table.lookup(name, descr);
    assert(sig);

    VTable *p_vtable = (p_orp_thread->p_java_lang_thread->vt);
    Method *run_method = class_lookup_method(p_vtable->clss, sig);
    if(!run_method){
	orp_cout << "Class " << p_vtable->clss->name->bytes << "doesn't have run() method defined.\n";
	//orp_exit(2);
    	run_method = class_lookup_method_recursive(p_vtable->clss, sig);

    }
    assert(run_method);


#ifndef NO_JVMDI_SUPPORT
    if (report_jvmdi_event_thread_start == true) // bugbug is there a ..._thread_end to test??
    {
        Object_Handle jt = orp_create_global_object_handle();
        jt->java_reference = (struct Java_java_lang_Object *)
                                p_TLS_orpthread->p_java_lang_thread;

        JVMDI_Event *p_event_record = 0;
        Allocate(sizeof(JVMDI_Event), (jbyte**)&p_event_record );
        memset(p_event_record, 0, sizeof(JVMDI_Event) );

        p_event_record->kind = JVMDI_EVENT_THREAD_START;
        p_event_record->u.thread_change.thread = jt;

        extern JVMDI_EventHook jvmdi_hook_function;
        extern const struct JNIEnv_ *jni_native_intf;

        jvmdi_hook_function( (struct JNIEnv_ *)jni_native_intf, p_event_record);
    }
#endif

    int old_floating_point_state = 0;
    void setup_floating_point_state(int *);
    setup_floating_point_state(&old_floating_point_state);

    // Set the app_status to "running" just before entering Java code. It is 
    // "birthing" till now.
    p_orp_thread->app_status = thread_is_running;

    active_thread_count ++;

    // the thread that originally called java_lang_Thread_start() will wait for this event 
    DWORD stat = SetEvent(new_thread_started_handle);
    assert(stat);

    orp_execute_java_method(run_method, 0, p_orp_thread->p_java_lang_thread);

    void cleanup_floating_point_state(int);
    cleanup_floating_point_state(old_floating_point_state);


#ifndef NO_JVMDI_SUPPORT
    if (report_jvmdi_event_thread_start == true) // bugbug is there a ..._thread_end to test??
    {
        Object_Handle jt = orp_create_global_object_handle();
        jt->java_reference = (struct Java_java_lang_Object *)p_TLS_orpthread->p_java_lang_thread;

        JVMDI_Event *p_event_record = 0;
        Allocate(sizeof(JVMDI_Event), (jbyte**)&p_event_record );
        memset(p_event_record, 0, sizeof(JVMDI_Event) );

        p_event_record->kind = JVMDI_EVENT_THREAD_START;
        p_event_record->u.thread_change.thread = jt;

        extern JVMDI_EventHook jvmdi_hook_function;
        extern const struct JNIEnv_ *jni_native_intf;

        jvmdi_hook_function( (struct JNIEnv_ *)jni_native_intf, p_event_record);
    }
#endif


    assert(p_orp_thread->app_status == thread_is_running);
    p_orp_thread->app_status = thread_is_dying;

    // Invoke Thread.exit()
    name  = ORP_Global_State::loader_env->string_pool.lookup("exit");
    descr = ORP_Global_State::loader_env->string_pool.lookup("()V");
    sig   = ORP_Global_State::loader_env->sig_table.lookup(name, descr);
    assert(sig);

    Method *exit_method;
    Class *p_class;
    p_class = p_vtable->clss;
    while(p_class) {
        exit_method = class_lookup_method(p_class, sig);
        if (exit_method) break;
        p_class = p_class->super_class;
    }
    
    Class *clss = ORP_Global_State::loader_env->java_lang_Thread_Class;

    p_class = p_vtable->clss->super_class;
    bool inherits_from_thread = false;
    while(p_class) {
        if (p_class == clss) {
            inherits_from_thread = true;
            break;
        }
        p_class = p_class->super_class;
    }
    if ( (inherits_from_thread) && exit_method ) {
        orp_cout << flush;
       
        // reload pointer to a live Java Object (Java_java_lang_Thread) that GC _may_ have moved
        volatile Java_java_lang_Object * p_zz;
        p_zz = (volatile Java_java_lang_Object *)p_orp_thread->p_java_lang_thread;
        orp_execute_java_method(exit_method, 0, p_zz);
    }

	gc_thread_kill();
    // In our current one nursery per thread world we need to release this nursery.
    // In a nursery per CPU world we would do something else like not release the
    // nursery.
    void *spent_nursery = p_TLS_orpthread->p_nursery;
    p_TLS_orpthread->p_nursery = NULL; // orphan the spent nursery
    gc_release_nursery (spent_nursery); // release it to the spent list.

    // reload pointer to a live Java Object (Java_java_lang_Thread) that GC _may_ have moved
    volatile Java_java_lang_Object * p_vv;
    p_vv = (volatile Java_java_lang_Object *)p_orp_thread->p_java_lang_thread;
    assert (p_vv->vt); // Check that p_vv is a reasonable object with a vtable.
    orp_monitor_enter( (struct Java_java_lang_Object *)p_vv);
    // Reload p_vv since gc could happened in orp_monitor_enter().
    p_vv = (volatile Java_java_lang_Object *)p_orp_thread->p_java_lang_thread;


#ifdef _DEBUG

    // SAPPHIRE needs to make sure we get the correct header in this situation.
#ifndef GC_SAPPHIRE
    assert(p_TLS_orpthread->p_current_object == 0);

    // Reload p_vv since gc could happened in orp_monitor_enter().
    p_vv = (volatile Java_java_lang_Object *)p_orp_thread->p_java_lang_thread;
    POINTER_SIZE_INT *p_header = P_OBJ_INFO(p_vv);

    /////void slow_header_lock(volatile POINTER_SIZE_INT *p_header);
    ////////slow_header_lock(p_header);
    ACQUIRE_BUSY_BIT(p_header);

    if ( (*p_header & SLOW_LOCKING) == SLOW_LOCKING) {    
        Lock_Block *p_lock_chain;
        p_lock_chain =(Lock_Block *)(*p_header & LOCK_BLOCK_POINTER_MASK);
        assert(p_lock_chain->lock_recursion_count_shifted_left == QUICK_RECURSION_INC_DEC_REMENT);
        assert( (p_lock_chain->old_object_header & QUICK_THREAD_INDEX_MASK) ==
                        p_TLS_orpthread->quick_thread_index_shifted_left);
    } else
    {
        assert( (*p_header & QUICK_RECURSION_MASK) == QUICK_RECURSION_INC_DEC_REMENT);
        assert( (*p_header & QUICK_THREAD_INDEX_MASK) == 
            p_TLS_orpthread->quick_thread_index_shifted_left);
    }

    RELEASE_BUSY_BIT(p_header);
#endif // GC_SAPPHIRE
#endif // _DEBUG


    assert (p_vv->vt);

    reset_alive_flag_in_thread_object(p_vv);

    java_lang_Object_notifyAll ( (struct Java_java_lang_Object *)p_vv);

    p_vv = (volatile Java_java_lang_Object *)p_orp_thread->p_java_lang_thread;

    orp_monitor_exit( (struct Java_java_lang_Object *)p_vv);

    // Reload p_vv since gc could happened in orp_monitor_exit().
    p_vv = (volatile Java_java_lang_Object *)p_orp_thread->p_java_lang_thread;

    // Gc can happen in the below but p_vv is protected.

    GC_Frame gcf1;
    orp_push_gc_frame(&gcf1, (void *)&p_vv, sizeof(void *) );
    orp_enable_gc();

    p_thread_lock->_lock_enum();

    orp_disable_gc();
    orp_pop_gc_frame(&gcf1);  

    assert (p_vv->vt);

    if ( !is_this_a_daemon_thread( (void *)p_vv) ) 
        non_daemon_thread_count--;   


    assert(p_orp_thread->gc_frames == 0);  

	free_this_thread_block(get_orp_thread_ptr( (void *)p_vv) );

    THREAD_CLEANUP();

    if (!non_daemon_thread_count) {
        DWORD stat = SetEvent(non_daemon_threads_dead_handle);
        assert(stat);
    }

    active_thread_count --;

    // turned off for now --> orp_monitor_singlethread();
    p_thread_lock->_unlock_enum();

	_endthreadex(99);
    return(99);
}
 

void java_lang_Thread_start_generic(volatile Java_java_lang_Object *p_this_volatile) 
{
    GC_Frame gcf1;
    orp_push_gc_frame(&gcf1, (void *)&p_this_volatile, sizeof(void *) );
    orp_enable_gc();

// get a nursery for child thread. this invocation previously is by child thread itself 
// in call_the_run_method()
    void *temp_nursery = gc_get_new_nursery();

    p_thread_lock->_lock_enum();

    orp_disable_gc();
    orp_pop_gc_frame(&gcf1);  

    //BUGBUG this should throw IllegalThreadStateException  
    // because field in use means thread is already running		
    assert(is_thread_private_data_field_in_use(p_this_volatile) == 0); 

    ORP_thread * p_orp_thread = get_a_thread_block();

    p_orp_thread->p_java_lang_thread = p_this_volatile;

    set_java_thread_private_data_field(p_this_volatile, p_orp_thread);
    set_alive_flag_in_thread_object(p_this_volatile);

    assert(is_thread_private_data_field_in_use(p_this_volatile) != 0); 

    p_orp_thread->thread_is_java_suspended = false;			
    p_orp_thread->p_nursery = temp_nursery;			

    if ( is_this_a_daemon_thread( (void *)p_this_volatile) == 0)
        non_daemon_thread_count++;

#ifdef MONITOR_STO	
    if(! bMultithreaded){
        bMultithreaded = true;
        for(int i=0; i<(num_lazylock-(int)lazylist)/4; i++)
            orp_monitor_enter(lazylist[i]);

        void * getaddress__orp_monitor_enter_naked();
        void * getaddress__orp_monitor_exit_naked();
        char * restore__orp_monitor_enter_naked(char *);
        char * restore__orp_monitor_exit_naked(char *);

        char * ss = (char *)getaddress__orp_monitor_enter_naked();
        restore__orp_monitor_enter_naked(ss);
        ss = (char *)getaddress__orp_monitor_exit_naked();
        restore__orp_monitor_exit_naked(ss);
    }
#endif

	p_orp_thread->thread_handle = (HANDLE)_beginthreadex( 
                                            (void *)0, (unsigned)(64*1024), 

                                            (unsigned(__stdcall *)(void *))call_the_run_method2, 

                                            (void *)p_this_volatile,

                                            (unsigned)0, // Just start the thread.

                                            (unsigned *)&p_orp_thread->thread_id);

    if (p_orp_thread->thread_handle == 0) {
        orp_cout << "Thread creation failed" << endl;
        orp_exit(1);
	}

    Sleep(0);

	// Thread is brought up running with the default priority.
    // This seems better than suspending and then setting the priority since
	// it works on Linux as well.
	// set_thread_priority(p_orp_thread, p_this_volatile);

	// the new thread just resumed above will set new_thread_started_handle
	int status;
    status = WaitForSingleObject(new_thread_started_handle, INFINITE);
    assert(status != WAIT_FAILED);

    p_thread_lock->_unlock_enum();
} //java_lang_Thread_start_generic


void java_lang_Thread_interrupt_generic 
    (volatile Java_java_lang_Object *p_java_thr_volatile) 
{
    GC_Frame gcf1;
    orp_push_gc_frame(&gcf1, (void *)&p_java_thr_volatile, sizeof(void *) );
    orp_enable_gc();

    p_thread_lock->_lock_enum();

    orp_disable_gc();
    orp_pop_gc_frame(&gcf1);  

    //ORP_thread * p_thr = (ORE_thread *) (p_java_thr_volatile->PrivateInfo);
    ORP_thread *p_thr = get_orp_thread_ptr( (void *)p_java_thr_volatile);

    if (p_thr == 0) {
        p_thread_lock->_unlock_enum();
        return;  // don't try to interrupt a non-existant thread
    }

    if (p_thr->app_status == zip) {
        p_thread_lock->_unlock_enum();
        return;  // don't try to interrupt a non-existant thread
    }    

    internal_suspend_utility(p_thr);

    p_thr->interrupt_thread_api_support = true;
    bool old_state = p_thr->interrupt_a_waiting_thread;
    p_thr->interrupt_a_waiting_thread = true;

    set_interrupt_flag_in_thread_object(p_java_thr_volatile);

    if (p_thr == p_TLS_orpthread) {
        p_thread_lock->_unlock_enum();
        return; // interrupting ourself
    }
     
    DWORD stat;
    switch (p_thr->app_status)
    {
        case thread_is_sleeping:
            {
                // do nothing, do NOT allow sleeping threads to be interrupted
                break;
            }
        case thread_is_waiting: 
            {
                if (old_state == false) {

                    p_thr->app_status = thread_is_running;

                    assert(p_thr->which_trap == x_java_wait);
                    p_thr->which_trap = x_nothing;

                    assert(p_thr->gc_status == gc_at_safepoint);
                    p_thr->gc_status = zero;

                    //wgs: change assertion here
                    //assert(p_thr->p_latest_wait_lock_block->lock_or_wait_state == 
                    //                                        waiting_for_the_notify);
                    assert(p_thr->p_latest_wait_lock_block->lock_or_wait_state == 
                                                            waiting_for_the_notify ||
                           p_thr->p_latest_wait_lock_block->lock_or_wait_state == 
                                                            waiting_for_the_lock);

                    stat = SetEvent(p_thr->event_handle_interrupt);
                    assert(stat);
                }
                break;
            }
    }
    stat = RESUME_THREAD(p_thr);
    assert(stat == 1);

    p_thread_lock->_unlock_enum();
} //java_lang_Thread_interrupt0

#ifdef ORP_POSIX

unsigned __stdcall call_the_run_method2(void *p_xx)
{
    call_the_run_method(p_xx);
}


void _endthreadex(int zz)
{
    // on linux, this is a nop,
    // call_the_run_method2() simply returns into the linux kernel
}
#endif // ORP_POSIX
#endif //#ifndef  OBJECT_LOCK_V2


