// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/stack.h,v 1.2 2001/08/13 09:52:49 xhshi Exp $
//

#ifndef _STACK_H_
#define _STACK_H_

#include <assert.h>
#include "Mem_Manager.h"

class Inst;

class Stack {
public:
	Stack(Mem_Manager& mem_manager,unsigned sz) : size(sz) {
		_top = 0;
		_elems = (Inst**)mem_manager.alloc(sizeof(Inst*)*sz);
	}
	void reset() {_top =  0;}
	Inst *pop() {assert(_top>0); return _elems[--_top];}
	void pop(int n);
	void push(Inst *inst) {
		assert(_top < size);
		_elems[_top++] = inst;
	}
	Inst *ith_word(int ith);
    Inst *ith_elem(int ith) {return _elems[_top - ith - 1];}
    unsigned depth();
    unsigned top() {return _top;}

	const unsigned size;
private:
	unsigned _top;
	Inst **_elems;
};
#endif // _STACK_H_
