// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/pldi.cpp,v 1.2 2001/08/13 09:52:49 xhshi Exp $
//



#include "defines.h"
#include "pldi.h"
#include "bitstream.h"

#ifdef PLDI
unsigned pldi_num_methods = 0;
unsigned pldi_code_size = 0;
unsigned pldi_info_size = 0;
unsigned pldi_methods_with_wb = 0;
unsigned pldi_gc_unsafe_inst = 0;
unsigned pldi_num_single_inst = 0;
unsigned pldi_num_multiple_inst = 0;
unsigned pldi_single_reg_change[n_reg];
unsigned pldi_multiple_reg_change = 0;

unsigned pldi_stk_push_ref = 0;
unsigned pldi_stk_push_nonref = 0;
unsigned pldi_stk_call = 0;
unsigned pldi_stk_pop = 0;
unsigned pldi_stk_other = 0;

unsigned pldi_bb_snapshots = 0;
unsigned pldi_std_gc_safe = 0;

unsigned pldi_jsr_problems = 0;

unsigned pldi_inst_hist[MAX_INST_HIST];

unsigned pldi_inst_effect[2][2][2];
#endif // PLDI

void print_pldi_stats()
{
#ifdef PLDI
    BitStream b(0.0); // dump stats during destructor

    cout << "Number of methods\t" << pldi_num_methods << endl;
    cout << "Code size\t"         << pldi_code_size   << endl;
    cout << "GC map size\t"       << pldi_info_size   << endl;

    cout << "Methods with write barriers\t"      << pldi_methods_with_wb << endl;
    cout << "Number of GC-unsafe instructions\t" << pldi_gc_unsafe_inst  << endl;

    cout << "Number of reg=0,stk=0,esp=0\t"   << pldi_inst_effect[0][0][0] << endl;
    cout << "Number of reg=1,stk=1,esp=1\t"   << pldi_inst_effect[1][1][1] << endl;
    cout << "Stack location only\t"           << pldi_inst_effect[0][1][0] << endl;
    cout << "Stack pointer, stack location\t" << pldi_inst_effect[0][1][1] << endl;
    cout << "Register, stack location\t"      << pldi_inst_effect[1][1][0] << endl;
    cout << "Register only\t"                 << pldi_inst_effect[1][0][0] << endl;
    cout << "Stack pointer, register\t"       << pldi_inst_effect[1][0][1] << endl;
    cout << "Stack pointer only\t"            << pldi_inst_effect[0][0][1] << endl;

    cout << "Number of single instructions\t" << pldi_num_single_inst   << endl;
    cout << "Number of multi instructions\t"  << pldi_num_multiple_inst << endl;

    unsigned i;
    for (i=0; i<n_reg; i++)
    {
        if (i != esp_reg)
            cout << X86_Reg_Str[i] << "\t" << pldi_single_reg_change[i] << endl;
    }
    cout << "Multi-register\t" << pldi_multiple_reg_change << endl;

    cout << "Other\t"              << pldi_stk_other       << endl;
    cout << "Pop\t"                << pldi_stk_pop         << endl;
    cout << "Call\t"               << pldi_stk_call        << endl;
    cout << "Push non-reference\t" << pldi_stk_push_nonref << endl;
    cout << "Push reference\t"     << pldi_stk_push_ref    << endl;

    cout << "Snapshots\t" << pldi_bb_snapshots << endl;
    cout << "Standard GC points\t" << pldi_std_gc_safe << endl;

    cout << "JSR problems\t" << pldi_jsr_problems << endl;

    for (i=1; i<MAX_INST_HIST; i++)
        cout << "Instruction length " << i << "\t" << pldi_inst_hist[i]/2 << endl;
    cout << "Instruction length (other)\t" << pldi_inst_hist[0]/2 << endl;
#endif // PLDI
}
