// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/o3_profiling.cpp,v 1.7 2001/12/07 00:16:00 xli18 Exp $
//


#include "defines.h"
#include <iostream.h>
#include <fstream.h>
#include "ir.h"
#include "expression.h"
#include "jit_intf.h"
#include "flow_graph.h"
#include "build_ir_routines.h"
#include "o3_profiling.h"
#include "bitstream.h"
#include "gc_eh_support.h"
#ifdef STAT_INDIRECT_CALL
#include "stack_manipulation.h"
#include "Mem_Manager.h"
#include "nogc.h"
#endif
//extern ofstream g_cout ;

#ifdef O3_VTune_Support
#ifndef STAT_INDIRECT_CALL
#include "stack_manipulation.h"
#include "Mem_Manager.h"
#include "nogc.h"
#endif

#ifdef ORP_VTUNE_SUPPORT
#include "orp_vtune.h"
#endif


#include "..\\ia32_o1_jit\\vtune.h"
#endif

void print_o3_profiling_info(JIT_Handle jit_handle) {
    if (!O3_statistics) return;
	FILE* fp ;
	fp = fopen("o3_profile.txt","w+") ;
	assert(fp) ;
    Method_Iterator mi;
    for (mi = method_get_first_method_jit(jit_handle); 
         mi != JAVA_METHOD_END;
         mi = method_get_next_method_jit(mi)) {
        Method_Handle m = method_get_method_jit(mi);
        // retrieve method info
        Byte *mi = method_get_info_block(m,jit_handle);
        assert(mi != NULL);
        BitStream bits(mi, *(unsigned *)mi);
        GC_Map::fixed_width_info fwi;
        init_prof_and_overridden(bits,fwi); // retrieve prof_rec from bitstream
        //
        // retrieve profiling info
        //
        O3_Profile_Rec *prof_rec = (O3_Profile_Rec*)fwi.prof_rec;
        assert(prof_rec != NULL);
        if (prof_rec == NULL) continue;
		fprintf(fp,"Method_Name: %s.%s%s\n",class_get_name(method_get_class(m)),
											method_get_name(m) ,
											method_get_descriptor(m)) ;
        // print profiling info
        O3_UNIQUE_LABEL *label = (O3_UNIQUE_LABEL*)&prof_rec->bb[prof_rec->n_bb];
        O3_PROF_INFO *info = (O3_PROF_INFO*)&label[prof_rec->n_bb];
        unsigned i;
        for (i = 0; i < prof_rec->n_bb; i++) {
            if (info[i] == 1)
				fprintf(fp,"      BB #@ %d\t" , label[i]) ;
            else
				fprintf(fp,"      BB # %d\t" , label[i]) ;
            if (sizeof(O3_PROF_COUNTER) == sizeof(uint64)) {
				fprintf(fp,"%p\t%I64u\n", &prof_rec->bb[i], prof_rec->bb[i]) ;
            } else
				fprintf(fp,"%p\t%lu\n", &prof_rec->bb[i], prof_rec->bb[i]) ;
        }

		//
		// for inner_bb instrument
		//
		if(Inner_O3_statistics){
			for(i=0 ; i< prof_rec->inner_counter_num ; i++){
				if (sizeof(O3_PROF_COUNTER) == sizeof(uint64)) 
					fprintf(fp,"Inner_bb_counter: %p\t%I64u\n", &prof_rec->inner_counter[i] , prof_rec->inner_counter[i]) ;
				else
					fprintf(fp,"Inner_bb_counter: %p\t%lu\n", &prof_rec->inner_counter[i] , prof_rec->inner_counter[i]) ;
			}
		}
    }

	fclose(fp) ;
//	g_cout.close() ;
}

static unsigned estimate_prof_rec_size(unsigned num_be_entries) {
    unsigned extra_entries = (num_be_entries == 0)? 0 : num_be_entries-1;
    return sizeof(O3_Profile_Rec) +                  // default size
           sizeof(O3_PROF_COUNTER)*extra_entries +   // for back_edge counters
           sizeof(O3_UNIQUE_LABEL)*num_be_entries+   // for bb unique label
           sizeof(O3_PROF_INFO)*num_be_entries ;      // for extra info
}

//
// create a profiling record for each method
//
O3_Profile_Rec *create_o3_profile_rec(Method_Handle m_handle,
                                      Compile_Handle comp_handle,
                                      unsigned n_bb) {
    if (!O3_statistics) return NULL;

    unsigned sz = estimate_prof_rec_size(n_bb);
    O3_Profile_Rec *prof_rec = 
        (O3_Profile_Rec*)method_allocate_jit_data_block(m_handle,comp_handle,sz);
    // 
    // initialize profiling record
    //
    prof_rec->n_bb = n_bb;
    prof_rec->been_recompiled = false;
    prof_rec->m_entry = 0;  // set counter to zero
    O3_UNIQUE_LABEL *label = (O3_UNIQUE_LABEL*)&prof_rec->bb[n_bb];
    O3_PROF_INFO *info = (O3_PROF_INFO*)&label[n_bb];
    unsigned i;
    for (i = 0; i < n_bb; i++) {
        if (sizeof(O3_PROF_COUNTER) == sizeof(int64))
			prof_rec->bb[i] = __UINT64_C(0) ;
		else
			prof_rec->bb[i] = 0; // set counter to zero
        info[i] = 0;
    }

	//
	// for inner BB counters
	//
	prof_rec->inner_counter = NULL ;
	prof_rec->inner_counter_num = 0 ;
    return prof_rec;
}


static void insert_code(Cfg_Node *node, Closure *c) {
    O3_Prof_Closure *pc = (O3_Prof_Closure*)c;
    Expressions& exprs = pc->exprs;
    O3_Profile_Rec *prof = pc->prof_rec;
    Inst *inst_head = node->IR_instruction_list()->next();
    //
    // set unique label of node
    //
    O3_UNIQUE_LABEL *label = (O3_UNIQUE_LABEL*)&prof->bb[prof->n_bb];
#ifdef PRINTABLE_O3
    label[node->label] = node->unique_label;
#else
    label[node->label] = node->label;
#endif
    O3_PROF_INFO *info = (O3_PROF_INFO*)&label[prof->n_bb];
    if (node->is_cold_non_inlined())
        info[node->label] = 1;
    //
    // generate "iinc counter, 1"
    //
    O3_Jit_Type ty;
    void *addr = (void*)&prof->bb[node->label];
    Operand_Exp *imm1;
    if (sizeof(O3_PROF_COUNTER) == sizeof(uint64)) {
        ty = JIT_TYPE_LONG;
        Value val;
	    val.l.hi = 0; val.l.lo = 1;
        imm1 = exprs.lookup_const_exp(&val,ty);
    } else {
        ty = JIT_TYPE_INT;
        imm1 = exprs.lookup_imm_exp(1,ty);
    }
    Operand_Exp *cnt = exprs.lookup_static_exp(addr, ty, addr, NULL);
    Exp *plus = exprs.lookup_inst_exp(Exp::Add,cnt,imm1,ty);
    Exp *asgn = exprs.lookup_inst_exp(Exp::Assign,cnt,plus,ty);
    Inst *inc = new (exprs.mem) Add_Inst(Add_Inst::add,cnt->opnd,imm1->opnd,asgn,inst_head);
    inc->set_dst(cnt->opnd);
    inc->expand(exprs);
}

//
// insert instrumenting code for each block
//
void insert_profiling_code(Flow_Graph *fg, Expressions &exprs) {
    if (!O3_statistics) return;
    //
    // create profile record that hold all counters
    //
    int max_label = fg->reassign_label();
    O3_Profile_Rec *prof_rec = create_o3_profile_rec(fg->m_handle(),
                                                     fg->cmpl_handle(),
                                                     max_label);
    fg->o3_prof_rec = prof_rec;
	if(Inner_O3_statistics){
		fg->o3_prof_rec->inner_counter_num = fg->inner_counter_num ;
		fg->o3_prof_rec->inner_counter = (O3_PROF_COUNTER*)(fg->inner_counter) ;
	}
    O3_Prof_Closure c(exprs,prof_rec);
    fg->apply(insert_code,&c);
}

#ifdef STAT_INDIRECT_CALL
//
// Instrument a Push before every instrumented-JNI
//
void instrument_push_indr_call(Cfg_Node *node, Closure *c)
{
	assert(c) ;
    Flow_Graph *fg = ((Instrument_Closure*)c)->fg;
    Operand *src = NULL;
    Inst *head = node->IR_instruction_list();
    Mem_Manager& mm = fg->mem_manager;

    Inst *i;
    for (i = head->next(); i != head; i = i->next()) {
        //
        // Find out which Call_Inst is a "call [offset]"
        //
        if (i->is_call()){

			//if(i->n_srcs && i->src(0)->kind == Operand::Field){
			if( ((Call_Inst*)i)->kind == Call_Inst::special_call ||
				((Call_Inst*)i)->kind == Call_Inst::virtual_call ||
				((Call_Inst*)i)->kind == Call_Inst::static_call  ||
				((Call_Inst*)i)->kind == Call_Inst::interface_call){
				//
				//Here instrument the stub
				//
				Exp *imm = ((Instrument_Closure*)c)->exprs.lookup_imm_exp(0, JIT_TYPE_INT); // imm exp is purely used for creating push
			    Operand_Exp *eax = ((Instrument_Closure*)c)->exprs.lookup_reg_exp(eax_reg,JIT_TYPE_INT,0);
				Inst* p_inst = new (mm) Push_Inst(eax->opnd,imm,i) ;
				p_inst->set_gc_unsafe() ;

			}//if

		}//if
    }//for

}
//
// Instrument a JNI before every indirect call
//
void instrument_indr_call(Cfg_Node *node, Closure *c)
{
	static ofstream cout("indirect_branch.log") ;

	assert(c) ;
    Flow_Graph *fg = ((Instrument_Closure*)c)->fg;
    Operand *src = NULL;
    Inst *head = node->IR_instruction_list();
    Mem_Manager& mem = fg->mem_manager;

    Inst *i;
    for (i = head->next(); i != head; i = i->next()) {
        //
        // Find out which Call_Inst is a "call [offset]"
        //
        if (i->is_call()){
			i->print(cout) ;

			//if(i->n_srcs && i->src(0)->kind == Operand::Field){
			if( //((Call_Inst*)i)->kind == Call_Inst::special_call ||
				((Call_Inst*)i)->kind == Call_Inst::virtual_call ||
				//((Call_Inst*)i)->kind == Call_Inst::static_call  ||
				((Call_Inst*)i)->kind == Call_Inst::interface_call){

				cout << " \t << Indirect Branch" ;

				
//				i->set_gc_unsafe() ;
				Inst* i_arg0 = ((Call_Inst*)i)->get_arg(0) ;
				Exp* exp = i->exp ;
				int n_srcs = 1 ;
				int esp_adjust = 4;
/*1
				Exp *ib_exp = ((Instrument_Closure*)c)->exprs.lookup_inst_exp(Exp::StatIndirectCall, exp, NULL,JIT_TYPE_VOID);
				Inst* stat_inst = new(mem) StatIndirectCall_Inst(i->src(0), ib_exp, i_arg0);
				stat_inst->set_gc_unsafe() ;
1*/

				//
				// txx = i->src(0)
				// push(txx) ;
				// call stat_indirect_call
				//
				Inst* assign_inst = new (mem) Assign_Inst(((Instrument_Closure*)c)->exprs.create_new_temp_reg(JIT_TYPE_ADDR),i->src(0),exp,i);
//				Inst *assign_inst = ((Instrument_Closure*)c)->exprs.lookup_imm(0xf1973f,JIT_TYPE_ADDR,i);
//				exp = assign_inst->exp ;

				Inst **argarray = (Inst**)mem.alloc(n_srcs * sizeof(*argarray));
				argarray[0] = new (mem) Push_Inst(assign_inst->dst(),((Inst_Exp*)exp)->left_child(),i); 
//				argarray[0] = new (mem) Push_Inst(i->src(0),((Inst_Exp*)exp)->left_child(),i); 

				Exp *ib_exp = ((Instrument_Closure*)c)->exprs.lookup_inst_exp(Exp::StatIndirectCall, exp, NULL,JIT_TYPE_VOID);
				Inst* cll = new (mem) Stat_Call_Inst(ib_exp,i) ;
				cll->set_gc_unsafe() ;
/*
				Exp *ib_exp = ((Instrument_Closure*)c)->exprs.lookup_inst_exp(Exp::StatIndirectCall, exp, NULL,JIT_TYPE_VOID);
				Call_Inst *cll = new(mem) Call_Inst(Call_Inst::stat_indirect_call, ib_exp, NULL, false, i); 
				cll->set_args(argarray, n_srcs, NULL);
				cll->set_expanded();
				argarray[0]->set_gc_unsafe() ;
				cll->set_gc_unsafe() ;
*/
				Operand_Exp *esp = ((Instrument_Closure*)c)->exprs.lookup_reg_exp(esp_reg,JIT_TYPE_INT,0);
				Operand_Exp *imm = ((Instrument_Closure*)c)->exprs.lookup_imm_exp(esp_adjust, JIT_TYPE_INT);
				Inst_Exp *add = ((Instrument_Closure*)c)->exprs.lookup_inst_exp(Exp::Add,esp,imm,JIT_TYPE_INT);
				Inst *add_i = new (mem) Add_Inst(Add_Inst::add,esp->opnd,imm->opnd,add,i);

				add_i->set_dst(esp->opnd);
				add_i->dont_eliminate();

				//int n_args = ((Call_Inst*)i)->n_args() - 1 ;
				//Inst* inst_head = n_args >= 0 ? ((Call_Inst*)i)->get_arg(n_args) : i ;
				//Exp *ib_exp = ((Instrument_Closure*)c)->exprs.lookup_inst_exp(Exp::StatIndirectCall, inst_head->exp, NULL,JIT_TYPE_VOID);
				//Inst* stat_inst = new(mem) StatIndirectCall_Inst(inst_head->dst(), ib_exp, i);

				//
				//Here instrument the stub
				//
				/*
				unsigned n_srcs = 1 ;
				//Inst *base = ((Instrument_Closure*)c)->exprs.lookup_imm((unsigned)((Call_Inst*)i)->get_mhandle(),JIT_TYPE_ADDR,i);
				//Exp *ib_exp = ((Instrument_Closure*)c)->exprs.lookup_inst_exp(Exp::StatIndirectCall, base->exp, NULL,JIT_TYPE_VOID);
				Inst **argarray = (Inst**)mm.alloc(n_srcs * sizeof(*argarray));
				//Exp *imm = ((Instrument_Closure*)c)->exprs.lookup_imm_exp(0, JIT_TYPE_INT); // imm exp is purely used for creating push
			    Operand_Exp *arg = ((Instrument_Closure*)c)->exprs.lookup_imm_exp((unsigned)((Call_Inst*)i)->get_mhandle(),JIT_TYPE_INT);
				Inst_Exp *push = ((Instrument_Closure*)c)->exprs.lookup_inst_exp(Exp::Push,arg,NULL,JIT_TYPE_INT);
				argarray[0] = new (mm) Push_Inst(arg->opnd,push,i);
				//Inst* p_inst = new (mm) Push_Inst(arg->opnd,imm,i) ;
				//argarray[0] = new (mm) Push_Inst(base->dst(),ib_exp,i); 
				Call_Inst *cll = new(mm) Call_Inst(Call_Inst::stat_indirect_call, arg, NULL, true, i); 
				cll->set_args(argarray, n_srcs, NULL);
				cll->set_expanded();
				argarray[0]->set_gc_unsafe() ;
				//p_inst->set_gc_unsafe() ;
				cll->set_gc_unsafe() ;
				i->set_gc_unsafe() ;
				*/
//				int n_args = ((Call_Inst*)i)->n_args() - 1 ;
//				Inst* inst_head = n_args >= 0 ? ((Call_Inst*)i)->get_arg(n_args) : i ;

//				Exp *imm = ((Instrument_Closure*)c)->exprs.lookup_imm_exp(0, JIT_TYPE_INT); // imm exp is purely used for creating push
//				Call_Inst *call = new (mm) Call_Inst(Call_Inst::stat_indirect_call,imm,NULL,false,inst_head);
//				call->set_gc_unsafe() ;

				//Inst *base = ((Instrument_Closure*)c)->exprs.lookup_imm(0x119731/*(unsigned)((Call_Inst*)i)->get_mhandle()*/,JIT_TYPE_ADDR,i);
				//Exp *ib_exp = ((Instrument_Closure*)c)->exprs.lookup_inst_exp(Exp::StatIndirectCall, base->exp, NULL,JIT_TYPE_VOID);
				//new(mm) StatIndirectCall_Inst(base->dst(), ib_exp, i);

//				new (mem) Push_Inst(base->dst() ,ib_exp,i); 
//				Call_Inst *call = new (mm) Call_Inst(Call_Inst::stat_indirect_call,
//													  NULL,NULL,false,i);
			}//if

			cout << "\n" ;
			cout.flush() ;

		}//if
    }//for

}

void count_stat_indirect_call(unsigned mh)
{
}

//
// This intrumented function is used to record who calling an indirect branch(now it's invokevirtual),
// and who being called.
// We use such an array, which has  N * 16-byte-length-record. Every record looks like this:
//     |  caller_addr  |  callee_addr  |         64-bit count        |   order    |	  b_current   |
//              4              4             		  8					   4			  4
//										   of the callee.
// Another version of recorder
//     | caller_addr   |  callee_addr  |    count   |
//              4               4             8
//
#define STAT_BUF_LEN 256 //128
#define STAT_RECORD_LEN 16
void __stdcall
orp_stat_indirect_call(unsigned caller_addr, unsigned callee_addr)
{
	static bool lock = false ;
	static int order = -1 ;
	static uint64 total_count = 0 ;
	static unsigned* buf = NULL ;
	static FILE* outfile = NULL ;//stderr ;
	int slot, i ;

	///////////////////////////////////LOCK//////////////////////////
	while(lock){ Sleep(10);}
	lock = true ;

	if(!outfile){
		outfile = fopen("dump_o3_indirect_call.txt","w+") ;
	}
	assert(outfile) ;
	
	//
	// Allocate memory for recording
	//
	if(buf == NULL){
		buf = (unsigned*)gc_malloc_fixed_code_for_class_loading(sizeof(unsigned)*STAT_BUF_LEN*STAT_RECORD_LEN) ;
		memset(buf,STAT_BUF_LEN*STAT_RECORD_LEN,sizeof(unsigned)) ;
	}
	assert(buf) ;
	
	if(caller_addr == 0 && callee_addr ==0){// Just dump !
		for(i = 0; i<= order ; i++){
			uint64* count = (uint64*)&buf[STAT_RECORD_LEN*i+2] ;
			fprintf(outfile,"%u\t%u\t%I64u\n",buf[STAT_RECORD_LEN*i], buf[STAT_RECORD_LEN*i+1], *count) ;
		}
		fflush(outfile) ;
		order = -1 ;
		goto MY_OUT;
	}

	//
	// Simple way to record the caller-callee pairs
	//
	for(slot = order ; slot >=0 && slot < STAT_BUF_LEN; slot--)
		if(buf[slot * STAT_RECORD_LEN] == caller_addr) break ;

	if(slot >=0 && slot < STAT_BUF_LEN && buf[slot * STAT_RECORD_LEN] == caller_addr && buf[slot * STAT_RECORD_LEN+1] == callee_addr){
			uint64* count = (uint64*)&buf[STAT_RECORD_LEN*slot+2] ;
			(*count) ++ ;
	}else{
		order ++ ;
//		total_count ++ ;
//		if(total_count % 10000 == 1){
//			printf("\n.............%I64u\n",total_count) ;
//		}
		if(order >= STAT_BUF_LEN){
			//
			// Dump the buf
			//
			for(i = 0; i< STAT_BUF_LEN ; i++){
				uint64* count = (uint64*)&buf[STAT_RECORD_LEN*i+2] ;
				fprintf(outfile,"%u\t%u\t%I64u\n",buf[STAT_RECORD_LEN*i], buf[STAT_RECORD_LEN*i+1], *count) ;
			}
			fflush(outfile) ;
			//
			//Reset the buf
			//
			memset(buf,0, STAT_BUF_LEN*STAT_RECORD_LEN*sizeof(unsigned)) ;
			order = 0 ;
		}
		assert(order < STAT_BUF_LEN) ;
		//int offset = order * STAT_RECORD_LEN ;
		buf[order * STAT_RECORD_LEN] = caller_addr ;
		buf[order * STAT_RECORD_LEN+1] = callee_addr ;
		uint64* count = (uint64*)&buf[order * STAT_RECORD_LEN+2] ;
		(*count) ++ ;
	}

MY_OUT:
	///////////////////////////////////UNLOCK//////////////////////////
	lock = false ;
	return ;

}

void *getaddress__orp_stat_indirect_call_naked()
{
    static void *addr = 0;
    if (addr) {
        return addr;
    }

    const int stub_size = 128;
    char *stub = (char *)gc_malloc_fixed_code_for_class_loading(stub_size);
#ifdef _DEBUG
    memset(stub, 0xcc /*int 3*/, stub_size);
#endif

    char *ss = stub;

	//
	//push eax, ecx, edx
	//
	ss = push(ss,&R_Opnd(eax_reg)) ;
	ss = push(ss,&R_Opnd(ecx_reg)) ;
	ss = push(ss,&R_Opnd(edx_reg)) ;

	ss = gen_setup_j2n_frame(ss);
	ss = push(ss, &M_Base_Opnd(esp_reg, sizeof(J2N_Saved_State) + 12) ); //callee_addr
    ss = push(ss, &M_Base_Opnd(esp_reg, sizeof(J2N_Saved_State) + 12) ); // caller_addr
    ss = call(ss, (char *)orp_stat_indirect_call);
	ss = gen_pop_j2n_frame(ss);

	//
	//pop edx, ecx, eax
	//
    ss = pop(ss, &edx_opnd);
    ss = pop(ss, &ecx_opnd);
    ss = pop(ss, &eax_opnd);

    ss = ret(ss,&Imm_Opnd(0));

    assert(ss - stub < stub_size);

    addr = stub;
#ifdef ORP_VTUNE_SUPPORT
    //M: 
    vtune_notify_stub_load_finished("getaddress__orp_stat_indirect_call_naked",(Byte*) stub,ss-stub);
#endif
    return addr;
} //getaddress__orp_stat_indirect_call_naked
#endif


