#include "defines.h"
//#ifdef INLINE_NATIVE
#include "ir.h"
#include "expression.h"
#include "nativeparser.h"
#include "nativegen.h"

//gen imm operand and exp
void NativeOpndManager::gen_imm_opnd(Expressions& exprs, NativeInfo* info, NativeOpndInfo* opnd_info, Operand*& o, Exp*& e)
{
    assert( opnd_info->is_imm());
	o = new (mem) Imm_Operand(opnd_info->val, JIT_TYPE_INT);
	e = exprs.lookup_imm_exp(opnd_info->val, JIT_TYPE_INT);
	
	//add operand and exp info to list
	append_opnd_exp(opnd_info, o, e);
}

//gen field opnd and exp
void NativeOpndManager::gen_field_opnd(NativeOpndInfo* opnd_info, Operand*& o, Exp*& e, O3_Jit_Type ty)
{
	assert(opnd_info->is_field());
	
	//set base opnd info
	NativeOpndInfo base_opnd_info;
	base_opnd_info.set_info( NativeOpndInfo::temp, opnd_info->num, 0, opnd_info->val, opnd_info->hi_tag) ;
	
	//gen base opnd, exp for field opnd
	Temp_Reg*	base_opnd = NULL;
	Exp*		base_exp = NULL;
	base_opnd = (Temp_Reg*)get_opnd(&base_opnd_info); 
	assert(base_opnd);
	base_exp = get_exp(base_opnd, &base_opnd_info); 
	assert(base_exp);

	//gen field opnd, exp
	o = new (mem) Field_Operand((Reg_Operand*)base_opnd, opnd_info->off, ty, 0, true);
    e = exprs.lookup_field_exp(base_exp, opnd_info->off, ty, 0);
	
	//append field opnd, exp to NativeOpndManager
	append_opnd_exp(opnd_info, o, e);
};

//get opnd from NativeOpndManager, if it exists, return it, else return NULL
Operand* NativeOpndManager::get_opnd_from_list(NativeOpndInfo* opnd_info, NativeOpndInfo::NativeOpndNode* list, unsigned len)
{
	for ( unsigned i = 0; i < len; i++) {
		if ( cmp_opnd_info( opnd_info, list[i].info)) {
			switch (opnd_info->hi_tag) {
			case NativeOpndInfo::whole:
				return list[i].opnd;
			case NativeOpndInfo::hi:
				return get_hi_opnd(list[i].opnd);
			case NativeOpndInfo::lo:
				return get_lo_opnd(list[i].opnd);
			default:
				assert(0);
			}
		}
	}
	return NULL;
}

//get opnd from NativeOpndManager, if it exists in NativeOpndManager, return it, else return NULL
Operand* NativeOpndManager::get_opnd(NativeOpndInfo* opnd_info)
{
	Operand* o = NULL;
	//in arguments($i)
	if ( opnd_info->is_in_arg()){
		o = get_opnd_from_list( opnd_info, in_arg_list, native_in_arg_num);
		assert(o);
		return o;
	}
	//out arguments(#i)
	if ( opnd_info->is_out_arg()){
		o = get_opnd_from_list( opnd_info, out_arg_list, native_out_arg_num);
		assert(o);
		return o;
	}

	o = get_opnd_from_list( opnd_info, opnd_list, get_opnd_list_size());

	return o;
}

//append opnd info to NativeOpndManager
void NativeOpndManager::append_opnd_exp(NativeOpndInfo* opnd_info, Operand* opnd, Exp* exp)
{
	opnd_list[opnd_list_size].info = (NativeOpndInfo*)mem.alloc(sizeof(NativeOpndInfo));
	copy(opnd_list[opnd_list_size].info, opnd_info);
	opnd_list[opnd_list_size].opnd = opnd;
	opnd_list[opnd_list_size].exp = exp;
	opnd_list_size++;
	assert( opnd_list_size <= MAX_NATIVE_OPND_LIST_SIZE);
}

//get exp from NativeOpndManager
Exp* NativeOpndManager::get_exp_from_list( Operand* o, NativeOpndInfo::NativeOpndNode* list, unsigned len)
{
	Exp* exp = NULL;
	for ( unsigned i = 0; i < len; i++){
		if ( list[i].opnd == o)
			return list[i].exp;
	}
	return NULL;
}

// get exp for opnd
Exp* NativeOpndManager::get_exp( Operand* o, NativeOpndInfo *opnd_info)
{
	Exp* exp = NULL;
	
	if (opnd_info->is_whole_opnd()){
		switch (opnd_info->tag){
		case NativeOpndInfo::in_arg:
			exp = get_exp_from_list( o, in_arg_list, native_in_arg_num);
			assert(exp);
			break;
		case NativeOpndInfo::out_arg:
			exp = get_exp_from_list( o, out_arg_list, native_out_arg_num);
			assert(exp);
			break;
		case NativeOpndInfo::temp:
		case NativeOpndInfo::imm:
		case NativeOpndInfo::field:
			exp = get_exp_from_list( o, opnd_list, opnd_list_size);
			assert(exp);
			break;
		default:
			assert(0);
		}
	}
	else{
		assert(o->is_temp_reg());
		exp = exprs.lookup_temp_reg_exp((Temp_Reg*)o);
		assert(exp);
	}
	
	return exp;
}

//get opnd, exp from NativeOpndManager
void NativeInstGenerator::get_opnd_exp(NativeOpndInfo* opnd_info, Operand*& o, Exp*& exp)
{
	if (o = nom.get_opnd(opnd_info))
		exp = nom.get_exp(o, opnd_info);
	else if ( opnd_info->is_imm()) // a new imm src opnd
		nom.gen_imm_opnd(exprs, &info, opnd_info, o, exp);
	else if ( opnd_info->is_field()) // a new field src opnd
		nom.gen_field_opnd(opnd_info, o, exp, info.get_type());

    //::set global candidate , temp-solution
    if(o && o->is_temp_reg())
        ((Temp_Reg*)o)->set_global_reg_cand() ;
}

//get src opnd, exp
void NativeInstGenerator::get_src_opnd_exp( Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp)
{
	NativeOpndInfo opnd_info;
	switch (info.src_opnd_num()){
	case 2: // 2 src opnd
		opnd_info = info.get_opnd_info(2);
		get_opnd_exp(&opnd_info, r, r_exp);
	case 1: // 1 src opnd
		opnd_info = info.get_opnd_info(1);
		get_opnd_exp(&opnd_info, l, l_exp);
		break;
	case 0: // without src opnd
		break;
	default:
		assert(0);
	}
}

//get dest opnd, exp
void NativeInstGenerator::get_dst_opnd_exp( Temp_Reg*& o, Exp*& e)
{
	NativeOpndInfo opnd_info;	
	if ( info.has_dst()) {
		opnd_info = info.get_opnd_info(0); // get dest opnd info
		get_opnd_exp( &opnd_info, (Operand*&)o, e);

		if ( o == NULL /*&& opnd_info.tag != NativeOpndInfo::out_arg*/ ) {
			o = exprs.create_new_temp_reg( info.get_type());
			e = exprs.lookup_temp_reg_exp((Reg_Operand*&) o);
			nom.append_opnd_exp( &opnd_info, o, e);
		}
		else
			o->set_temp_reg_has_multiple_defs();
	}
}

//main entry to gen inst
Inst* NativeInstGenerator::gen_inst()
{
	Inst *i = NULL;
    Operand *l = NULL, *r = NULL;
	Exp *l_exp = NULL, *r_exp = NULL;
	O3_Jit_Type ty = info.get_type();
	Exp* exp = NULL; 
	NativeOpndInfo opnd_info;
	Temp_Reg* tmp = NULL;
	Exp* dst_exp = NULL;
	Operand* o = NULL;
	Status_Flags *status = NULL;
	
	get_src_opnd_exp( l, l_exp, r, r_exp);
	get_dst_opnd_exp( tmp, dst_exp);

	switch (info.get_opcode()){
    case NativeInfo::Checkcast:
//Checkcast
        gen_checkcast_inst(l, l_exp, r, r_exp, ty, i, tmp, Exp::Checkcast, Type_Inst::cast) ;
        break ;
//Mul_Inst
	case NativeInfo::Mul:
		gen_mul_inst(l, l_exp, r, r_exp, ty, i, tmp);	
		break;
	case NativeInfo::Smul:	
		gen_smul_inst(l, l_exp, r, r_exp, ty, i, tmp);	
		break;
//Assign_Inst	
	case NativeInfo::Mov:
		gen_mov_inst(l, l_exp, r, r_exp, ty, i, tmp);
		break;
//Add_Inst
	case NativeInfo::Add:
		gen_add_inst(l, l_exp, r, r_exp, ty, i, tmp, Exp::Add, Add_Inst::add);
		break;
	case NativeInfo::Adc:		
		gen_add_inst(l, l_exp, r, r_exp, ty, i, tmp, Exp::Adc, Add_Inst::adc);	
		break;
//Long shift
	case NativeInfo::Shld:	
		gen_shld_inst(l, l_exp, r, r_exp, ty, i, tmp);	
		break;
	case NativeInfo::Shrd:		
		gen_shrd_inst(l, l_exp, r, r_exp, ty, i, tmp);	
		break;
//Convt_Inst
	case NativeInfo::Convt:
			exp = exprs.lookup_inst_exp(Exp::Convt,l_exp,NULL,ty);
			i = new (mem) Convt_Inst(l, exp, inst_head);
			i->set_dst(tmp);
		break;
//bitwise_inst
	case NativeInfo::And:		
		gen_bitwise_inst(l, l_exp, r, r_exp, ty, i, tmp, Exp::And, Bitwise_Inst::k_and);	
		break;
	case NativeInfo::Or:
		gen_bitwise_inst(l, l_exp, r, r_exp, ty, i, tmp, Exp::Or, Bitwise_Inst::k_or);
		break;
	case NativeInfo::Xor:
		gen_bitwise_inst(l, l_exp, r, r_exp, ty, i, tmp, Exp::Xor, Bitwise_Inst::k_xor);	
		break;
	case NativeInfo::Shl:
		gen_bitwise_inst(l, l_exp, r, r_exp, ty, i, tmp, Exp::Shl, Bitwise_Inst::shl);	
		break;
	case NativeInfo::Shr:
		gen_bitwise_inst(l, l_exp, r, r_exp, ty, i, tmp, Exp::Shr, Bitwise_Inst::shr);
		break;
	case NativeInfo::Sar:		
		gen_bitwise_inst(l, l_exp, r, r_exp, ty, i, tmp, Exp::Sar, Bitwise_Inst::sar);	
		break;
//branch_inst	
	case NativeInfo::Jp:
		break;
	case NativeInfo::Beq:
		gen_branch_inst(l, l_exp, r, r_exp, ty, i, tmp, Exp::Beq, Branch_Inst::beq);	
		break;
	case NativeInfo::Bne:
		gen_branch_inst(l, l_exp, r, r_exp, ty, i, tmp, Exp::Bne, Branch_Inst::bne);	
		break;
	case NativeInfo::Blt:		
		gen_branch_inst(l, l_exp, r, r_exp, ty, i, tmp, Exp::Blt, Branch_Inst::blt);	
		break;
	case NativeInfo::Bge:		
		gen_branch_inst(l, l_exp, r, r_exp, ty, i, tmp, Exp::Bge, Branch_Inst::bge);	
		break;
	case NativeInfo::Bgt:		
		gen_branch_inst(l, l_exp, r, r_exp, ty, i, tmp, Exp::Bgt, Branch_Inst::bgt);	
		break;
	case NativeInfo::Ble:		
		gen_branch_inst(l, l_exp, r, r_exp, ty, i, tmp, Exp::Ble, Branch_Inst::ble);	
		break;
//Sub_Inst
	case NativeInfo::Sub:
		gen_sub_inst(l, l_exp, r, r_exp, ty, i, tmp, Exp::Sub, Sub_Inst::sub);	
		break;
	case NativeInfo::Sbb:		
		gen_sub_inst(l, l_exp, r, r_exp, ty, i, tmp, Exp::Sbb, Sub_Inst::sbb);	
		break;
//Div_Inst
	case NativeInfo::Div:
		gen_div_inst(l, l_exp, r, r_exp, ty, i, tmp);
		break;
//Compare_Inst
//    enum Kind {cmp,cmp_lt,cmp_gt,test,n_cmp};
	case NativeInfo::Cmp:
		gen_compare_inst(l, l_exp, r, r_exp, ty, i, tmp, Exp::Compare, Compare_Inst::cmp);		
		break;
	case NativeInfo::Test:		
		gen_compare_inst(l, l_exp, r, r_exp, ty, i, tmp, Exp::Test, Compare_Inst::test);	
		break;
	default:
		assert(0);
		break;
	}
	
	//if the dest opnd is hi_opnd, set_expanded
	if ( info.has_dst() && info.get_opnd_info(0).hi_tag != NativeOpndInfo::whole) 
		i->set_expanded();

    if ( info.has_dst() && info.get_opnd_info(0).hi_tag == NativeOpndInfo::hi){
        NativeOpndInfo tmp_info;
        nom.copy(&tmp_info, &info.get_opnd_info(0));
        Temp_Reg* tmp_opnd_hi = (Temp_Reg*)nom.get_opnd(&tmp_info);
        tmp_opnd_hi->set_foldable(false) ;
        tmp_info.hi_tag = NativeOpndInfo::whole;
        Temp_Reg* tmp_opnd = (Temp_Reg*)nom.get_opnd(&tmp_info);
        tmp_opnd->set_foldable(false);
     }

	return i;
}

//Assign_Inst
void NativeInstGenerator::gen_mov_inst( Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp, O3_Jit_Type ty, Inst*& i, Temp_Reg *tmp)
{
	Exp* exp = exprs.lookup_inst_exp(Exp::Assign,l_exp,r_exp,ty);
	i = new (mem) Assign_Inst(tmp,l,exp,inst_head); 
	i->set_dst(tmp);
}

//Checkcast_Inst
void NativeInstGenerator::gen_checkcast_inst(Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp, O3_Jit_Type ty, Inst*& i, Temp_Reg *tmp, Exp::Kind exp_kind, Type_Inst::Kind inst_kind)
{
	Exp* exp = exprs.lookup_inst_exp(exp_kind,l_exp,r_exp,ty);
	i = new (mem) Type_Inst(inst_kind,l,r,exp,inst_head); 
	i->set_dst(tmp);
}

//Add_Inst
void NativeInstGenerator::gen_add_inst(Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp, O3_Jit_Type ty, Inst*& i, Temp_Reg *tmp, Exp::Kind exp_kind, Add_Inst::Kind inst_kind)
{
	Exp* exp = exprs.lookup_inst_exp(exp_kind,l_exp,r_exp,ty);
	i = new (mem) Add_Inst(inst_kind,l,r,exp,inst_head); 
	i->set_dst(tmp);
}

void NativeInstGenerator::gen_compare_inst(Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp, O3_Jit_Type ty, Inst*& i, Temp_Reg *tmp, Exp::Kind exp_kind, Compare_Inst::Kind inst_kind)
{
    if ( exp_kind == Exp::Compare){
		Exp* exp = exprs.lookup_inst_exp(exp_kind, l_exp, r_exp,ty);		
		i = new (mem) Compare_Inst(inst_kind,true/*is_cmpg*/, l, r,
										 exp, false/*cse_for_this*/, inst_head);
	}
	else if ( exp_kind == Exp::Test){
		Exp *exp = exprs.lookup_inst_exp(exp_kind,l_exp, r_exp,ty);
		i = new (mem) Compare_Inst(inst_kind,false,l,exp,false,inst_head);
	}
	else
		assert(0);

	Status_Flags *status = new (mem) Status_Flags(exprs.reg_map.get_tmp_reg_id(0), ty);
	i->set_dst(status);
}

//Div_Inst
void NativeInstGenerator::gen_div_inst(Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp, O3_Jit_Type ty, Inst*& i, Temp_Reg *tmp)
{
    Exp *exp = exprs.lookup_inst_exp(Exp::Div, l_exp, r_exp, ty);
    i = new (mem) Div_Inst(Div_Inst::div, l, r, exp, inst_head); 
    i->set_dst(tmp);
}

//Bitwise_Inst
void NativeInstGenerator::gen_bitwise_inst(Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp, O3_Jit_Type ty, Inst*& i, Temp_Reg *tmp, Exp::Kind exp_kind, Bitwise_Inst::Kind inst_kind)
{
	if(exp_kind==Exp::Shl || exp_kind==Exp::Sar || exp_kind==Exp::Shr){
		Exp* ecx_exp = exprs.lookup_reg_exp(ecx_reg,JIT_TYPE_INT,0) ;
		Operand *ecx = exprs.lookup_reg_exp(ecx_reg,JIT_TYPE_INT,0)->opnd;
		Assign_Inst* i1 = new (mem) Assign_Inst(ecx, r, r_exp,inst_head) ; // eax =.I l_opnd ;
		i1->set_copy_prop(false) ;
		
		Exp* exp = exprs.lookup_inst_exp(exp_kind, l_exp, ecx_exp, JIT_TYPE_INT);
		i = new (mem) Bitwise_Inst(inst_kind, l, ecx, exp, inst_head); 
	}else{
		Exp* exp = exprs.lookup_inst_exp(exp_kind, l_exp, r_exp, JIT_TYPE_INT);
		i = new (mem) Bitwise_Inst(inst_kind, l, r, exp, inst_head); 
	}

	i->set_dst(tmp);
}

//Mul_Inst
void NativeInstGenerator::gen_mul_inst( Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp, O3_Jit_Type ty, Inst*& i, Temp_Reg *tmp)
{
	Exp* exp = exprs.lookup_inst_exp(Exp::Mul,l_exp,r_exp,ty);
	i = new (mem) Mul_Inst(Mul_Inst::mul,l,r,exp,inst_head); 
	i->set_dst(tmp);
}

void NativeInstGenerator::gen_smul_inst( Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp, O3_Jit_Type ty, Inst*& i, Temp_Reg *tmp)
{
	Operand *edx_eax = exprs.lookup_reg_exp(eax_reg,JIT_TYPE_LONG,0)->opnd;
	Operand *edx = exprs.lookup_reg_exp(edx_reg,JIT_TYPE_INT,0)->opnd;

	//Have to clear EDX. In some cases, if the product is less than 2^32, edx is never be changed.
	Imm_Operand* imm_zero = new (mem) Imm_Operand(0x0, JIT_TYPE_INT) ;
	Exp* imm_zero_exp = exprs.lookup_imm_exp(0x0, JIT_TYPE_INT) ;
	new (mem) Assign_Inst(edx,imm_zero, imm_zero_exp,inst_head) ; // edx =.I 0 ;
	
	edx_eax->set_hi_opnd(edx) ;

    Exp* ecx_exp = exprs.lookup_reg_exp(ecx_reg,JIT_TYPE_INT,0) ;
	Operand *ecx = exprs.lookup_reg_exp(ecx_reg,JIT_TYPE_INT,0)->opnd;
    Assign_Inst* i2 = new (mem) Assign_Inst(ecx, r, r_exp,inst_head) ; // esi =.I r_opnd ;
    i2->set_copy_prop(false) ;

    Exp* eax_exp = exprs.lookup_reg_exp(eax_reg,JIT_TYPE_INT,0) ;
	Operand *eax = exprs.lookup_reg_exp(eax_reg,JIT_TYPE_INT,0)->opnd;
    Assign_Inst* i1 = new (mem) Assign_Inst(eax, l, l_exp,inst_head) ; // eax =.I l_opnd ;
    i1->set_copy_prop(false) ;

	Exp* mul_exp = exprs.lookup_inst_exp(Exp::Smul, eax_exp/*l_exp*/, ecx_exp/*r_exp*/, JIT_TYPE_LONG) ;
	i = new (mem) Mul_Inst(Mul_Inst::smul,eax/*l*/, ecx/*r*/, mul_exp, inst_head) ;
	i->set_dst(edx_eax);	
	
	i = new (mem) Assign_Inst(tmp,i->dst(),mul_exp, inst_head) ;
	i->set_dst(tmp) ;
}

//Sub_Inst
void NativeInstGenerator::gen_sub_inst(Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp, O3_Jit_Type ty, Inst*& i, Temp_Reg *tmp, Exp::Kind exp_kind, Sub_Inst::Kind inst_kind)
{
	Exp* exp = exprs.lookup_inst_exp(exp_kind,l_exp,r_exp,ty);
	i = new (mem) Sub_Inst(inst_kind,l,r,exp,inst_head); 
	i->set_dst(tmp);
}

//Branch_Inst
void NativeInstGenerator::gen_branch_inst(Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp, O3_Jit_Type ty, Inst*& i, Temp_Reg *tmp, Exp::Kind exp_kind, Branch_Inst::Kind inst_kind)
{
	Exp* exp = exprs.lookup_inst_exp(exp_kind,last_inst->exp,NULL,JIT_TYPE_VOID);		
	new (mem) Branch_Inst((Branch_Inst::Kind)(Branch_Inst::beq + (exp_kind - Exp::Beq)),true/*is_signed*/, last_inst->dst(), exp, inst_head); 
}

//
void NativeInstGenerator::gen_shld_inst( Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp, O3_Jit_Type ty, Inst*& i, Temp_Reg *tmp)
{
	Operand_Exp *exp_hi = NULL, *exp_lo = NULL;
	assert(l->is_temp_reg());
	
	Reg_Operand* hi = (Reg_Operand*)l->hi_opnd();
	if ( hi->is_reg())
		exp_hi = exprs.lookup_reg_exp(hi->id, hi->type, 1);
	else if ( hi->is_temp_reg())
		exp_hi = exprs.lookup_temp_reg_exp((Reg_Operand*)l->hi_opnd());
	else
		assert(0);
	
	exp_lo = exprs.lookup_temp_reg_exp((Reg_Operand*)l);

	//mov t1, l.lo
	Temp_Reg* reg_t1 = exprs.create_new_temp_reg(JIT_TYPE_INT);
	Operand_Exp* exp_t1 = exprs.lookup_temp_reg_exp(reg_t1);
	Exp* exp = exprs.lookup_inst_exp(Exp::Assign, exp_t1, exp_lo,JIT_TYPE_INT);
	i = new (mem) Assign_Inst(reg_t1, l, exp, inst_head); 
	i->set_dst(reg_t1);
	//shl l.hi, r
	exp = exprs.lookup_inst_exp(Exp::Shl, exp_hi, r_exp, JIT_TYPE_INT);
	i = new (mem) Bitwise_Inst(Bitwise_Inst::shl,l->hi_opnd(),r,exp,inst_head); 
	i->set_dst(l->hi_opnd());
	//t2 = sub 32, r
	Temp_Reg* reg_t2 = exprs.create_new_temp_reg(JIT_TYPE_INT);
	Operand_Exp* exp_t2 = exprs.lookup_temp_reg_exp(reg_t2);
	Imm_Operand* reg_imm = new (mem) Imm_Operand(32, JIT_TYPE_INT);
	Operand_Exp* exp_imm = exprs.lookup_imm_exp(32, JIT_TYPE_INT);
	exp = exprs.lookup_inst_exp(Exp::Sub, exp_imm, r_exp, JIT_TYPE_INT);
	i = new (mem) Sub_Inst(Sub_Inst::sub, reg_imm, r, exp, inst_head);
	i->set_dst(reg_t2);
	//shr t1, t2
	exp = exprs.lookup_inst_exp(Exp::Shr, exp_t1, exp_t2, JIT_TYPE_INT);
	i = new (mem) Bitwise_Inst(Bitwise_Inst::shr, reg_t1, reg_t2, exp, inst_head);
	i->set_dst(reg_t1);
	//or l.hi, t1
	exp = exprs.lookup_inst_exp(Exp::Or, exp_hi, exp_t1, JIT_TYPE_INT);
	i = new (mem) Bitwise_Inst(Bitwise_Inst::k_or, l->hi_opnd(), reg_t1, exp, inst_head);
	i->set_dst(l->hi_opnd());
}

//
void NativeInstGenerator::gen_shrd_inst( Operand*& l, Exp*& l_exp, Operand*& r, Exp*& r_exp, O3_Jit_Type ty, Inst*& i, Temp_Reg *tmp)
{
	Operand_Exp *exp_hi = NULL, *exp_lo = NULL;
	assert(l->is_temp_reg());
	
	Reg_Operand* hi = (Reg_Operand*)l->hi_opnd();
	if ( hi->is_reg())
		exp_hi = exprs.lookup_reg_exp(hi->id, hi->type, 1);
	else if ( hi->is_temp_reg())
		exp_hi = exprs.lookup_temp_reg_exp((Reg_Operand*)l->hi_opnd());
	else
		assert(0);
	
	exp_lo = exprs.lookup_temp_reg_exp((Reg_Operand*)l);

	//mov t1, l.hi
	Temp_Reg* reg_t1 = exprs.create_new_temp_reg(JIT_TYPE_INT);
	Operand_Exp* exp_t1 = exprs.lookup_temp_reg_exp(reg_t1);
	Exp* exp = exprs.lookup_inst_exp(Exp::Assign, exp_t1, exp_hi,JIT_TYPE_INT);
	i = new (mem) Assign_Inst(reg_t1, l->hi_opnd(), exp, inst_head); 
	i->set_dst(reg_t1);
	//shr l.lo, r
	exp = exprs.lookup_inst_exp(Exp::Shr, l_exp, r_exp, JIT_TYPE_INT);
	i = new (mem) Bitwise_Inst(Bitwise_Inst::shr,l,r,exp,inst_head); 
	i->set_dst(l);
	i->set_expanded();
	//t2 = sub 32, r
	Temp_Reg* reg_t2 = exprs.create_new_temp_reg(JIT_TYPE_INT);
	Operand_Exp* exp_t2 = exprs.lookup_temp_reg_exp(reg_t2);
	Imm_Operand* reg_imm = new (mem) Imm_Operand(32, JIT_TYPE_INT);
	Operand_Exp* exp_imm = exprs.lookup_imm_exp(32, JIT_TYPE_INT);
	exp = exprs.lookup_inst_exp(Exp::Sub, exp_imm, r_exp, JIT_TYPE_INT);
	i = new (mem) Sub_Inst(Sub_Inst::sub, reg_imm, r, exp, inst_head);
	i->set_dst(reg_t2);
	//shl t1, t2
	exp = exprs.lookup_inst_exp(Exp::Shl, exp_t1, exp_t2, JIT_TYPE_INT);
	i = new (mem) Bitwise_Inst(Bitwise_Inst::shl, reg_t1, reg_t2, exp, inst_head);
	i->set_dst(reg_t1);
	//or l.lo, t1
	exp = exprs.lookup_inst_exp(Exp::Or, l_exp, exp_t1, JIT_TYPE_INT);
	i = new (mem) Bitwise_Inst(Bitwise_Inst::k_or, l, reg_t1, exp, inst_head);
	i->set_dst(l);
	i->set_expanded();
}

//#endif
