// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/data_emitter.h,v 1.2 2001/08/13 09:54:55 xhshi Exp $
//

#ifndef _DATA_EMITTER_H_
#define _DATA_EMITTER_H_

#include "../x86/x86.h"
#include "Mem_Manager.h"
#include "ir.h"
#include <string.h>

class O3_Data_Emitter {
public:
    O3_Data_Emitter(char *db, unsigned sz) 
        : _data_block(db), _size(sz), _offset(0) {
        assert(((unsigned)db)%sizeof(int) == 0); // word aligned
    }
    char *emit_float(float f) {
        assert(_data_block != NULL && _offset + sizeof(float) <= _size);
		Value val;
		val.f = f;
		Imm_Opnd(val.i).emit32(_data_block+_offset);
		_offset += sizeof(float);
        return _data_block + _offset - sizeof(float);
	}
	char *emit_double(double d) {
        unsigned dbl = sizeof(double);
        assert(_data_block != NULL && _offset + dbl <= _size);
        if (((unsigned)_data_block + _offset) % dbl != 0)  // not aligned
            _offset = (((unsigned)_data_block+_offset)/dbl+1)*dbl - (unsigned)_data_block; 
		Value val;
		val.d = d;
		Imm_Opnd(val.l.hi).emit32(_data_block+_offset+sizeof(int));
		Imm_Opnd(val.l.lo).emit32(_data_block+_offset);
		_offset += dbl;
        return _data_block + _offset - dbl;
	}
	char *emit_int(int i) {
        assert(_data_block != NULL && _offset + sizeof(int) <= _size);
		Imm_Opnd(i).emit32(_data_block+_offset);
		_offset += sizeof(int);
        return _data_block + _offset - sizeof(int);
	}
	char *get_label() {return _data_block + _offset;}
private:
	unsigned _size, _offset;
	char *_data_block;
};

#endif // _DATA_EMITTER_H
