// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/build_ir_routines.h,v 1.2 2001/08/13 09:54:55 xhshi Exp $
//



#ifndef _BUILD_IR_ROUTINES_H_
#define _BUILD_IR_ROUTINES_H_


class Stack;
//
// routines for building IR
//
Spill_Operand *create_spill_opnd(Mem_Manager& mem, unsigned spill_id, O3_Jit_Type ty);

Const_Operand *create_const_opnd(Mem_Manager& mem, Value *val, O3_Jit_Type ty);

Static_Operand *create_static_opnd(Mem_Manager& mem, void *addr, O3_Jit_Type ty, Field_Handle fh);

Ret_Operand *create_ret_opnd(Mem_Manager& mem, unsigned reg_id, O3_Jit_Type ty);

Virtual_Reg *create_vreg_opnd(Mem_Manager& mem, unsigned reg_id, O3_Jit_Type ty);

Arg_Operand *create_arg_opnd(Mem_Manager& mem, unsigned ith_arg, 
                             unsigned reg_id, O3_Jit_Type ty);

Array_Operand *create_array_operand(Mem_Manager& mem, Inst *base, Inst *index, 
                                    Inst *bnd, unsigned shift, unsigned off, 
                                    O3_Jit_Type ty, bool optimize);

Field_Operand *create_field_operand(Mem_Manager& mem, Inst *base, 
                                    unsigned off, O3_Jit_Type ty, FIELD_UID fid);

extern void array_load(Mem_Manager& mem,Expressions&,Stack& stack,Inst *inst_head,char ty);

extern Inst *array_load(Mem_Manager& mem, Expressions& exprs,
                        Inst *inst_head, Inst *base, Inst *indx, char ty);

extern void array_store(Mem_Manager& mem,Expressions&,Stack& stack,Inst *inst_head,char ty);

extern void gen_assign(Mem_Manager& mem,   Expressions& exprs, 
                       Stack& stack,       Inst *inst_head,	         
                       unsigned var_no,    Inst *src,  O3_Jit_Type type);

extern void gen_alu(Mem_Manager& mem_manager, Expressions& exprs, 
                    Stack& stack, Inst *inst_head, Exp::Kind op, char ty);

extern void gen_alu1(Mem_Manager& mem_manager, Expressions& exprs, 
                     Stack& stack, Inst *inst_head, Exp::Kind op);

extern void gen_return(Mem_Manager& mem, Expressions& exprs,
                       Stack& stack, Inst *inst_head, Inst *src);

extern void gen_return64(Mem_Manager& mem,Expressions& exprs,Stack& stack, Inst *inst_head);

extern void gen_dup(Mem_Manager& mem, Expressions& exprs, Stack& stack, Inst *inst_head);

extern void gen_dup_x1(Mem_Manager& mem, Expressions& exprs, Stack& stack, Inst *inst_head);

extern void gen_dup_x2(Mem_Manager& mem, Expressions& exprs, Stack& stack, Inst *inst_head);

extern void gen_dup2(Mem_Manager& mem,Expressions& exprs, Stack& stack, Inst* inst_head);

extern void gen_dup2_x1(Mem_Manager& mem,Expressions& exprs, Stack& stack, Inst* inst_head);

extern void gen_dup2_x2(Mem_Manager& mem,Expressions& exprs, Stack& stack, Inst* inst_head);

extern void gen_iinc(Mem_Manager& mem, Expressions& exprs, Stack& stack, Inst *inst_head,
                     unsigned var_no, int inc);

extern void gen_const(Mem_Manager& mem, Expressions& exprs, Stack& stack, Inst *inst_head,
			          Compile_Handle comp_handle,Class_Handle class_handle, unsigned index);

extern void gen_cmp_branch(Mem_Manager& mem, Expressions& exprs, Stack& stack, 
                           Inst *inst_head, Exp::Kind op, O3_Jit_Type ty,
                           bool is_cmpg,
                           char *stack_sig_out, int  &stack_sig_out_size);

#ifdef JIT_SAPPHIRE
extern void gen_acmp_branch(Mem_Manager& mem, Expressions& exprs, Stack& stack, 
                            Inst *inst_head, Exp::Kind op, char *sig_out,  
                            int  &sig_out_size);
#endif

extern Inst *gen_cmp_inst(Mem_Manager& mem, Expressions& exprs, Inst *inst_head, 
                          Inst *src0, Inst *src1, O3_Jit_Type ty, bool is_cmpg);

extern Inst *gen_array_cmp_inst(Mem_Manager& mem, Expressions& exprs, Inst *inst_head, 
                          Inst *src0, Inst *src1, O3_Jit_Type ty, bool cse_for_this);

extern Inst *gen_test_inst(Mem_Manager& mem, Expressions& exprs, Inst *inst_head, Inst *src);

extern void gen_branch(Mem_Manager& mem, Expressions& exprs,
                       Inst *inst_head, bool is_signed, Exp::Kind op, Inst *src);

extern void gen_getfield(Mem_Manager &mem, Expressions& exprs, Stack& stack, Inst *inst_head,
                         Compile_Handle comp_handle,Class_Handle class_handle, unsigned index);

extern void gen_putfield(Mem_Manager &mem, Expressions& exprs, Stack& stack, Inst *inst_head,
                         Compile_Handle comp_handle,Class_Handle class_handle,
                         unsigned index, bool gc_requires_write_barriers);

extern void gen_getstatic(Mem_Manager &mem, Expressions& exprs, Stack& stack, Inst *inst_head,
                  Compile_Handle comp_handle,Class_Handle class_handle, unsigned index);

extern void gen_putstatic(Mem_Manager &mem, Expressions& exprs, Stack& stack, 
                          Inst *inst_head,Compile_Handle comp_handle,Class_Handle class_handle, unsigned index);

extern void gen_invokevirtual(Mem_Manager& mem, Expressions& exprs, Stack& stack,
					   Inst *inst_head, Compile_Handle comp_handle, Class_Handle c_handle, unsigned index);

extern void gen_invokespecial(Mem_Manager& mem, Expressions& exprs, Stack& stack,
					   Inst *inst_head, Compile_Handle comp_handle,Class_Handle c_handle, unsigned index);

extern void gen_invokestatic(Mem_Manager& mem, Expressions& exprs, Stack& stack,
					   Inst *inst_head, Compile_Handle comp_handle,Class_Handle c_handle, unsigned index);

extern void gen_invokeinterface(Mem_Manager& mem, Expressions& exprs, Stack& stack,
					   Inst *inst_head, Compile_Handle comp_handle,Class_Handle c_handle, unsigned index, unsigned n_args);

extern void gen_conversion(Mem_Manager& mem, Expressions& exprs, Stack& stack,
                           Inst *inst_head, O3_Jit_Type conv_to, O3_Jit_Type conv_fm);

extern void gen_ret(Mem_Manager& mem, Expressions& exprs, Inst *inst_head, unsigned var);

extern void gen_switch(Mem_Manager& mem, Expressions& exprs, Inst *inst_head, 
                       Exp::Kind op, Inst *src, Cfg_Extra_Info *switch_info);

extern void gen_new(Mem_Manager& mem, Expressions& exprs, Stack& stack,
                    Inst *inst_head, Compile_Handle comp_handle,
                    Class_Handle c_handle,unsigned index);

extern void gen_new_array(Mem_Manager& mem, Expressions& exprs, Stack& stack,
				          Inst *inst_head, Compile_Handle comp_handle, Class_Handle c_handle,
                          unsigned index, Inst *n_elem, Exp::Kind op);

extern void gen_multianewarray(Mem_Manager& mem, Expressions& exprs, Stack& stack,
                               Inst *inst_head, Compile_Handle comp_handle,
                               Class_Handle c_handle,
                               unsigned n_dim, unsigned index);

extern void gen_checkcast(Mem_Manager& mem, Expressions& exprs, Stack& stack,
                          Inst *inst_head, Compile_Handle comp_handle,
                          Class_Handle c_handle, unsigned index);

extern void gen_instanceof(Mem_Manager& mem, Expressions& exprs, Stack& stack,
                          Inst *inst_head, Compile_Handle comp_handle,
                          Class_Handle c_handle, unsigned index);

extern void gen_monitor(Mem_Manager& mem, Expressions& exprs, Stack& stack,
                        Inst *inst_head, Exp::Kind op);

extern void gen_athrow(Mem_Manager& mem, Expressions& exprs, Stack& stack, 
                Inst *inst_head);

extern void gen_synch_method_enter(Expressions& exprs, Class_Handle  c_handle,
                                   Method_Handle m_handle, Inst *inst);

extern void gen_synch_method_exit(Expressions& exprs,Class_Handle  c_handle,
						           Method_Handle m_handle, Inst *inst);

extern void spill_left_on_stack(Mem_Manager& mem, Expressions& exprs, Stack& stack, 
                      Inst *inst_head, char *stack_sig, int& stack_sig_size);

extern void create_assign_inst(Mem_Manager& mem, Expressions& exprs, Inst *inst_head,
                        Operand *dst, Exp *dst_exp, Inst *src, O3_Jit_Type type);

extern Inst *create_assign_inst(Expressions& exprs, Inst *inst_head,
                                Operand_Exp  *dst,  Operand_Exp *src, 
                                O3_Jit_Type  type);
#endif // _BUILD_IR_ROUTINES_H_

