// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/bitstream.h,v 1.2 2001/08/13 09:54:55 xhshi Exp $
//



#ifndef _BITSTREAM_H
#define _BITSTREAM_H

#include "Mem_Manager.h"
#include "pldi.h"

// The model is that for writing, you first do all your trial writing,
// so that you know what the total number of bits required will be.
// Then you allocate the actual array, and start writing into it for
// real.  We need to do it this way because until we know the ultimate
// size of the BitStream array, we don't know how wide to make the offsets
// into the array.

// If we're trying to gather statistics, allow the "emit" routines
// to take the extra tag argument.  Otherwise, use the preprocessor
// to strip away the tag argument.
#ifdef PLDI
#define emit_signed(a,b,c)               r_emit_signed            ((a), (b), (c))
#define emit_unsigned(a,b,c)             r_emit_unsigned          ((a), (b), (c))
#define emit_signed_at_offset(a,b,c,d)   r_emit_signed_at_offset  ((a), (b), (c), (d))
#define emit_unsigned_at_offset(a,b,c,d) r_emit_unsigned_at_offset((a), (b), (c), (d))
#define _emit(a,b,c)                     r__emit                  ((a), (b), (c))
#else // PLDI
#define emit_signed(a,b,c)               r_emit_signed            ((a), (b))
#define emit_unsigned(a,b,c)             r_emit_unsigned          ((a), (b))
#define emit_signed_at_offset(a,b,c,d)   r_emit_signed_at_offset  ((a), (b), (c))
#define emit_unsigned_at_offset(a,b,c,d) r_emit_unsigned_at_offset((a), (b), (c))
#define _emit(a,b,c)                     r__emit                  ((a), (b))
#endif // PLDI

class BitStream
{
public:
    // This constructor is used for creating a BitStream from scratch.
    BitStream(): _array(NULL), _read_only(false), _started_writing(false),
        _dump_stats_in_destructor(false) { set_offset(0); }
    // This constructor is used for reading an existing BitStream.
    BitStream(unsigned char *array, unsigned num_bits): _final_array_size_bits(num_bits),
        _array(array), _read_only(true), _started_writing(false),
        _dump_stats_in_destructor(false) { set_offset(0); }
    // This constructor is just a dummy routine that causes the stats
    // to be dumped during its destructor.
    BitStream(double d): _array(NULL), _read_only(false), _started_writing(false),
        _dump_stats_in_destructor(true) { set_offset(0); }
    ~BitStream();
    enum StatType {
        //stat_unknown,
        stat_prof_bits,
#ifdef PLDI_OVERRIDDEN
        stat_overridden_bits,
#endif
        stat_bbcount_bits,
        stat_bbcount,
        stat_max_inst_len_bits,
        stat_n_spill_words,
        stat_n_callee_zero,
        stat_n_callee,
        stat_push_pop_ret_offsets,
        stat_sync,
        stat_gc_safe,
        stat_eip_array,
        stat_mi_offset_array,
        stat_num_inst_recs,
        stat_adj_nonzero,
        stat_adj_bits,
        stat_initial_adj,
        stat_init_reg_state,
        stat_bv_size_parms,
        stat_esp_offset_parms,
        stat_rec_inst_len,
        stat_rec_reg_parms,
        stat_rec_reg_stk_esp_change,
        stat_rec_stk_change,
        stat_rec_esp_change_op,
        stat_rec_esp_change_adj,
        stat_BOGUS_ENTRIES_FOLLOW,
        stat_ESP_num_inst_recs,
        stat_ESP_adj_nonzero,
        stat_ESP_adj_bits,
        stat_ESP_initial_adj,
        stat_ESP_rec_inst_len,
        stat_ESP_op,
        stat_ESP_adj,
        stat_GC_init_reg_state,
        stat_GC_bv_size_parms,
        stat_GC_num_inst_recs,
        stat_GC_esp_offset_parms,
        stat_GC_rec_inst_len,
        stat_GC_stk_reg_change,
        stat_GC_reg_parms,
        stat_GC_stk_parms,
        stat_NUM
    };

#ifdef PLDI
    void r_emit_signed            (int      value, unsigned num_bits, StatType tag);
    void r_emit_unsigned          (unsigned value, unsigned num_bits, StatType tag);
    void r_emit_signed_at_offset  (int      value, unsigned num_bits, unsigned offset, StatType tag);
    void r_emit_unsigned_at_offset(unsigned value, unsigned num_bits, unsigned offset, StatType tag);
#else // PLDI
    void r_emit_signed            (int      value, unsigned num_bits);
    void r_emit_unsigned          (unsigned value, unsigned num_bits);
    void r_emit_signed_at_offset  (int      value, unsigned num_bits, unsigned offset);
    void r_emit_unsigned_at_offset(unsigned value, unsigned num_bits, unsigned offset);
#endif // PLDI

    int      read_signed            (unsigned num_bits);
    unsigned read_unsigned          (unsigned num_bits);
    int      read_signed_at_offset  (unsigned num_bits, unsigned offset);
    unsigned read_unsigned_at_offset(unsigned num_bits, unsigned offset);

    unsigned get_offset()                { return _current_bit_ptr_global; }
    void     set_offset(unsigned offset) { _current_bit_ptr_global = offset; }

    void start_writing(Mem_Manager &mem, unsigned total_bits);
    void copy_into(unsigned char *dest);

    static unsigned bits_required_for_unsigned(unsigned value);
    static unsigned bits_required_for_signed  (int      value);
private:
    unsigned char *_array;
    unsigned _final_array_size_bits;
    unsigned _current_bit_ptr_global;
    bool _read_only;
    bool _started_writing;
    bool _dump_stats_in_destructor;

#ifdef PLDI
    void     r__emit(unsigned value, unsigned num_bits, StatType tag);
#else // PLDI
    void     r__emit(unsigned value, unsigned num_bits);
#endif // PLDI
//    unsigned _read(                unsigned num_bits);
};

#endif // _BITSTREAM_H
