// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/level_1a_jit_intf.cpp,v 1.7 2001/12/15 11:30:33 xli18 Exp $
//

#include "defines.h"
#include <stdio.h>
#include <iostream.h>
#include <assert.h>

#include "Mem_Manager.h"
#include "orp_types.h"
#include "jit_runtime_support.h"
#include "level_1a_jit_intf.h"
#include "jit.h"
#include "profiling.h"
#include "code_gen.h"
#include "o1_debugging_support.h"
#include "root_set_enum.h"
#include "internal_jit_intf.h"

#ifdef ORP_POSIX
#include <string.h>
#endif

Level_1a_JIT::~Level_1a_JIT()
{
    print_profiling_info(o1_jit);//::jit_handle
#if 0
    extern unsigned ken_total_gen_mi;   // KEN testing
    extern unsigned ken_total_gen_code; // KEN testing
    extern unsigned ken_total_gen_const_data;
    extern unsigned ken_total_gen_data;
    extern unsigned ken_total_gen_info;
    cout << "Total generated method info = " << ken_total_gen_mi << endl;
    cout << "Total code size             = " << ken_total_gen_code << endl;
    cout << "Total data size             = " << ken_total_gen_const_data << endl;
    cout << "Total small method info size= " << ken_total_gen_info << endl;
    cout << "Total method info size      = " << ken_total_gen_data << endl;
#endif // 0
} //Level_1a_JIT::~Level_1a_JIT



JIT_Result 
Level_1a_JIT::compile_method(Compile_Handle     compilation,          // in
                             Method_Handle      meth,                 // in
                             JIT_Flags          flags                 // in
                             )
{
#if 0
    JIT_Result res = l1a_compile_method(compilation,meth,flags,cm_gen_method_code);
#else // PLDI Lazy GC map
    JIT_Result res = l1a_compile_method(compilation,meth,flags,cm_gen_code);
#endif

#if 0  // KEN! testing jvmdi support
//    int off = get_break_point_offset(compilation, meth, flags, 66);
//    cout << "BC " << 66 << " off= " << off << endl;
    jint n_entry;
    JVMDI_line_number_entry *line_table;
    GetLineNumberTable(NULL, meth, &n_entry, &line_table);

    JVMDI_exception_handler_entry *exc_table;
    GetExceptionHandlerTable(NULL, meth, &n_entry, &exc_table);

    JVMDI_local_variable_entry *var_table;
    GetLocalVariableTable(NULL,meth,&n_entry,&var_table);

    jclass *exceptions;
    GetThrownExceptions(NULL, meth, &n_entry, &exceptions);

    Object_Handle_Struct oh;
    oh.java_reference = (Java_java_lang_Object *)c;
    jmethodID *methods;
    GetClassMethods(&oh, &n_entry, &methods);

    jfieldID *fields;
    GetClassFields(&oh,&n_entry,&fields); 

    jclass *intfs;
    GetImplementedInterfaces(&oh,&n_entry,&intfs);
#endif

    return res;
} //Level_1a_JIT::compile_method

JIT_Result 
Level_1a_JIT::gen_method_info(Compile_Handle     compilation,          // in
                              Method_Handle      meth,                 // in
                              JIT_Flags          flags                 // in
                              )
{
    //
    // only generate method info
    //
    return l1a_compile_method(compilation,meth,flags,cm_gen_method);
} //Level_1a_JIT::compile_method



void
Level_1a_JIT::unwind_stack_frame(Method_Handle      meth,              // in
                                 Frame_Context     *context,           // in out
                                 Boolean            is_first           // in
                        )
{
    L1a_UnwindStackFrame_Full(context, 
		o1_method_get_info_block(meth), 
		is_first, 
		0);
} //Level_1a_JIT::unwind_stack_frame



void
Level_1a_JIT::fix_handler_context(Method_Handle      meth,            // in
                                  Frame_Context     *context,         // in out
                                  Boolean            is_first         // in
                                  )
{
    L1a_FixHandlerContext(context, 
		0, 
		o1_method_get_info_block(meth), 
		0);
} //Level_1a_JIT::fix_handler_context


//?? wgs: because O1 is not gc safe at every inst, adjustContextEIP is just
//   an approximate way to adjust eip to gc safe
#include "Class.h"
#include "method_lookup.h"
#ifdef USE_DLL_JIT
__declspec(dllimport)
#else
extern 
#endif
	Method_Lookup_Table methods;

#ifdef USE_DLL_JIT
__declspec(dllexport)
#endif
void adjustContextEIP(Frame_Context *context){
	void *eip = (void*)(*context->p_eip);
	JIT_Specific_Info *jit_info = methods.find(eip);
    Method *m = jit_info->get_method();
	Jit_Method_Info *jmi = o1_method_get_info_block((Method_Handle)m);
	for (unsigned i = 0; i < jmi->num_call_sites; i++) {
		if (((DWORD)jmi->cs_info[i].ret_IP) >= (DWORD)eip){
			*context->p_eip = jmi->cs_info[i].ret_IP;
			break;
		}
	}
}

void L1a_EnumerateGcRefs(
	Frame_Context	*context,
	void			*methodStart,
	void			*methodInfoPtr,
	GC_Enumeration_Handle			hCallback,
    Boolean          is_first);

//
// Call from the ORP into the JIT.
// The JIT:
// 1. Enumerates all references for the current stack.
//    The enumeration is precise, i.e., non-references are not
//    enumerated.
//    References are returned to the ORP with the orp_enumerate_root_reference
//    call.  The enum_handle argument must be used in those callbacks.
// 2. Unwinds the stack and modifies the context in-place.
//
void 
Level_1a_JIT::get_root_set_from_stack_frame(
                              Method_Handle          meth,             // in
                              GC_Enumeration_Handle  enum_handle,      // in
                              Frame_Context         *context,          // in out
                              Boolean                is_first          // in
                              )
{
    L1a_EnumerateGcRefs(context, 
		0, 
		o1_method_get_info_block(meth), 
		enum_handle, 
		is_first);
} //Level_1a_JIT::get_root_set_from_stack_frame



extern bool L1a_do_dumpjit;
extern const char *O1a_envvar_METHODS;
void Level_1a_JIT::next_command_line_argument(const char *name, const char *arg)
{
    if(strcmp(name, "-jitO1a"))
        return;

    char *method_str = "METHODS=";

    if (strncmp(arg, method_str, strlen(method_str)) == 0)
        O1a_envvar_METHODS = arg + strlen(method_str);
    else if (strcmp(arg, "nodumpjit") == 0)
        L1a_do_dumpjit = false;
    else if (strcmp(arg, "instrument") == 0)
        instrumenting = true;
    else if (strcmp(arg, "statistics") == 0){
        instrumenting = statistics = true;
		inner_statistics = true ;
	}
            
} //Level_1a_JIT::next_command_line_argument



Boolean Level_1a_JIT::can_enumerate(Method_Handle method,
                                    uint32        eip
                                    )
{
    return FALSE;
} //Level_1a_JIT::can_enumerate



unsigned Level_1a_JIT::num_breakpoints(Method_Handle method,
                                       uint32        eip
                                       )
{
    return l1a_num_breakpoints(method, eip);
} //Level_1a_JIT::num_breakpoints



// The JIT needs to write the breakpoint addresses into bp[],
// and to make context->p_eip point to the return eip for the method.
void Level_1a_JIT::get_breakpoints(Method_Handle method,      // in
                                   uint32        *bp,         // out
                                   Frame_Context *context     // in out
                                   )
{
    l1a_get_breakpoints(method, bp, context);
} //Level_1a_JIT::get_breakpoints


void *
Level_1a_JIT::get_address_of_this(Method_Handle          meth,            // in
                                  const Frame_Context   *context,         // in
                                  Boolean                is_first         // in
                                  )
{
    return l1a_get_address_of_this(meth, (Frame_Context *)context, is_first);
} //Level_1a_JIT::get_address_of_this



Boolean l1a_call_returns_a_reference(Method_Handle         method,              // in
                                       const Frame_Context  *context              // in
                                       );
Boolean
Level_1a_JIT::call_returns_a_reference(Method_Handle         method,              // in
                                       const Frame_Context  *context              // in
                                       )
{
    return l1a_call_returns_a_reference(method, context);
} //Level_1a_JIT::call_returns_a_reference


//
// return the address of variable var_no
//
void *Level_1a_JIT::get_address_of_var(Frame_Context *context,
                                       Boolean       is_first,
                                       unsigned      var_no)
{
    return l1a_get_address_of_var(context,is_first,var_no);
}

int Level_1a_JIT::get_break_point_offset(Compile_Handle compilation,
                                         Method_Handle  meth,
                                         JIT_Flags      flags,
                                         unsigned       bc_location)
{
    return l1a_get_break_point_offset(compilation,meth,flags,bc_location);
}

#ifdef ORP_NT
#include "orp_process.h"
void Level_1a_JIT::thread_recompile_methods() 
{
    _beginthread(l1a_thread_recompile_methods, 0, NULL);
}
#else
void Level_1a_JIT::thread_recompile_methods() 
{
    // not implemented
    assert(0);
}
#endif
