// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/cmp_branch.h,v 1.2 2001/08/13 09:59:51 xhshi Exp $
//


#ifndef _CMP_BRANCH_H_
#define _CMP_BRANCH_H_

void emit_lcmp_br(Mem_Manager&  mem_manager,
				  Code_Emitter& emitter, Stack& stack,
				  Code_Patch*&  code_patch_list,
				  Map_Entry     *map, 
				  unsigned char bytecode,
				  bool          bwd_branch,
				  unsigned      target_bc_index,
				  unsigned      fall_thru_index);

void emit_fdcmp_br(Mem_Manager&           mem_manager,
				  Code_Emitter&           emitter, 
                  Stack&                  stack,
				  Code_Patch*&            code_patch_list,
				  Map_Entry               *map, 
				  unsigned char           curr_bc,
                  unsigned char           prev_bc,
				  bool                    is_bwd_br,
				  unsigned                target_bc_index,
                  unsigned                fall_bc_index,
		          Pre_Alloc_Operand_Pool& op_pool);

void emit_cmp0_br(Mem_Manager&  mem_manager,
				  Code_Emitter& emitter, Stack& stack,
				  Code_Patch*&  code_patch_list,
				  Map_Entry     *map, 
				  unsigned char bytecode,
				  bool          bwd_branch,
				  unsigned      target_bc_index);

void emit_compare(Code_Emitter& em, 
                  Stack&        stack,
                  unsigned char bc,
                  Pre_Alloc_Operand_Pool& op_pool);

void emit_ifxx(Mem_Manager&  mm,
               Code_Emitter& emitter,
               Stack&        stack,
               Code_Patch*&  code_patch_list,
               Map_Entry     *map, 
               X86_CC        cc,
               bool          is_bwd_br,
               unsigned      target_bc_index);

void emit_br(Mem_Manager&  mem_manager,
             Code_Emitter& emitter,
		     Code_Patch*&  code_patch_list,
             Map_Entry     *map, 
             X86_CC        cc,
             unsigned      target_bc_index,
             bool          is_bwd_branch,
             bool          is_signed);

#endif // _CMP_BRANCH_H_
