// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/cg_field_access.cpp,v 1.2 2001/08/13 09:59:51 xhshi Exp $
//


#include "defines.h"
#include "jit_intf.h"
#include "internal_jit_intf.h"
#include <iostream.h>
#include <stdarg.h>
#include "code_emitter.h"
#include "cg_prepass.h"
#include "operand.h"
#include "lazy_code_selector.h"
#include "register_manager.h"
#include "stack.h"
#include "jit_runtime_support.h"

#include "cg_field_access.h"
#include "fp_compatibility.h"

//
// If JIT generates method info lazily, JIT generates code first and 
// calls select_code() to produce method information on demand.  Because
// the state of VM at the time of producing the method info may differ
// from the state of generating code.  JIT cannot call the helper 
// class_is_initialized() to determine if an initializer call is needed.
//
static bool need_initializer(Class_Handle field_class,
                             unsigned     num_get_put_static,
                             unsigned    *class_initializer, 
                             CODE_MI      code_mi) {
    bool need = false;
    if (code_mi == cm_gen_method) { // check bit vector if a call was generated
        unsigned set = class_initializer[num_get_put_static/(8*sizeof(unsigned))] &   
            (1u << (num_get_put_static % (8*sizeof(unsigned))));
        need = (set != 0);
    } else {
        need = !class_is_initialized(field_class);
        //
        // set bit vector if a call is generated
        //
        if (need)
            class_initializer[num_get_put_static/(8*sizeof(unsigned))] |=   
            (1u << (num_get_put_static % (8*sizeof(unsigned))));
    }
    return need;
}

//
// If the field cannot be resolved at JIT time, a run-time call is 
// generated to throw the linking exception when the field access
// is executed at run time.
//
static void gen_throw_linking_excepion(Mem_Manager&     mm,
				                       Code_Emitter&    emitter,
				                       Stack&           stack,
				                       Class_Handle     class_handle,
				                       unsigned         index,
                                       Code_Patch *&    code_patch_list,
                                       Jit_Method_Info *method_info,
                                       Loader_Exception lexc) {
    void *addr = orp_get_rt_support_addr(ORP_RT_THROW_LINKING_EXCEPTION);
    //
    // generate ThrowLinkingException(index,clss,exc);
    //
    stack.call_home(0);
    emitter.emit_push(&Imm_Opnd(lexc));
    make_esp_record(emitter.get_offset(),1,method_info,mm);
    emitter.emit_push(&Imm_Opnd((unsigned)class_handle));
    make_esp_record(emitter.get_offset(),2,method_info,mm);
    emitter.emit_push(&Imm_Opnd(index));
    make_esp_record(emitter.get_offset(),3,method_info,mm);
    unsigned patch_offset = emitter.get_offset()+1;
    method_info->cs_info[method_info->cnt].precall_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].returns_ref = 0;
    emitter.emit_call((char*)addr);
    method_info->cs_info[method_info->cnt].ret_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].outarg_bv = 0x0; // no ref outargs
    method_info->cs_info[method_info->cnt].m_handle = NULL;
    method_info->cs_info[method_info->cnt++].num_out_args = 3;
    code_patch_list = new(mm) Call_Patch(code_patch_list,patch_offset,(char*)addr);
}

//
// If the field is not yet initialized, a run-time call is generated
// to initialize the field at runtime.
//
static void gen_init_class(Mem_Manager&     mm,
				           Code_Emitter&    emitter,
				           Stack&           stack,
                           Code_Patch *&    code_patch_list,
                           Jit_Method_Info *method_info,
                           Class_Handle     field_class) {
    stack.call_home(0);
    void *addr = orp_get_rt_support_addr(ORP_RT_INITIALIZE_CLASS);
    //
    // generate initialize_class(class_handle);
    //
    emitter.emit_push(&Imm_Opnd((unsigned)field_class));
    make_esp_record(emitter.get_offset(), 1, method_info,mm);


    unsigned patch_offset = emitter.get_offset()+1;
    method_info->cs_info[method_info->cnt].precall_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].returns_ref = 0;
    emitter.emit_call((char*)addr);
    method_info->cs_info[method_info->cnt].ret_IP =
        (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].outarg_bv = 0;
    method_info->cs_info[method_info->cnt].m_handle = NULL;
    method_info->cs_info[method_info->cnt++].num_out_args = 1;
    code_patch_list = new(mm) Call_Patch(code_patch_list,patch_offset,(char*)addr);
}

int gen_getstatic(Mem_Manager&      mem_manager,
				   Code_Emitter&    emitter,
				   Stack&           stack,
				   Class_Handle     class_handle,
                   Compile_Handle   comp_handle,
				   unsigned         index,
                   Code_Patch *&    code_patch_list,
                   Jit_Method_Info *method_info,
                   unsigned&        num_get_put_static, 
                   unsigned        *class_initializer, 
                   CODE_MI          code_mi) {
    char *addr = NULL;
    Java_Type ty;
    Loader_Exception lexc;
	Field_Handle field_handle = resolve_static_field(comp_handle,class_handle,index,&lexc);

    if (!field_handle) {
        gen_throw_linking_excepion(mem_manager, emitter,
                                   stack,       class_handle,
                                   index,       code_patch_list,
                                   method_info, lexc);
        ty = get_java_type(const_pool_get_field_descriptor(class_handle,index));
    } else {

        ////////////////// begin class initialization

        Class_Handle field_class = field_get_class(field_handle);
        if (need_initializer(field_class,num_get_put_static,class_initializer,code_mi)) {
            gen_init_class(mem_manager, emitter,
                           stack,       code_patch_list,
                           method_info, field_class);
        }
	    addr = (char*)field_get_addr(field_handle);
        ty = field_get_type(field_handle);

        ////////////////// end class initialization
    }
	switch (ty) {
	case JAVA_TYPE_LONG:
	case JAVA_TYPE_DOUBLE:
		// 64-bits
		stack.push64(new(mem_manager) Static_Operand(addr,0),
					 new(mem_manager) Static_Operand(addr+4,0));
		break;
	default:
		// 32-bits
		stack.push(new(mem_manager) Static_Operand(addr,0));
		break;
	}
    num_get_put_static++;

    return 0;
}

int gen_putstatic(Mem_Manager&      mem_manager,
				   Code_Emitter&    emitter,
				   Stack&           stack,
				   Class_Handle     class_handle,
                   Compile_Handle   comp_handle,
				   unsigned         index,
                   Code_Patch *&    code_patch_list,
                   Jit_Method_Info *method_info,
                   unsigned&        num_get_put_static, 
                   unsigned        *class_initializer, 
                   CODE_MI          code_mi) {
    char *addr = NULL;
    Java_Type ty;
    Loader_Exception lexc;
	Field_Handle field_handle = resolve_static_field(comp_handle,class_handle,index,&lexc);

    if (!field_handle) {
        gen_throw_linking_excepion(mem_manager, emitter,
                                   stack,       class_handle,
                                   index,       code_patch_list,
                                   method_info, lexc);

        ty = get_java_type(const_pool_get_field_descriptor(class_handle,index));
    } else {

        ////////////////// begin class initialization

        Class_Handle field_class = field_get_class(field_handle);
        if (need_initializer(field_class,num_get_put_static,class_initializer,code_mi)) {
                gen_init_class(mem_manager, emitter,
                               stack,       code_patch_list,
                               method_info, field_class);
        }
        addr = (char*)field_get_addr(field_handle);
        ty = field_get_type(field_handle);

        ////////////////// end class initialization
    }

	Static_Operand *operand;
	switch (ty) {
	case JAVA_TYPE_LONG:
	case JAVA_TYPE_DOUBLE:
		// 64-bits
		Operand *src_hi, *src_lo;
		stack.pop64(src_lo,src_hi);
		operand = new(mem_manager) Static_Operand(addr+4,0);
		gen_store32(emitter,stack,operand->mem_opnd(),src_hi);
		operand = new(mem_manager) Static_Operand(addr,0);
		gen_store32(emitter,stack,operand->mem_opnd(),src_lo);

		break;
	default:
		// 32-bits
		operand = new(mem_manager) Static_Operand(addr,0);
		Operand *src = stack.pop();
		gen_store32(emitter,stack,operand->mem_opnd(),src);
		break;
	}
    num_get_put_static++;

    return 0;
}

int gen_getfield(Mem_Manager&      mem_manager,
				   Code_Emitter&   emitter,
				   Code_Patch *&   code_patch_list,
				   Stack&          stack,
				   Class_Handle    class_handle,
                   Compile_Handle  comp_handle,
				   unsigned        index,
                   Jit_Method_Info *method_info) {
    Loader_Exception lexc;
	Field_Handle field_handle = resolve_nonstatic_field(comp_handle,class_handle,index,&lexc);
    //
    //  cannot resolve the field
    //
    if (!field_handle) {
        gen_throw_linking_excepion(mem_manager, emitter,
                                   stack,       class_handle,
                                   index,       code_patch_list,
                                   method_info, lexc);

        Java_Type ty = get_java_type(const_pool_get_field_descriptor(class_handle,index));
        //
        // We need to push something onto the stack because the subsequent
        // bytecode expects the operands on the stack.
        //
        char *addr = NULL;
        if (ty == JAVA_TYPE_LONG || ty == JAVA_TYPE_DOUBLE)
		    stack.push64(new(mem_manager) Static_Operand(addr,0),
					     new(mem_manager) Static_Operand(addr+4,0));
	    else
		    stack.push(new(mem_manager) Static_Operand(addr,0));
    } else { // field is resolved successfully

	    unsigned offset = field_get_offset(field_handle);
        if (!offset)
            return 1;
#if 0    
        // Collect field access stats if required.
        if (collect_hotfield_stats) {
            extern void *get_addr_of_read_counter(Field_Handle f) ;
            void *ctr = get_addr_of_read_counter(field_handle);
            assert(ctr);
            Static_Operand *operand = new(mem_manager) Static_Operand(ctr, 0);
            emitter.emit_inc(&operand->opnd);
        }
#endif

	    Field_Operand *operand;
	    Operand *base = stack.pop();
	    //
	    // base address must be in a register; so first make sure it
	    // is in a register
	    //
	    if (!base->is_reg()) {
		    base->free_opnd(&stack.reg_manager);
		    Reg_Operand *reg = stack.reg_manager.get_reg();
		    base->emit_mov_to_reg(emitter,&reg->opnd);
		    base = reg;
#ifdef _CSE
		    stack.update_cse(reg,0);
#endif // _CSE
	    }
	    Reg_Operand *base_reg = (Reg_Operand *)base;
	    //
	    // Note that base is not freed because it is on the stack as
	    // part of the pushed operand
	    //
        Java_Type ty = field_get_type(field_handle);
	    switch (ty) {
	    case JAVA_TYPE_LONG:
		    // 64-bits
		    stack.push64(new(mem_manager) Field_Operand(base_reg->opnd.reg_no(),offset),
					     new(mem_manager) Field_Operand(base_reg->opnd.reg_no(),offset+4));
		    break;
	    case JAVA_TYPE_DOUBLE:
        case JAVA_TYPE_FLOAT:
            {
                bool is_dbl = ty == JAVA_TYPE_DOUBLE;
                if (stack.fp_strict_mode)
                {
                    base_reg->free_opnd(&stack.reg_manager);
                    //
                    // force throwing NullPointerException if base_reg is NULL
                    //
                    emitter.emit_fld(Field_Operand(base_reg->opnd.reg_no(),offset).mem_opnd(),is_dbl);
                    if (is_dbl) {
                        Stack_Operand *dst = stack.op_pool.nth_stack(stack.depth()+1);
                        emitter.emit_fst(dst->mem_opnd(),1,1);
                        stack.push64(dst,stack.op_pool.nth_stack(stack.depth()));
                    } else {
                        Stack_Operand *dst = stack.op_pool.nth_stack(stack.depth());
                        emitter.emit_fst(dst->mem_opnd(),0,1);
                        stack.push(dst);
                    }
                } else {
                    load_onto_fp_stack(stack, &Field_Operand(base_reg->opnd.reg_no(),offset), is_dbl);
                    result_on_fp_stack(mem_manager, stack, is_dbl);
                    base_reg->free_opnd(&stack.reg_manager);
                }
            }
            break;
	    default:
		    // 32-bits
		    operand = new(mem_manager) Field_Operand(base_reg->opnd.reg_no(),offset);
		    stack.push(operand);
		    break;
	    }
    }
    return 0;
}

int gen_putfield(Mem_Manager&      mem_manager,
				   Code_Emitter&   emitter,
				   Code_Patch *&   code_patch_list,
				   Stack&          stack,
				   Class_Handle    class_handle,
                   Compile_Handle  comp_handle,
                   bool            gc_requires_write_barriers,
				   unsigned        index,
                   Jit_Method_Info *method_info) {
    Loader_Exception lexc;
	Field_Handle field_handle = resolve_nonstatic_field(comp_handle,class_handle,index,&lexc);
    //
    //  cannot resolve the field
    //
    if (!field_handle) { 
        gen_throw_linking_excepion(mem_manager, emitter,
                                   stack,       class_handle,
                                   index,       code_patch_list,
                                   method_info, lexc);

        Java_Type ty = get_java_type(const_pool_get_field_descriptor(class_handle,index));
        //
        // we don't need to generate any code except popping operands from
        // the stack
        //
        if (ty == JAVA_TYPE_LONG || ty == JAVA_TYPE_DOUBLE) {
		    Operand *src_hi, *src_lo;
		    stack.pop64(src_lo,src_hi);
        } else  // 32-bits
		    stack.pop();
    } else { // field is resolved successfully
	    unsigned offset = field_get_offset(field_handle);
        if (!offset)
            return 1;
#if 0
        // Insert code to collect field access data.
        if (collect_hotfield_stats) {
            extern void *get_addr_of_write_counter(Field_Handle f) ;
            void *ctr = get_addr_of_write_counter(field_handle);
            assert(ctr);
            Static_Operand *operand = new(mem_manager) Static_Operand(ctr, 0);
            emitter.emit_inc(&operand->opnd);
        }
#endif
        Field_Operand *operand;
	    enum Java_Type mt = field_get_type(field_handle);
	    switch (mt) {
	    case JAVA_TYPE_LONG:
	    case JAVA_TYPE_DOUBLE: {
		    // 64-bits
		    Operand *src_hi, *src_lo;
		    stack.pop64(src_lo,src_hi);
		    Operand *base = stack.pop();
		    //
		    // base address must be in a register; so first make sure it
		    // is in a register
		    //
		    if (!base->is_reg()) {
			    base->free_opnd(&stack.reg_manager);
			    Reg_Operand *reg = stack.reg_manager.get_reg();
			    base->emit_mov_to_reg(emitter,&reg->opnd);
			    base = reg;
#ifdef _CSE
                stack.update_cse(reg,1);
#endif // _CSE
		    }
            //
            // make sure precise exception
            //
            stack.maintain_precise_exception();

		    Reg_Operand *base_reg = (Reg_Operand *)base;
		    operand = new(mem_manager) Field_Operand(base_reg->opnd.reg_no(),offset+4);
		    if (src_hi->is_mem()) {
 			    Reg_Operand *reg = stack.reg_manager.get_reg();
			    if (reg == NULL) {
				    // no more registers.  use the stack
				    // push src_hi
				    // pop  [base,offset+4]
				    src_hi->emit_push(emitter);
				    emitter.emit_pop(operand->mem_opnd());
			    } else {
				    //
				    //  mov	reg,src_hi
				    //	mov	[base,offset+4],reg
				    //
				    src_hi->emit_mov_to_reg(emitter,&reg->opnd);
				    src_hi = reg;
				    gen_store32(emitter,stack,operand->mem_opnd(),src_hi);
			    }
		    } else if (src_hi->kind != Operand::Fp)
			    gen_store32(emitter,stack,operand->mem_opnd(),src_hi);

		    if (src_lo->is_mem()) {
			    src_lo->free_opnd(&stack.reg_manager);
			    Reg_Operand *reg = stack.reg_manager.get_reg();
			    src_lo->emit_mov_to_reg(emitter,&reg->opnd);
			    src_lo = reg;
		    }
		    operand = new(mem_manager) Field_Operand(base_reg->opnd.reg_no(),offset);
		    gen_store32(emitter,stack,operand->mem_opnd(),src_lo);
		    operand->free_opnd(&stack.reg_manager);
		    break;
        }
#ifndef DISABLE_GC_WRITE_BARRIERS
	    case JAVA_TYPE_CLASS:
	    case JAVA_TYPE_ARRAY:
            if (!gc_requires_write_barriers)
            {
                // fall through to "default" label
            }
            else
		    {
                // 32-bits
                Operand *src = stack.pop();
                Operand *base = stack.pop();
                
                stack.push(src);  // HACK!!!
                //
                // base address must be in a register; so first make sure it
                // is in a register
                //
                if (!base->is_reg()) { 
                    // Put base into some register.
                    base->free_opnd(&stack.reg_manager);
                    Reg_Operand *reg = stack.reg_manager.get_reg();
                    base->emit_mov_to_reg(emitter,&reg->opnd);
                    base = reg;
#ifdef _CSE  // Does this remain?
			        stack.update_cse(reg,1);
#endif // _CSE
                }
                
                operand = new(mem_manager) Field_Operand(((Reg_Operand *)base)->opnd.reg_no(), offset);
                src = stack.pop();  
                if (!src->is_reg()) {
                    src->free_opnd(&stack.reg_manager);
                    Reg_Operand *r = stack.reg_manager.get_reg();
                    src->emit_mov_to_reg(emitter,&r->opnd);
                    src = r;
                }
                src->emit_mov_to_mem(emitter,&operand->opnd);
                src->free_opnd(&stack.reg_manager);
                stack.call_home(0);
                // Call the helper function.
                if (!base->contain(ecx_reg)) {
                    Reg_Operand *r = stack.reg_manager.get_reg(ecx_reg);
                    base->emit_mov_to_reg(emitter,&r->opnd);
                    r->free_opnd(&stack.reg_manager);
                }
                base->free_opnd(&stack.reg_manager);
                
                void *helper = orp_get_rt_support_addr(ORP_RT_WRITE_BARRIER_FASTCALL);
                unsigned patch_offset = emitter.get_offset() + 1;
                emitter.emit_call((char*)helper);
                code_patch_list =
                    new(mem_manager) Call_Patch(code_patch_list,patch_offset,(char*)helper);
                
                break;
		    }
#endif // DISABLE_GC_WRITE_BARRIERS
	    default:	{
		    // 32-bits
		    Operand *src = stack.pop();
		    Operand *base = stack.pop();
		    //
		    // base address must be in a register; so first make sure it
		    // is in a register
		    //
		    if (!base->is_reg()) {
			    base->free_opnd(&stack.reg_manager);
			    Reg_Operand *reg = stack.reg_manager.get_reg();
			    base->emit_mov_to_reg(emitter,&reg->opnd);
			    base = reg;
#ifdef _CSE
                stack.update_cse(reg,1);
#endif // _CSE
		    }
		    if (src->is_mem()) {
			    src->free_opnd(&stack.reg_manager);
			    Reg_Operand *reg = stack.reg_manager.get_reg();
			    src->emit_mov_to_reg(emitter,&reg->opnd);
			    src = reg;
#ifdef _CSE
			    stack.update_cse(reg,0);
#endif // _CSE
		    }
            //
            // make sure precise exception
            //
            stack.maintain_precise_exception();
        
		    Reg_Operand *base_reg = (Reg_Operand *)base;

		    operand = new(mem_manager) Field_Operand(base_reg->opnd.reg_no(),offset);
		    gen_store32(emitter,stack,operand->mem_opnd(),src);
		    operand->free_opnd(&stack.reg_manager);
		    break;
        }
        } // switch
#ifdef _CSE
		    stack.cse->kill_reg_cse(stack.curr_bc_index(),index);
#endif // _CSE
    }
    return 0;
}

